/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme;
import org.locationtech.geomesa.fs.storage.common.partitions.XZ2Scheme$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tmb\u0001\u0002\u0014(\u0001ZB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005X\u0001\tE\t\u0015!\u0003M\u0011!A\u0006A!f\u0001\n\u0003)\u0005\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002$\t\u000bi\u0003A\u0011A.\t\u000f\u0001\u0004!\u0019!C\u0005C\"1\u0001\u000e\u0001Q\u0001\n\tDQ!\u001b\u0001\u0005B-CQA\u001b\u0001\u0005B-DQa\u001e\u0001\u0005BaDq!a\u0001\u0001\t#\n)\u0001C\u0004\u0002\n\u0001!\t&a\u0003\t\u0013\u0005e\u0003!!A\u0005\u0002\u0005m\u0003\"CA2\u0001E\u0005I\u0011AA3\u0011%\tY\bAI\u0001\n\u0003\ti\bC\u0005\u0002\u0002\u0002\t\n\u0011\"\u0001\u0002f!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\t\u0003+\u0003\u0011\u0011!C\u0001\u000b\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003K\u0003\u0011\u0011!C!\u0003OC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005\u0005\u0007!!A\u0005B\u0005\r\u0007\"CAc\u0001\u0005\u0005I\u0011IAd\u0011%\tI\rAA\u0001\n\u0003\nYmB\u0004\u0002P\u001eB\t!!5\u0007\r\u0019:\u0003\u0012AAj\u0011\u0019QF\u0004\"\u0001\u0002\\\"I\u0011Q\u001c\u000fC\u0002\u0013\u0005\u0011Q\u0011\u0005\t\u0003?d\u0002\u0015!\u0003\u0002\b\u001a1\u0011\u0011\u001d\u000f\u0001\u0003GDaA\u0017\u0011\u0005\u0002\t\r\u0001b\u0002B\u0005A\u0011\u0005#1\u0002\u0005\n\u0005'a\u0012\u0011!CA\u0005+A\u0011B!\b\u001d\u0003\u0003%\tIa\b\t\u0013\tEB$!A\u0005\n\tM\"!\u0003-[eM\u001b\u0007.Z7f\u0015\tA\u0013&\u0001\u0006qCJ$\u0018\u000e^5p]NT!AK\u0016\u0002\r\r|W.\\8o\u0015\taS&A\u0004ti>\u0014\u0018mZ3\u000b\u00059z\u0013A\u00014t\u0015\t\u0001\u0014'A\u0004hK>lWm]1\u000b\u0005I\u001a\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u000194(\u0011\t\u0003qej\u0011aJ\u0005\u0003u\u001d\u0012Qb\u00159bi&\fGnU2iK6,\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003y\tK!aQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t\tLGo]\u000b\u0002\rB\u0011AhR\u0005\u0003\u0011v\u00121!\u00138u\u0003\u0015\u0011\u0017\u000e^:!\u0003\u00119Wm\\7\u0016\u00031\u0003\"!\u0014+\u000f\u00059\u0013\u0006CA(>\u001b\u0005\u0001&BA)6\u0003\u0019a$o\\8u}%\u00111+P\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T{\u0005)q-Z8nA\u0005Iq-Z8n\u0013:$W\r_\u0001\u000bO\u0016|W.\u00138eKb\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003];z{\u0006C\u0001\u001d\u0001\u0011\u0015!u\u00011\u0001G\u0011\u0015Qu\u00011\u0001M\u0011\u0015Av\u00011\u0001G\u0003\rA(PM\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011QmL\u0001\u0006GV\u0014h/Z\u0005\u0003O\u0012\u0014a\u0001\u0017.3'\u001a\u001b\u0015\u0001\u0002={e\u0001\nq\u0001]1ui\u0016\u0014h.\u0001\thKR\u0004\u0016M\u001d;ji&|gNT1nKR\u0011A\n\u001c\u0005\u0006[.\u0001\rA\\\u0001\bM\u0016\fG/\u001e:f!\tyW/D\u0001q\u0015\t\t(/\u0001\u0004tS6\u0004H.\u001a\u0006\u0003[NT!\u0001^\u001a\u0002\u000f=\u0004XM\\4jg&\u0011a\u000f\u001d\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002#\u001d,GoQ8wKJLgn\u001a$jYR,'\u000f\u0006\u0002z\u007fB\u0011!0`\u0007\u0002w*\u0011Ap]\u0001\u0007M&dG/\u001a:\n\u0005y\\(A\u0002$jYR,'\u000f\u0003\u0004\u0002\u00021\u0001\r\u0001T\u0001\na\u0006\u0014H/\u001b;j_:\fa\u0001Z5hSR\u001cHc\u0001$\u0002\b!)A)\u0004a\u0001\r\u0006qq-\u001a8fe\u0006$XMU1oO\u0016\u001cH\u0003BA\u0007\u0003\u000f\u0002b!a\u0004\u0002\u001a\u0005}a\u0002BA\t\u0003+q1aTA\n\u0013\u0005q\u0014bAA\f{\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u00111aU3r\u0015\r\t9\"\u0010\t\u0005\u0003C\t\tE\u0004\u0003\u0002$\u0005ub\u0002BA\u0013\u0003oqA!a\n\u000249!\u0011\u0011FA\u0019\u001d\u0011\tY#a\f\u000f\u0007=\u000bi#C\u00015\u0013\t\u00114'\u0003\u00021c%\u0019\u0011QG\u0018\u0002\ri|'\u000fZ3s\u0013\u0011\tI$a\u000f\u0002\u000fM47-\u001e:wK*\u0019\u0011QG\u0018\n\t\u0005]\u0011q\b\u0006\u0005\u0003s\tY$\u0003\u0003\u0002D\u0005\u0015#AC%oI\u0016D(+\u00198hK*!\u0011qCA \u0011\u001d\tIE\u0004a\u0001\u0003\u0017\n!\u0001_=\u0011\r\u0005=\u0011\u0011DA'!-a\u0014qJA*\u0003'\n\u0019&a\u0015\n\u0007\u0005ESH\u0001\u0004UkBdW\r\u000e\t\u0004y\u0005U\u0013bAA,{\t1Ai\\;cY\u0016\fAaY8qsR9A,!\u0018\u0002`\u0005\u0005\u0004b\u0002#\u0010!\u0003\u0005\rA\u0012\u0005\b\u0015>\u0001\n\u00111\u0001M\u0011\u001dAv\u0002%AA\u0002\u0019\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002h)\u001aa)!\u001b,\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001e>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\nyGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0000)\u001aA*!\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\"\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006!A.\u00198h\u0015\t\t\t*\u0001\u0003kCZ\f\u0017bA+\u0002\f\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAN\u0003C\u00032\u0001PAO\u0013\r\ty*\u0010\u0002\u0004\u0003:L\b\u0002CAR+\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000b\u0005\u0004\u0002,\u0006E\u00161T\u0007\u0003\u0003[S1!a,>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\u000biK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA]\u0003\u007f\u00032\u0001PA^\u0013\r\ti,\u0010\u0002\b\u0005>|G.Z1o\u0011%\t\u0019kFA\u0001\u0002\u0004\tY*\u0001\u0005iCND7i\u001c3f)\u00051\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002:\u00065\u0007\"CAR5\u0005\u0005\t\u0019AAN\u0003%A&LM*dQ\u0016lW\r\u0005\u000299M!A$!6B!\ra\u0014q[\u0005\u0004\u00033l$AB!osJ+g\r\u0006\u0002\u0002R\u0006!a*Y7f\u0003\u0015q\u0015-\\3!\u0005eA&L\r)beRLG/[8o'\u000eDW-\\3GC\u000e$xN]=\u0014\u0007\u0001\n)\u000f\u0005\u0003\u0002h\u0006uh\u0002BAu\u0003stA!a;\u0002x:!\u0011Q^A{\u001d\u0011\ty/a=\u000f\t\u0005\u001d\u0012\u0011_\u0005\u0003]=J!\u0001L\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\r\tYpJ\u0001\u000e'B\fG/[1m'\u000eDW-\\3\n\t\u0005}(\u0011\u0001\u0002\u001e'B\fG/[1m!\u0006\u0014H/\u001b;j_:\u001c6\r[3nK\u001a\u000b7\r^8ss*\u0019\u00111`\u0014\u0015\u0005\t\u0015\u0001c\u0001B\u0004A5\tA$\u0001\u000bck&dG\rU1si&$\u0018n\u001c8TG\",W.\u001a\u000b\bo\t5!q\u0002B\t\u0011\u0015!%\u00051\u0001G\u0011\u0015Q%\u00051\u0001M\u0011\u0015A&\u00051\u0001G\u0003\u0015\t\u0007\u000f\u001d7z)\u001da&q\u0003B\r\u00057AQ\u0001R\u0012A\u0002\u0019CQAS\u0012A\u00021CQ\u0001W\u0012A\u0002\u0019\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\"\t5\u0002#\u0002\u001f\u0003$\t\u001d\u0012b\u0001B\u0013{\t1q\n\u001d;j_:\u0004b\u0001\u0010B\u0015\r23\u0015b\u0001B\u0016{\t1A+\u001e9mKNB\u0001Ba\f%\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u000e\u0011\t\u0005%%qG\u0005\u0005\u0005s\tYI\u0001\u0004PE*,7\r\u001e")
public class XZ2Scheme
extends SpatialScheme
implements Product,
Serializable {
    private final int bits;
    private final String geom;
    private final int geomIndex;
    private final XZ2SFC xz2;

    public static Option<Tuple3<Object, String, Object>> unapply(XZ2Scheme xZ2Scheme) {
        return XZ2Scheme$.MODULE$.unapply(xZ2Scheme);
    }

    public static XZ2Scheme apply(int n, String string, int n2) {
        return XZ2Scheme$.MODULE$.apply(n, string, n2);
    }

    public static String Name() {
        return XZ2Scheme$.MODULE$.Name();
    }

    public int bits() {
        return this.bits;
    }

    public String geom() {
        return this.geom;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    private XZ2SFC xz2() {
        return this.xz2;
    }

    public String pattern() {
        return new StringBuilder(8).append(this.bits()).append("-bit-xz2").toString();
    }

    public String getPartitionName(SimpleFeature feature) {
        Geometry geometry = (Geometry)feature.getAttribute(this.geom());
        Envelope envelope = geometry.getEnvelopeInternal();
        return Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)this.xz2().index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), this.xz2().index$default$5()))), this.format());
    }

    public Filter getCoveringFilter(String partition) {
        throw new NotImplementedError("https://geomesa.atlassian.net/browse/GEOMESA-2967");
    }

    @Override
    public int digits(int bits) {
        return (int)package$.MODULE$.ceil((double)(bits / 2 + 1) * package$.MODULE$.log10(4.0) - package$.MODULE$.log10(3.0));
    }

    @Override
    public Seq<package.IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> xy) {
        return this.xz2().ranges(xy, this.xz2().ranges$default$2());
    }

    public XZ2Scheme copy(int bits, String geom, int geomIndex) {
        return new XZ2Scheme(bits, geom, geomIndex);
    }

    public int copy$default$1() {
        return this.bits();
    }

    public String copy$default$2() {
        return this.geom();
    }

    public int copy$default$3() {
        return this.geomIndex();
    }

    public String productPrefix() {
        return "XZ2Scheme";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.bits());
            }
            case 1: {
                return this.geom();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.geomIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XZ2Scheme;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.bits());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.geom()));
        n = Statics.mix((int)n, (int)this.geomIndex());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XZ2Scheme)) return false;
        boolean bl = true;
        if (!bl) return false;
        XZ2Scheme xZ2Scheme = (XZ2Scheme)x$1;
        if (this.bits() != xZ2Scheme.bits()) return false;
        String string = this.geom();
        String string2 = xZ2Scheme.geom();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.geomIndex() != xZ2Scheme.geomIndex()) return false;
        if (!xZ2Scheme.canEqual(this)) return false;
        return true;
    }

    public XZ2Scheme(int bits, String geom, int geomIndex) {
        this.bits = bits;
        this.geom = geom;
        this.geomIndex = geomIndex;
        super(bits, geom);
        Product.$init$((Product)this);
        this.xz2 = XZ2SFC$.MODULE$.apply((short)(bits / 2));
    }

    public static class XZ2PartitionSchemeFactory
    extends SpatialScheme.SpatialPartitionSchemeFactory {
        @Override
        public SpatialScheme buildPartitionScheme(int bits, String geom, int geomIndex) {
            return new XZ2Scheme(bits, geom, geomIndex);
        }

        public XZ2PartitionSchemeFactory() {
            super(XZ2Scheme$.MODULE$.Name());
        }
    }
}

