/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata$;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader;
import org.locationtech.geomesa.fs.storage.common.FileSystemThreadedReader$ChainedReaderTask$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.concurrent.package;
import org.opengis.feature.simple.SimpleFeature;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class FileSystemThreadedReader$
implements StrictLogging {
    public static FileSystemThreadedReader$ MODULE$;
    private final Logger logger;

    static {
        new FileSystemThreadedReader$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public CloseableIterator<SimpleFeature> apply(Iterator<Tuple2<AbstractFileSystemStorage.FileSystemPathReader, Seq<StorageMetadata.StorageFilePath>>> readers, int threads) {
        if (threads < 2) {
            return CloseableIterator$.MODULE$.iteratorToCloseable(readers.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    AbstractFileSystemStorage.FileSystemPathReader reader = (AbstractFileSystemStorage.FileSystemPathReader)tuple2._1();
                    Seq files = (Seq)tuple2._2();
                    HashSet mods = HashSet$.MODULE$.empty();
                    return CloseableIterator$.MODULE$.apply(((IterableLike)files.sorted(StorageMetadata$.MODULE$.StorageFilePathOrdering())).iterator(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)f -> MODULE$.org$locationtech$geomesa$fs$storage$common$FileSystemThreadedReader$$read(reader, (StorageMetadata.StorageFilePath)f, (scala.collection.mutable.Set<String>)mods));
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        LinkedBlockingQueue<SimpleFeature> queue = new LinkedBlockingQueue<SimpleFeature>(2000000);
        ExecutorService es = Executors.newFixedThreadPool(threads);
        Phaser phaser = new Phaser(es){
            private final ExecutorService es$1;

            public boolean onAdvance(int phase, int registeredParties) {
                this.es$1.shutdown();
                return true;
            }
            {
                this.es$1 = es$1;
                super(1);
            }
        };
        try {
            try {
                ObjectRef child = ObjectRef.create((Object)new Phaser(phaser));
                IntRef parties = IntRef.create((int)0);
                readers.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        AbstractFileSystemStorage.FileSystemPathReader reader = (AbstractFileSystemStorage.FileSystemPathReader)tuple2._1();
                        Seq files = (Seq)tuple2._2();
                        ListBuffer groups = (ListBuffer)ListBuffer$.MODULE$.empty();
                        ObjectRef group = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.empty()));
                        ((IterableLike)files.sorted(StorageMetadata$.MODULE$.StorageFilePathOrdering())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                            Enumeration.Value value = file.file().action();
                            Enumeration.Value value2 = StorageMetadata.StorageFileAction$.MODULE$.Append();
                            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                                return ((ArrayBuffer)group$1.elem).$plus$eq(file);
                            }
                            if (((ArrayBuffer)group$1.elem).nonEmpty()) {
                                groups.$plus$eq((Object)((ArrayBuffer)group$1.elem).toSeq());
                                group$1.elem = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                            }
                            return groups.$plus$eq((Object)new .colon.colon(file, (List)Nil$.MODULE$));
                        });
                        Object object = ((ArrayBuffer)group.elem).nonEmpty() ? groups.$plus$eq((Object)((ArrayBuffer)group.elem).toSeq()) : BoxedUnit.UNIT;
                        parties$1.elem += groups.length();
                        if (parties$1.elem > package.PhaserUtils$.MODULE$.MaxParties()) {
                            parties$1.elem = groups.length();
                            child$1.elem = new Phaser(phaser);
                        }
                        ((Phaser)child$1.elem).register();
                        return es.submit(new FileSystemThreadedReader.ChainedReaderTask(es, (Phaser)child$1.elem, reader, (Seq<StorageMetadata.StorageFilePath>)((Seq)groups.head()), (Seq<Seq<StorageMetadata.StorageFilePath>>)((ListBuffer)groups.tail()).toSeq(), queue, FileSystemThreadedReader$ChainedReaderTask$.MODULE$.$lessinit$greater$default$7()));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    es.shutdownNow();
                    throw e;
                }
                throw throwable;
            }
        }
        finally {
            phaser.arriveAndDeregister();
        }
        return new FileSystemThreadedReader(es, phaser, queue);
    }

    public CloseableIterator<SimpleFeature> org$locationtech$geomesa$fs$storage$common$FileSystemThreadedReader$$read(AbstractFileSystemStorage.FileSystemPathReader reader, StorageMetadata.StorageFilePath file, scala.collection.mutable.Set<String> mods) {
        Enumeration.Value value = file.file().action();
        Enumeration.Value value2 = StorageMetadata.StorageFileAction$.MODULE$.Append();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new FileSystemThreadedReader.AppendingReaderIterator(reader, file.path(), (Set<String>)mods);
        }
        Enumeration.Value value4 = StorageMetadata.StorageFileAction$.MODULE$.Modify();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new FileSystemThreadedReader.ModifyingReaderIterator(reader, file.path(), mods);
        }
        Enumeration.Value value6 = StorageMetadata.StorageFileAction$.MODULE$.Delete();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return new FileSystemThreadedReader.DeletingReaderIterator(reader, file.path(), mods);
        }
        throw new NotImplementedError(new StringBuilder(27).append("Unexpected storage action: ").append(file.file().action()).toString());
    }

    private FileSystemThreadedReader$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

