/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.s3;

import com.amazonaws.services.s3.AmazonS3;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.common.s3.S3ObjectTagObserver;
import org.locationtech.geomesa.security.SecurityUtils;
import org.locationtech.geomesa.security.VisibilityEvaluator;
import org.locationtech.geomesa.security.VisibilityEvaluator$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0003\u0006\u00013!A1\u0002\u0001B\u0001B\u0003%a\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"B!\u0001\t\u0003\u0011\u0005bB$\u0001\u0005\u0004%I\u0001\u0013\u0005\u0007#\u0002\u0001\u000b\u0011B%\t\u000bI\u0003A\u0011I*\t\u000b\r\u0004A\u0011\u000b3\u0003)M\u001bd+[:jE&d\u0017\u000e^=PEN,'O^3s\u0015\tYA\"\u0001\u0002tg)\u0011QBD\u0001\u0007G>lWn\u001c8\u000b\u0005=\u0001\u0012aB:u_J\fw-\u001a\u0006\u0003#I\t!AZ:\u000b\u0005M!\u0012aB4f_6,7/\u0019\u0006\u0003+Y\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aF\u0001\u0004_J<7\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u0003)I!!\b\u0006\u0003'M\u001btJ\u00196fGR$\u0016mZ(cg\u0016\u0014h/\u001a:\u0011\u0005}9S\"\u0001\u0011\u000b\u0005-\t#B\u0001\u0012$\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001\u0013&\u0003%\tW.\u0019>p]\u0006<8OC\u0001'\u0003\r\u0019w.\\\u0005\u0003Q\u0001\u0012\u0001\"Q7bu>t7kM\u0001\u0005a\u0006$\b\u000e\u0005\u0002,c5\tAF\u0003\u0002\u0012[)\u0011afL\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005A2\u0012AB1qC\u000eDW-\u0003\u00023Y\t!\u0001+\u0019;i\u0003\r!\u0018m\u001a\t\u0003kyr!A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eB\u0012A\u0002\u001fs_>$hHC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f;\u0003\u0019a\u0014N\\5u}Q!1\tR#G!\tY\u0002\u0001C\u0003\f\t\u0001\u0007a\u0004C\u0003*\t\u0001\u0007!\u0006C\u00034\t\u0001\u0007A'\u0001\u0007wSNL'-\u001b7ji&,7/F\u0001J!\rQu\nN\u0007\u0002\u0017*\u0011A*T\u0001\b[V$\u0018M\u00197f\u0015\tq%(\u0001\u0006d_2dWm\u0019;j_:L!\u0001U&\u0003\u0007M+G/A\u0007wSNL'-\u001b7ji&,7\u000fI\u0001\u0006oJLG/\u001a\u000b\u0003)b\u0003\"!\u0016,\u000e\u0003iJ!a\u0016\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u00063\u001e\u0001\rAW\u0001\bM\u0016\fG/\u001e:f!\tY\u0016-D\u0001]\u0015\tif,\u0001\u0004tS6\u0004H.\u001a\u0006\u00033~S!\u0001\u0019\f\u0002\u000f=\u0004XM\\4jg&\u0011!\r\u0018\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\tQ\fwm\u001d\u000b\u0002KB\u0019am\u001b8\u000f\u0005\u001dLgBA\u001ci\u0013\u0005Y\u0014B\u00016;\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0011%#XM]1cY\u0016T!A\u001b\u001e\u0011\tU{G\u0007N\u0005\u0003aj\u0012a\u0001V;qY\u0016\u0014\u0004")
public class S3VisibilityObserver
extends S3ObjectTagObserver {
    private final String tag;
    private final Set<String> visibilities;

    private Set<String> visibilities() {
        return this.visibilities;
    }

    public void write(SimpleFeature feature) {
        String vis = SecurityUtils.getVisibility((SimpleFeature)feature);
        if (vis != null) {
            this.visibilities().add((Object)vis);
            return;
        }
    }

    @Override
    public Iterable<Tuple2<String, String>> tags() {
        if (this.visibilities().isEmpty()) {
            return (Iterable)Nil$.MODULE$;
        }
        Set expressions = (Set)this.visibilities().flatMap((Function1 & Serializable & scala.Serializable)v -> {
            VisibilityEvaluator.VisibilityExpression visibilityExpression = VisibilityEvaluator$.MODULE$.parse(v, VisibilityEvaluator$.MODULE$.parse$default$2());
            if (visibilityExpression instanceof VisibilityEvaluator.VisibilityAnd) {
                VisibilityEvaluator.VisibilityAnd visibilityAnd = (VisibilityEvaluator.VisibilityAnd)visibilityExpression;
                Seq clauses = visibilityAnd.expressions();
                return clauses;
            }
            return (Seq)new .colon.colon((Object)visibilityExpression, (List)Nil$.MODULE$);
        }, Set$.MODULE$.canBuildFrom());
        String vis = new VisibilityEvaluator.VisibilityAnd(expressions.toSeq()).expression();
        return (Iterable)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tag), (Object)Base64.getEncoder().encodeToString(vis.getBytes(StandardCharsets.UTF_8))), (List)Nil$.MODULE$);
    }

    public S3VisibilityObserver(AmazonS3 s3, Path path, String tag) {
        this.tag = tag;
        super(s3, path);
        this.visibilities = Set$.MODULE$.empty();
    }
}

