/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.utils;

import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$FileType$;
import scala.Enumeration;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;

public final class StorageUtils$ {
    public static StorageUtils$ MODULE$;
    private final char LeafSeparator;

    static {
        new StorageUtils$();
    }

    public char LeafSeparator() {
        return this.LeafSeparator;
    }

    public Path baseDirectory(Path root, String partition, boolean leaf) {
        if (leaf) {
            return new Path(root, partition).getParent();
        }
        return new Path(root, partition);
    }

    public Path nextFile(Path root, String partition, boolean leaf, String extension, Enumeration.Value fileType, String name) {
        String filename = new StringBuilder(1).append(fileType).append(name).append(".").append(extension).toString();
        String filenameWithLeaf = leaf ? new StringBuilder(0).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(partition)).split('/'))).last()).append(this.LeafSeparator()).append(filename).toString() : filename;
        return new Path(this.baseDirectory(root, partition, leaf), filenameWithLeaf);
    }

    public String nextFile$default$6() {
        return new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).replaceAllLiterally("-", "");
    }

    public String leaf(String name) {
        return name.substring(0, name.indexOf(this.LeafSeparator()));
    }

    public Option<Enumeration.Value> fileType(String partition, boolean leaf, Path path) {
        int pos = leaf ? ((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(partition)).split('/'))).last()).length() + 1 : 0;
        char c = path.getName().charAt(pos);
        switch (c) {
            case 'W': {
                return new Some((Object)StorageUtils$FileType$.MODULE$.Written());
            }
            case 'C': {
                return new Some((Object)StorageUtils$FileType$.MODULE$.Compacted());
            }
            case 'I': {
                return new Some((Object)StorageUtils$FileType$.MODULE$.Imported());
            }
            case 'M': {
                return new Some((Object)StorageUtils$FileType$.MODULE$.Modified());
            }
            case 'D': {
                return new Some((Object)StorageUtils$FileType$.MODULE$.Deleted());
            }
        }
        return None$.MODULE$;
    }

    private StorageUtils$() {
        MODULE$ = this;
        this.LeafSeparator = (char)95;
    }
}

