/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataSerialization;
import org.locationtech.geomesa.fs.storage.common.metadata.MetadataSerialization$Persistence$;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import pureconfig.ConfigSource$;
import pureconfig.ConfigWriter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class MetadataSerialization$
implements MethodProfiling {
    public static MetadataSerialization$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new MetadataSerialization$();
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        MetadataSerialization$ metadataSerialization$ = this;
        synchronized (metadataSerialization$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void serialize(OutputStream out, package.Metadata metadata) {
        SimpleFeatureType x$1 = metadata.sft();
        boolean x$2 = false;
        boolean x$3 = true;
        Config sftConfig = SimpleFeatureTypes$.MODULE$.toConfig(x$1, x$3, x$2);
        MetadataSerialization.Persistence.PartitionSchemeConfig schemeConfig = new MetadataSerialization.Persistence.PartitionSchemeConfig(metadata.scheme().name(), (Map<String, String>)metadata.scheme().options());
        MetadataSerialization.Persistence.StoragePersistence persistence = new MetadataSerialization.Persistence.StoragePersistence(sftConfig, schemeConfig, (Map<String, String>)metadata.config());
        String data = (String)this.profile("Serialized storage configuration", (Function0 & Serializable & scala.Serializable)() -> ConfigWriter$.MODULE$.apply(MetadataSerialization$Persistence$.MODULE$.StoragePersistenceConvert()).to((Object)persistence).render(package$.MODULE$.RenderOptions()));
        this.profile("Wrote storage configuration", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.write(data.getBytes(StandardCharsets.UTF_8)));
    }

    public package.Metadata deserialize(InputStream in) {
        MetadataSerialization.Persistence.StoragePersistence persistence = (MetadataSerialization.Persistence.StoragePersistence)this.profile("Parsed storage configuration", (Function0 & Serializable & scala.Serializable)() -> {
            MetadataSerialization.Persistence.StoragePersistence storagePersistence;
            Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), (ConfigParseOptions)package$.MODULE$.ParseOptions());
            try {
                storagePersistence = (MetadataSerialization.Persistence.StoragePersistence)ConfigSource$.MODULE$.fromConfig(config).loadOrThrow(ClassTag$.MODULE$.apply(MetadataSerialization.Persistence.StoragePersistence.class), MetadataSerialization$Persistence$.MODULE$.StoragePersistenceConvert());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    storagePersistence = (MetadataSerialization.Persistence.StoragePersistence)MetadataSerialization$.v2$1(config).orElse((Function0 & Serializable & scala.Serializable)() -> MetadataSerialization$.v1$1(config)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw e;
                    });
                }
                throw throwable;
            }
            return storagePersistence;
        });
        SimpleFeatureType sft = (SimpleFeatureType)this.profile("Parsed simple feature type", (Function0 & Serializable & scala.Serializable)() -> {
            Config x$1 = persistence.featureType();
            None$ x$2 = None$.MODULE$;
            Option x$3 = SimpleFeatureTypes$.MODULE$.createType$default$2();
            return SimpleFeatureTypes$.MODULE$.createType(x$1, x$3, (Option)x$2);
        });
        package.NamedOptions scheme = new package.NamedOptions(persistence.partitionScheme().scheme(), persistence.partitionScheme().options());
        return new package.Metadata(sft, scheme, persistence.config());
    }

    private static final Try v1$1(Config config$1) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (MetadataSerialization.Persistence.StoragePersistenceV1)ConfigSource$.MODULE$.fromConfig(config$1).loadOrThrow(ClassTag$.MODULE$.apply(MetadataSerialization.Persistence.StoragePersistenceV1.class), MetadataSerialization$Persistence$.MODULE$.StoragePersistenceV1Convert())).map((Function1 & Serializable & scala.Serializable)p -> {
            boolean leaf = p.partitionScheme().options().get((Object)"leaf-storage").forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equalsIgnoreCase("true")));
            Map config = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package.Metadata$.MODULE$.Encoding()), (Object)p.encoding()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package.Metadata$.MODULE$.LeafStorage()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)leaf)))}));
            return new MetadataSerialization.Persistence.StoragePersistence(p.featureType(), p.partitionScheme(), (Map<String, String>)config);
        });
    }

    private static final Try v2$1(Config config$1) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (MetadataSerialization.Persistence.StoragePersistenceV2)ConfigSource$.MODULE$.fromConfig(config$1).loadOrThrow(ClassTag$.MODULE$.apply(MetadataSerialization.Persistence.StoragePersistenceV2.class), MetadataSerialization$Persistence$.MODULE$.StoragePersistenceV2Convert())).map((Function1 & Serializable & scala.Serializable)p -> {
            String leaf = Boolean.toString(p.leafStorage());
            Map config = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package.Metadata$.MODULE$.Encoding()), (Object)p.encoding()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package.Metadata$.MODULE$.LeafStorage()), (Object)leaf)}));
            return new MetadataSerialization.Persistence.StoragePersistence(p.featureType(), p.partitionScheme(), (Map<String, String>)config);
        });
    }

    private MetadataSerialization$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
    }
}

