/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme;
import org.locationtech.geomesa.fs.storage.common.partitions.Z2Scheme$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002\u0017.\u0001rB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003S\u0011!q\u0006A!f\u0001\n\u0003Y\u0005\u0002C0\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u000b\u0001\u0004A\u0011A1\t\u000f\u0019\u0004!\u0019!C\u0005\u0017\"1q\r\u0001Q\u0001\n1Cq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004q\u0001\u0001\u0006IA\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u00191\b\u0001)A\u0005g\"9q\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002=\u0001A\u0003%1\u000fC\u0003z\u0001\u0011\u0005\u0013\u000bC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0010\u0001!\t%!\u0005\t\u000f\u0005\r\u0002\u0001\"\u0015\u0002&!9\u0011\u0011\u0006\u0001\u0005R\u0005-\u0002\"CA:\u0001\u0005\u0005I\u0011AA;\u0011%\ti\bAI\u0001\n\u0003\ty\bC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002\u0018\"I\u00111\u0014\u0001\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003;\u0003\u0011\u0011!C!\u0003?C\u0001\"a,\u0001\u0003\u0003%\ta\u0013\u0005\n\u0003c\u0003\u0011\u0011!C\u0001\u0003gC\u0011\"a0\u0001\u0003\u0003%\t%!1\t\u0013\u0005=\u0007!!A\u0005\u0002\u0005E\u0007\"CAn\u0001\u0005\u0005I\u0011IAo\u0011%\ty\u000eAA\u0001\n\u0003\n\t\u000fC\u0005\u0002d\u0002\t\t\u0011\"\u0011\u0002f\u001e9\u0011\u0011^\u0017\t\u0002\u0005-hA\u0002\u0017.\u0011\u0003\ti\u000f\u0003\u0004aE\u0011\u0005\u0011Q\u001f\u0005\n\u0003o\u0014#\u0019!C\u0001\u0003?C\u0001\"!?#A\u0003%\u0011\u0011\u0015\u0004\u0007\u0003w\u0014\u0003!!@\t\r\u00014C\u0011\u0001B\u000f\u0011\u001d\u0011\u0019C\nC!\u0005KA\u0011B!\f#\u0003\u0003%\tIa\f\t\u0013\t]\"%!A\u0005\u0002\ne\u0002\"\u0003B&E\u0005\u0005I\u0011\u0002B'\u0005!Q&gU2iK6,'B\u0001\u00180\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0006\u0003aE\naaY8n[>t'B\u0001\u001a4\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001N\u001b\u0002\u0005\u0019\u001c(B\u0001\u001c8\u0003\u001d9Wm\\7fg\u0006T!\u0001O\u001d\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003i\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001fB\u000fB\u0011ahP\u0007\u0002[%\u0011\u0001)\f\u0002\u000e'B\fG/[1m'\u000eDW-\\3\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000fA\u0013x\u000eZ;diB\u0011!\tS\u0005\u0003\u0013\u000e\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fAAY5ugV\tA\n\u0005\u0002C\u001b&\u0011aj\u0011\u0002\u0004\u0013:$\u0018!\u00022jiN\u0004\u0013\u0001B4f_6,\u0012A\u0015\t\u0003'js!\u0001\u0016-\u0011\u0005U\u001bU\"\u0001,\u000b\u0005][\u0014A\u0002\u001fs_>$h(\u0003\u0002Z\u0007\u00061\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI6)A\u0003hK>l\u0007%A\u0005hK>l\u0017J\u001c3fq\u0006Qq-Z8n\u0013:$W\r\u001f\u0011\u0002\rqJg.\u001b;?)\u0011\u00117\rZ3\u0011\u0005y\u0002\u0001\"\u0002&\b\u0001\u0004a\u0005\"\u0002)\b\u0001\u0004\u0011\u0006\"\u00020\b\u0001\u0004a\u0015A\u0002=z\u0005&$8/A\u0004ys\nKGo\u001d\u0011\u0002\u0005i\u0014T#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055,\u0014!B2veZ,\u0017BA8m\u0005\u0015Q&g\u0015$D\u0003\rQ(\u0007I\u0001\bqJ\u000bG-[;t+\u0005\u0019\bC\u0001\"u\u0013\t)8I\u0001\u0004E_V\u0014G.Z\u0001\tqJ\u000bG-[;tA\u00059\u0011PU1eSV\u001c\u0018\u0001C=SC\u0012LWo\u001d\u0011\u0002\u000fA\fG\u000f^3s]\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u000b\u0003%rDQ!`\tA\u0002y\fqAZ3biV\u0014X\rE\u0002\u0000\u0003\u0017i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007g&l\u0007\u000f\\3\u000b\u0007u\f9AC\u0002\u0002\ne\nqa\u001c9f]\u001eL7/\u0003\u0003\u0002\u000e\u0005\u0005!!D*j[BdWMR3biV\u0014X-A\thKR\u001cuN^3sS:<g)\u001b7uKJ$B!a\u0005\u0002 A!\u0011QCA\u000e\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005\u001d\u0011A\u00024jYR,'/\u0003\u0003\u0002\u001e\u0005]!A\u0002$jYR,'\u000f\u0003\u0004\u0002\"I\u0001\rAU\u0001\na\u0006\u0014H/\u001b;j_:\fa\u0001Z5hSR\u001cHc\u0001'\u0002(!)!j\u0005a\u0001\u0019\u0006qq-\u001a8fe\u0006$XMU1oO\u0016\u001cH\u0003BA\u0017\u0003O\u0002b!a\f\u0002:\u0005}b\u0002BA\u0019\u0003kq1!VA\u001a\u0013\u0005!\u0015bAA\u001c\u0007\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001e\u0003{\u00111aU3r\u0015\r\t9d\u0011\t\u0005\u0003\u0003\n\tG\u0004\u0003\u0002D\u0005uc\u0002BA#\u0003/rA!a\u0012\u0002T9!\u0011\u0011JA)\u001d\u0011\tY%a\u0014\u000f\u0007U\u000bi%C\u0001;\u0013\tA\u0014(\u0003\u00027o%\u0019\u0011QK\u001b\u0002\ri|'\u000fZ3s\u0013\u0011\tI&a\u0017\u0002\u000fM47-\u001e:wK*\u0019\u0011QK\u001b\n\t\u0005]\u0012q\f\u0006\u0005\u00033\nY&\u0003\u0003\u0002d\u0005\u0015$AC%oI\u0016D(+\u00198hK*!\u0011qGA0\u0011\u001d\tI\u0007\u0006a\u0001\u0003W\n!\u0001_=\u0011\r\u0005=\u0012\u0011HA7!\u001d\u0011\u0015qN:tgNL1!!\u001dD\u0005\u0019!V\u000f\u001d7fi\u0005!1m\u001c9z)\u001d\u0011\u0017qOA=\u0003wBqAS\u000b\u0011\u0002\u0003\u0007A\nC\u0004Q+A\u0005\t\u0019\u0001*\t\u000fy+\u0002\u0013!a\u0001\u0019\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAAU\ra\u00151Q\u0016\u0003\u0003\u000b\u0003B!a\"\u0002\u00126\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)A\u0005v]\u000eDWmY6fI*\u0019\u0011qR\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0006%%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAMU\r\u0011\u00161Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0016\u0001\u00026bm\u0006L1aWAS\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!.\u0002<B\u0019!)a.\n\u0007\u0005e6IA\u0002B]fD\u0001\"!0\u001c\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0007CBAc\u0003\u0017\f),\u0004\u0002\u0002H*\u0019\u0011\u0011Z\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002N\u0006\u001d'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a5\u0002ZB\u0019!)!6\n\u0007\u0005]7IA\u0004C_>dW-\u00198\t\u0013\u0005uV$!AA\u0002\u0005U\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u00031\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\u000ba!Z9vC2\u001cH\u0003BAj\u0003OD\u0011\"!0!\u0003\u0003\u0005\r!!.\u0002\u0011i\u00134k\u00195f[\u0016\u0004\"A\u0010\u0012\u0014\t\t\nyo\u0012\t\u0004\u0005\u0006E\u0018bAAz\u0007\n1\u0011I\\=SK\u001a$\"!a;\u0002\t9\u000bW.Z\u0001\u0006\u001d\u0006lW\r\t\u0002\u00195J\u0002\u0016M\u001d;ji&|gnU2iK6,g)Y2u_JL8c\u0001\u0014\u0002\u0000B!!\u0011\u0001B\f\u001d\u0011\u0011\u0019Aa\u0005\u000f\t\t\u0015!\u0011\u0003\b\u0005\u0005\u000f\u0011yA\u0004\u0003\u0003\n\t5a\u0002BA$\u0005\u0017I!\u0001N\u001b\n\u0005I\u001a\u0014B\u0001\u00192\u0013\tqs&C\u0002\u0003\u00165\nQb\u00159bi&\fGnU2iK6,\u0017\u0002\u0002B\r\u00057\u0011Qd\u00159bi&\fG\u000eU1si&$\u0018n\u001c8TG\",W.\u001a$bGR|'/\u001f\u0006\u0004\u0005+iCC\u0001B\u0010!\r\u0011\tCJ\u0007\u0002E\u0005!\"-^5mIB\u000b'\u000f^5uS>t7k\u00195f[\u0016$r!\u0010B\u0014\u0005S\u0011Y\u0003C\u0003KQ\u0001\u0007A\nC\u0003QQ\u0001\u0007!\u000bC\u0003_Q\u0001\u0007A*A\u0003baBd\u0017\u0010F\u0004c\u0005c\u0011\u0019D!\u000e\t\u000b)K\u0003\u0019\u0001'\t\u000bAK\u0003\u0019\u0001*\t\u000byK\u0003\u0019\u0001'\u0002\u000fUt\u0017\r\u001d9msR!!1\bB$!\u0015\u0011%Q\bB!\u0013\r\u0011yd\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\t\u0013\u0019\u0005\u0014*M\u0013\r\u0011)e\u0011\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t%#&!AA\u0002\t\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t=\u0003\u0003BAR\u0005#JAAa\u0015\u0002&\n1qJ\u00196fGR\u0004")
public class Z2Scheme
extends SpatialScheme
implements Product,
Serializable {
    private final int bits;
    private final String geom;
    private final int geomIndex;
    private final int xyBits;
    private final Z2SFC z2;
    private final double xRadius;
    private final double yRadius;

    public static Option<Tuple3<Object, String, Object>> unapply(Z2Scheme z2Scheme) {
        return Z2Scheme$.MODULE$.unapply(z2Scheme);
    }

    public static Z2Scheme apply(int n, String string, int n2) {
        return Z2Scheme$.MODULE$.apply(n, string, n2);
    }

    public static String Name() {
        return Z2Scheme$.MODULE$.Name();
    }

    public int bits() {
        return this.bits;
    }

    public String geom() {
        return this.geom;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    private int xyBits() {
        return this.xyBits;
    }

    private Z2SFC z2() {
        return this.z2;
    }

    private double xRadius() {
        return this.xRadius;
    }

    private double yRadius() {
        return this.yRadius;
    }

    public String pattern() {
        return new StringBuilder(7).append(this.bits()).append("-bit-z2").toString();
    }

    public String getPartitionName(SimpleFeature feature) {
        Point pt = (Point)feature.getAttribute(this.geomIndex());
        return Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)this.z2().index(pt.getX(), pt.getY(), this.z2().index$default$3()))), this.format());
    }

    public Filter getCoveringFilter(String partition) {
        Tuple2 tuple2 = this.z2().invert(new StringOps(Predef$.MODULE$.augmentString(partition)).toLong());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double y = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
        double x2 = sp2._1$mcD$sp();
        double y2 = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(x2 - this.xRadius(), x2 + this.xRadius());
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        double xmin = sp3._1$mcD$sp();
        double xmax = sp3._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(xmin, xmax);
        double xmin2 = sp4._1$mcD$sp();
        double xmax2 = sp4._2$mcD$sp();
        Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(y2 - this.yRadius(), y2 + this.yRadius());
        if (sp5 == null) {
            throw new MatchError((Object)sp5);
        }
        double ymin = sp5._1$mcD$sp();
        double ymax = sp5._2$mcD$sp();
        Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(ymin, ymax);
        double ymin2 = sp6._1$mcD$sp();
        double ymax2 = sp6._2$mcD$sp();
        BBOX bbox = org.locationtech.geomesa.filter.package$.MODULE$.ff().bbox((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom()), (BoundingBox)new ReferencedEnvelope(xmin2, xmax2, ymin2, ymax2, package$.MODULE$.CRS_EPSG_4326()));
        None$ xExclusive = xmax2 == this.z2().lon().max() ? None$.MODULE$ : new Some((Object)org.locationtech.geomesa.filter.package$.MODULE$.ff().less((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().function("getX", new Expression[]{org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom())}), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal(xmax2)));
        None$ yExclusive = ymax2 == this.z2().lat().max() ? None$.MODULE$ : new Some((Object)org.locationtech.geomesa.filter.package$.MODULE$.ff().less((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().function("getY", new Expression[]{org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom())}), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal(ymax2)));
        return org.locationtech.geomesa.filter.package$.MODULE$.andFilters((Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)bbox, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)xExclusive), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)yExclusive), Seq$.MODULE$.canBuildFrom()), (FilterFactory)org.locationtech.geomesa.filter.package$.MODULE$.ff());
    }

    @Override
    public int digits(int bits) {
        return (int)scala.math.package$.MODULE$.ceil((double)bits * scala.math.package$.MODULE$.log10(2.0));
    }

    @Override
    public Seq<package.IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> xy) {
        return this.z2().ranges(xy, this.z2().ranges$default$2(), this.z2().ranges$default$3());
    }

    public Z2Scheme copy(int bits, String geom, int geomIndex) {
        return new Z2Scheme(bits, geom, geomIndex);
    }

    public int copy$default$1() {
        return this.bits();
    }

    public String copy$default$2() {
        return this.geom();
    }

    public int copy$default$3() {
        return this.geomIndex();
    }

    public String productPrefix() {
        return "Z2Scheme";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.bits());
            }
            case 1: {
                return this.geom();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.geomIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Z2Scheme;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.bits());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.geom()));
        n = Statics.mix((int)n, (int)this.geomIndex());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Z2Scheme)) return false;
        boolean bl = true;
        if (!bl) return false;
        Z2Scheme z2Scheme = (Z2Scheme)x$1;
        if (this.bits() != z2Scheme.bits()) return false;
        String string = this.geom();
        String string2 = z2Scheme.geom();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.geomIndex() != z2Scheme.geomIndex()) return false;
        if (!z2Scheme.canEqual(this)) return false;
        return true;
    }

    public Z2Scheme(int bits, String geom, int geomIndex) {
        this.bits = bits;
        this.geom = geom;
        this.geomIndex = geomIndex;
        super(bits, geom);
        Product.$init$((Product)this);
        this.xyBits = bits / 2;
        this.z2 = new Z2SFC(this.xyBits());
        this.xRadius = 360.0 / scala.math.package$.MODULE$.pow(2.0, (double)this.xyBits()) / (double)2;
        this.yRadius = 180.0 / scala.math.package$.MODULE$.pow(2.0, (double)this.xyBits()) / (double)2;
    }

    public static class Z2PartitionSchemeFactory
    extends SpatialScheme.SpatialPartitionSchemeFactory {
        @Override
        public SpatialScheme buildPartitionScheme(int bits, String geom, int geomIndex) {
            return new Z2Scheme(bits, geom, geomIndex);
        }

        public Z2PartitionSchemeFactory() {
            super(Z2Scheme$.MODULE$.Name());
        }
    }
}

