/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.s3;

import com.amazonaws.services.s3.AmazonS3;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserverFactory;
import org.locationtech.geomesa.fs.storage.common.s3.S3VisibilityObserver;
import org.locationtech.geomesa.fs.storage.common.s3.S3VisibilityObserverFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u000b\u0017\u0001\u0015BQ\u0001\u000e\u0001\u0005\u0002UB\u0011\"\b\u0001A\u0002\u0003\u0007I\u0011\u0002\u001d\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0005\"\u0003'\u0001\u0001\u0004\u0005\t\u0015)\u0003:\u0011%9\u0002\u00011AA\u0002\u0013%Q\nC\u0005Z\u0001\u0001\u0007\t\u0019!C\u00055\"IA\f\u0001a\u0001\u0002\u0003\u0006KA\u0014\u0005\n;\u0002\u0001\r\u00111A\u0005\nyC\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011B6\t\u00135\u0004\u0001\u0019!A!B\u0013y\u0006\"\u00028\u0001\t\u0003z\u0007bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003G\u0001A\u0011IA\u0013\u000f\u001d\t9C\u0006E\u0001\u0003S1a!\u0006\f\t\u0002\u0005-\u0002B\u0002\u001b\u0010\t\u0003\t\u0019\u0004C\u0005\u00026=\u0011\r\u0011\"\u0001\u00028!A\u0011QH\b!\u0002\u0013\tI\u0004C\u0005\u0002@=\u0011\r\u0011\"\u0001\u00028!A\u0011\u0011I\b!\u0002\u0013\tIDA\u000eTgYK7/\u001b2jY&$\u0018p\u00142tKJ4XM\u001d$bGR|'/\u001f\u0006\u0003/a\t!a]\u001a\u000b\u0005eQ\u0012AB2p[6|gN\u0003\u0002\u001c9\u000591\u000f^8sC\u001e,'BA\u000f\u001f\u0003\t17O\u0003\u0002 A\u00059q-Z8nKN\f'BA\u0011#\u00031awnY1uS>tG/Z2i\u0015\u0005\u0019\u0013aA8sO\u000e\u00011c\u0001\u0001']A\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0005Y\u0006twMC\u0001,\u0003\u0011Q\u0017M^1\n\u00055B#AB(cU\u0016\u001cG\u000f\u0005\u00020e5\t\u0001G\u0003\u000221\u0005AqNY:feZ,'/\u0003\u00024a\tIb)\u001b7f'f\u001cH/Z7PEN,'O^3s\r\u0006\u001cGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\ta#F\u0001:!\tQ\u0004)D\u0001<\u0015\tiBH\u0003\u0002>}\u00051\u0001.\u00193p_BT!a\u0010\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t5H\u0001\u0006GS2,7+_:uK6\faAZ:`I\u0015\fHC\u0001#K!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0011)f.\u001b;\t\u000f-\u001b\u0011\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\u0002\u0007\u0019\u001c\b%F\u0001O!\tyu+D\u0001Q\u0015\t9\u0012K\u0003\u0002S'\u0006A1/\u001a:wS\u000e,7O\u0003\u0002U+\u0006I\u0011-\\1{_:\fwo\u001d\u0006\u0002-\u0006\u00191m\\7\n\u0005a\u0003&\u0001C!nCj|gnU\u001a\u0002\rM\u001ct\fJ3r)\t!5\fC\u0004L\r\u0005\u0005\t\u0019\u0001(\u0002\u0007M\u001c\u0004%A\u0002uC\u001e,\u0012a\u0018\t\u0003A\u001et!!Y3\u0011\u0005\t4U\"A2\u000b\u0005\u0011$\u0013A\u0002\u001fs_>$h(\u0003\u0002g\r\u00061\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1g)A\u0004uC\u001e|F%Z9\u0015\u0005\u0011c\u0007bB&\n\u0003\u0003\u0005\raX\u0001\u0005i\u0006<\u0007%\u0001\u0003j]&$H\u0003\u0002#qorDQ!]\u0006A\u0002I\fAaY8oMB\u00111/^\u0007\u0002i*\u0011\u0011\u000fP\u0005\u0003mR\u0014QbQ8oM&<WO]1uS>t\u0007\"\u0002=\f\u0001\u0004I\u0018\u0001\u0002:p_R\u0004\"A\u000f>\n\u0005m\\$\u0001\u0002)bi\"DQ!`\u0006A\u0002y\f1a\u001d4u!\ry\u0018\u0011C\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u000511/[7qY\u0016TA!a\u0002\u0002\n\u00059a-Z1ukJ,'\u0002BA\u0006\u0003\u001b\t1!\u00199j\u0015\r\tyAI\u0001\tO\u0016|Go\\8mg&!\u00111CA\u0001\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u00033\ty\u0002E\u00020\u00037I1!!\b1\u0005I1\u0015\u000e\\3TsN$X-\\(cg\u0016\u0014h/\u001a:\t\r\u0005\u0005B\u00021\u0001z\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000b\rdwn]3\u0015\u0003\u0011\u000b1dU\u001aWSNL'-\u001b7jif|%m]3sm\u0016\u0014h)Y2u_JL\bCA\u001c\u0010'\ry\u0011Q\u0006\t\u0004\u000b\u0006=\u0012bAA\u0019\r\n1\u0011I\\=SK\u001a$\"!!\u000b\u0002\u001bQ\u000bwMT1nK\u000e{gNZ5h+\t\tI\u0004E\u0002(\u0003wI!\u0001\u001b\u0015\u0002\u001dQ\u000bwMT1nK\u000e{gNZ5hA\u0005QA)\u001a4bk2$H+Y4\u0002\u0017\u0011+g-Y;miR\u000bw\r\t")
public class S3VisibilityObserverFactory
implements FileSystemObserverFactory {
    private FileSystem fs;
    private AmazonS3 s3;
    private String tag;

    public static String DefaultTag() {
        return S3VisibilityObserverFactory$.MODULE$.DefaultTag();
    }

    public static String TagNameConfig() {
        return S3VisibilityObserverFactory$.MODULE$.TagNameConfig();
    }

    private FileSystem fs() {
        return this.fs;
    }

    private void fs_$eq(FileSystem x$1) {
        this.fs = x$1;
    }

    private AmazonS3 s3() {
        return this.s3;
    }

    private void s3_$eq(AmazonS3 x$1) {
        this.s3 = x$1;
    }

    private String tag() {
        return this.tag;
    }

    private void tag_$eq(String x$1) {
        this.tag = x$1;
    }

    @Override
    public void init(Configuration conf, Path root, SimpleFeatureType sft) {
        try {
            this.fs_$eq(root.getFileSystem(conf));
            Field field = this.fs().getClass().getDeclaredField("s3");
            field.setAccessible(true);
            this.s3_$eq((AmazonS3)field.get(this.fs()));
            this.tag_$eq(conf.get(S3VisibilityObserverFactory$.MODULE$.TagNameConfig(), S3VisibilityObserverFactory$.MODULE$.DefaultTag()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get s3 client", e);
        }
    }

    @Override
    public FileSystemObserver apply(Path path) {
        return new S3VisibilityObserver(this.s3(), path, this.tag());
    }

    @Override
    public void close() {
        this.s3_$eq(null);
        if (this.fs() != null) {
            try {
                try {
                    this.fs().close();
                }
                catch (Exception e) {
                    throw new IOException("Error closing S3 filesystem", e);
                }
            }
            finally {
                this.fs_$eq(null);
            }
            return;
        }
    }
}

