/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.partitions.DateTimeScheme$;
import org.locationtech.geomesa.fs.storage.common.partitions.DateTimeScheme$Config$;
import org.locationtech.geomesa.fs.storage.common.partitions.DateTimeScheme$Formats$;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.text.DateParsing$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyInt;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0011Ma!\u0002:t\u0001\u0006\u0015\u0001BCA\u0016\u0001\tU\r\u0011\"\u0001\u0002.!Q\u00111\t\u0001\u0003\u0012\u0003\u0006I!a\f\t\u0015\u0005\u0015\u0003A!f\u0001\n\u0003\t9\u0005\u0003\u0006\u0002`\u0001\u0011\t\u0012)A\u0005\u0003\u0013B!\"!\u0019\u0001\u0005+\u0007I\u0011AA2\u0011)\t\t\b\u0001B\tB\u0003%\u0011Q\r\u0005\u000b\u0003g\u0002!Q3A\u0005\u0002\u0005U\u0004BCA?\u0001\tE\t\u0015!\u0003\u0002x!Q\u0011q\u0010\u0001\u0003\u0016\u0004%\t!a\u0012\t\u0015\u0005\u0005\u0005A!E!\u0002\u0013\tI\u0005\u0003\u0006\u0002\u0004\u0002\u0011)\u001a!C\u0001\u0003kB!\"!\"\u0001\u0005#\u0005\u000b\u0011BA<\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013C\u0011\"a'\u0001\u0005\u0004%I!!(\t\u0011\u00055\u0006\u0001)A\u0005\u0003?C\u0011\"a,\u0001\u0005\u0004%\t%!\u001e\t\u0011\u0005E\u0006\u0001)A\u0005\u0003oBq!a-\u0001\t\u0003\n)\fC\u0004\u0002P\u0002!\t%!5\t\u000f\t\u0015\u0002\u0001\"\u0011\u0003(!9!q\u0006\u0001\u0005B\tE\u0002b\u0002B\u001b\u0001\u0011%!q\u0007\u0005\n\u0005\u0007\u0002\u0011\u0011!C\u0001\u0005\u000bB\u0011Ba\u0015\u0001#\u0003%\tA!\u0016\t\u0013\t-\u0004!%A\u0005\u0002\t5\u0004\"\u0003B9\u0001E\u0005I\u0011\u0001B:\u0011%\u00119\bAI\u0001\n\u0003\u0011I\bC\u0005\u0003~\u0001\t\n\u0011\"\u0001\u0003n!I!q\u0010\u0001\u0012\u0002\u0013\u0005!\u0011\u0010\u0005\n\u0005\u0003\u0003\u0011\u0011!C!\u0005\u0007C\u0011Ba$\u0001\u0003\u0003%\t!!\u001e\t\u0013\tE\u0005!!A\u0005\u0002\tM\u0005\"\u0003BP\u0001\u0005\u0005I\u0011\tBQ\u0011%\u0011y\u000bAA\u0001\n\u0003\u0011\t\fC\u0005\u0003<\u0002\t\t\u0011\"\u0011\u0003>\"I!q\u0018\u0001\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0005\u0007\u0004\u0011\u0011!C!\u0005\u000b<qA!3t\u0011\u0003\u0011YM\u0002\u0004sg\"\u0005!Q\u001a\u0005\b\u0003\u000f;C\u0011\u0001Bh\u0011%\u0011\tn\nb\u0001\n\u0003\u0011\u0019\t\u0003\u0005\u0003T\u001e\u0002\u000b\u0011\u0002BC\u0011\u001d\u0011)n\nC\u0001\u0005/DqA!6(\t\u0003\u0011\u0019oB\u0004\u0004\u0010\u001dB\ta!\u0005\u0007\u000f\rUq\u0005#\u0001\u0004\u0018!9\u0011q\u0011\u0018\u0005\u0002\re\u0001\"CB\u000e]\t\u0007I\u0011AA$\u0011!\u0019iB\fQ\u0001\n\u0005%\u0003\"CB\u0010]\t\u0007I\u0011AA$\u0011!\u0019\tC\fQ\u0001\n\u0005%\u0003\"CB\u0012]\t\u0007I\u0011AA$\u0011!\u0019)C\fQ\u0001\n\u0005%\u0003\"CB\u0014]\t\u0007I\u0011AA$\u0011!\u0019IC\fQ\u0001\n\u0005%saBB\u0016O!\u00051Q\u0006\u0004\b\u0007_9\u0003\u0012AB\u0019\u0011\u001d\t9)\u000fC\u0001\u0007gAqA!6:\t\u0003\u0019)D\u0002\u0004\u0004>e\u00025q\b\u0005\u000b\u0007\u0003b$Q3A\u0005\u0002\u0005\u001d\u0003BCB\"y\tE\t\u0015!\u0003\u0002J!Q\u00111\u0006\u001f\u0003\u0016\u0004%\t!!\f\t\u0015\u0005\rCH!E!\u0002\u0013\ty\u0003\u0003\u0006\u0002Fq\u0012)\u001a!C\u0001\u0003\u000fB!\"a\u0018=\u0005#\u0005\u000b\u0011BA%\u0011)\u0019)\u0005\u0010BK\u0002\u0013\u0005\u00111\r\u0005\u000b\u0007\u000fb$\u0011#Q\u0001\n\u0005\u0015\u0004\u0002CADy\u0011\u0005\u0011h!\u0013\t\u0013\t\rC(!A\u0005\u0002\rM\u0003\"\u0003B*yE\u0005I\u0011\u0001B7\u0011%\u0011Y\u0007PI\u0001\n\u0003\u0011)\u0006C\u0005\u0003rq\n\n\u0011\"\u0001\u0003n!I!q\u000f\u001f\u0012\u0002\u0013\u0005!1\u000f\u0005\n\u0005\u0003c\u0014\u0011!C!\u0005\u0007C\u0011Ba$=\u0003\u0003%\t!!\u001e\t\u0013\tEE(!A\u0005\u0002\ru\u0003\"\u0003BPy\u0005\u0005I\u0011\tBQ\u0011%\u0011y\u000bPA\u0001\n\u0003\u0019\t\u0007C\u0005\u0003<r\n\t\u0011\"\u0011\u0003>\"I!q\u0018\u001f\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0005\u0007d\u0014\u0011!C!\u0007K:\u0001ba\u001b:\u0011\u0003I4Q\u000e\u0004\t\u0007{I\u0004\u0012A\u001d\u0004p!9\u0011q\u0011+\u0005\u0002\rE\u0004b\u0002Bk)\u0012\u000511\u000f\u0005\n\u0005+$\u0016\u0011!CA\u0007wB\u0011b!\"U\u0003\u0003%\tia\"\t\u0013\rUE+!A\u0005\n\r]\u0005\"CBPs\t\u0007I\u0011ABQ\u0011!\u0019\u0019+\u000fQ\u0001\n\re\u0002\"CBSs\t\u0007I\u0011ABQ\u0011!\u00199+\u000fQ\u0001\n\re\u0002\"CBUs\t\u0007I\u0011ABQ\u0011!\u0019Y+\u000fQ\u0001\n\re\u0002\"CBWs\t\u0007I\u0011ABQ\u0011!\u0019y+\u000fQ\u0001\n\re\u0002\"CBYs\t\u0007I\u0011ABQ\u0011!\u0019\u0019,\u000fQ\u0001\n\re\u0002\"CB[s\t\u0007I\u0011ABQ\u0011!\u00199,\u000fQ\u0001\n\re\u0002\"CB]s\t\u0007I\u0011ABQ\u0011!\u0019Y,\u000fQ\u0001\n\re\u0002\"CB_s\t\u0007I\u0011ABQ\u0011!\u0019y,\u000fQ\u0001\n\re\u0002\"CBas\t\u0007I\u0011BBb\u0011!\u0019I-\u000fQ\u0001\n\r\u0015gABBfO\u0001\u0019i\rC\u0004\u0002\b2$\ta!6\t\u000f\reG\u000e\"\u0011\u0004\\\"I!Q[\u0014\u0002\u0002\u0013\u00055\u0011 \u0005\n\u0007\u000b;\u0013\u0011!CA\t\u000fA\u0011b!&(\u0003\u0003%Iaa&\u0003\u001d\u0011\u000bG/\u001a+j[\u0016\u001c6\r[3nK*\u0011A/^\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c(B\u0001<x\u0003\u0019\u0019w.\\7p]*\u0011\u00010_\u0001\bgR|'/Y4f\u0015\tQ80\u0001\u0002gg*\u0011A0`\u0001\bO\u0016|W.Z:b\u0015\tqx0\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007N\u0003\u0002\u0002\u0002\u0005\u0019qN]4\u0004\u0001MI\u0001!a\u0002\u0002\u0014\u0005}\u0011Q\u0005\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0011\u0011QB\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003#\tYA\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D<\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u001e\u0005]!a\u0004)beRLG/[8o'\u000eDW-\\3\u0011\t\u0005%\u0011\u0011E\u0005\u0005\u0003G\tYAA\u0004Qe>$Wo\u0019;\u0011\t\u0005%\u0011qE\u0005\u0005\u0003S\tYA\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0005g_Jl\u0017\r\u001e;feV\u0011\u0011q\u0006\t\u0005\u0003c\ty$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u00191wN]7bi*!\u0011\u0011HA\u001e\u0003\u0011!\u0018.\\3\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!!\u0011\u00024\t\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\u0002\u0015\u0019|'/\\1ui\u0016\u0014\b%A\u0004qCR$XM\u001d8\u0016\u0005\u0005%\u0003\u0003BA&\u00033rA!!\u0014\u0002VA!\u0011qJA\u0006\u001b\t\t\tF\u0003\u0003\u0002T\u0005\r\u0011A\u0002\u001fs_>$h(\u0003\u0003\u0002X\u0005-\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#AB*ue&twM\u0003\u0003\u0002X\u0005-\u0011\u0001\u00039biR,'O\u001c\u0011\u0002\u0011M$X\r]+oSR,\"!!\u001a\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SRA!a\u001b\u00028\u0005AA/Z7q_J\fG.\u0003\u0003\u0002p\u0005%$AC\"ie>tw.\u00168ji\u0006I1\u000f^3q+:LG\u000fI\u0001\u0005gR,\u0007/\u0006\u0002\u0002xA!\u0011\u0011BA=\u0013\u0011\tY(a\u0003\u0003\u0007%sG/A\u0003ti\u0016\u0004\b%A\u0002ei\u001e\fA\u0001\u001a;hA\u0005AA\r^4J]\u0012,\u00070A\u0005ei\u001eLe\u000eZ3yA\u00051A(\u001b8jiz\"b\"a#\u0002\u0010\u0006E\u00151SAK\u0003/\u000bI\nE\u0002\u0002\u000e\u0002i\u0011a\u001d\u0005\b\u0003Wi\u0001\u0019AA\u0018\u0011\u001d\t)%\u0004a\u0001\u0003\u0013Bq!!\u0019\u000e\u0001\u0004\t)\u0007C\u0004\u0002t5\u0001\r!a\u001e\t\u000f\u0005}T\u00021\u0001\u0002J!9\u00111Q\u0007A\u0002\u0005]\u0014\u0001\u0003;sk:\u001c\u0017\r^3\u0016\u0005\u0005}\u0005\u0003CA\u0005\u0003C\u000b)+!*\n\t\u0005\r\u00161\u0002\u0002\n\rVt7\r^5p]F\u0002B!a*\u0002*6\u0011\u0011qG\u0005\u0005\u0003W\u000b9DA\u0007[_:,G\rR1uKRKW.Z\u0001\niJ,hnY1uK\u0002\nQ\u0001Z3qi\"\fa\u0001Z3qi\"\u0004\u0013\u0001E4fiB\u000b'\u000f^5uS>tg*Y7f)\u0011\tI%a.\t\u000f\u0005e&\u00031\u0001\u0002<\u00069a-Z1ukJ,\u0007\u0003BA_\u0003\u0017l!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005e\u0016Q\u0019\u0006\u0005\u00033\t9MC\u0002\u0002J~\f\u0001bZ3pi>|Gn]\u0005\u0005\u0003\u001b\fyLA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\u0015O\u0016$8+[7qY&4\u0017.\u001a3GS2$XM]:\u0015\r\u0005M'\u0011\u0003B\u0010!\u0019\tI!!6\u0002Z&!\u0011q[A\u0006\u0005\u0019y\u0005\u000f^5p]B1\u00111\\As\u0003WtA!!8\u0002b:!\u0011qJAp\u0013\t\ti!\u0003\u0003\u0002d\u0006-\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003O\fIOA\u0002TKFTA!a9\u0002\fA!\u0011Q\u001eB\u0006\u001d\u0011\tyOa\u0002\u000f\t\u0005E(Q\u0001\b\u0005\u0003g\u0014\u0019A\u0004\u0003\u0002v\n\u0005a\u0002BA|\u0003\u007ftA!!?\u0002~:!\u0011qJA~\u0013\t\t\t!\u0003\u0002\u007f\u007f&\u0011A0`\u0005\u0003unL!\u0001_=\n\u0007\u0005eq/\u0003\u0003\u0003\n\u0005]\u0011a\u0004)beRLG/[8o'\u000eDW-\\3\n\t\t5!q\u0002\u0002\u0011'&l\u0007\u000f\\5gS\u0016$g)\u001b7uKJTAA!\u0003\u0002\u0018!9!1C\nA\u0002\tU\u0011A\u00024jYR,'\u000f\u0005\u0003\u0003\u0018\tmQB\u0001B\r\u0015\u0011\u0011\u0019\"!2\n\t\tu!\u0011\u0004\u0002\u0007\r&dG/\u001a:\t\u0013\t\u00052\u0003%AA\u0002\t\r\u0012!\u00039beRLG/[8o!\u0019\tI!!6\u0002J\u0005Ir-\u001a;J]R,'o]3di&tw\rU1si&$\u0018n\u001c8t)\u0011\u0011IC!\f\u0011\r\u0005%\u0011Q\u001bB\u0016!\u0019\tY.!:\u0002J!9!1\u0003\u000bA\u0002\tU\u0011!E4fi\u000e{g/\u001a:j]\u001e4\u0015\u000e\u001c;feR!!Q\u0003B\u001a\u0011\u001d\u0011\t#\u0006a\u0001\u0003\u0013\nQcZ3u\u0007>4XM]5oOB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003:\t\u0005\u0003CBA\u0005\u0003+\u0014Y\u0004\u0005\u0005\u0002\n\tu\"1\u0006B\u0016\u0013\u0011\u0011y$a\u0003\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011\u0019B\u0006a\u0001\u0005+\tAaY8qsRq\u00111\u0012B$\u0005\u0013\u0012YE!\u0014\u0003P\tE\u0003\"CA\u0016/A\u0005\t\u0019AA\u0018\u0011%\t)e\u0006I\u0001\u0002\u0004\tI\u0005C\u0005\u0002b]\u0001\n\u00111\u0001\u0002f!I\u00111O\f\u0011\u0002\u0003\u0007\u0011q\u000f\u0005\n\u0003\u007f:\u0002\u0013!a\u0001\u0003\u0013B\u0011\"a!\u0018!\u0003\u0005\r!a\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u000b\u0016\u0005\u0003_\u0011If\u000b\u0002\u0003\\A!!Q\fB4\u001b\t\u0011yF\u0003\u0003\u0003b\t\r\u0014!C;oG\",7m[3e\u0015\u0011\u0011)'a\u0003\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003j\t}#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B8U\u0011\tIE!\u0017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u000f\u0016\u0005\u0003K\u0012I&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tm$\u0006BA<\u00053\nabY8qs\u0012\"WMZ1vYR$S'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011)\t\u0005\u0003\u0003\b\n5UB\u0001BE\u0015\u0011\u0011Y)a\u000f\u0002\t1\fgnZ\u0005\u0005\u00037\u0012I)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tU%1\u0014\t\u0005\u0003\u0013\u00119*\u0003\u0003\u0003\u001a\u0006-!aA!os\"I!Q\u0014\u0011\u0002\u0002\u0003\u0007\u0011qO\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0006C\u0002BS\u0005W\u0013)*\u0004\u0002\u0003(*!!\u0011VA\u0006\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005[\u00139K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BZ\u0005s\u0003B!!\u0003\u00036&!!qWA\u0006\u0005\u001d\u0011un\u001c7fC:D\u0011B!(#\u0003\u0003\u0005\rA!&\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u001e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\"\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019La2\t\u0013\tuU%!AA\u0002\tU\u0015A\u0004#bi\u0016$\u0016.\\3TG\",W.\u001a\t\u0004\u0003\u001b;3#B\u0014\u0002\b\u0005\u0015BC\u0001Bf\u0003\u0011q\u0015-\\3\u0002\u000b9\u000bW.\u001a\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005-%\u0011\u001cBn\u0005;\u0014yN!9\t\u000f\u0005U2\u00061\u0001\u0002J!9\u0011\u0011M\u0016A\u0002\u0005\u0015\u0004bBA:W\u0001\u0007\u0011q\u000f\u0005\b\u0003\u007fZ\u0003\u0019AA%\u0011\u001d\t\u0019i\u000ba\u0001\u0003o\"B\"a#\u0003f\n\u001d(\u0011\u001eBv\u0005[Dq!a\u000b-\u0001\u0004\ty\u0003C\u0004\u0002b1\u0002\r!!\u001a\t\u000f\u0005MD\u00061\u0001\u0002x!9\u0011q\u0010\u0017A\u0002\u0005%\u0003bBABY\u0001\u0007\u0011q\u000f\u0015\bY\tE(q\u001fB~!\u0011\tIAa=\n\t\tU\u00181\u0002\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017E\u0001B}\u0003I\u0002\u0016\r\u001e;fe:\u0004\u0013n\u001d\u0011o_R\u00043m\u001c:sK\u000e$\be\u001e5f]\u0002*8/\u001b8hAQD\u0017n\u001d\u0011d_:\u001cHO];di>\u0014\u0018'C\u0012\u0002J\tu8Q\u0001B\u0000\u0013\u0011\u0011yp!\u0001\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0015\u0011\u0019\u0019!a\u0003\u0002\u0015\u0011,\u0007O]3dCR,G-M\u0005$\u0007\u000f\u0019Iaa\u0003\u0004\u00049!\u0011\u0011BB\u0005\u0013\u0011\u0019\u0019!a\u00032\u000f\t\nI!a\u0003\u0004\u000e\t)1oY1mC\u000611i\u001c8gS\u001e\u00042aa\u0005/\u001b\u00059#AB\"p]\u001aLwmE\u0002/\u0003\u000f!\"a!\u0005\u0002#\u0011\u000bG/\u001a+j[\u00164uN]7bi>\u0003H/\u0001\nECR,G+[7f\r>\u0014X.\u0019;PaR\u0004\u0013aC*uKB,f.\u001b;PaR\fAb\u0015;faVs\u0017\u000e^(qi\u0002\nqa\u0015;fa>\u0003H/\u0001\u0005Ti\u0016\u0004x\n\u001d;!\u00031!EoZ!uiJL'-\u001e;f\u00035!EoZ!uiJL'-\u001e;fA\u00059ai\u001c:nCR\u001c\bcAB\ns\t9ai\u001c:nCR\u001c8cA\u001d\u0002\bQ\u00111Q\u0006\u000b\u0005\u0007o\u0019I\u0007\u0005\u0004\u0002\n\u0005U7\u0011\b\t\u0004\u0007waT\"A\u001d\u0003\r\u0019{'/\\1u'\u001da\u0014qAA\u0010\u0003K\tAA\\1nK\u0006)a.Y7fA\u0005!QO\\5u\u0003\u0015)h.\u001b;!))\u0019Ida\u0013\u0004N\r=3\u0011\u000b\u0005\b\u0007\u0003*\u0005\u0019AA%\u0011\u001d\tY#\u0012a\u0001\u0003_Aq!!\u0012F\u0001\u0004\tI\u0005C\u0004\u0004F\u0015\u0003\r!!\u001a\u0015\u0015\re2QKB,\u00073\u001aY\u0006C\u0005\u0004B\u0019\u0003\n\u00111\u0001\u0002J!I\u00111\u0006$\u0011\u0002\u0003\u0007\u0011q\u0006\u0005\n\u0003\u000b2\u0005\u0013!a\u0001\u0003\u0013B\u0011b!\u0012G!\u0003\u0005\r!!\u001a\u0015\t\tU5q\f\u0005\n\u0005;k\u0015\u0011!a\u0001\u0003o\"BAa-\u0004d!I!QT(\u0002\u0002\u0003\u0007!Q\u0013\u000b\u0005\u0005g\u001b9\u0007C\u0005\u0003\u001eJ\u000b\t\u00111\u0001\u0003\u0016\"91\u0011I\u001eA\u0002\u0005%\u0013A\u0002$pe6\fG\u000fE\u0002\u0004<Q\u001bR\u0001VA\u0004\u0003K!\"a!\u001c\u0015\u0011\re2QOB<\u0007sBqa!\u0011W\u0001\u0004\tI\u0005C\u0004\u00026Y\u0003\r!!\u0013\t\u000f\r\u0015c\u000b1\u0001\u0002fQQ1\u0011HB?\u0007\u007f\u001a\tia!\t\u000f\r\u0005s\u000b1\u0001\u0002J!9\u00111F,A\u0002\u0005=\u0002bBA#/\u0002\u0007\u0011\u0011\n\u0005\b\u0007\u000b:\u0006\u0019AA3\u0003\u001d)h.\u00199qYf$Ba!#\u0004\u0012B1\u0011\u0011BAk\u0007\u0017\u0003B\"!\u0003\u0004\u000e\u0006%\u0013qFA%\u0003KJAaa$\u0002\f\t1A+\u001e9mKRB\u0011ba%Y\u0003\u0003\u0005\ra!\u000f\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCABM!\u0011\u00119ia'\n\t\ru%\u0011\u0012\u0002\u0007\u001f\nTWm\u0019;\u0002\r5Kg.\u001e;f+\t\u0019I$A\u0004NS:,H/\u001a\u0011\u0002\r!{WO\u001d7z\u0003\u001dAu.\u001e:ms\u0002\nQ\u0001R1jYf\fa\u0001R1jYf\u0004\u0013aB'p]RDG._\u0001\t\u001b>tG\u000f\u001b7zA\u0005a!*\u001e7jC:l\u0015N\\;uK\u0006i!*\u001e7jC:l\u0015N\\;uK\u0002\nABS;mS\u0006t\u0007j\\;sYf\fQBS;mS\u0006t\u0007j\\;sYf\u0004\u0013a\u0003&vY&\fg\u000eR1jYf\fABS;mS\u0006tG)Y5ms\u0002\naaV3fW2L\u0018aB,fK.d\u0017\u0010I\u0001\u0004C2dWCABc!\u0019\u0011)ka2\u0004:%!\u0011q\u001dBT\u0003\u0011\tG\u000e\u001c\u0011\u0003=\u0011\u000bG/\u001a+j[\u0016\u0004\u0016M\u001d;ji&|gnU2iK6,g)Y2u_JL8#\u00027\u0002\b\r=\u0007\u0003BA\u000b\u0007#LAaa5\u0002\u0018\t1\u0002+\u0019:uSRLwN\\*dQ\u0016lWMR1di>\u0014\u0018\u0010\u0006\u0002\u0004XB\u001911\u00037\u0002\t1|\u0017\r\u001a\u000b\u0007\u0007;\u001cyn!;\u0011\r\u0005%\u0011Q[A\n\u0011\u001d\u0019\tO\u001ca\u0001\u0007G\f1a\u001d4u!\u0011\til!:\n\t\r\u001d\u0018q\u0018\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007bBBv]\u0002\u00071Q^\u0001\u0007G>tg-[4\u0011\t\r=81\u001f\b\u0005\u0003_\u001c\t0\u0003\u0003\u0002d\u0006]\u0011\u0002BB{\u0007o\u0014ABT1nK\u0012|\u0005\u000f^5p]NTA!a9\u0002\u0018Qq\u00111RB~\u0007{\u001cy\u0010\"\u0001\u0005\u0004\u0011\u0015\u0001bBA\u0016_\u0002\u0007\u0011q\u0006\u0005\b\u0003\u000bz\u0007\u0019AA%\u0011\u001d\t\tg\u001ca\u0001\u0003KBq!a\u001dp\u0001\u0004\t9\bC\u0004\u0002\u0000=\u0004\r!!\u0013\t\u000f\u0005\ru\u000e1\u0001\u0002xQ!A\u0011\u0002C\t!\u0019\tI!!6\u0005\fA\u0001\u0012\u0011\u0002C\u0007\u0003_\tI%!\u001a\u0002x\u0005%\u0013qO\u0005\u0005\t\u001f\tYA\u0001\u0004UkBdWM\u000e\u0005\n\u0007'\u0003\u0018\u0011!a\u0001\u0003\u0017\u0003")
public class DateTimeScheme
implements PartitionScheme,
Product,
scala.Serializable {
    private final DateTimeFormatter formatter;
    private final String pattern;
    private final ChronoUnit stepUnit;
    private final int step;
    private final String dtg;
    private final int dtgIndex;
    private final Function1<ZonedDateTime, ZonedDateTime> truncate;
    private final int depth;

    public static Option<Tuple6<DateTimeFormatter, String, ChronoUnit, Object, String, Object>> unapply(DateTimeScheme dateTimeScheme) {
        return DateTimeScheme$.MODULE$.unapply(dateTimeScheme);
    }

    public static DateTimeScheme apply(DateTimeFormatter dateTimeFormatter, String string, ChronoUnit chronoUnit, int n, String string2, int n2) {
        return DateTimeScheme$.MODULE$.apply(dateTimeFormatter, string, chronoUnit, n, string2, n2);
    }

    public static DateTimeScheme apply(DateTimeFormatter dateTimeFormatter, ChronoUnit chronoUnit, int n, String string, int n2) {
        return DateTimeScheme$.MODULE$.apply(dateTimeFormatter, chronoUnit, n, string, n2);
    }

    public static DateTimeScheme apply(String string, ChronoUnit chronoUnit, int n, String string2, int n2) {
        return DateTimeScheme$.MODULE$.apply(string, chronoUnit, n, string2, n2);
    }

    public static String Name() {
        return DateTimeScheme$.MODULE$.Name();
    }

    public Option<String> getSimplifiedFilters$default$2() {
        return PartitionScheme.getSimplifiedFilters$default$2$((PartitionScheme)this);
    }

    public DateTimeFormatter formatter() {
        return this.formatter;
    }

    public String pattern() {
        return this.pattern;
    }

    public ChronoUnit stepUnit() {
        return this.stepUnit;
    }

    public int step() {
        return this.step;
    }

    public String dtg() {
        return this.dtg;
    }

    public int dtgIndex() {
        return this.dtgIndex;
    }

    private Function1<ZonedDateTime, ZonedDateTime> truncate() {
        return this.truncate;
    }

    public int depth() {
        return this.depth;
    }

    public String getPartitionName(SimpleFeature feature) {
        return this.formatter().format(DateUtils$.MODULE$.toInstant((Date)feature.getAttribute(this.dtgIndex())).atZone(ZoneOffset.UTC));
    }

    public Option<Seq<PartitionScheme.SimplifiedFilter>> getSimplifiedFilters(Filter filter, Option<String> partition) {
        return this.getCoveringPartitions(filter).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Seq covered = (Seq)tuple2._1();
                Seq intersecting = (Seq)tuple2._2();
                Builder result = Seq$.MODULE$.newBuilder();
                if (covered.nonEmpty()) {
                    Seq x$1 = (Seq)package$.MODULE$.partitionSubFilters(filter, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.isTemporalFilter(x$2, this.dtg())))._2();
                    FilterFactory x$22 = package$.MODULE$.andOption$default$2(x$1);
                    Option coveredFilter = package$.MODULE$.andOption(x$1, x$22);
                    boxedUnit = result.$plus$eq((Object)new PartitionScheme.SimplifiedFilter((Filter)coveredFilter.getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE), covered, false));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object = intersecting.nonEmpty() ? result.$plus$eq((Object)new PartitionScheme.SimplifiedFilter(filter, (Seq)intersecting.distinct(), false)) : BoxedUnit.UNIT;
                Option option = partition;
                if (None$.MODULE$.equals(option)) {
                    return (Seq)result.result();
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String p = (String)some.value();
                    Option matched = ((IterableLike)result.result()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DateTimeScheme.$anonfun$getSimplifiedFilters$4(p, x$3)));
                    return Option$.MODULE$.option2Iterable(matched.map((Function1 & Serializable & scala.Serializable)x$4 -> {
                        Seq x$3 = (Seq)new .colon.colon((Object)p, (List)Nil$.MODULE$);
                        Filter x$42 = x$4.copy$default$1();
                        boolean x$5 = x$4.copy$default$3();
                        return x$4.copy(x$42, x$3, x$5);
                    })).toSeq();
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Option<Seq<String>> getIntersectingPartitions(Filter filter) {
        return this.getCoveringPartitions(filter).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Seq covered = (Seq)tuple2._1();
                Seq intersecting = (Seq)tuple2._2();
                return (Seq)covered.$plus$plus((GenTraversableOnce)intersecting, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Filter getCoveringFilter(String partition) {
        ZonedDateTime zdt = DateParsing$.MODULE$.parse(partition, this.formatter());
        String start = DateParsing$.MODULE$.format(zdt, DateParsing$.MODULE$.format$default$2());
        String end = DateParsing$.MODULE$.format(zdt.plus(1L, this.stepUnit()), DateParsing$.MODULE$.format$default$2());
        return FilterHelper$.MODULE$.ff().and((Filter)FilterHelper$.MODULE$.ff().greaterOrEqual((Expression)FilterHelper$.MODULE$.ff().property(this.dtg()), (Expression)FilterHelper$.MODULE$.ff().literal((Object)start)), (Filter)FilterHelper$.MODULE$.ff().less((Expression)FilterHelper$.MODULE$.ff().property(this.dtg()), (Expression)FilterHelper$.MODULE$.ff().literal((Object)end)));
    }

    private Option<Tuple2<Seq<String>, Seq<String>>> getCoveringPartitions(Filter filter) {
        Filter x$1 = filter;
        String x$2 = this.dtg();
        boolean x$3 = false;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues bounds = FilterHelper$.MODULE$.extractIntervals(x$1, x$2, x$4, x$3);
        if (bounds.disjoint()) {
            return new Some((Object)new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$));
        }
        if (bounds.isEmpty() || !bounds.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isBoundedBothSides()))) {
            return None$.MODULE$;
        }
        ListBuffer covered = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer intersecting = (ListBuffer)ListBuffer$.MODULE$.empty();
        bounds.values().foreach(arg_0 -> DateTimeScheme.$anonfun$getCoveringPartitions$2(this, covered, intersecting, arg_0));
        return new Some((Object)new Tuple2((Object)covered.toSeq(), (Object)intersecting.toSeq()));
    }

    public DateTimeScheme copy(DateTimeFormatter formatter, String pattern, ChronoUnit stepUnit, int step, String dtg, int dtgIndex) {
        return new DateTimeScheme(formatter, pattern, stepUnit, step, dtg, dtgIndex);
    }

    public DateTimeFormatter copy$default$1() {
        return this.formatter();
    }

    public String copy$default$2() {
        return this.pattern();
    }

    public ChronoUnit copy$default$3() {
        return this.stepUnit();
    }

    public int copy$default$4() {
        return this.step();
    }

    public String copy$default$5() {
        return this.dtg();
    }

    public int copy$default$6() {
        return this.dtgIndex();
    }

    public String productPrefix() {
        return "DateTimeScheme";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.formatter();
            }
            case 1: {
                return this.pattern();
            }
            case 2: {
                return this.stepUnit();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.step());
            }
            case 4: {
                return this.dtg();
            }
            case 5: {
                return BoxesRunTime.boxToInteger((int)this.dtgIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateTimeScheme;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.formatter()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pattern()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.stepUnit()));
        n = Statics.mix((int)n, (int)this.step());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dtg()));
        n = Statics.mix((int)n, (int)this.dtgIndex());
        return Statics.finalizeHash((int)n, (int)6);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateTimeScheme)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateTimeScheme dateTimeScheme = (DateTimeScheme)x$1;
        DateTimeFormatter dateTimeFormatter = this.formatter();
        DateTimeFormatter dateTimeFormatter2 = dateTimeScheme.formatter();
        if (dateTimeFormatter == null) {
            if (dateTimeFormatter2 != null) {
                return false;
            }
        } else if (!dateTimeFormatter.equals(dateTimeFormatter2)) return false;
        String string = this.pattern();
        String string2 = dateTimeScheme.pattern();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ChronoUnit chronoUnit = this.stepUnit();
        ChronoUnit chronoUnit2 = dateTimeScheme.stepUnit();
        if (chronoUnit == null) {
            if (chronoUnit2 != null) {
                return false;
            }
        } else if (!chronoUnit.equals(chronoUnit2)) return false;
        if (this.step() != dateTimeScheme.step()) return false;
        String string3 = this.dtg();
        String string4 = dateTimeScheme.dtg();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        if (this.dtgIndex() != dateTimeScheme.dtgIndex()) return false;
        if (!dateTimeScheme.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$depth$1(char x$1) {
        return x$1 == '/';
    }

    public static final /* synthetic */ boolean $anonfun$getSimplifiedFilters$4(String p$1, PartitionScheme.SimplifiedFilter x$3) {
        return x$3.partitions().contains((Object)p$1);
    }

    private final void addSteps$1(int step, ZonedDateTime current, int steps$1, boolean coveringLast$1, ListBuffer covered$1, ListBuffer intersecting$1) {
        while (true) {
            if (step == steps$1) {
                BoxedUnit boxedUnit;
                if (coveringLast$1) {
                    covered$1.$plus$eq((Object)this.formatter().format(current));
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                intersecting$1.$plus$eq((Object)this.formatter().format(current));
                boxedUnit = BoxedUnit.UNIT;
                break;
            }
            covered$1.$plus$eq((Object)this.formatter().format(current));
            current = current.plus(1L, this.stepUnit());
            ++step;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$getCoveringPartitions$2(DateTimeScheme $this, ListBuffer covered$1, ListBuffer intersecting$1, Bounds bound) {
        block6: {
            lower = (ZonedDateTime)bound.lower().value().get();
            upper = (ZonedDateTime)bound.upper().value().get();
            start = (ZonedDateTime)$this.truncate().apply((Object)lower);
            end = (ZonedDateTime)$this.truncate().apply((Object)(bound.upper().inclusive() != false ? upper : upper.minus(1L, ChronoUnit.MILLIS)));
            steps = (int)$this.stepUnit().between(start, end);
            if (!bound.lower().inclusive()) ** GOTO lbl-1000
            v0 = lower;
            var10_9 = start;
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = coveringFirst = false;
            }
            if (!bound.upper().exclusive()) break block6;
            v2 = upper;
            var12_11 = end.plus(1L, $this.stepUnit());
            if (!(v2 == null ? var12_11 != null : v2.equals(var12_11) == false)) ** GOTO lbl-1000
        }
        if (bound.upper().inclusive() && !upper.isBefore(end.plus(1L, $this.stepUnit()).minus(1L, ChronoUnit.MILLIS))) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = coveringLast = false;
        }
        if (steps == 0) {
            if (coveringFirst && coveringLast) {
                return covered$1.$plus$eq((Object)$this.formatter().format(start));
            }
            return intersecting$1.$plus$eq((Object)$this.formatter().format(start));
        }
        v4 = coveringFirst != false ? covered$1.$plus$eq((Object)$this.formatter().format(start)) : intersecting$1.$plus$eq((Object)$this.formatter().format(start));
        $this.addSteps$1(1, start.plus(1L, $this.stepUnit()), steps, coveringLast, covered$1, intersecting$1);
        return BoxedUnit.UNIT;
    }

    public DateTimeScheme(DateTimeFormatter formatter, String pattern, ChronoUnit stepUnit, int step, String dtg, int dtgIndex) {
        Function1 & Serializable & scala.Serializable intersect;
        this.formatter = formatter;
        this.pattern = pattern;
        this.stepUnit = stepUnit;
        this.step = step;
        this.dtg = dtg;
        this.dtgIndex = dtgIndex;
        PartitionScheme.$init$((PartitionScheme)this);
        Product.$init$((Product)this);
        ChronoUnit chronoUnit = stepUnit;
        if (ChronoUnit.NANOS.equals(chronoUnit) ? true : (ChronoUnit.MICROS.equals(chronoUnit) ? true : (ChronoUnit.MILLIS.equals(chronoUnit) ? true : (ChronoUnit.SECONDS.equals(chronoUnit) ? true : (ChronoUnit.MINUTES.equals(chronoUnit) ? true : (ChronoUnit.HOURS.equals(chronoUnit) ? true : ChronoUnit.DAYS.equals(chronoUnit))))))) {
            intersect = (Function1 & Serializable & scala.Serializable)dt -> dt.truncatedTo(this.stepUnit());
        } else if (ChronoUnit.MONTHS.equals(chronoUnit)) {
            TemporalAdjuster adjuster = TemporalAdjusters.firstDayOfMonth();
            intersect = (Function1 & Serializable & scala.Serializable)dt -> dt.with(adjuster).truncatedTo(ChronoUnit.DAYS);
        } else if (ChronoUnit.YEARS.equals(chronoUnit)) {
            TemporalAdjuster adjuster = TemporalAdjusters.firstDayOfYear();
            intersect = (Function1 & Serializable & scala.Serializable)dt -> dt.with(adjuster).truncatedTo(ChronoUnit.DAYS);
        } else {
            intersect = (Function1 & Serializable & scala.Serializable)dt -> DateParsing$.MODULE$.parse(this.formatter().format((TemporalAccessor)dt), this.formatter());
        }
        this.truncate = intersect;
        this.depth = new StringOps(Predef$.MODULE$.augmentString(pattern)).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DateTimeScheme.$anonfun$depth$1(BoxesRunTime.unboxToChar((Object)x$1)))) + 1;
    }

    public static class DateTimePartitionSchemeFactory
    implements PartitionSchemeFactory {
        public Option<PartitionScheme> load(SimpleFeatureType sft, package.NamedOptions config) {
            LazyInt step$lzy = new LazyInt();
            LazyRef dtg$lzy = new LazyRef();
            LazyInt dtgIndex$lzy = new LazyInt();
            String string = config.name();
            String string2 = DateTimeScheme$.MODULE$.Name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                DateTimeFormatter dateTimeFormatter;
                ChronoUnit unit = (ChronoUnit)config.options().get((Object)DateTimeScheme$Config$.MODULE$.StepUnitOpt()).map((Function1 & Serializable & scala.Serializable)c -> ChronoUnit.valueOf(c.toUpperCase())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(38).append("DateTime scheme requires valid unit '").append(DateTimeScheme$Config$.MODULE$.StepUnitOpt()).append("'").toString());
                });
                String format = (String)config.options().getOrElse((Object)DateTimeScheme$Config$.MODULE$.DateTimeFormatOpt(), (Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(40).append("DateTime scheme requires valid format '").append(DateTimeScheme$Config$.MODULE$.DateTimeFormatOpt()).append("'").toString());
                });
                Predef$.MODULE$.require(!format.endsWith("/"), (Function0 & Serializable & scala.Serializable)() -> "Format cannot end with a slash");
                try {
                    dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        throw new IllegalArgumentException(new StringBuilder(23).append("Invalid date format '").append(format).append("':").toString(), e);
                    }
                    throw throwable;
                }
                DateTimeFormatter formatter = dateTimeFormatter;
                return new Some((Object)new DateTimeScheme(formatter, format, unit, DateTimePartitionSchemeFactory.step$1(step$lzy, config), DateTimePartitionSchemeFactory.dtg$1(dtg$lzy, config, sft), DateTimePartitionSchemeFactory.dtgIndex$1(dtgIndex$lzy, sft, dtg$lzy, config)));
            }
            return DateTimeScheme$Formats$.MODULE$.apply(config.name()).map((Function1 & Serializable & scala.Serializable)f -> new DateTimeScheme(f.formatter(), f.pattern(), f.unit(), DateTimePartitionSchemeFactory.step$1(step$lzy, config), DateTimePartitionSchemeFactory.dtg$1(dtg$lzy, config, sft), DateTimePartitionSchemeFactory.dtgIndex$1(dtgIndex$lzy, sft, dtg$lzy, config)));
        }

        public static final /* synthetic */ int $anonfun$load$1(String x$7) {
            return new StringOps(Predef$.MODULE$.augmentString(x$7)).toInt();
        }

        private static final /* synthetic */ int step$lzycompute$1(LazyInt step$lzy$1, package.NamedOptions config$1) {
            int n;
            LazyInt lazyInt = step$lzy$1;
            synchronized (lazyInt) {
                n = step$lzy$1.initialized() ? step$lzy$1.value() : step$lzy$1.initialize(BoxesRunTime.unboxToInt((Object)config$1.options().get((Object)DateTimeScheme$Config$.MODULE$.StepOpt()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)DateTimePartitionSchemeFactory.$anonfun$load$1(x$7))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1)));
            }
            return n;
        }

        private static final int step$1(LazyInt step$lzy$1, package.NamedOptions config$1) {
            if (step$lzy$1.initialized()) {
                return step$lzy$1.value();
            }
            return DateTimePartitionSchemeFactory.step$lzycompute$1(step$lzy$1, config$1);
        }

        private static final /* synthetic */ String dtg$lzycompute$1(LazyRef dtg$lzy$1, package.NamedOptions config$1, SimpleFeatureType sft$1) {
            String string;
            LazyRef lazyRef = dtg$lzy$1;
            synchronized (lazyRef) {
                string = dtg$lzy$1.initialized() ? (String)dtg$lzy$1.value() : (String)dtg$lzy$1.initialize(config$1.options().get((Object)DateTimeScheme$Config$.MODULE$.DtgAttribute()).orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(43).append("DateTime scheme requires valid attribute '").append(DateTimeScheme$Config$.MODULE$.DtgAttribute()).append("'").toString());
                }));
            }
            return string;
        }

        private static final String dtg$1(LazyRef dtg$lzy$1, package.NamedOptions config$1, SimpleFeatureType sft$1) {
            if (dtg$lzy$1.initialized()) {
                return (String)dtg$lzy$1.value();
            }
            return DateTimePartitionSchemeFactory.dtg$lzycompute$1(dtg$lzy$1, config$1, sft$1);
        }

        private static final /* synthetic */ int dtgIndex$lzycompute$1(LazyInt dtgIndex$lzy$1, SimpleFeatureType sft$1, LazyRef dtg$lzy$1, package.NamedOptions config$1) {
            int n;
            LazyInt lazyInt = dtgIndex$lzy$1;
            synchronized (lazyInt) {
                n = dtgIndex$lzy$1.initialized() ? dtgIndex$lzy$1.value() : dtgIndex$lzy$1.initialize(BoxesRunTime.unboxToInt((Object)new Some((Object)BoxesRunTime.boxToInteger((int)sft$1.indexOf(DateTimePartitionSchemeFactory.dtg$1(dtg$lzy$1, config$1, sft$1)))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != -1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException(new StringBuilder(44).append("Attribute '").append(DateTimePartitionSchemeFactory.dtg$1(dtg$lzy$1, config$1, sft$1)).append("' does not exist in feature type ").append(sft$1.getTypeName()).toString());
                })));
            }
            return n;
        }

        private static final int dtgIndex$1(LazyInt dtgIndex$lzy$1, SimpleFeatureType sft$1, LazyRef dtg$lzy$1, package.NamedOptions config$1) {
            if (dtgIndex$lzy$1.initialized()) {
                return dtgIndex$lzy$1.value();
            }
            return DateTimePartitionSchemeFactory.dtgIndex$lzycompute$1(dtgIndex$lzy$1, sft$1, dtg$lzy$1, config$1);
        }
    }
}

