/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.geomesa.curve.Z2SFC;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme;
import org.locationtech.geomesa.fs.storage.common.partitions.Z2Scheme$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.jts.geom.Point;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001\u0002\u0017.\u0001rB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003S\u0011!q\u0006A!f\u0001\n\u0003Y\u0005\u0002C0\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u000b\u0001\u0004A\u0011A1\t\u000f\u0019\u0004!\u0019!C\u0005\u0017\"1q\r\u0001Q\u0001\n1Cq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004q\u0001\u0001\u0006IA\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u00191\b\u0001)A\u0005g\"9q\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002=\u0001A\u0003%1\u000fC\u0003z\u0001\u0011\u0005\u0013\u000bC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005\u001d\u0002\u0001\"\u0015\u0002*!9\u0011Q\u0006\u0001\u0005R\u0005=\u0002\"CA<\u0001\u0005\u0005I\u0011AA=\u0011%\t\t\tAI\u0001\n\u0003\t\u0019\tC\u0005\u0002\u001a\u0002\t\n\u0011\"\u0001\u0002\u001c\"I\u0011q\u0014\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003C\u0003\u0011\u0011!C!\u0003GC\u0001\"a-\u0001\u0003\u0003%\ta\u0013\u0005\n\u0003k\u0003\u0011\u0011!C\u0001\u0003oC\u0011\"a1\u0001\u0003\u0003%\t%!2\t\u0013\u0005M\u0007!!A\u0005\u0002\u0005U\u0007\"CAp\u0001\u0005\u0005I\u0011IAq\u0011%\t\u0019\u000fAA\u0001\n\u0003\n)\u000fC\u0005\u0002h\u0002\t\t\u0011\"\u0011\u0002j\u001e9\u0011Q^\u0017\t\u0002\u0005=hA\u0002\u0017.\u0011\u0003\t\t\u0010\u0003\u0004aE\u0011\u0005\u0011\u0011 \u0005\n\u0003w\u0014#\u0019!C\u0001\u0003GC\u0001\"!@#A\u0003%\u0011Q\u0015\u0004\u0007\u0003\u007f\u0014\u0003A!\u0001\t\r\u00014C\u0011\u0001B\u0011\u0011\u001d\u00119C\nC!\u0005SA\u0011B!\r#\u0003\u0003%\tIa\r\t\u0013\tm\"%!A\u0005\u0002\nu\u0002\"\u0003B(E\u0005\u0005I\u0011\u0002B)\u0005!Q&gU2iK6,'B\u0001\u00180\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0006\u0003aE\naaY8n[>t'B\u0001\u001a4\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001N\u001b\u0002\u0005\u0019\u001c(B\u0001\u001c8\u0003\u001d9Wm\\7fg\u0006T!\u0001O\u001d\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003i\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001fB\u000fB\u0011ahP\u0007\u0002[%\u0011\u0001)\f\u0002\u000e'B\fG/[1m'\u000eDW-\\3\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000fA\u0013x\u000eZ;diB\u0011!\tS\u0005\u0003\u0013\u000e\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fAAY5ugV\tA\n\u0005\u0002C\u001b&\u0011aj\u0011\u0002\u0004\u0013:$\u0018!\u00022jiN\u0004\u0013\u0001B4f_6,\u0012A\u0015\t\u0003'js!\u0001\u0016-\u0011\u0005U\u001bU\"\u0001,\u000b\u0005][\u0014A\u0002\u001fs_>$h(\u0003\u0002Z\u0007\u00061\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI6)A\u0003hK>l\u0007%A\u0005hK>l\u0017J\u001c3fq\u0006Qq-Z8n\u0013:$W\r\u001f\u0011\u0002\rqJg.\u001b;?)\u0011\u00117\rZ3\u0011\u0005y\u0002\u0001\"\u0002&\b\u0001\u0004a\u0005\"\u0002)\b\u0001\u0004\u0011\u0006\"\u00020\b\u0001\u0004a\u0015A\u0002=z\u0005&$8/A\u0004ys\nKGo\u001d\u0011\u0002\u0005i\u0014T#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055,\u0014!B2veZ,\u0017BA8m\u0005\u0015Q&g\u0015$D\u0003\rQ(\u0007I\u0001\bqJ\u000bG-[;t+\u0005\u0019\bC\u0001\"u\u0013\t)8I\u0001\u0004E_V\u0014G.Z\u0001\tqJ\u000bG-[;tA\u00059\u0011PU1eSV\u001c\u0018\u0001C=SC\u0012LWo\u001d\u0011\u0002\u000fA\fG\u000f^3s]\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u000b\u0003%rDQ!`\tA\u0002y\fqAZ3biV\u0014X\rE\u0002\u0000\u0003\u001fi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007g&l\u0007\u000f\\3\u000b\u0007u\f9A\u0003\u0003\u0002\n\u0005-\u0011aA1qS*\u0019\u0011QB\u001d\u0002\u0011\u001d,w\u000e^8pYNLA!!\u0005\u0002\u0002\ti1+[7qY\u00164U-\u0019;ve\u0016\f\u0011cZ3u\u0007>4XM]5oO\u001aKG\u000e^3s)\u0011\t9\"a\t\u0011\t\u0005e\u0011qD\u0007\u0003\u00037QA!!\b\u0002\b\u00051a-\u001b7uKJLA!!\t\u0002\u001c\t1a)\u001b7uKJDa!!\n\u0013\u0001\u0004\u0011\u0016!\u00039beRLG/[8o\u0003\u0019!\u0017nZ5ugR\u0019A*a\u000b\t\u000b)\u001b\u0002\u0019\u0001'\u0002\u001d\u001d,g.\u001a:bi\u0016\u0014\u0016M\\4fgR!\u0011\u0011GA6!\u0019\t\u0019$!\u0010\u0002D9!\u0011QGA\u001d\u001d\r)\u0016qG\u0005\u0002\t&\u0019\u00111H\"\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005\r\u0019V-\u001d\u0006\u0004\u0003w\u0019\u0005\u0003BA#\u0003KrA!a\u0012\u0002b9!\u0011\u0011JA.\u001d\u0011\tY%a\u0016\u000f\t\u00055\u0013Q\u000b\b\u0005\u0003\u001f\n\u0019FD\u0002V\u0003#J\u0011AO\u0005\u0003qeJ!AN\u001c\n\u0007\u0005eS'\u0001\u0004{_J$WM]\u0005\u0005\u0003;\ny&A\u0004tM\u000e,(O^3\u000b\u0007\u0005eS'\u0003\u0003\u0002<\u0005\r$\u0002BA/\u0003?JA!a\u001a\u0002j\tQ\u0011J\u001c3fqJ\u000bgnZ3\u000b\t\u0005m\u00121\r\u0005\b\u0003[\"\u0002\u0019AA8\u0003\tA\u0018\u0010\u0005\u0004\u00024\u0005u\u0012\u0011\u000f\t\b\u0005\u0006M4o]:t\u0013\r\t)h\u0011\u0002\u0007)V\u0004H.\u001a\u001b\u0002\t\r|\u0007/\u001f\u000b\bE\u0006m\u0014QPA@\u0011\u001dQU\u0003%AA\u00021Cq\u0001U\u000b\u0011\u0002\u0003\u0007!\u000bC\u0004_+A\u0005\t\u0019\u0001'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0011\u0016\u0004\u0019\u0006\u001d5FAAE!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M5)\u0001\u0006b]:|G/\u0019;j_:LA!a&\u0002\u000e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0014\u0016\u0004%\u0006\u001d\u0015AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\u0005Y\u0006twM\u0003\u0002\u00020\u0006!!.\u0019<b\u0013\rY\u0016\u0011V\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI,a0\u0011\u0007\t\u000bY,C\u0002\u0002>\u000e\u00131!\u00118z\u0011!\t\tmGA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002HB1\u0011\u0011ZAh\u0003sk!!a3\u000b\u0007\u000557)\u0001\u0006d_2dWm\u0019;j_:LA!!5\u0002L\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9.!8\u0011\u0007\t\u000bI.C\u0002\u0002\\\u000e\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002Bv\t\t\u00111\u0001\u0002:\u0006A\u0001.Y:i\u0007>$W\rF\u0001M\u0003!!xn\u0015;sS:<GCAAS\u0003\u0019)\u0017/^1mgR!\u0011q[Av\u0011%\t\t\rIA\u0001\u0002\u0004\tI,\u0001\u0005[eM\u001b\u0007.Z7f!\tq$e\u0005\u0003#\u0003g<\u0005c\u0001\"\u0002v&\u0019\u0011q_\"\u0003\r\u0005s\u0017PU3g)\t\ty/\u0001\u0003OC6,\u0017!\u0002(b[\u0016\u0004#\u0001\u0007.3!\u0006\u0014H/\u001b;j_:\u001c6\r[3nK\u001a\u000b7\r^8ssN\u0019aEa\u0001\u0011\t\t\u0015!1\u0004\b\u0005\u0005\u000f\u00119B\u0004\u0003\u0003\n\tUa\u0002\u0002B\u0006\u0005'qAA!\u0004\u0003\u00129!\u00111\nB\b\u0013\t!T'\u0003\u00023g%\u0011\u0001'M\u0005\u0003]=J1A!\u0007.\u00035\u0019\u0006/\u0019;jC2\u001c6\r[3nK&!!Q\u0004B\u0010\u0005u\u0019\u0006/\u0019;jC2\u0004\u0016M\u001d;ji&|gnU2iK6,g)Y2u_JL(b\u0001B\r[Q\u0011!1\u0005\t\u0004\u0005K1S\"\u0001\u0012\u0002)\t,\u0018\u000e\u001c3QCJ$\u0018\u000e^5p]N\u001b\u0007.Z7f)\u001di$1\u0006B\u0017\u0005_AQA\u0013\u0015A\u00021CQ\u0001\u0015\u0015A\u0002ICQA\u0018\u0015A\u00021\u000bQ!\u00199qYf$rA\u0019B\u001b\u0005o\u0011I\u0004C\u0003KS\u0001\u0007A\nC\u0003QS\u0001\u0007!\u000bC\u0003_S\u0001\u0007A*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t}\"1\n\t\u0006\u0005\n\u0005#QI\u0005\u0004\u0005\u0007\u001a%AB(qi&|g\u000e\u0005\u0004C\u0005\u000fb%\u000bT\u0005\u0004\u0005\u0013\u001a%A\u0002+va2,7\u0007\u0003\u0005\u0003N)\n\t\u00111\u0001c\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003TA!\u0011q\u0015B+\u0013\u0011\u00119&!+\u0003\r=\u0013'.Z2u\u0001")
public class Z2Scheme
extends SpatialScheme
implements Product,
Serializable {
    private final int bits;
    private final String geom;
    private final int geomIndex;
    private final int xyBits;
    private final Z2SFC z2;
    private final double xRadius;
    private final double yRadius;

    public static Option<Tuple3<Object, String, Object>> unapply(Z2Scheme z2Scheme) {
        return Z2Scheme$.MODULE$.unapply(z2Scheme);
    }

    public static Z2Scheme apply(int n, String string, int n2) {
        return Z2Scheme$.MODULE$.apply(n, string, n2);
    }

    public static String Name() {
        return Z2Scheme$.MODULE$.Name();
    }

    public int bits() {
        return this.bits;
    }

    public String geom() {
        return this.geom;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    private int xyBits() {
        return this.xyBits;
    }

    private Z2SFC z2() {
        return this.z2;
    }

    private double xRadius() {
        return this.xRadius;
    }

    private double yRadius() {
        return this.yRadius;
    }

    public String pattern() {
        return new StringBuilder(7).append(this.bits()).append("-bit-z2").toString();
    }

    public String getPartitionName(SimpleFeature feature) {
        Point pt = (Point)feature.getAttribute(this.geomIndex());
        return Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)this.z2().index(pt.getX(), pt.getY(), this.z2().index$default$3()))), this.format());
    }

    public Filter getCoveringFilter(String partition) {
        Tuple2 tuple2 = this.z2().invert(new StringOps(Predef$.MODULE$.augmentString(partition)).toLong());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double y = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
        double x2 = sp2._1$mcD$sp();
        double y2 = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(x2 - this.xRadius(), x2 + this.xRadius());
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        double xmin = sp3._1$mcD$sp();
        double xmax = sp3._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(xmin, xmax);
        double xmin2 = sp4._1$mcD$sp();
        double xmax2 = sp4._2$mcD$sp();
        Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(y2 - this.yRadius(), y2 + this.yRadius());
        if (sp5 == null) {
            throw new MatchError((Object)sp5);
        }
        double ymin = sp5._1$mcD$sp();
        double ymax = sp5._2$mcD$sp();
        Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(ymin, ymax);
        double ymin2 = sp6._1$mcD$sp();
        double ymax2 = sp6._2$mcD$sp();
        BBOX bbox = org.locationtech.geomesa.filter.package$.MODULE$.ff().bbox((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom()), (BoundingBox)new ReferencedEnvelope(xmin2, xmax2, ymin2, ymax2, package$.MODULE$.CRS_EPSG_4326()));
        None$ xExclusive = xmax2 == this.z2().lon().max() ? None$.MODULE$ : new Some((Object)org.locationtech.geomesa.filter.package$.MODULE$.ff().less((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().function("getX", new Expression[]{org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom())}), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal(xmax2)));
        None$ yExclusive = ymax2 == this.z2().lat().max() ? None$.MODULE$ : new Some((Object)org.locationtech.geomesa.filter.package$.MODULE$.ff().less((Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().function("getY", new Expression[]{org.locationtech.geomesa.filter.package$.MODULE$.ff().property(this.geom())}), (Expression)org.locationtech.geomesa.filter.package$.MODULE$.ff().literal(ymax2)));
        return org.locationtech.geomesa.filter.package$.MODULE$.andFilters((Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)bbox, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)xExclusive), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)yExclusive), Seq$.MODULE$.canBuildFrom()), org.locationtech.geomesa.filter.package$.MODULE$.ff());
    }

    @Override
    public int digits(int bits) {
        return (int)scala.math.package$.MODULE$.ceil((double)bits * scala.math.package$.MODULE$.log10(2.0));
    }

    @Override
    public Seq<package.IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> xy) {
        return this.z2().ranges(xy, this.z2().ranges$default$2(), this.z2().ranges$default$3());
    }

    public Z2Scheme copy(int bits, String geom, int geomIndex) {
        return new Z2Scheme(bits, geom, geomIndex);
    }

    public int copy$default$1() {
        return this.bits();
    }

    public String copy$default$2() {
        return this.geom();
    }

    public int copy$default$3() {
        return this.geomIndex();
    }

    public String productPrefix() {
        return "Z2Scheme";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.bits());
            }
            case 1: {
                return this.geom();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.geomIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Z2Scheme;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.bits());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.geom()));
        n = Statics.mix((int)n, (int)this.geomIndex());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Z2Scheme)) return false;
        boolean bl = true;
        if (!bl) return false;
        Z2Scheme z2Scheme = (Z2Scheme)x$1;
        if (this.bits() != z2Scheme.bits()) return false;
        String string = this.geom();
        String string2 = z2Scheme.geom();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.geomIndex() != z2Scheme.geomIndex()) return false;
        if (!z2Scheme.canEqual(this)) return false;
        return true;
    }

    public Z2Scheme(int bits, String geom, int geomIndex) {
        this.bits = bits;
        this.geom = geom;
        this.geomIndex = geomIndex;
        super(bits, geom);
        Product.$init$((Product)this);
        this.xyBits = bits / 2;
        this.z2 = new Z2SFC(this.xyBits());
        this.xRadius = 360.0 / scala.math.package$.MODULE$.pow(2.0, (double)this.xyBits()) / (double)2;
        this.yRadius = 180.0 / scala.math.package$.MODULE$.pow(2.0, (double)this.xyBits()) / (double)2;
    }

    public static class Z2PartitionSchemeFactory
    extends SpatialScheme.SpatialPartitionSchemeFactory {
        @Override
        public SpatialScheme buildPartitionScheme(int bits, String geom, int geomIndex) {
            return new Z2Scheme(bits, geom, geomIndex);
        }

        public Z2PartitionSchemeFactory() {
            super(Z2Scheme$.MODULE$.Name());
        }
    }
}

