/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme$Config$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh!\u0002\u0012$\u0003\u0003\u0011\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQa\u0014\u0001\u0005\u0002ACq!\u0016\u0001C\u0002\u0013Ea\u000b\u0003\u0004X\u0001\u0001\u0006I\u0001\u0012\u0005\u00061\u00021\t\"\u0017\u0005\u00067\u00021\t\u0002\u0018\u0005\n\u0003\u000f\u0001!\u0019!C!\u0003\u0013Aq!a\u0003\u0001A\u0003%\u0001\tC\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011Q\n\u0001\u0005\n\u0005]saBA/G!\u0005\u0011q\f\u0004\u0007E\rB\t!!\u0019\t\r=sA\u0011AA2\u000f\u001d\t)G\u0004E\u0001\u0003O2q!a\u001b\u000f\u0011\u0003\ti\u0007\u0003\u0004P#\u0011\u0005\u0011q\u000e\u0005\t\u0003c\n\"\u0019!C\u0001-\"9\u00111O\t!\u0002\u0013!\u0005\u0002CA;#\t\u0007I\u0011\u0001,\t\u000f\u0005]\u0014\u0003)A\u0005\t\"A\u0011\u0011P\tC\u0002\u0013\u0005a\u000bC\u0004\u0002|E\u0001\u000b\u0011\u0002#\u0007\u000f\u0005ud\"!\u0001\u0002\u0000!I\u0011qQ\r\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0007\u001ff!\t!!#\t\u0013\u0005=\u0015D1A\u0005\n\u0005E\u0005\u0002CAT3\u0001\u0006I!a%\t\u0011\u0005%\u0016D1A\u0005\nYCq!a+\u001aA\u0003%A\tC\u0004\u0002.f!\t%a,\t\u000f\u0005]\u0017D\"\u0001\u0002Z\ni1\u000b]1uS\u0006d7k\u00195f[\u0016T!\u0001J\u0013\u0002\u0015A\f'\u000f^5uS>t7O\u0003\u0002'O\u000511m\\7n_:T!\u0001K\u0015\u0002\u000fM$xN]1hK*\u0011!fK\u0001\u0003MNT!\u0001L\u0017\u0002\u000f\u001d,w.\\3tC*\u0011afL\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\tQT(D\u0001<\u0015\tat%A\u0002ba&L!AP\u001e\u0003\u001fA\u000b'\u000f^5uS>t7k\u00195f[\u0016\fAAY5ugB\u0011A'Q\u0005\u0003\u0005V\u00121!\u00138u\u0003\u00119Wm\\7\u0011\u0005\u0015ceB\u0001$K!\t9U'D\u0001I\u0015\tI\u0015'\u0001\u0004=e>|GOP\u0005\u0003\u0017V\na\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111*N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u001bF\u000b\u0005\u0002S\u00015\t1\u0005C\u0003@\u0007\u0001\u0007\u0001\tC\u0003D\u0007\u0001\u0007A)\u0001\u0004g_Jl\u0017\r^\u000b\u0002\t\u00069am\u001c:nCR\u0004\u0013A\u00023jO&$8\u000f\u0006\u0002A5\")qH\u0002a\u0001\u0001\u0006qq-\u001a8fe\u0006$XMU1oO\u0016\u001cHCA/{!\rq6M\u001a\b\u0003?\u0006t!a\u00121\n\u0003YJ!AY\u001b\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\u0004'\u0016\f(B\u000126!\t9wO\u0004\u0002ik:\u0011\u0011N\u001d\b\u0003UBt!a[8\u000f\u00051tgBA$n\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\taS&\u0003\u0002rW\u00051!p\u001c:eKJL!a\u001d;\u0002\u000fM47-\u001e:wK*\u0011\u0011oK\u0005\u0003EZT!a\u001d;\n\u0005aL(AC%oI\u0016D(+\u00198hK*\u0011!M\u001e\u0005\u0006w\u001e\u0001\r\u0001`\u0001\u0003qf\u00042AX2~!)!d0!\u0001\u0002\u0002\u0005\u0005\u0011\u0011A\u0005\u0003\u007fV\u0012a\u0001V;qY\u0016$\u0004c\u0001\u001b\u0002\u0004%\u0019\u0011QA\u001b\u0003\r\u0011{WO\u00197f\u0003\u0015!W\r\u001d;i+\u0005\u0001\u0015A\u00023faRD\u0007%\u0001\u000bhKR\u001c\u0016.\u001c9mS\u001aLW\r\u001a$jYR,'o\u001d\u000b\u0007\u0003#\t\u0019$a\u0012\u0011\u000bQ\n\u0019\"a\u0006\n\u0007\u0005UQG\u0001\u0004PaRLwN\u001c\t\u0005=\u000e\fI\u0002\u0005\u0003\u0002\u001c\u00055b\u0002BA\u000f\u0003SqA!a\b\u0002(9!\u0011\u0011EA\u0013\u001d\rQ\u00171E\u0005\u0003U-J!\u0001K\u0015\n\u0005q:\u0013bAA\u0016w\u0005y\u0001+\u0019:uSRLwN\\*dQ\u0016lW-\u0003\u0003\u00020\u0005E\"\u0001E*j[Bd\u0017NZ5fI\u001aKG\u000e^3s\u0015\r\tYc\u000f\u0005\b\u0003kQ\u0001\u0019AA\u001c\u0003\u00191\u0017\u000e\u001c;feB!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u00026\u0005u\"b\u0001\u001f\u0002@)\u0019\u0011\u0011I\u0018\u0002\u0011\u001d,w\u000e^8pYNLA!!\u0012\u0002<\t1a)\u001b7uKJD\u0011\"!\u0013\u000b!\u0003\u0005\r!a\u0013\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003\u0002\u001b\u0002\u0014\u0011\u000b\u0011dZ3u\u0013:$XM]:fGRLgn\u001a)beRLG/[8ogR!\u0011\u0011KA+!\u0015!\u00141CA*!\rq6\r\u0012\u0005\b\u0003kY\u0001\u0019AA\u001c)\u0019\t\t&!\u0017\u0002\\!9\u0011Q\u0007\u0007A\u0002\u0005]\u0002bBA%\u0019\u0001\u0007\u00111J\u0001\u000e'B\fG/[1m'\u000eDW-\\3\u0011\u0005Is1C\u0001\b4)\t\ty&\u0001\u0004D_:4\u0017n\u001a\t\u0004\u0003S\nR\"\u0001\b\u0003\r\r{gNZ5h'\t\t2\u0007\u0006\u0002\u0002h\u0005iq)Z8n\u0003R$(/\u001b2vi\u0016\fabR3p[\u0006#HO]5ckR,\u0007%\u0001\u0007[eI+7o\u001c7vi&|g.A\u0007[eI+7o\u001c7vi&|g\u000eI\u0001\u000e1j\u0013$+Z:pYV$\u0018n\u001c8\u0002\u001daS&GU3t_2,H/[8oA\ti2\u000b]1uS\u0006d\u0007+\u0019:uSRLwN\\*dQ\u0016lWMR1di>\u0014\u0018p\u0005\u0003\u001ag\u0005\u0005\u0005c\u0001\u001e\u0002\u0004&\u0019\u0011QQ\u001e\u0003-A\u000b'\u000f^5uS>t7k\u00195f[\u00164\u0015m\u0019;pef\fAA\\1nKR!\u00111RAG!\r\tI'\u0007\u0005\u0007\u0003\u000f[\u0002\u0019\u0001#\u0002\u00179\fW.\u001a)biR,'O\\\u000b\u0003\u0003'\u0003B!!&\u0002$6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*A\u0003sK\u001e,\u0007P\u0003\u0003\u0002\u001e\u0006}\u0015\u0001B;uS2T!!!)\u0002\t)\fg/Y\u0005\u0005\u0003K\u000b9JA\u0004QCR$XM\u001d8\u0002\u00199\fW.\u001a)biR,'O\u001c\u0011\u0002\u0015I,7o\u001c7vi&|g.A\u0006sKN|G.\u001e;j_:\u0004\u0013\u0001\u00027pC\u0012$b!!-\u00024\u0006\u001d\u0007\u0003\u0002\u001b\u0002\u0014eBq!!.!\u0001\u0004\t9,A\u0002tMR\u0004B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003\u0003\fi$A\u0004gK\u0006$XO]3\n\t\u0005\u0015\u00171\u0018\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007bBAeA\u0001\u0007\u00111Z\u0001\u0007G>tg-[4\u0011\t\u00055\u0017\u0011\u001b\b\u0005\u0003;\ty-\u0003\u0002cw%!\u00111[Ak\u00051q\u0015-\\3e\u001fB$\u0018n\u001c8t\u0015\t\u00117(\u0001\u000bck&dG\rU1si&$\u0018n\u001c8TG\",W.\u001a\u000b\b#\u0006m\u0017Q\\Ap\u0011\u0015y\u0014\u00051\u0001A\u0011\u0015\u0019\u0015\u00051\u0001E\u0011\u0019\t\t/\ta\u0001\u0001\u0006Iq-Z8n\u0013:$W\r\u001f")
public abstract class SpatialScheme
implements PartitionScheme {
    private final String geom;
    private final String format;
    private final int depth;

    public Option<String> getSimplifiedFilters$default$2() {
        return PartitionScheme.getSimplifiedFilters$default$2$((PartitionScheme)this);
    }

    public String format() {
        return this.format;
    }

    public abstract int digits(int var1);

    public abstract Seq<package.IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> var1);

    public int depth() {
        return this.depth;
    }

    public Option<Seq<PartitionScheme.SimplifiedFilter>> getSimplifiedFilters(Filter filter, Option<String> partition) {
        return this.getIntersectingPartitions(filter, partition).map((Function1 & Serializable & scala.Serializable)partitions -> (Seq)new .colon.colon((Object)new PartitionScheme.SimplifiedFilter(filter, partitions, false), (List)Nil$.MODULE$));
    }

    public Option<Seq<String>> getIntersectingPartitions(Filter filter) {
        return this.getIntersectingPartitions(filter, (Option<String>)None$.MODULE$);
    }

    private Option<Seq<String>> getIntersectingPartitions(Filter filter, Option<String> partition) {
        FilterValues geometries = FilterHelper$.MODULE$.extractGeometries(filter, this.geom, true);
        if (geometries.disjoint()) {
            return new Some((Object)Nil$.MODULE$);
        }
        if (geometries.values().isEmpty()) {
            return None$.MODULE$;
        }
        Seq partitions = (Seq)partition.map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)new .colon.colon(x$1, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Seq<package.IndexRange> ranges = this.generateRanges((Seq<Tuple4<Object, Object, Object, Object>>)((Seq)geometries.values().map((Function1 & Serializable & scala.Serializable)geometry -> GeometryUtils$.MODULE$.bounds(geometry), Seq$.MODULE$.canBuildFrom())));
            return (Seq)((TraversableLike)((SeqLike)ranges.flatMap((Function1 & Serializable & scala.Serializable)r -> new RichLong(Predef$.MODULE$.longWrapper(r.lower())).to((Object)BoxesRunTime.boxToLong((long)r.upper())), Seq$.MODULE$.canBuildFrom())).distinct()).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$2))), this.format()), Seq$.MODULE$.canBuildFrom());
        });
        return new Some((Object)partitions);
    }

    public SpatialScheme(int bits, String geom) {
        this.geom = geom;
        PartitionScheme.$init$((PartitionScheme)this);
        Predef$.MODULE$.require(bits % 2 == 0, (Function0 & Serializable & scala.Serializable)() -> "Resolution must be an even number");
        this.format = new StringBuilder(3).append("%0").append(this.digits(bits)).append("d").toString();
        this.depth = 1;
    }

    public static abstract class SpatialPartitionSchemeFactory
    implements PartitionSchemeFactory {
        private final String name;
        private final Pattern namePattern;
        private final String resolution;

        private Pattern namePattern() {
            return this.namePattern;
        }

        private String resolution() {
            return this.resolution;
        }

        public Option<PartitionScheme> load(SimpleFeatureType sft, package.NamedOptions config) {
            Matcher matcher = this.namePattern().matcher(config.name());
            if (!matcher.matches()) {
                return None$.MODULE$;
            }
            String geom = (String)config.options().getOrElse((Object)SpatialScheme$Config$.MODULE$.GeomAttribute(), (Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
            int geomIndex = sft.indexOf(geom);
            if (geomIndex == -1) {
                throw new IllegalArgumentException(new StringBuilder(40).append(this.name).append(" scheme requires valid geometry field '").append(SpatialScheme$Config$.MODULE$.GeomAttribute()).append("'").toString());
            }
            int res = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)matcher.group(2)).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())).orElse((Function0 & Serializable & scala.Serializable)() -> config.options().get((Object)this.resolution())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)SpatialPartitionSchemeFactory.$anonfun$load$4(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(34).append($this.name).append(" scheme requires bit resolution '").append(this.resolution()).append("'").toString());
            }));
            return new Some((Object)this.buildPartitionScheme(res, geom, geomIndex));
        }

        public abstract SpatialScheme buildPartitionScheme(int var1, String var2, int var3);

        public static final /* synthetic */ int $anonfun$load$4(String x$1) {
            return Integer.parseInt(x$1);
        }

        public SpatialPartitionSchemeFactory(String name) {
            this.name = name;
            this.namePattern = Pattern.compile(new StringBuilder(17).append(name).append("(-([0-9]+)bits?)?").toString());
            this.resolution = new StringBuilder(11).append(name).append("-resolution").toString();
        }
    }
}

