/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.s3;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.accumulo.access.AccessExpression;
import org.apache.hadoop.fs.Path;
import org.geotools.api.feature.simple.SimpleFeature;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.security.SecurityUtils;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4Qa\u0004\t\u0002\u0002}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006q\u0001!\t!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019!\u0006\u0001)A\u0005\u007f!QQ\u000b\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002,\t\u000fq\u0003!\u0019!C\u0005;\"1a\f\u0001Q\u0001\niCqa\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004a\u0001\u0001\u0006IA\u0017\u0005\u0006C\u0002!\tE\u0019\u0005\u0006M\u0002!\tE\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006m\u0002!Ia\u001e\u0005\u0006m\u00021\tB\u001f\u0002\u001d\u0003\n\u001cHO]1diN\u001bd+[:jE&d\u0017\u000e^=PEN,'O^3s\u0015\t\t\"#\u0001\u0002tg)\u00111\u0003F\u0001\u0007G>lWn\u001c8\u000b\u0005U1\u0012aB:u_J\fw-\u001a\u0006\u0003/a\t!AZ:\u000b\u0005eQ\u0012aB4f_6,7/\u0019\u0006\u00037q\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!H\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0001B\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\u0012\u0012\u0001C8cg\u0016\u0014h/\u001a:\n\u00055R#A\u0005$jY\u0016\u001c\u0016p\u001d;f[>\u00137/\u001a:wKJ\fA\u0001]1uQB\u0011\u0001GN\u0007\u0002c)\u0011qC\r\u0006\u0003gQ\na\u0001[1e_>\u0004(BA\u001b\u001d\u0003\u0019\t\u0007/Y2iK&\u0011q'\r\u0002\u0005!\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\u0003uq\u0002\"a\u000f\u0001\u000e\u0003AAQA\f\u0002A\u0002=\nAB^5tS\nLG.\u001b;jKN,\u0012a\u0010\t\u0004\u0001\u001eKU\"A!\u000b\u0005\t\u001b\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\t\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%B\u0005\r\u0019V\r\u001e\t\u0003\u0015Fs!aS(\u0011\u00051+U\"A'\u000b\u00059s\u0012A\u0002\u001fs_>$h(\u0003\u0002Q\u000b\u00061\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001V)A\u0007wSNL'-\u001b7ji&,7\u000fI\u0001\u0004q\u0012\n\u0004\u0003B,Y5jk\u0011!R\u0005\u00033\u0016\u0013a\u0001V;qY\u0016\u0014\u0004CA\u0011\\\u0013\t\u0011&%\u0001\u0004ck\u000e\\W\r^\u000b\u00025\u00069!-^2lKR\u0004\u0013aA6fs\u0006!1.Z=!\u0003\u00151G.^:i)\u0005\u0019\u0007CA,e\u0013\t)WI\u0001\u0003V]&$\u0018!B2m_N,\u0017!B<sSR,GCA2j\u0011\u0015QG\u00021\u0001l\u0003\u001d1W-\u0019;ve\u0016\u0004\"\u0001\u001c;\u000e\u00035T!A\\8\u0002\rMLW\u000e\u001d7f\u0015\tQ\u0007O\u0003\u0002re\u0006\u0019\u0011\r]5\u000b\u0005Md\u0012\u0001C4f_R|w\u000e\\:\n\u0005Ul'!D*j[BdWMR3biV\u0014X-\u0001\bnC.,G+Y4SKF,Xm\u001d;\u0015\u0007\rD\u0018\u0010C\u0003]\u001b\u0001\u0007\u0011\nC\u0003`\u001b\u0001\u0007\u0011\n\u0006\u0003dwrl\b\"\u0002/\u000f\u0001\u0004I\u0005\"B0\u000f\u0001\u0004I\u0005\"\u0002@\u000f\u0001\u0004I\u0015A\u0003<jg&\u0014\u0017\u000e\\5us\u0002")
public abstract class AbstractS3VisibilityObserver
implements FileSystemObserver {
    private final Set<String> visibilities = Set$.MODULE$.empty();
    private final /* synthetic */ Tuple2 x$1;
    private final String bucket;
    private final String key;

    private Set<String> visibilities() {
        return this.visibilities;
    }

    private String bucket() {
        return this.bucket;
    }

    private String key() {
        return this.key;
    }

    public void flush() {
    }

    public void close() {
        try {
            this.makeTagRequest(this.bucket(), this.key());
        }
        catch (Exception e) {
            throw new IOException("Error tagging object", e);
        }
    }

    public void write(SimpleFeature feature) {
        String vis = SecurityUtils.getVisibility((SimpleFeature)feature);
        if (vis != null) {
            this.visibilities().add((Object)vis);
            return;
        }
    }

    private void makeTagRequest(String bucket, String key) {
        if (this.visibilities().nonEmpty()) {
            String vis = this.visibilities().mkString("(", ")&(", ")");
            String expression = AccessExpression.of((String)vis, (boolean)true).getExpression();
            this.makeTagRequest(bucket, key, Base64.getEncoder().encodeToString(expression.getBytes(StandardCharsets.UTF_8)));
            return;
        }
    }

    public abstract void makeTagRequest(String var1, String var2, String var3);

    public AbstractS3VisibilityObserver(Path path) {
        URI uri = path.toUri();
        String uriPath = uri.getPath();
        String key = uriPath.startsWith("/") ? uriPath.substring(1) : uriPath;
        Tuple2 tuple2 = new Tuple2((Object)uri.getHost(), (Object)key);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String bucket = (String)tuple2._1();
        String key2 = (String)tuple2._2();
        this.x$1 = new Tuple2((Object)bucket, (Object)key2);
        this.bucket = (String)this.x$1._1();
        this.key = (String)this.x$1._2();
    }
}

