/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.geotools.api.feature.simple.SimpleFeature;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorageFactory$;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadataFactory$;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.SizeableFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$Counters$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils$;
import org.locationtech.geomesa.utils.io.FileSizeEstimator;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;

@ScalaSignature(bytes="\u0006\u0001\rUb\u0001B&M\u0001mC\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\b\u0003c\u0001A\u0011AA9\u0011\u001d\ty\u0005\u0001C!\u0003oBq!a\u001f\u0001\t\u0003\ni\bC\u0004\u0002\b\u0002!\t%!#\u0007\r\u0005m\u0005\u0001AAO\u0011)\tYF\u0002B\u0001B\u0003%\u0011Q\f\u0005\b\u0003c1A\u0011AAZ\u0011!\tfA1A\u0005\n\u0005m\u0006\u0002CAd\r\u0001\u0006I!!0\t\u0013\u0005%gA1A\u0005\n\u0005-\u0007\u0002CAo\r\u0001\u0006I!!4\t\u0013\u0005}gA1A\u0005\n\u0005\u0005\b\u0002CAu\r\u0001\u0006I!a9\t\u0013\u0005-hA1A\u0005\n\u00055\b\u0002\u0003B\u0007\r\u0001\u0006I!a<\t\u0013\t=aA1A\u0005\n\tE\u0001\u0002\u0003B\u0010\r\u0001\u0006IAa\u0005\t\u0013\t\u0005bA1A\u0005\n\t\r\u0002\u0002\u0003B\u0016\r\u0001\u0006IA!\n\t\u0013\t5bA1A\u0005\n\t=\u0002\u0002CB\u0010\r\u0001\u0006IA!\r\t\u0013\r\u0005bA1A\u0005\n\t-\b\u0002CB\u0012\r\u0001\u0006I!a\u001a\t\u000f\r\u0015b\u0001\"\u0003\u0004(!9!q\u0010\u0004\u0005B\r-\u0002b\u0002BQ\r\u0011\u00053\u0011\u0007\u0004\b\u0005\u000b2\u0011\u0011\u0005B$\u0011)\u0011I\u0005\bB\u0001B\u0003%\u0011Q\u001a\u0005\b\u0003caB\u0011\u0001B&\u0011%\u0011y\u0005\ba\u0001\n\u0013\u0011\t\u0006C\u0005\u0003Tq\u0001\r\u0011\"\u0003\u0003V!A!1\f\u000f!B\u0013\u0011I\u0002C\u0005\u0003^q\u0011\r\u0011\"\u0003\u0003`!A!\u0011\u000f\u000f!\u0002\u0013\u0011\t\u0007C\u0005\u0003tq\u0011\r\u0011\"\u0003\u0003v!A!Q\u0010\u000f!\u0002\u0013\u00119\bC\u0004\u0003\u0000q!\tA!!\t\u000f\t-E\u0004\"\u0001\u0003\u000e\"9!\u0011\u0015\u000f\u0005\u0002\t\r\u0006b\u0002BT9\u0011E!\u0011\u0016\u0004\u0007\u0007\u00171Aa!\u0004\t\u0015\t%#F!A!\u0002\u0013\ti\rC\u0004\u00022)\"\taa\u0004\t\u0013\tU(F1A\u0005\n\t]\b\u0002\u0003B\u0000U\u0001\u0006I!a\u0015\t\u000f\t}$\u0006\"\u0011\u0004\u0016!9!\u0011\u0015\u0016\u0005B\rmaA\u0002BZ\r\u0011\u0011)\f\u0003\u0006\u0003JE\u0012\t\u0011)A\u0005\u0003\u001bD!Ba.2\u0005\u0003\u0005\u000b\u0011\u0002B]\u0011)\tY&\rB\u0001B\u0003%\u0011Q\f\u0005\b\u0003c\tD\u0011\u0001Bd\u0011%\u0011y%\ra\u0001\n\u0013\u0011\t\u0006C\u0005\u0003TE\u0002\r\u0011\"\u0003\u0003R\"A!1L\u0019!B\u0013\u0011I\u0002C\u0005\u0003VF\u0002\r\u0011\"\u0003\u0003R!I!q[\u0019A\u0002\u0013%!\u0011\u001c\u0005\t\u0005;\f\u0004\u0015)\u0003\u0003\u001a!I!q\\\u0019A\u0002\u0013%!\u0011\u000b\u0005\n\u0005C\f\u0004\u0019!C\u0005\u0005GD\u0001Ba:2A\u0003&!\u0011\u0004\u0005\f\u0005S\f\u0004\u0019!a\u0001\n\u0013\u0011Y\u000fC\u0006\u0003nF\u0002\r\u00111A\u0005\n\t=\bb\u0003Bzc\u0001\u0007\t\u0011)Q\u0005\u0003OB1B!>2\u0001\u0004\u0005\r\u0011\"\u0003\u0003x\"Y!\u0011`\u0019A\u0002\u0003\u0007I\u0011\u0002B~\u0011-\u0011y0\ra\u0001\u0002\u0003\u0006K!a\u0015\t\u000f\t}\u0014\u0007\"\u0011\u0004\u0002!9!\u0011U\u0019\u0005B\r\u001dqaBA\u000f\u0019\"\u0005\u0011q\u0004\u0004\u0007\u00172C\t!a\t\t\u000f\u0005E\u0002\n\"\u0001\u00024\u00151\u0011Q\u0007%\u0001\u0003o\u0011Q\u0003U1si&$\u0018n\u001c8PkR\u0004X\u000f\u001e$pe6\fGO\u0003\u0002N\u001d\u0006!!n\u001c2t\u0015\ty\u0005+\u0001\u0004d_6lwN\u001c\u0006\u0003#J\u000bqa\u001d;pe\u0006<WM\u0003\u0002T)\u0006\u0011am\u001d\u0006\u0003+Z\u000bqaZ3p[\u0016\u001c\u0018M\u0003\u0002X1\u0006aAn\\2bi&|g\u000e^3dQ*\t\u0011,A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00019B!Q\f\u001a4o\u001b\u0005q&BA0a\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002bE\u00061\u0001.\u00193p_BT!a\u0019-\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t)gL\u0001\u0007PkR\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!A.\u00198h\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\tY{\u0017\u000e\u001a\t\u0003_bl\u0011\u0001\u001d\u0006\u0003cJ\faa]5na2,'BA:u\u0003\u001d1W-\u0019;ve\u0016T!!\u001e<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002x1\u0006Aq-Z8u_>d7/\u0003\u0002za\ni1+[7qY\u00164U-\u0019;ve\u0016\f\u0001\u0002Z3mK\u001e\fG/\u001a\t\u0003y*s!!`$\u000f\u0007y\fYBD\u0002\u0000\u00033qA!!\u0001\u0002\u00189!\u00111AA\u000b\u001d\u0011\t)!a\u0005\u000f\t\u0005\u001d\u0011\u0011\u0003\b\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002.\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0016BA,Y\u0013\t)f+\u0003\u0002T)&\u0011\u0011KU\u0005\u0003\u001fBK!!\u0014(\u0002+A\u000b'\u000f^5uS>tw*\u001e;qkR4uN]7biB\u0019\u0011\u0011\u0005%\u000e\u00031\u001b2\u0001SA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"BAA\u0016\u0003\u0015\u00198-\u00197b\u0013\u0011\ty#!\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011q\u0004\u0002\u0017'&tw\r\\3GS2,w*\u001e;qkR4uN]7biJ!\u0011\u0011HA\u001f\r\u0019\tY\u0004\u0013\u0001\u00028\taAH]3gS:,W.\u001a8u}A1\u0011qHA%M:l!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007_V$\b/\u001e;\u000b\u0007\u0005\u001dc,A\u0002mS\nLA!a\u0013\u0002B\t\u0001b)\u001b7f\u001fV$\b/\u001e;G_Jl\u0017\r\u001e\u0005\t\u0003\u001f\nID\"\u0001\u0002R\u0005yq-\u001a;SK\u000e|'\u000fZ,sSR,'\u000f\u0006\u0004\u0002T\u0005e\u00131\r\t\u0006;\u0006UcM\\\u0005\u0004\u0003/r&\u0001\u0004*fG>\u0014Hm\u0016:ji\u0016\u0014\b\u0002CA.\u0003\u001b\u0002\r!!\u0018\u0002\u000f\r|g\u000e^3yiB\u0019Q,a\u0018\n\u0007\u0005\u0005dL\u0001\nUCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\b\u0002CA3\u0003\u001b\u0002\r!a\u001a\u0002\t\u0019LG.\u001a\t\u0005\u0003S\ni'\u0004\u0002\u0002l)\u00111\u000bY\u0005\u0005\u0003_\nYG\u0001\u0003QCRDG\u0003BA:\u0003k\u00022!!\t\u0001\u0011\u0015Q(\u00011\u0001|)\u0011\t\u0019&!\u001f\t\u000f\u0005m3\u00011\u0001\u0002^\u0005\u0011r-\u001a;PkR\u0004X\u000f^\"p[6LG\u000f^3s)\u0011\ty(!\"\u0011\u0007u\u000b\t)C\u0002\u0002\u0004z\u0013qbT;uaV$8i\\7nSR$XM\u001d\u0005\b\u00037\"\u0001\u0019AA/\u0003A\u0019\u0007.Z2l\u001fV$\b/\u001e;Ta\u0016\u001c7\u000f\u0006\u0003\u0002\f\u0006E\u0005\u0003BA\u0014\u0003\u001bKA!a$\u0002*\t!QK\\5u\u0011\u001d\t\u0019*\u0002a\u0001\u0003+\u000b1A[8c!\ri\u0016qS\u0005\u0004\u00033s&A\u0003&pE\u000e{g\u000e^3yi\nY\u0002+\u0019:uSRLwN\\*dQ\u0016lWMU3d_J$wK]5uKJ\u001cRABA*\u0003?\u0003B!!)\u000206\u0011\u00111\u0015\u0006\u0005\u0003K\u000b9+\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0003\u0002*\u0006-\u0016\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\u00055\u0016aA2p[&!\u0011\u0011WAR\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0015\t\u0005U\u0016\u0011\u0018\t\u0004\u0003o3Q\"\u0001\u0001\t\u000f\u0005m\u0003\u00021\u0001\u0002^U\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000b\u0019-\u0004\u0002\u0002B*\u0011Q\u000fU\u0005\u0005\u0003\u000b\f\tMA\tGS2,7+_:uK6\u001cFo\u001c:bO\u0016\f\u0001b\u001d;pe\u0006<W\rI\u0001\tK:\u001cw\u000eZ5oOV\u0011\u0011Q\u001a\t\u0005\u0003\u001f\f9N\u0004\u0003\u0002R\u0006M\u0007\u0003BA\u0005\u0003SIA!!6\u0002*\u00051\u0001K]3eK\u001aLA!!7\u0002\\\n11\u000b\u001e:j]\u001eTA!!6\u0002*\u0005IQM\\2pI&tw\rI\u0001\u0005Y\u0016\fg-\u0006\u0002\u0002dB!\u0011qEAs\u0013\u0011\t9/!\u000b\u0003\u000f\t{w\u000e\\3b]\u0006)A.Z1gA\u0005Aa-\u001b7f)f\u0004X-\u0006\u0002\u0002pB!\u0011\u0011\u001fB\u0004\u001d\u0011\t\u0019P!\u0001\u000f\t\u0005U\u00181 \b\u0004}\u0006]\u0018bAA}\u001d\u0006)Q\u000f^5mg&!\u0011Q`A\u0000\u00031\u0019Fo\u001c:bO\u0016,F/\u001b7t\u0015\r\tIPT\u0005\u0005\u0005\u0007\u0011)!\u0001\u0005GS2,G+\u001f9f\u0015\u0011\ti0a@\n\t\t%!1\u0002\u0002\t\r&dW\rV=qK*!!1\u0001B\u0003\u0003%1\u0017\u000e\\3UsB,\u0007%\u0001\u0005gS2,7+\u001b>f+\t\u0011\u0019\u0002\u0005\u0004\u0002(\tU!\u0011D\u0005\u0005\u0005/\tIC\u0001\u0004PaRLwN\u001c\t\u0005\u0003O\u0011Y\"\u0003\u0003\u0003\u001e\u0005%\"\u0001\u0002'p]\u001e\f\u0011BZ5mKNK'0\u001a\u0011\u0002\u000f\r|WO\u001c;feV\u0011!Q\u0005\t\u0004;\n\u001d\u0012b\u0001B\u0015=\n91i\\;oi\u0016\u0014\u0018\u0001C2pk:$XM\u001d\u0011\u0002\u000b\r\f7\r[3\u0016\u0005\tE\u0002\u0003\u0003B\u001a\u0005{\tiM!\u0011\u000e\u0005\tU\"\u0002\u0002B\u001c\u0005s\tq!\\;uC\ndWM\u0003\u0003\u0003<\u0005%\u0012AC2pY2,7\r^5p]&!!q\bB\u001b\u0005\ri\u0015\r\u001d\t\u0004\u0005\u0007bR\"\u0001\u0004\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uKN\u0019A$!\n\u0002\u0013A\f'\u000f^5uS>tG\u0003\u0002B!\u0005\u001bBqA!\u0013\u001f\u0001\u0004\ti-A\u0003d_VtG/\u0006\u0002\u0003\u001a\u0005I1m\\;oi~#S-\u001d\u000b\u0005\u0003\u0017\u00139\u0006C\u0005\u0003Z\u0001\n\t\u00111\u0001\u0003\u001a\u0005\u0019\u0001\u0010J\u0019\u0002\r\r|WO\u001c;!\u0003\u0019\u0011w.\u001e8egV\u0011!\u0011\r\t\u0005\u0005G\u0012i'\u0004\u0002\u0003f)!!q\rB5\u0003\u00119Wm\\7\u000b\u0007\t-d+A\u0002kiNLAAa\u001c\u0003f\tAQI\u001c<fY>\u0004X-A\u0004c_VtGm\u001d\u0011\u0002\u000b\u0019LG.Z:\u0016\u0005\t]\u0004C\u0002B\u001a\u0005s\ni-\u0003\u0003\u0003|\tU\"aC!se\u0006L()\u001e4gKJ\faAZ5mKN\u0004\u0013!B<sSR,GCBAF\u0005\u0007\u00139\t\u0003\u0004\u0003\u0006\u001a\u0002\rAZ\u0001\u0004W\u0016L\bB\u0002BEM\u0001\u0007a.A\u0003wC2,X-\u0001\u0003nKR\fWC\u0001BH!\u0011\u0011\tJa'\u000f\t\tM%q\u0013\b\u0004\u007f\nU\u0015BA;Q\u0013\u0011\u0011I*!1\u0002\u001fM#xN]1hK6+G/\u00193bi\u0006LAA!(\u0003 \n\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\u000b\t\te\u0015\u0011Y\u0001\u0006G2|7/\u001a\u000b\u0005\u0003\u0017\u0013)\u000bC\u0004\u0002\\!\u0002\r!!\u0018\u0002\u00139,wo\u0016:ji\u0016\u0014HC\u0001BV!!\t9C!,\u0002h\u0005M\u0013\u0002\u0002BX\u0003S\u0011a\u0001V;qY\u0016\u0014\u0014f\u0001\u000f2U\t)2\t[;oW\u0016$\u0007+\u0019:uSRLwN\\*uCR,7cA\u0019\u0003B\u0005IQm\u001d;j[\u0006$xN\u001d\t\u0005\u0005w\u0013\u0019-\u0004\u0002\u0003>*!!q\u0018Ba\u0003\tIwNC\u0002\u0002zRKAA!2\u0003>\n\tb)\u001b7f'&TX-R:uS6\fGo\u001c:\u0015\u0011\t%'1\u001aBg\u0005\u001f\u00042Aa\u00112\u0011\u001d\u0011I%\u000ea\u0001\u0003\u001bDqAa.6\u0001\u0004\u0011I\fC\u0004\u0002\\U\u0002\r!!\u0018\u0015\t\u0005-%1\u001b\u0005\n\u00053:\u0014\u0011!a\u0001\u00053\tQ\u0001^8uC2\f\u0011\u0002^8uC2|F%Z9\u0015\t\u0005-%1\u001c\u0005\n\u00053R\u0014\u0011!a\u0001\u00053\ta\u0001^8uC2\u0004\u0013!\u0003:f[\u0006Lg.\u001b8h\u00035\u0011X-\\1j]&twm\u0018\u0013fcR!\u00111\u0012Bs\u0011%\u0011I&PA\u0001\u0002\u0004\u0011I\"\u0001\u0006sK6\f\u0017N\\5oO\u0002\nA\u0001]1uQV\u0011\u0011qM\u0001\ta\u0006$\bn\u0018\u0013fcR!\u00111\u0012By\u0011%\u0011I\u0006QA\u0001\u0002\u0004\t9'A\u0003qCRD\u0007%\u0001\u0004xe&$XM]\u000b\u0003\u0003'\n!b\u001e:ji\u0016\u0014x\fJ3r)\u0011\tYI!@\t\u0013\te3)!AA\u0002\u0005M\u0013aB<sSR,'\u000f\t\u000b\u0007\u0003\u0017\u001b\u0019a!\u0002\t\r\t\u0015U\t1\u0001g\u0011\u0019\u0011I)\u0012a\u0001]R!\u00111RB\u0005\u0011\u001d\tYF\u0012a\u0001\u0003;\u0012AcU5oO2,\u0007+\u0019:uSRLwN\\*uCR,7c\u0001\u0016\u0003BQ!1\u0011CB\n!\r\u0011\u0019E\u000b\u0005\b\u0005\u0013b\u0003\u0019AAg)\u0019\tYia\u0006\u0004\u001a!1!QQ\u0018A\u0002\u0019DaA!#0\u0001\u0004qG\u0003BAF\u0007;Aq!a\u00171\u0001\u0004\ti&\u0001\u0004dC\u000eDW\rI\u0001\to>\u00148\u000eU1uQ\u0006Iqo\u001c:l!\u0006$\b\u000eI\u0001\t]\u0016<8\u000b^1uKR!!\u0011IB\u0015\u0011\u001d\u0011I%\u0007a\u0001\u0003\u001b$b!a#\u0004.\r=\u0002B\u0002BC5\u0001\u0007a\r\u0003\u0004\u0003\nj\u0001\rA\u001c\u000b\u0005\u0003\u0017\u001b\u0019\u0004C\u0004\u0002\\m\u0001\r!!\u0018")
public class PartitionOutputFormat
extends OutputFormat<Void, SimpleFeature> {
    public final FileOutputFormat<Void, SimpleFeature> org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate;

    public RecordWriter<Void, SimpleFeature> getRecordWriter(TaskAttemptContext context) {
        return new PartitionSchemeRecordWriter(this, context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate.getOutputCommitter(context);
    }

    public void checkOutputSpecs(JobContext job) {
        Path outDir = FileOutputFormat.getOutputPath((JobContext)job);
        if (outDir == null) {
            throw new InvalidJobConfException("Output directory not set");
        }
        TokenCache.obtainTokensForNamenodes((Credentials)job.getCredentials(), (Path[])((Path[])((Object[])new Path[]{outDir})), (Configuration)job.getConfiguration());
    }

    public PartitionOutputFormat(FileOutputFormat<Void, SimpleFeature> delegate) {
        this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate = delegate;
    }

    public class PartitionSchemeRecordWriter
    extends RecordWriter<Void, SimpleFeature>
    implements LazyLogging {
        public final TaskAttemptContext org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context;
        private final FileSystemStorage org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage;
        private final String org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding;
        private final boolean org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf;
        private final Enumeration.Value org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType;
        private final Option<Object> fileSize;
        private final Counter counter;
        private final Map<String, PartitionState> cache;
        private final Path org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;
        public final /* synthetic */ PartitionOutputFormat $outer;

        private Logger logger$lzycompute() {
            PartitionSchemeRecordWriter partitionSchemeRecordWriter = this;
            synchronized (partitionSchemeRecordWriter) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        public FileSystemStorage org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage;
        }

        public String org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding;
        }

        public boolean org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf;
        }

        public Enumeration.Value org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType;
        }

        private Option<Object> fileSize() {
            return this.fileSize;
        }

        private Counter counter() {
            return this.counter;
        }

        private Map<String, PartitionState> cache() {
            return this.cache;
        }

        public Path org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath() {
            return this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath;
        }

        private PartitionState newState(String partition) {
            None$ estimator;
            None$ none$;
            FileSystemStorage fileSystemStorage = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage();
            if (fileSystemStorage instanceof SizeableFileSystemStorage) {
                SizeableFileSystemStorage sizeableFileSystemStorage = (SizeableFileSystemStorage)fileSystemStorage;
                none$ = sizeableFileSystemStorage.targetSize(this.fileSize()).map((Function1 & Serializable & scala.Serializable)size -> sizeableFileSystemStorage.estimator(BoxesRunTime.unboxToLong((Object)size)));
            } else {
                none$ = None$.MODULE$;
            }
            None$ none$2 = estimator = none$;
            if (None$.MODULE$.equals(none$2)) {
                return new SinglePartitionState(this, partition);
            }
            if (none$2 instanceof Some) {
                Some some = (Some)none$2;
                FileSizeEstimator e = (FileSizeEstimator)some.value();
                return new ChunkedPartitionState(this, partition, e, this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context);
            }
            throw new MatchError((Object)none$2);
        }

        public void write(Void key, SimpleFeature value) {
            String partition = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().scheme().getPartitionName(value);
            PartitionState state = (PartitionState)this.cache().getOrElseUpdate((Object)partition, (Function0 & Serializable & scala.Serializable)() -> this.newState(partition));
            state.write(key, value);
            this.counter().increment(1L);
        }

        public void close(TaskAttemptContext context) {
            this.cache().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PartitionSchemeRecordWriter.$anonfun$close$1(this, context, x0$1);
                return BoxedUnit.UNIT;
            });
            package.CloseWithLogging$.MODULE$.apply((Object)this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage(), IsCloseable$.MODULE$.closeableIsCloseable());
        }

        public /* synthetic */ PartitionOutputFormat org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$close$1(PartitionSchemeRecordWriter $this, TaskAttemptContext context$1, Tuple2 x0$1) {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                String partition = (String)tuple2._1();
                PartitionState state = (PartitionState)tuple2._2();
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug("Closing writer for {}", new Object[]{partition});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                state.close(context$1);
                $this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().addPartition(state.meta());
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public PartitionSchemeRecordWriter(PartitionOutputFormat $outer, TaskAttemptContext context) {
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context = context;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            LazyLogging.$init$((LazyLogging)this);
            Configuration conf = context.getConfiguration();
            Path root = StorageConfiguration$.MODULE$.getRootPath(conf);
            package.FileSystemContext fsc = package.FileSystemContext$.MODULE$.apply(root, conf);
            StorageMetadata metadata = (StorageMetadata)StorageMetadataFactory$.MODULE$.load(fsc).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(32).append("No storage defined under path '").append(root).append("'").toString());
            });
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage = FileSystemStorageFactory$.MODULE$.apply(fsc, metadata);
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().encoding();
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().metadata().leafStorage();
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType = StorageConfiguration$.MODULE$.getFileType(context.getConfiguration());
            this.fileSize = StorageConfiguration$.MODULE$.getTargetFileSize(context.getConfiguration());
            this.counter = context.getCounter(StorageConfiguration$Counters$.MODULE$.Group(), StorageConfiguration$Counters$.MODULE$.Features());
            this.cache = Map$.MODULE$.empty();
            this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath = ((FileOutputCommitter)$outer.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate.getOutputCommitter(context)).getWorkPath();
        }

        private class ChunkedPartitionState
        extends PartitionState {
            private final FileSizeEstimator estimator;
            private final TaskAttemptContext context;
            private long count;
            private long total;
            private long remaining;
            private Path path;
            private RecordWriter<Void, SimpleFeature> writer;

            private long count() {
                return this.count;
            }

            private void count_$eq(long x$1) {
                this.count = x$1;
            }

            private long total() {
                return this.total;
            }

            private void total_$eq(long x$1) {
                this.total = x$1;
            }

            private long remaining() {
                return this.remaining;
            }

            private void remaining_$eq(long x$1) {
                this.remaining = x$1;
            }

            private Path path() {
                return this.path;
            }

            private void path_$eq(Path x$1) {
                this.path = x$1;
            }

            private RecordWriter<Void, SimpleFeature> writer() {
                return this.writer;
            }

            private void writer_$eq(RecordWriter<Void, SimpleFeature> x$1) {
                this.writer = x$1;
            }

            @Override
            public void write(Void key, SimpleFeature value) {
                if (this.writer() == null) {
                    Tuple2<Path, RecordWriter<Void, SimpleFeature>> tuple2 = this.newWriter();
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Path p = (Path)tuple2._1();
                    RecordWriter w = (RecordWriter)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)p, (Object)w);
                    Path p2 = (Path)tuple22._1();
                    RecordWriter w2 = (RecordWriter)tuple22._2();
                    this.path_$eq(p2);
                    this.writer_$eq((RecordWriter<Void, SimpleFeature>)w2);
                }
                this.writer().write((Object)key, (Object)value);
                this.count_$eq(this.count() + 1L);
                this.remaining_$eq(this.remaining() - 1L);
                if (this.remaining() == 0L) {
                    this.writer().close(this.context);
                    this.writer_$eq(null);
                    this.total_$eq(this.total() + this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$ChunkedPartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$storage().context().fs().getFileStatus(this.path()).getLen());
                    this.estimator.update(this.total(), this.count());
                    this.remaining_$eq(this.estimator.estimate(0L));
                }
                super.write(key, value);
            }

            @Override
            public void close(TaskAttemptContext context) {
                if (this.writer() != null) {
                    this.writer().close(context);
                }
                super.close(context);
            }

            public /* synthetic */ PartitionSchemeRecordWriter org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$ChunkedPartitionState$$$outer() {
                return this.$outer;
            }

            public ChunkedPartitionState(PartitionSchemeRecordWriter $outer, String partition, FileSizeEstimator estimator, TaskAttemptContext context) {
                this.estimator = estimator;
                this.context = context;
                super($outer, partition);
                this.count = 0L;
                this.total = 0L;
                this.remaining = estimator.estimate(0L);
            }
        }

        public abstract class PartitionState {
            private final String partition;
            private long count;
            private final Envelope bounds;
            private final ArrayBuffer<String> files;
            public final /* synthetic */ PartitionSchemeRecordWriter $outer;

            public static Method reflMethod$Method1(Class x$1) {
                CallSite methodCache1 = StructuralCallSite.bootstrap("apply", (Lorg/apache/hadoop/mapreduce/TaskAttemptContext;Lorg/apache/hadoop/fs/Path;)Ljava/lang/Object;);
                Method method1 = methodCache1.find(x$1);
                if (method1 != null) {
                    return method1;
                }
                method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("getRecordWriter", methodCache1.parameterTypes()));
                methodCache1.add(x$1, method1);
                return method1;
            }

            private long count() {
                return this.count;
            }

            private void count_$eq(long x$1) {
                this.count = x$1;
            }

            private Envelope bounds() {
                return this.bounds;
            }

            private ArrayBuffer<String> files() {
                return this.files;
            }

            public void write(Void key, SimpleFeature value) {
                Geometry geom = (Geometry)value.getDefaultGeometry();
                if (geom != null) {
                    this.bounds().expandToInclude(geom.getEnvelopeInternal());
                }
                this.count_$eq(this.count() + 1L);
            }

            public StorageMetadata.PartitionMetadata meta() {
                long millis = System.currentTimeMillis();
                ArrayBuffer f = (ArrayBuffer)this.files().map((Function1 & Serializable & scala.Serializable)x$1 -> new StorageMetadata.StorageFile(x$1, millis, StorageMetadata.StorageFile$.MODULE$.apply$default$3(), StorageMetadata.StorageFile$.MODULE$.apply$default$4(), StorageMetadata.StorageFile$.MODULE$.apply$default$5()), ArrayBuffer$.MODULE$.canBuildFrom());
                return new StorageMetadata.PartitionMetadata(this.partition, f.toSeq(), StorageMetadata.PartitionBounds$.MODULE$.apply(this.bounds()), this.count());
            }

            public void close(TaskAttemptContext context) {
                context.getCounter(StorageConfiguration$Counters$.MODULE$.Group(), StorageConfiguration$Counters$.MODULE$.partition(this.partition)).increment(this.count());
            }

            public Tuple2<Path, RecordWriter<Void, SimpleFeature>> newWriter() {
                Object object;
                BoxedUnit boxedUnit;
                Path file = StorageUtils$.MODULE$.nextFile(this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$workPath(), this.partition, this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$leaf(), this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$encoding(), this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$fileType(), StorageUtils$.MODULE$.nextFile$default$6());
                if (this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().logger().underlying().isDebugEnabled()) {
                    this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().logger().underlying().debug("Creating record writer at path {}", new Object[]{file});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.files().$plus$eq((Object)file.getName());
                FileOutputFormat<Void, SimpleFeature> qual1 = this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$$delegate;
                try {
                    object = PartitionState.reflMethod$Method1(qual1.getClass()).invoke(qual1, this.org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer().org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$$context, file);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                return new Tuple2((Object)file, (Object)((RecordWriter)object));
            }

            public /* synthetic */ PartitionSchemeRecordWriter org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$PartitionState$$$outer() {
                return this.$outer;
            }

            public PartitionState(PartitionSchemeRecordWriter $outer, String partition) {
                this.partition = partition;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count = 0L;
                this.bounds = new Envelope();
                this.files = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            }
        }

        private class SinglePartitionState
        extends PartitionState {
            private final RecordWriter<Void, SimpleFeature> writer = (RecordWriter)this.newWriter()._2();

            private RecordWriter<Void, SimpleFeature> writer() {
                return this.writer;
            }

            @Override
            public void write(Void key, SimpleFeature value) {
                this.writer().write((Object)key, (Object)value);
                super.write(key, value);
            }

            @Override
            public void close(TaskAttemptContext context) {
                this.writer().close(context);
                super.close(context);
            }

            public /* synthetic */ PartitionSchemeRecordWriter org$locationtech$geomesa$fs$storage$common$jobs$PartitionOutputFormat$PartitionSchemeRecordWriter$SinglePartitionState$$$outer() {
                return this.$outer;
            }

            public SinglePartitionState(PartitionSchemeRecordWriter $outer, String partition) {
                super($outer, partition);
            }
        }
    }
}

