/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.common.metadata.package;
import org.locationtech.geomesa.fs.storage.common.metadata.package$PartitionAction$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import pureconfig.ConfigCursor;
import pureconfig.ConfigListCursor;
import pureconfig.ConfigObjectCursor;
import pureconfig.ConfigReader;
import pureconfig.ConfigReader$;
import pureconfig.ConfigWriter;
import pureconfig.error.CannotConvert;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.FailureReason;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class package$ {
    public static package$ MODULE$;
    private final ConfigReader<package.PartitionConfig> org$locationtech$geomesa$fs$storage$common$metadata$package$$PartitionReader;
    private final ConfigReader<package.CompactedConfig> org$locationtech$geomesa$fs$storage$common$metadata$package$$CompactedReader;
    private final ConfigReader<StorageMetadata.StorageFile> StorageFileCompactReader;
    private final ConfigReader<StorageMetadata.StorageFile> StorageFileVerboseReader;
    private final ConfigReader<Tuple3<Object, String, String>> BoundReader;
    private final package.EnumerationReader<package$PartitionAction$> PartitionActionReader;
    private final package.EnumerationReader<StorageMetadata.StorageFileAction$> StorageFileActionReader;

    static {
        new package$();
    }

    public SimpleFeatureType namespaced(SimpleFeatureType sft, Option<String> namespace) {
        return (SimpleFeatureType)namespace.map((Function1 & Serializable & scala.Serializable)ns -> SimpleFeatureTypes$.MODULE$.renameSft(sft, new StringBuilder(1).append((String)ns).append(":").append(sft.getTypeName()).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft);
    }

    public Option<package.PartitionConfig> mergePartitionConfigs(Seq<package.PartitionConfig> configs) {
        return ((TraversableOnce)((TraversableLike)configs.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.timestamp()), (Ordering)Ordering.Long$.MODULE$)).dropWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$mergePartitionConfigs$2(x$2)))).reduceLeftOption((Function2 & Serializable & scala.Serializable)(result, update) -> {
            Enumeration.Value value = update.action();
            Enumeration.Value value2 = package$PartitionAction$.MODULE$.Add();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                return result.$plus((package.PartitionConfig)update);
            }
            Enumeration.Value value4 = package$PartitionAction$.MODULE$.Remove();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                return result.$minus((package.PartitionConfig)update);
            }
            throw new MatchError((Object)value);
        });
    }

    public ConfigReader<package.PartitionConfig> org$locationtech$geomesa$fs$storage$common$metadata$package$$PartitionReader() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$package$$PartitionReader;
    }

    public ConfigReader<package.CompactedConfig> org$locationtech$geomesa$fs$storage$common$metadata$package$$CompactedReader() {
        return this.org$locationtech$geomesa$fs$storage$common$metadata$package$$CompactedReader;
    }

    private ConfigReader<StorageMetadata.StorageFile> StorageFileCompactReader() {
        return this.StorageFileCompactReader;
    }

    private ConfigReader<StorageMetadata.StorageFile> StorageFileVerboseReader() {
        return this.StorageFileVerboseReader;
    }

    private ConfigReader<Tuple3<Object, String, String>> BoundReader() {
        return this.BoundReader;
    }

    private package.EnumerationReader<package$PartitionAction$> PartitionActionReader() {
        return this.PartitionActionReader;
    }

    private package.EnumerationReader<StorageMetadata.StorageFileAction$> StorageFileActionReader() {
        return this.StorageFileActionReader;
    }

    public ConfigValue org$locationtech$geomesa$fs$storage$common$metadata$package$$writeCompactedConfig(ConfigWriter<package.PartitionConfig> delegate, package.CompactedConfig compacted) {
        return ConfigValueFactory.fromMap(Collections.singletonMap("partitions", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)compacted.partitions().map((Function1 & Serializable & scala.Serializable)a -> delegate.to(a), Seq$.MODULE$.canBuildFrom())).asJava()));
    }

    private Either<ConfigReaderFailures, package.CompactedConfig> readCompactedConfig(ConfigCursor cur) {
        return cur.asObjectCursor().right().flatMap((Function1 & Serializable & scala.Serializable)obj -> obj.atKey("partitions").right().flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.asListCursor()).right().flatMap((Function1 & Serializable & scala.Serializable)par -> MODULE$.convertList((ConfigListCursor)par, (ConfigReader)MODULE$.org$locationtech$geomesa$fs$storage$common$metadata$package$$PartitionReader()).right().map((Function1 & Serializable & scala.Serializable)list -> new package.CompactedConfig((Seq<package.PartitionConfig>)list))));
    }

    public ConfigValue org$locationtech$geomesa$fs$storage$common$metadata$package$$writePartitionConfigCompact(package.PartitionConfig partition) {
        ArrayList<Object> list = new ArrayList<Object>(5);
        list.add(new StringOps(Predef$.MODULE$.augmentString(partition.action().toString())).take(1));
        list.add(BoxesRunTime.boxToLong((long)partition.timestamp()));
        list.add(JavaConverters$.MODULE$.seqAsJavaListConverter(partition.envelope()).asJava());
        list.add(BoxesRunTime.boxToLong((long)partition.count()));
        list.add(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partition.files().map((Function1 & Serializable & scala.Serializable)file -> MODULE$.writeStorageFileCompact((StorageMetadata.StorageFile)file), Seq$.MODULE$.canBuildFrom())).asJava());
        return ConfigValueFactory.fromMap(Collections.singletonMap(partition.name(), list));
    }

    public ConfigValue org$locationtech$geomesa$fs$storage$common$metadata$package$$writePartitionConfigVerbose(package.PartitionConfig partition) {
        Object object;
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("name", partition.name());
        map.put("action", partition.action().toString());
        map.put("files", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partition.files().map((Function1 & Serializable & scala.Serializable)file -> MODULE$.writeStorageFileVerbose((StorageMetadata.StorageFile)file), Seq$.MODULE$.canBuildFrom())).asJava());
        map.put("count", BoxesRunTime.boxToLong((long)partition.count()));
        map.put("timestamp", BoxesRunTime.boxToLong((long)partition.timestamp()));
        if (partition.envelope().nonEmpty()) {
            HashMap<String, Double> envelope = new HashMap<String, Double>(4);
            envelope.put("xmin", BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)partition.envelope().head())));
            envelope.put("ymin", BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)partition.envelope().apply(1))));
            envelope.put("xmax", BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)partition.envelope().apply(2))));
            envelope.put("ymax", BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)partition.envelope().apply(3))));
            object = map.put("envelope", envelope);
        } else {
            object = BoxedUnit.UNIT;
        }
        return ConfigValueFactory.fromMap(map);
    }

    private Either<ConfigReaderFailures, package.PartitionConfig> readPartitionConfig(ConfigCursor cur) {
        Either<ConfigReaderFailures, package.PartitionConfig> compact = this.readPartitionConfigCompact(cur);
        if (compact.isRight()) {
            return compact;
        }
        return this.readPartitionConfigVerbose(cur).left().flatMap((Function1 & Serializable & scala.Serializable)x$11 -> compact);
    }

    private Either<ConfigReaderFailures, package.PartitionConfig> readPartitionConfigCompact(ConfigCursor cur) {
        return cur.asObjectCursor().right().flatMap((Function1 & Serializable & scala.Serializable)obj -> {
            String name = (String)obj.keys().head();
            return obj.atKeyOrUndefined(name).asListCursor().right().flatMap((Function1 & Serializable & scala.Serializable)list -> {
                if (list.size() != 5) {
                    return cur.failed((FailureReason)new CannotConvert((String)cur.valueOpt().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), package.PartitionConfig.class.getSimpleName(), new StringBuilder(44).append("value ").append(cur.valueOpt().orNull(Predef$.MODULE$.$conforms())).append(" does not have the expected 6 elements").toString()));
                }
                return MODULE$.PartitionActionReader().from(list.atIndexOrUndefined(0)).right().flatMap((Function1 & Serializable & scala.Serializable)action -> list.atIndexOrUndefined(1).asLong().right().flatMap((Function1 & Serializable & scala.Serializable)ts -> package$.$anonfun$readPartitionConfigCompact$6(list, name, action, BoxesRunTime.unboxToLong((Object)ts))));
            });
        });
    }

    private Either<ConfigReaderFailures, package.PartitionConfig> readPartitionConfigVerbose(ConfigCursor cur) {
        return cur.asObjectCursor().right().flatMap((Function1 & Serializable & scala.Serializable)obj -> obj.atKey("name").right().flatMap((Function1 & Serializable & scala.Serializable)x$18 -> x$18.asString()).right().flatMap((Function1 & Serializable & scala.Serializable)name -> obj.atKey("action").right().flatMap((Function1 & Serializable & scala.Serializable)cur -> MODULE$.PartitionActionReader().from((ConfigCursor)cur)).right().flatMap((Function1 & Serializable & scala.Serializable)action -> obj.atKey("files").right().flatMap((Function1 & Serializable & scala.Serializable)x$19 -> x$19.asListCursor()).right().flatMap((Function1 & Serializable & scala.Serializable)x$20 -> MODULE$.convertList((ConfigListCursor)x$20, (ConfigReader)MODULE$.StorageFileVerboseReader())).right().flatMap((Function1 & Serializable & scala.Serializable)files -> obj.atKey("count").right().flatMap((Function1 & Serializable & scala.Serializable)cur -> ConfigReader$.MODULE$.longConfigReader().from(cur)).right().flatMap((Function1 & Serializable & scala.Serializable)count -> package$.$anonfun$readPartitionConfigVerbose$19(obj, name, action, files, BoxesRunTime.unboxToLong((Object)count)))))));
    }

    private ConfigValue writeStorageFileCompact(StorageMetadata.StorageFile file) {
        ArrayList<Object> list = new ArrayList<Object>(5);
        list.add(file.name());
        list.add(new StringOps(Predef$.MODULE$.augmentString(file.action().toString())).take(1));
        list.add(BoxesRunTime.boxToLong((long)file.timestamp()));
        Object object = file.sort().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)list.add(JavaConverters$.MODULE$.seqAsJavaListConverter(file.sort()).asJava())) : BoxedUnit.UNIT;
        Object object2 = file.bounds().nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)list.add(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)file.bounds().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int a = BoxesRunTime.unboxToInt((Object)tuple3._1());
                String f = (String)tuple3._2();
                String t = (String)tuple3._3();
                return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)a), f, t}))).asJava();
            }
            throw new MatchError((Object)tuple3);
        }, Seq$.MODULE$.canBuildFrom())).asJava())) : BoxedUnit.UNIT;
        return ConfigValueFactory.fromIterable(list);
    }

    private ConfigValue writeStorageFileVerbose(StorageMetadata.StorageFile file) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("name", file.name());
        map.put("timestamp", BoxesRunTime.boxToLong((long)file.timestamp()));
        map.put("action", file.action().toString());
        Object object = file.sort().nonEmpty() ? map.put("sort", JavaConverters$.MODULE$.seqAsJavaListConverter(file.sort()).asJava()) : BoxedUnit.UNIT;
        Object object2 = file.bounds().nonEmpty() ? map.put("bounds", JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)file.bounds().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int a = BoxesRunTime.unboxToInt((Object)tuple3._1());
                String f = (String)tuple3._2();
                String t = (String)tuple3._3();
                return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)a), f, t}))).asJava();
            }
            throw new MatchError((Object)tuple3);
        }, Seq$.MODULE$.canBuildFrom())).asJava()) : BoxedUnit.UNIT;
        return ConfigValueFactory.fromMap(map);
    }

    private Either<ConfigReaderFailures, StorageMetadata.StorageFile> readStorageFileCompact(ConfigCursor cur) {
        return cur.asListCursor().right().flatMap((Function1 & Serializable & scala.Serializable)list -> {
            if (list.size() < 3 || list.size() > 5) {
                return cur.failed((FailureReason)new CannotConvert((String)cur.valueOpt().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), StorageMetadata.StorageFile.class.getSimpleName(), new StringBuilder(52).append("value ").append(cur.valueOpt().orNull(Predef$.MODULE$.$conforms())).append(" does not have the expected number of elements").toString()));
            }
            return list.atIndexOrUndefined(0).asString().right().flatMap((Function1 & Serializable & scala.Serializable)name -> MODULE$.StorageFileActionReader().from(list.atIndexOrUndefined(1)).right().flatMap((Function1 & Serializable & scala.Serializable)action -> list.atIndexOrUndefined(2).asLong().right().flatMap((Function1 & Serializable & scala.Serializable)ts -> package$.$anonfun$readStorageFileCompact$6(list, name, action, BoxesRunTime.unboxToLong((Object)ts)))));
        });
    }

    private Either<ConfigReaderFailures, StorageMetadata.StorageFile> readStorageFileVerbose(ConfigCursor cur) {
        Either withAction = cur.asObjectCursor().right().flatMap((Function1 & Serializable & scala.Serializable)obj -> obj.atKey("name").right().flatMap((Function1 & Serializable & scala.Serializable)x$22 -> x$22.asString()).right().flatMap((Function1 & Serializable & scala.Serializable)name -> obj.atKey("timestamp").right().flatMap((Function1 & Serializable & scala.Serializable)cur -> ConfigReader$.MODULE$.longConfigReader().from(cur)).right().flatMap((Function1 & Serializable & scala.Serializable)ts -> package$.$anonfun$readStorageFileVerbose$5(obj, name, BoxesRunTime.unboxToLong((Object)ts)))));
        if (withAction.isRight()) {
            return withAction;
        }
        Either sansAction = cur.asString().right().map((Function1 & Serializable & scala.Serializable)name -> new StorageMetadata.StorageFile(name, 0L, StorageMetadata.StorageFile$.MODULE$.apply$default$3(), StorageMetadata.StorageFile$.MODULE$.apply$default$4(), StorageMetadata.StorageFile$.MODULE$.apply$default$5()));
        return sansAction.left().flatMap((Function1 & Serializable & scala.Serializable)x$23 -> withAction);
    }

    private Either<ConfigReaderFailures, Seq<Object>> readEnvelope(ConfigListCursor env) {
        return this.convertList(env, ConfigReader$.MODULE$.doubleConfigReader()).right().flatMap((Function1 & Serializable & scala.Serializable)coords -> {
            if (coords.isEmpty() || coords.length() == 4) {
                return scala.package$.MODULE$.Right().apply(coords);
            }
            return env.failed((FailureReason)new CannotConvert((String)env.valueOpt().map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), "Seq[Double]", new StringBuilder(44).append("value ").append(env.valueOpt().orNull(Predef$.MODULE$.$conforms())).append(" does not have the expected 4 elements").toString()));
        });
    }

    private Either<ConfigReaderFailures, Seq<Object>> readSort(ConfigCursor cur) {
        if (cur.isUndefined()) {
            return scala.package$.MODULE$.Right().apply((Object)Nil$.MODULE$);
        }
        return cur.asListCursor().right().flatMap((Function1 & Serializable & scala.Serializable)list -> MODULE$.convertList((ConfigListCursor)list, (ConfigReader)ConfigReader$.MODULE$.intConfigReader()));
    }

    private Either<ConfigReaderFailures, Seq<Tuple3<Object, String, String>>> readBounds(ConfigCursor cur) {
        if (cur.isUndefined()) {
            return scala.package$.MODULE$.Right().apply((Object)Nil$.MODULE$);
        }
        return cur.asListCursor().right().flatMap((Function1 & Serializable & scala.Serializable)x$25 -> MODULE$.convertList((ConfigListCursor)x$25, (ConfigReader)MODULE$.BoundReader()));
    }

    private Either<ConfigReaderFailures, Tuple3<Object, String, String>> readBound(ConfigCursor cur) {
        return cur.asListCursor().right().flatMap((Function1 & Serializable & scala.Serializable)list -> {
            if (list.size() != 3) {
                return cur.failed((FailureReason)new CannotConvert((String)cur.valueOpt().map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), "Tuple3[Int, String, String]", new StringBuilder(31).append("value ").append(cur.valueOpt().orNull(Predef$.MODULE$.$conforms())).append(" does not have 3 elements").toString()));
            }
            return list.atIndexOrUndefined(0).asInt().right().flatMap((Function1 & Serializable & scala.Serializable)attribute -> package$.$anonfun$readBound$4(list, BoxesRunTime.unboxToInt((Object)attribute)));
        });
    }

    private <T> Either<ConfigReaderFailures, Seq<T>> convertList(ConfigListCursor list, ConfigReader<T> reader) {
        Builder res = Seq$.MODULE$.newBuilder();
        ConfigReaderFailures err = null;
        for (int i = 0; i < list.size(); ++i) {
            Either either = reader.from(list.atIndexOrUndefined(i));
            if (either instanceof Right) {
                Right right = (Right)either;
                Object success = right.value();
                res.$plus$eq(success);
                continue;
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                ConfigReaderFailures failure = (ConfigReaderFailures)left.value();
                if (err == null) {
                    err = failure;
                    continue;
                }
                err = err.$plus$plus(failure);
                continue;
            }
            throw new MatchError((Object)either);
        }
        if (err == null) {
            return scala.package$.MODULE$.Right().apply(res.result());
        }
        return scala.package$.MODULE$.Left().apply(err);
    }

    public static final /* synthetic */ boolean $anonfun$mergePartitionConfigs$2(package.PartitionConfig x$2) {
        Enumeration.Value value = x$2.action();
        Enumeration.Value value2 = package$PartitionAction$.MODULE$.Add();
        return value == null ? value2 != null : !value.equals(value2);
    }

    public static final /* synthetic */ Either $anonfun$readPartitionConfigCompact$9(ConfigListCursor list$1, String name$2, Enumeration.Value action$1, Seq env$1, long ts$1, long count) {
        return list$1.atIndexOrUndefined(4).asListCursor().right().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.convertList((ConfigListCursor)x$13, (ConfigReader)MODULE$.StorageFileCompactReader())).right().map((Function1 & Serializable & scala.Serializable)files -> new package.PartitionConfig(name$2, action$1, (Seq<StorageMetadata.StorageFile>)files, count, (Seq<Object>)env$1, ts$1));
    }

    public static final /* synthetic */ Either $anonfun$readPartitionConfigCompact$6(ConfigListCursor list$1, String name$2, Enumeration.Value action$1, long ts) {
        return list$1.atIndexOrUndefined(2).asListCursor().right().flatMap((Function1 & Serializable & scala.Serializable)env -> MODULE$.readEnvelope((ConfigListCursor)env)).right().flatMap((Function1 & Serializable & scala.Serializable)env -> list$1.atIndexOrUndefined(3).asLong().right().flatMap((Function1 & Serializable & scala.Serializable)count -> package$.$anonfun$readPartitionConfigCompact$9(list$1, name$2, action$1, env, ts, BoxesRunTime.unboxToLong((Object)count))));
    }

    public static final /* synthetic */ Seq $anonfun$readPartitionConfigVerbose$9(double xmin$1, double ymin$1, double xmax$1, double ymax) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{xmin$1, ymin$1, xmax$1, ymax}));
    }

    public static final /* synthetic */ Either $anonfun$readPartitionConfigVerbose$7(ConfigObjectCursor env$2, double xmin$1, double ymin$1, double xmax) {
        return env$2.atKey("ymax").right().flatMap((Function1 & Serializable & scala.Serializable)x$17 -> x$17.asDouble()).right().map((Function1 & Serializable & scala.Serializable)ymax -> package$.$anonfun$readPartitionConfigVerbose$9(xmin$1, ymin$1, xmax, BoxesRunTime.unboxToDouble((Object)ymax)));
    }

    public static final /* synthetic */ Either $anonfun$readPartitionConfigVerbose$5(ConfigObjectCursor env$2, double xmin$1, double ymin) {
        return env$2.atKey("xmax").right().flatMap((Function1 & Serializable & scala.Serializable)x$16 -> x$16.asDouble()).right().flatMap((Function1 & Serializable & scala.Serializable)xmax -> package$.$anonfun$readPartitionConfigVerbose$7(env$2, xmin$1, ymin, BoxesRunTime.unboxToDouble((Object)xmax)));
    }

    public static final /* synthetic */ Either $anonfun$readPartitionConfigVerbose$3(ConfigObjectCursor env$2, double xmin) {
        return env$2.atKey("ymin").right().flatMap((Function1 & Serializable & scala.Serializable)x$15 -> x$15.asDouble()).right().flatMap((Function1 & Serializable & scala.Serializable)ymin -> package$.$anonfun$readPartitionConfigVerbose$5(env$2, xmin, BoxesRunTime.unboxToDouble((Object)ymin)));
    }

    private static final Either readEnvelope$1(ConfigObjectCursor obj) {
        ConfigCursor configCursor = obj.atKeyOrUndefined("envelope");
        if (configCursor.isUndefined()) {
            return scala.package$.MODULE$.Right().apply((Object)Nil$.MODULE$);
        }
        return configCursor.asObjectCursor().right().flatMap((Function1 & Serializable & scala.Serializable)env -> env.atKey("xmin").right().flatMap((Function1 & Serializable & scala.Serializable)x$14 -> x$14.asDouble()).right().flatMap((Function1 & Serializable & scala.Serializable)xmin -> package$.$anonfun$readPartitionConfigVerbose$3(env, BoxesRunTime.unboxToDouble((Object)xmin))));
    }

    public static final /* synthetic */ package.PartitionConfig $anonfun$readPartitionConfigVerbose$22(String name$3, Enumeration.Value action$2, Seq files$1, long count$2, Seq bounds$1, long ts) {
        return new package.PartitionConfig(name$3, action$2, (Seq<StorageMetadata.StorageFile>)files$1, count$2, (Seq<Object>)bounds$1, ts);
    }

    public static final /* synthetic */ Either $anonfun$readPartitionConfigVerbose$19(ConfigObjectCursor obj$1, String name$3, Enumeration.Value action$2, Seq files$1, long count) {
        return package$.readEnvelope$1(obj$1).right().flatMap((Function1 & Serializable & scala.Serializable)bounds -> obj$1.atKey("timestamp").right().flatMap((Function1 & Serializable & scala.Serializable)cur -> ConfigReader$.MODULE$.longConfigReader().from(cur)).right().map((Function1 & Serializable & scala.Serializable)ts -> package$.$anonfun$readPartitionConfigVerbose$22(name$3, action$2, files$1, count, bounds, BoxesRunTime.unboxToLong((Object)ts))));
    }

    public static final /* synthetic */ Either $anonfun$readStorageFileCompact$6(ConfigListCursor list$2, String name$4, Enumeration.Value action$3, long ts) {
        return MODULE$.readSort(list$2.atIndexOrUndefined(3)).right().flatMap((Function1 & Serializable & scala.Serializable)sort -> MODULE$.readBounds(list$2.atIndexOrUndefined(4)).right().map((Function1 & Serializable & scala.Serializable)bounds -> new StorageMetadata.StorageFile(name$4, ts, action$3, sort, bounds)));
    }

    public static final /* synthetic */ Either $anonfun$readStorageFileVerbose$5(ConfigObjectCursor obj$2, String name$5, long ts) {
        return obj$2.atKey("action").right().flatMap((Function1 & Serializable & scala.Serializable)cur -> MODULE$.StorageFileActionReader().from((ConfigCursor)cur)).right().flatMap((Function1 & Serializable & scala.Serializable)action -> MODULE$.readSort(obj$2.atKeyOrUndefined("sort")).right().flatMap((Function1 & Serializable & scala.Serializable)sort -> MODULE$.readBounds(obj$2.atKeyOrUndefined("bounds")).right().map((Function1 & Serializable & scala.Serializable)bounds -> new StorageMetadata.StorageFile(name$5, ts, action, sort, bounds))));
    }

    public static final /* synthetic */ Either $anonfun$readBound$4(ConfigListCursor list$3, int attribute) {
        return list$3.atIndexOrUndefined(1).asString().right().flatMap((Function1 & Serializable & scala.Serializable)from -> list$3.atIndexOrUndefined(2).asString().right().map((Function1 & Serializable & scala.Serializable)to -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)attribute), from, to)));
    }

    private package$() {
        MODULE$ = this;
        this.org$locationtech$geomesa$fs$storage$common$metadata$package$$PartitionReader = ConfigReader$.MODULE$.fromCursor((Function1 & Serializable & scala.Serializable)cur -> MODULE$.readPartitionConfig((ConfigCursor)cur));
        this.org$locationtech$geomesa$fs$storage$common$metadata$package$$CompactedReader = ConfigReader$.MODULE$.fromCursor((Function1 & Serializable & scala.Serializable)cur -> MODULE$.readCompactedConfig((ConfigCursor)cur));
        this.StorageFileCompactReader = ConfigReader$.MODULE$.fromCursor((Function1 & Serializable & scala.Serializable)cur -> MODULE$.readStorageFileCompact((ConfigCursor)cur));
        this.StorageFileVerboseReader = ConfigReader$.MODULE$.fromCursor((Function1 & Serializable & scala.Serializable)cur -> MODULE$.readStorageFileVerbose((ConfigCursor)cur));
        this.BoundReader = ConfigReader$.MODULE$.fromCursor((Function1 & Serializable & scala.Serializable)cur -> MODULE$.readBound((ConfigCursor)cur));
        this.PartitionActionReader = new package.EnumerationReader<package$PartitionAction$>(package$PartitionAction$.MODULE$);
        this.StorageFileActionReader = new package.EnumerationReader<StorageMetadata.StorageFileAction$>(StorageMetadata.StorageFileAction$.MODULE$);
    }
}

