/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.utils;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$RemoteIterator$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PathCache$
implements LazyLogging {
    public static PathCache$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty CacheDurationProperty;
    private final long duration;
    private final LoadingCache<Tuple2<FileSystem, Path>, Boolean> pathCache;
    private final LoadingCache<Tuple2<FileSystem, Path>, Stream<FileStatus>> org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache;
    private final LoadingCache<Tuple2<FileSystem, Path>, FileStatus> statusCache;
    private final Method refresh;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new PathCache$();
    }

    private Logger logger$lzycompute() {
        PathCache$ pathCache$ = this;
        synchronized (pathCache$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public GeoMesaSystemProperties.SystemProperty CacheDurationProperty() {
        return this.CacheDurationProperty;
    }

    private long duration() {
        return this.duration;
    }

    private LoadingCache<Tuple2<FileSystem, Path>, Boolean> pathCache() {
        return this.pathCache;
    }

    public LoadingCache<Tuple2<FileSystem, Path>, Stream<FileStatus>> org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache() {
        return this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache;
    }

    private LoadingCache<Tuple2<FileSystem, Path>, FileStatus> statusCache() {
        return this.statusCache;
    }

    private Method refresh() {
        return this.refresh;
    }

    public void register(FileSystem fs, Path path) {
        this.pathCache().put((Object)new Tuple2((Object)fs, (Object)path), (Object)Boolean.TRUE);
        if (this.refresh() != null) {
            this.refresh().invoke(this.statusCache(), new Tuple2((Object)fs, (Object)path));
            return;
        }
    }

    public boolean exists(FileSystem fs, Path path, boolean reload) {
        if (reload) {
            this.invalidate(fs, path);
        }
        return (Boolean)this.pathCache().get((Object)new Tuple2((Object)fs, (Object)path));
    }

    public boolean exists$default$3() {
        return false;
    }

    public FileStatus status(FileSystem fs, Path path, boolean reload) {
        if (reload) {
            this.invalidate(fs, path);
        }
        return (FileStatus)this.statusCache().get((Object)new Tuple2((Object)fs, (Object)path));
    }

    public boolean status$default$3() {
        return false;
    }

    public Iterator<FileStatus> list(FileSystem fs, Path dir, boolean reload) {
        if (reload) {
            this.invalidate(fs, dir);
        }
        return ((Stream)this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache().get((Object)new Tuple2((Object)fs, (Object)dir))).iterator();
    }

    public boolean list$default$3() {
        return false;
    }

    public void invalidate(FileSystem fs, Path path) {
        ((IterableLike)new .colon.colon(this.pathCache(), (List)new .colon.colon(this.statusCache(), (List)new .colon.colon(this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.invalidate((Object)new Tuple2((Object)fs, (Object)path));
            return BoxedUnit.UNIT;
        });
        if (path.getParent() != null) {
            this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache().invalidate((Object)new Tuple2((Object)fs, (Object)path.getParent()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$refresh$1(Method x$1) {
        String string = x$1.getName();
        String string2 = "refresh";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private PathCache$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.CacheDurationProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.fs.file.cache.duration", "15 minutes");
        this.duration = ((Duration)this.CacheDurationProperty().toDuration().get()).toMillis();
        this.pathCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileSystem, Path>, Boolean>(){

            public Map<? extends Tuple2<FileSystem, Path>, ? extends Boolean> loadAll(Set<? extends Tuple2<FileSystem, Path>> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) throws Exception {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<? extends Map<? extends Tuple2<FileSystem, Path>, ? extends Boolean>> asyncLoadAll(Set<? extends Tuple2<FileSystem, Path>> x$1, Executor x$2) throws Exception {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) throws Exception {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Boolean load(Tuple2<FileSystem, Path> key) {
                return Predef$.MODULE$.boolean2Boolean(((FileSystem)key._1()).exists((Path)key._2()));
            }
        });
        this.org$locationtech$geomesa$fs$storage$common$utils$PathCache$$listCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileSystem, Path>, Stream<FileStatus>>(){

            public Map<? extends Tuple2<FileSystem, Path>, ? extends Stream<FileStatus>> loadAll(Set<? extends Tuple2<FileSystem, Path>> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) throws Exception {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<? extends Map<? extends Tuple2<FileSystem, Path>, ? extends Stream<FileStatus>>> asyncLoadAll(Set<? extends Tuple2<FileSystem, Path>> x$1, Executor x$2) throws Exception {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) throws Exception {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Stream<FileStatus> load(Tuple2<FileSystem, Path> key) {
                return PathCache$RemoteIterator$.MODULE$.apply(((FileSystem)key._1()).listStatusIterator((Path)key._2())).toStream();
            }
        });
        this.statusCache = Caffeine.newBuilder().expireAfterWrite(this.duration(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Tuple2<FileSystem, Path>, FileStatus>(){

            public Map<? extends Tuple2<FileSystem, Path>, ? extends FileStatus> loadAll(Set<? extends Tuple2<FileSystem, Path>> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture<? extends Map<? extends Tuple2<FileSystem, Path>, ? extends FileStatus>> asyncLoadAll(Set<? extends Tuple2<FileSystem, Path>> x$1, Executor x$2) throws Exception {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public FileStatus load(Tuple2<FileSystem, Path> key) {
                FileStatus fileStatus;
                try {
                    fileStatus = ((FileSystem)key._1()).getFileStatus((Path)key._2());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileStatus = null;
                }
                return fileStatus;
            }

            public CompletableFuture<FileStatus> asyncLoad(Tuple2<FileSystem, Path> key, Executor executor) {
                return super.asyncLoad(key, executor).whenCompleteAsync((BiConsumer)new PathCache.ListCacheRefresh(key), executor);
            }

            public CompletableFuture<FileStatus> asyncReload(Tuple2<FileSystem, Path> key, FileStatus oldValue, Executor executor) {
                return super.asyncReload(key, (Object)oldValue, executor).whenCompleteAsync((BiConsumer)new PathCache.ListCacheRefresh(key), executor);
            }
        });
        this.refresh = (Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LoadingCache.class.getMethods())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PathCache$.$anonfun$refresh$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Could not get refresh cache method - cache operations will be less efficient");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return null;
        });
    }
}

