/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.metadata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadata$;
import org.locationtech.geomesa.fs.storage.common.metadata.FileBasedMetadataFactory;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.DebugLogProfiling;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import pureconfig.ConfigSource$;
import pureconfig.ConfigWriter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class MetadataJson$
implements DebugLogProfiling {
    public static MetadataJson$ MODULE$;
    private final String MetadataPath;
    private final ConcurrentHashMap<String, package.NamedOptions> cache;
    private final Logger logger;

    static {
        new MetadataJson$();
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)DebugLogProfiling.profile$((DebugLogProfiling)this, (String)message, code);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String MetadataPath() {
        return this.MetadataPath;
    }

    private ConcurrentHashMap<String, package.NamedOptions> cache() {
        return this.cache;
    }

    public Option<package.NamedOptions> readMetadata(package.FileSystemContext context) {
        BoxedUnit boxedUnit;
        String key = context.root().toUri().toString();
        ObjectRef cached = ObjectRef.create((Object)this.cache().get(key));
        if ((package.NamedOptions)cached.elem == null) {
            Path file = new Path(context.root(), this.MetadataPath());
            if (PathCache$.MODULE$.exists(context.fs(), file, PathCache$.MODULE$.exists$default$3())) {
                Config config = (Config)this.profile("Loaded metadata configuration", (Function0 & Serializable & scala.Serializable)() -> (Config)package.WithClose$.MODULE$.apply((Object)new InputStreamReader((InputStream)context.fs().open(file), StandardCharsets.UTF_8), (Function1 & Serializable & scala.Serializable)in -> ConfigFactory.load((Config)ConfigFactory.parseReader((Reader)in, (ConfigParseOptions)package$.MODULE$.ParseOptions())), IsCloseable$.MODULE$.closeableIsCloseable()));
                if (config.hasPath("name")) {
                    cached.elem = (package.NamedOptions)this.profile("Parsed metadata configuration", (Function0 & Serializable & scala.Serializable)() -> (package.NamedOptions)ConfigSource$.MODULE$.fromConfig(config).loadOrThrow(ClassTag$.MODULE$.apply(package.NamedOptions.class), package$.MODULE$.NamedOptionsConvert()));
                    boxedUnit = this.cache().put(key, (package.NamedOptions)cached.elem);
                } else {
                    context.fs().rename(file, new Path(context.root(), new StringBuilder(4).append(this.MetadataPath()).append(".bak").toString()));
                    PathCache$.MODULE$.invalidate(context.fs(), file);
                    this.transitionMetadata(context, config).foreach((Function1 & Serializable & scala.Serializable)meta -> {
                        cached.elem = meta;
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return Option$.MODULE$.apply((Object)((package.NamedOptions)cached.elem));
    }

    public void writeMetadata(package.FileSystemContext context, package.NamedOptions metadata) {
        Path file = new Path(context.root(), this.MetadataPath());
        if (PathCache$.MODULE$.exists(context.fs(), file, true)) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Trying to create a new storage instance but metadata already exists at '").append(file).append("'").toString());
        }
        String data = (String)this.profile("Serialized metadata configuration", (Function0 & Serializable & scala.Serializable)() -> ConfigWriter$.MODULE$.apply(package$.MODULE$.NamedOptionsConvert()).to((Object)metadata).render(package$.MODULE$.RenderOptions()));
        String interpolated = data.replaceAll("\\$\\{[a-zA-Z0-9_.]+}", "\"$0\"");
        this.profile("Persisted metadata configuration", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> package.WithClose$.MODULE$.apply((Object)context.fs().create(file, false), (Function1 & Serializable & scala.Serializable)out -> {
            MetadataJson$.$anonfun$writeMetadata$3(interpolated, out);
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable()));
        String string = data;
        String string2 = interpolated;
        package.NamedOptions toCache = !(string != null ? !string.equals(string2) : string2 != null) ? metadata : (package.NamedOptions)ConfigSource$.MODULE$.fromConfig(ConfigFactory.load((Config)ConfigFactory.parseString((String)interpolated, (ConfigParseOptions)package$.MODULE$.ParseOptions()))).loadOrThrow(ClassTag$.MODULE$.apply(package.NamedOptions.class), package$.MODULE$.NamedOptionsConvert());
        this.cache().put(context.root().toUri().toString(), toCache);
        PathCache$.MODULE$.register(context.fs(), file);
    }

    private Option<package.NamedOptions> transitionMetadata(package.FileSystemContext context, Config config) {
        None$ none$;
        try {
            Config x$12 = config.getConfig("featureType");
            None$ x$2 = None$.MODULE$;
            Option x$3 = SimpleFeatureTypes$.MODULE$.createType$default$2();
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(x$12, x$3, (Option)x$2);
            String encoding = config.getString("encoding");
            Config schemeConfig = config.getConfig("partitionScheme");
            Config schemeOpts = schemeConfig.getConfig("options");
            package.NamedOptions scheme = new package.NamedOptions(schemeConfig.getString("scheme"), ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(schemeOpts.entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), (Object)schemeOpts.getString((String)e.getKey())), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            boolean leafStorage = scheme.options().get((Object)"leaf-storage").forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataJson$.$anonfun$transitionMetadata$2(x$1)));
            package.Metadata meta = package.Metadata$.MODULE$.apply(sft, encoding, scheme, leafStorage, package.Metadata$.MODULE$.apply$default$5());
            Config partitionConfig = config.getConfig("partitions");
            package.NamedOptions defaults = FileBasedMetadata$.MODULE$.LegacyOptions();
            package.WithClose$.MODULE$.apply((Object)new FileBasedMetadataFactory().create(context, defaults.options(), meta), (Function1 & Serializable & scala.Serializable)metadata -> {
                MetadataJson$.$anonfun$transitionMetadata$3(partitionConfig, metadata);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            none$ = new Some((Object)defaults);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e2 = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error transitioning old metadata format: ", e2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$writeMetadata$3(String interpolated$1, FSDataOutputStream out) {
        out.write(interpolated$1.getBytes(StandardCharsets.UTF_8));
        out.hflush();
        out.hsync();
    }

    public static final /* synthetic */ boolean $anonfun$transitionMetadata$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$transitionMetadata$4(Config partitionConfig$1, FileBasedMetadata metadata$2, Map.Entry e) {
        String name = (String)e.getKey();
        Buffer files = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionConfig$1.getStringList(name)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new StorageMetadata.StorageFile(x$2, 0L, StorageMetadata.StorageFile$.MODULE$.apply$default$3(), StorageMetadata.StorageFile$.MODULE$.apply$default$4(), StorageMetadata.StorageFile$.MODULE$.apply$default$5()), Buffer$.MODULE$.canBuildFrom());
        metadata$2.addPartition(new StorageMetadata.PartitionMetadata(name, files.toSeq(), (Option)None$.MODULE$, 0L));
    }

    public static final /* synthetic */ void $anonfun$transitionMetadata$3(Config partitionConfig$1, FileBasedMetadata metadata) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(partitionConfig$1.root().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> {
            MetadataJson$.$anonfun$transitionMetadata$4(partitionConfig$1, metadata, e);
            return BoxedUnit.UNIT;
        });
    }

    private MetadataJson$() {
        MODULE$ = this;
        MethodProfiling.$init$((MethodProfiling)this);
        StrictLogging.$init$((StrictLogging)this);
        DebugLogProfiling.$init$((DebugLogProfiling)this);
        this.MetadataPath = "metadata.json";
        this.cache = new ConcurrentHashMap();
    }
}

