/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.common.partitions;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.curve.XZ2SFC;
import org.locationtech.geomesa.curve.XZ2SFC$;
import org.locationtech.geomesa.fs.storage.common.partitions.SpatialScheme;
import org.locationtech.geomesa.fs.storage.common.partitions.XZ2Scheme$;
import org.locationtech.geomesa.zorder.sfcurve.package;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001\u0002\u0014(\u0001ZB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005X\u0001\tE\t\u0015!\u0003M\u0011!A\u0006A!f\u0001\n\u0003)\u0005\u0002C-\u0001\u0005#\u0005\u000b\u0011\u0002$\t\u000bi\u0003A\u0011A.\t\u000f\u0001\u0004!\u0019!C\u0005C\"1\u0001\u000e\u0001Q\u0001\n\tDQ!\u001b\u0001\u0005B-CQA\u001b\u0001\u0005B-DQ!\u001f\u0001\u0005BiDq!a\u0002\u0001\t#\nI\u0001C\u0004\u0002\u000e\u0001!\t&a\u0004\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA4\u0001E\u0005I\u0011AA5\u0011%\ty\bAI\u0001\n\u0003\t\t\tC\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002j!I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0012\u0005\t\u00033\u0003\u0011\u0011!C\u0001\u000b\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003S\u0003\u0011\u0011!C!\u0003WC\u0011\"!/\u0001\u0003\u0003%\t!a/\t\u0013\u0005\u0015\u0007!!A\u0005B\u0005\u001d\u0007\"CAe\u0001\u0005\u0005I\u0011IAf\u0011%\ti\rAA\u0001\n\u0003\nymB\u0004\u0002T\u001eB\t!!6\u0007\r\u0019:\u0003\u0012AAl\u0011\u0019QF\u0004\"\u0001\u0002`\"I\u0011\u0011\u001d\u000fC\u0002\u0013\u0005\u0011\u0011\u0012\u0005\t\u0003Gd\u0002\u0015!\u0003\u0002\f\u001a1\u0011Q\u001d\u000f\u0001\u0003ODaA\u0017\u0011\u0005\u0002\t\u001d\u0001b\u0002B\u0007A\u0011\u0005#q\u0002\u0005\n\u0005/a\u0012\u0011!CA\u00053A\u0011B!\t\u001d\u0003\u0003%\tIa\t\t\u0013\tUB$!A\u0005\n\t]\"!\u0003-[eM\u001b\u0007.Z7f\u0015\tA\u0013&\u0001\u0006qCJ$\u0018\u000e^5p]NT!AK\u0016\u0002\r\r|W.\\8o\u0015\taS&A\u0004ti>\u0014\u0018mZ3\u000b\u00059z\u0013A\u00014t\u0015\t\u0001\u0014'A\u0004hK>lWm]1\u000b\u0005I\u001a\u0014\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u000194(\u0011\t\u0003qej\u0011aJ\u0005\u0003u\u001d\u0012Qb\u00159bi&\fGnU2iK6,\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003y\tK!aQ\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t\tLGo]\u000b\u0002\rB\u0011AhR\u0005\u0003\u0011v\u00121!\u00138u\u0003\u0015\u0011\u0017\u000e^:!\u0003\u00119Wm\\7\u0016\u00031\u0003\"!\u0014+\u000f\u00059\u0013\u0006CA(>\u001b\u0005\u0001&BA)6\u0003\u0019a$o\\8u}%\u00111+P\u0001\u0007!J,G-\u001a4\n\u0005U3&AB*ue&twM\u0003\u0002T{\u0005)q-Z8nA\u0005Iq-Z8n\u0013:$W\r_\u0001\u000bO\u0016|W.\u00138eKb\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003];z{\u0006C\u0001\u001d\u0001\u0011\u0015!u\u00011\u0001G\u0011\u0015Qu\u00011\u0001M\u0011\u0015Av\u00011\u0001G\u0003\rA(PM\u000b\u0002EB\u00111MZ\u0007\u0002I*\u0011QmL\u0001\u0006GV\u0014h/Z\u0005\u0003O\u0012\u0014a\u0001\u0017.3'\u001a\u001b\u0015\u0001\u0002={e\u0001\nq\u0001]1ui\u0016\u0014h.\u0001\thKR\u0004\u0016M\u001d;ji&|gNT1nKR\u0011A\n\u001c\u0005\u0006[.\u0001\rA\\\u0001\bM\u0016\fG/\u001e:f!\tyw/D\u0001q\u0015\t\t(/\u0001\u0004tS6\u0004H.\u001a\u0006\u0003[NT!\u0001^;\u0002\u0007\u0005\u0004\u0018N\u0003\u0002wg\u0005Aq-Z8u_>d7/\u0003\u0002ya\ni1+[7qY\u00164U-\u0019;ve\u0016\f\u0011cZ3u\u0007>4XM]5oO\u001aKG\u000e^3s)\rY\u00181\u0001\t\u0003y~l\u0011! \u0006\u0003}N\faAZ5mi\u0016\u0014\u0018bAA\u0001{\n1a)\u001b7uKJDa!!\u0002\r\u0001\u0004a\u0015!\u00039beRLG/[8o\u0003\u0019!\u0017nZ5ugR\u0019a)a\u0003\t\u000b\u0011k\u0001\u0019\u0001$\u0002\u001d\u001d,g.\u001a:bi\u0016\u0014\u0016M\\4fgR!\u0011\u0011CA&!\u0019\t\u0019\"!\b\u0002$9!\u0011QCA\r\u001d\ry\u0015qC\u0005\u0002}%\u0019\u00111D\u001f\u0002\u000fA\f7m[1hK&!\u0011qDA\u0011\u0005\r\u0019V-\u001d\u0006\u0004\u00037i\u0004\u0003BA\u0013\u0003\u000brA!a\n\u0002B9!\u0011\u0011FA\u001e\u001d\u0011\tY#a\u000e\u000f\t\u00055\u0012Q\u0007\b\u0005\u0003_\t\u0019DD\u0002P\u0003cI\u0011\u0001N\u0005\u0003eMJ!\u0001M\u0019\n\u0007\u0005er&\u0001\u0004{_J$WM]\u0005\u0005\u0003{\ty$A\u0004tM\u000e,(O^3\u000b\u0007\u0005er&\u0003\u0003\u0002\u001c\u0005\r#\u0002BA\u001f\u0003\u007fIA!a\u0012\u0002J\tQ\u0011J\u001c3fqJ\u000bgnZ3\u000b\t\u0005m\u00111\t\u0005\b\u0003\u001br\u0001\u0019AA(\u0003\tA\u0018\u0010\u0005\u0004\u0002\u0014\u0005u\u0011\u0011\u000b\t\fy\u0005M\u0013qKA,\u0003/\n9&C\u0002\u0002Vu\u0012a\u0001V;qY\u0016$\u0004c\u0001\u001f\u0002Z%\u0019\u00111L\u001f\u0003\r\u0011{WO\u00197f\u0003\u0011\u0019w\u000e]=\u0015\u000fq\u000b\t'a\u0019\u0002f!9Ai\u0004I\u0001\u0002\u00041\u0005b\u0002&\u0010!\u0003\u0005\r\u0001\u0014\u0005\b1>\u0001\n\u00111\u0001G\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001b+\u0007\u0019\u000big\u000b\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C;oG\",7m[3e\u0015\r\tI(P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a!+\u00071\u000bi'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\t\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\t1\fgn\u001a\u0006\u0003\u0003+\u000bAA[1wC&\u0019Q+a$\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qTAS!\ra\u0014\u0011U\u0005\u0004\u0003Gk$aA!os\"A\u0011qU\u000b\u0002\u0002\u0003\u0007a)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003[\u0003b!a,\u00026\u0006}UBAAY\u0015\r\t\u0019,P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\\\u0003c\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QXAb!\ra\u0014qX\u0005\u0004\u0003\u0003l$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003O;\u0012\u0011!a\u0001\u0003?\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\r\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\f\u00061Q-];bYN$B!!0\u0002R\"I\u0011q\u0015\u000e\u0002\u0002\u0003\u0007\u0011qT\u0001\n1j\u00134k\u00195f[\u0016\u0004\"\u0001\u000f\u000f\u0014\tq\tI.\u0011\t\u0004y\u0005m\u0017bAAo{\t1\u0011I\\=SK\u001a$\"!!6\u0002\t9\u000bW.Z\u0001\u0006\u001d\u0006lW\r\t\u0002\u001a1j\u0013\u0004+\u0019:uSRLwN\\*dQ\u0016lWMR1di>\u0014\u0018pE\u0002!\u0003S\u0004B!a;\u0003\u00029!\u0011Q^A\u007f\u001d\u0011\ty/a?\u000f\t\u0005E\u0018\u0011 \b\u0005\u0003g\f9P\u0004\u0003\u0002,\u0005U\u0018B\u0001\u00180\u0013\taS&\u0003\u0002+W%\u0011\u0001&K\u0005\u0004\u0003\u007f<\u0013!D*qCRL\u0017\r\\*dQ\u0016lW-\u0003\u0003\u0003\u0004\t\u0015!!H*qCRL\u0017\r\u001c)beRLG/[8o'\u000eDW-\\3GC\u000e$xN]=\u000b\u0007\u0005}x\u0005\u0006\u0002\u0003\nA\u0019!1\u0002\u0011\u000e\u0003q\tACY;jY\u0012\u0004\u0016M\u001d;ji&|gnU2iK6,GcB\u001c\u0003\u0012\tM!Q\u0003\u0005\u0006\t\n\u0002\rA\u0012\u0005\u0006\u0015\n\u0002\r\u0001\u0014\u0005\u00061\n\u0002\rAR\u0001\u0006CB\u0004H.\u001f\u000b\b9\nm!Q\u0004B\u0010\u0011\u0015!5\u00051\u0001G\u0011\u0015Q5\u00051\u0001M\u0011\u0015A6\u00051\u0001G\u0003\u001d)h.\u00199qYf$BA!\n\u00032A)AHa\n\u0003,%\u0019!\u0011F\u001f\u0003\r=\u0003H/[8o!\u0019a$Q\u0006$M\r&\u0019!qF\u001f\u0003\rQ+\b\u000f\\34\u0011!\u0011\u0019\u0004JA\u0001\u0002\u0004a\u0016a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011I\u0004\u0005\u0003\u0002\u000e\nm\u0012\u0002\u0002B\u001f\u0003\u001f\u0013aa\u00142kK\u000e$\b")
public class XZ2Scheme
extends SpatialScheme
implements Product,
Serializable {
    private final int bits;
    private final String geom;
    private final int geomIndex;
    private final XZ2SFC xz2;

    public static Option<Tuple3<Object, String, Object>> unapply(XZ2Scheme xZ2Scheme) {
        return XZ2Scheme$.MODULE$.unapply(xZ2Scheme);
    }

    public static XZ2Scheme apply(int n, String string, int n2) {
        return XZ2Scheme$.MODULE$.apply(n, string, n2);
    }

    public static String Name() {
        return XZ2Scheme$.MODULE$.Name();
    }

    public int bits() {
        return this.bits;
    }

    public String geom() {
        return this.geom;
    }

    public int geomIndex() {
        return this.geomIndex;
    }

    private XZ2SFC xz2() {
        return this.xz2;
    }

    public String pattern() {
        return new StringBuilder(8).append(this.bits()).append("-bit-xz2").toString();
    }

    public String getPartitionName(SimpleFeature feature) {
        Geometry geometry = (Geometry)feature.getAttribute(this.geom());
        Envelope envelope = geometry.getEnvelopeInternal();
        return Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToLong((long)this.xz2().index(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), this.xz2().index$default$5()))), this.format());
    }

    public Filter getCoveringFilter(String partition) {
        throw new UnsupportedOperationException("https://geomesa.atlassian.net/browse/GEOMESA-2967");
    }

    @Override
    public int digits(int bits) {
        return (int)package$.MODULE$.ceil((double)(bits / 2 + 1) * package$.MODULE$.log10(4.0) - package$.MODULE$.log10(3.0));
    }

    @Override
    public Seq<package.IndexRange> generateRanges(Seq<Tuple4<Object, Object, Object, Object>> xy) {
        return this.xz2().ranges(xy, this.xz2().ranges$default$2());
    }

    public XZ2Scheme copy(int bits, String geom, int geomIndex) {
        return new XZ2Scheme(bits, geom, geomIndex);
    }

    public int copy$default$1() {
        return this.bits();
    }

    public String copy$default$2() {
        return this.geom();
    }

    public int copy$default$3() {
        return this.geomIndex();
    }

    public String productPrefix() {
        return "XZ2Scheme";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.bits());
            }
            case 1: {
                return this.geom();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.geomIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XZ2Scheme;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.bits());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.geom()));
        n = Statics.mix((int)n, (int)this.geomIndex());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XZ2Scheme)) return false;
        boolean bl = true;
        if (!bl) return false;
        XZ2Scheme xZ2Scheme = (XZ2Scheme)x$1;
        if (this.bits() != xZ2Scheme.bits()) return false;
        String string = this.geom();
        String string2 = xZ2Scheme.geom();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.geomIndex() != xZ2Scheme.geomIndex()) return false;
        if (!xZ2Scheme.canEqual(this)) return false;
        return true;
    }

    public XZ2Scheme(int bits, String geom, int geomIndex) {
        this.bits = bits;
        this.geom = geom;
        this.geomIndex = geomIndex;
        super(bits, geom);
        Product.$init$((Product)this);
        this.xz2 = XZ2SFC$.MODULE$.apply((short)(bits / 2));
    }

    public static class XZ2PartitionSchemeFactory
    extends SpatialScheme.SpatialPartitionSchemeFactory {
        @Override
        public SpatialScheme buildPartitionScheme(int bits, String geom, int geomIndex) {
            return new XZ2Scheme(bits, geom, geomIndex);
        }

        public XZ2PartitionSchemeFactory() {
            super(XZ2Scheme$.MODULE$.Name());
        }
    }
}

