/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.converter;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0005\u000b\u0001]A\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0017\u0001\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015A\b\u0001\"\u0011z\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!!\b\u0001\t\u0013\tyBA\rD_:4XM\u001d;fe\u001aKG.Z*zgR,WNU3bI\u0016\u0014(BA\u0006\r\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u000e\u001d\u000591\u000f^8sC\u001e,'BA\b\u0011\u0003\t17O\u0003\u0002\u0012%\u00059q-Z8nKN\f'BA\n\u0015\u00031awnY1uS>tG/Z2i\u0015\u0005)\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u0019=Y\u0002\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u00104\u001d\t\u0001\u0003G\u0004\u0002\"]9\u0011!%\f\b\u0003G1r!\u0001J\u0016\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0017\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0004\b\n\u0005=b\u0011AB2p[6|g.\u0003\u00022e\u0005I\u0012IY:ue\u0006\u001cGOR5mKNK8\u000f^3n'R|'/Y4f\u0015\tyC\"\u0003\u00025k\t!b)\u001b7f'f\u001cH/Z7QCRD'+Z1eKJT!!\r\u001a\u0011\u0005]rT\"\u0001\u001d\u000b\u0005eR\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001e=\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001f\u0002\u0007\r|W.\u0003\u0002@q\ti1\u000b\u001e:jGRdunZ4j]\u001e\f!AZ2\u0011\u0005\tCU\"A\"\u000b\u0005=!%BA#G\u0003\u0019A\u0017\rZ8pa*\u0011q\tF\u0001\u0007CB\f7\r[3\n\u0005%\u001b%a\u0003$jY\u0016\u001cuN\u001c;fqR\u0004\"a\u0013(\u000e\u00031S!!\u0014\t\u0002\u0011\r|gN^3siJJ!a\u0014'\u0003-MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>tg/\u001a:uKJ\faAZ5mi\u0016\u0014\bcA\rS)&\u00111K\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005UKV\"\u0001,\u000b\u0005A;&B\u0001-\u0015\u0003\u001dy\u0007/\u001a8hSNL!A\u0017,\u0003\r\u0019KG\u000e^3s\u0003%!(/\u00198tM>\u0014X\u000eE\u0002\u001a%v\u0003B!\u00070aQ&\u0011qL\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0005,gB\u00012d!\t1#$\u0003\u0002e5\u00051\u0001K]3eK\u001aL!AZ4\u0003\rM#(/\u001b8h\u0015\t!'\u0004\u0005\u0002j]6\t!N\u0003\u0002lY\u000611/[7qY\u0016T!!\\,\u0002\u000f\u0019,\u0017\r^;sK&\u0011qN\u001b\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017A\u0002\u001fj]&$h\bF\u0003siV4x\u000f\u0005\u0002t\u00015\t!\u0002C\u0003A\u000b\u0001\u0007\u0011\tC\u0003\f\u000b\u0001\u0007!\nC\u0003Q\u000b\u0001\u0007\u0011\u000bC\u0003\\\u000b\u0001\u0007A,\u0001\u0003sK\u0006$Gc\u0001>\u0002\fA)10!\u0001\u0002\u00065\tAP\u0003\u0002~}\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005}\u0004\u0012!B;uS2\u001c\u0018bAA\u0002y\n\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u0007%\f9!C\u0002\u0002\n)\u0014QbU5na2,g)Z1ukJ,\u0007bBA\u0007\r\u0001\u0007\u0011qB\u0001\u0005a\u0006$\b\u000eE\u0002C\u0003#I1!a\u0005D\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0011\u0019LG\u000e^3sK\u0012$2A_A\r\u0011\u0019\tYb\u0002a\u0001u\u0006\u0011\u0011N\\\u0001\fiJ\fgn\u001d4pe6,G\rF\u0002{\u0003CAa!a\u0007\t\u0001\u0004Q\b")
public class ConverterFileSystemReader
implements AbstractFileSystemStorage.FileSystemPathReader,
StrictLogging {
    private final FileContext fc;
    private final SimpleFeatureConverter converter;
    private final Option<Filter> filter;
    private final Option<Tuple2<String, SimpleFeatureType>> transform;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public CloseableIterator<SimpleFeature> read(Path path) {
        CloseableIterator closeableIterator;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Opening file {}", new Object[]{path});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            closeableIterator = this.converter.process((InputStream)this.fc.open(path), this.converter.process$default$2());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit2;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(23).append("Error processing uri '").append(path).append("'").toString(), e);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                closeableIterator = CloseableIterator$.MODULE$.empty();
            }
            throw throwable;
        }
        CloseableIterator iter = closeableIterator;
        return this.transformed(this.filtered((CloseableIterator<SimpleFeature>)iter));
    }

    private CloseableIterator<SimpleFeature> filtered(CloseableIterator<SimpleFeature> in) {
        Option<Filter> option = this.filter;
        if (None$.MODULE$.equals(option)) {
            return in;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Filter f = (Filter)some.value();
            return in.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)f.evaluate(x$1)));
        }
        throw new MatchError(option);
    }

    private CloseableIterator<SimpleFeature> transformed(CloseableIterator<SimpleFeature> in) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, SimpleFeatureType>> option = this.transform;
        if (None$.MODULE$.equals(option)) {
            return in;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String tdefs = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            TransformSimpleFeature feature = TransformSimpleFeature$.MODULE$.apply(this.converter.targetSft(), tsft, tdefs);
            return in.map((Function1 & Serializable & scala.Serializable)f -> ScalaSimpleFeature$.MODULE$.copy((SimpleFeature)feature.setFeature(f)));
        }
        throw new MatchError(option);
    }

    public ConverterFileSystemReader(FileContext fc, SimpleFeatureConverter converter, Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        this.fc = fc;
        this.converter = converter;
        this.filter = filter;
        this.transform = transform;
        StrictLogging.$init$((StrictLogging)this);
    }
}

