/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.converter;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.hadoop.HadoopDelegate;
import org.locationtech.geomesa.utils.io.PathUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0005\u000b\u0001]A\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u0017\u0001\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!!\t\u0001\t\u0013\t\u0019CA\rD_:4XM\u001d;fe\u001aKG.Z*zgR,WNU3bI\u0016\u0014(BA\u0006\r\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u000e\u001d\u000591\u000f^8sC\u001e,'BA\b\u0011\u0003\t17O\u0003\u0002\u0012%\u00059q-Z8nKN\f'BA\n\u0015\u00031awnY1uS>tG/Z2i\u0015\u0005)\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u0019=Y\u0002\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u00104\u001d\t\u0001\u0003G\u0004\u0002\"]9\u0011!%\f\b\u0003G1r!\u0001J\u0016\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0017\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0004\b\n\u0005=b\u0011AB2p[6|g.\u0003\u00022e\u0005I\u0012IY:ue\u0006\u001cGOR5mKNK8\u000f^3n'R|'/Y4f\u0015\tyC\"\u0003\u00025k\t!b)\u001b7f'f\u001cH/Z7QCRD'+Z1eKJT!!\r\u001a\u0011\u0005]rT\"\u0001\u001d\u000b\u0005eR\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001e=\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001f\u0002\u0007\r|W.\u0003\u0002@q\ti1\u000b\u001e:jGRdunZ4j]\u001e\f!AZ2\u0011\u0005\tCU\"A\"\u000b\u0005=!%BA#G\u0003\u0019A\u0017\rZ8pa*\u0011q\tF\u0001\u0007CB\f7\r[3\n\u0005%\u001b%a\u0003$jY\u0016\u001cuN\u001c;fqR\u0004\"a\u0013(\u000e\u00031S!!\u0014\t\u0002\u0011\r|gN^3siJJ!a\u0014'\u0003-MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>tg/\u001a:uKJ\faAZ5mi\u0016\u0014\bcA\rS)&\u00111K\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005U[V\"\u0001,\u000b\u0005A;&B\u0001-Z\u0003\r\t\u0007/\u001b\u0006\u00035R\t\u0001bZ3pi>|Gn]\u0005\u00039Z\u0013aAR5mi\u0016\u0014\u0018!\u0003;sC:\u001chm\u001c:n!\rI\"k\u0018\t\u00053\u0001\u0014'.\u0003\u0002b5\t1A+\u001e9mKJ\u0002\"aY4\u000f\u0005\u0011,\u0007C\u0001\u0014\u001b\u0013\t1'$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014\u001b!\tY\u0007/D\u0001m\u0015\tig.\u0001\u0004tS6\u0004H.\u001a\u0006\u0003_^\u000bqAZ3biV\u0014X-\u0003\u0002rY\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0002\rqJg.\u001b;?)\u0015!ho\u001e=z!\t)\b!D\u0001\u000b\u0011\u0015\u0001U\u00011\u0001B\u0011\u0015YQ\u00011\u0001K\u0011\u0015\u0001V\u00011\u0001R\u0011\u0015iV\u00011\u0001_\u0003\u0011\u0011X-\u00193\u0015\u0007q\fy\u0001E\u0003~\u0003\u000b\tI!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u000bG>dG.Z2uS>t'bAA\u0002!\u0005)Q\u000f^5mg&\u0019\u0011q\u0001@\u0003#\rcwn]3bE2,\u0017\n^3sCR|'\u000fE\u0002l\u0003\u0017I1!!\u0004m\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"9\u0011\u0011\u0003\u0004A\u0002\u0005M\u0011\u0001\u00029bi\"\u00042AQA\u000b\u0013\r\t9b\u0011\u0002\u0005!\u0006$\b.\u0001\u0005gS2$XM]3e)\ra\u0018Q\u0004\u0005\u0007\u0003?9\u0001\u0019\u0001?\u0002\u0005%t\u0017a\u0003;sC:\u001chm\u001c:nK\u0012$2\u0001`A\u0013\u0011\u0019\ty\u0002\u0003a\u0001y\u0002")
public class ConverterFileSystemReader
implements AbstractFileSystemStorage.FileSystemPathReader,
StrictLogging {
    private final FileContext fc;
    private final SimpleFeatureConverter converter;
    private final Option<Filter> filter;
    private final Option<Tuple2<String, SimpleFeatureType>> transform;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public CloseableIterator<SimpleFeature> read(Path path) {
        CloseableIterator closeableIterator;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Opening file {}", new Object[]{path});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            String string = PathUtils$.MODULE$.getUncompressedExtension(path.getName()).toLowerCase(Locale.US);
            HadoopDelegate.HadoopTarHandle handle = "tar".equals(string) ? new HadoopDelegate.HadoopTarHandle(this.fc, path) : (("zip".equals(string) ? true : "jar".equals(string)) ? new HadoopDelegate.HadoopZipHandle(this.fc, path) : new HadoopDelegate.HadoopFileHandle(this.fc, path));
            closeableIterator = handle.open().flatMap(arg_0 -> ConverterFileSystemReader.$anonfun$read$1(this, (HadoopDelegate.HadoopFileHandle)handle, arg_0));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit2;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(23).append("Error processing uri '").append(path).append("'").toString(), e);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                closeableIterator = CloseableIterator$.MODULE$.empty();
            }
            throw throwable;
        }
        CloseableIterator iter = closeableIterator;
        return this.transformed(this.filtered((CloseableIterator<SimpleFeature>)iter));
    }

    private CloseableIterator<SimpleFeature> filtered(CloseableIterator<SimpleFeature> in) {
        Option<Filter> option = this.filter;
        if (None$.MODULE$.equals(option)) {
            return in;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Filter f = (Filter)some.value();
            return in.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)f.evaluate(x$1)));
        }
        throw new MatchError(option);
    }

    private CloseableIterator<SimpleFeature> transformed(CloseableIterator<SimpleFeature> in) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, SimpleFeatureType>> option = this.transform;
        if (None$.MODULE$.equals(option)) {
            return in;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String tdefs = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            TransformSimpleFeature feature = TransformSimpleFeature$.MODULE$.apply(this.converter.targetSft(), tsft, tdefs);
            return in.map((Function1 & Serializable & scala.Serializable)f -> ScalaSimpleFeature$.MODULE$.copy((SimpleFeature)feature.setFeature(f)));
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ CloseableIterator $anonfun$read$1(ConverterFileSystemReader $this, HadoopDelegate.HadoopFileHandle handle$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option name = (Option)tuple2._1();
            InputStream is = (InputStream)tuple2._2();
            Map params = EvaluationContext$.MODULE$.inputFileParam((String)name.getOrElse((Function0 & Serializable & scala.Serializable)() -> handle$1.path()));
            return $this.converter.process(is, $this.converter.createEvaluationContext(params));
        }
        throw new MatchError((Object)tuple2);
    }

    public ConverterFileSystemReader(FileContext fc, SimpleFeatureConverter converter, Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        this.fc = fc;
        this.converter = converter;
        this.filter = filter;
        this.transform = transform;
        StrictLogging.$init$((StrictLogging)this);
    }
}

