/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.converter;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.api.PartitionSchemeFactory$;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadataFactory;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.converter.ConverterMetadata;
import org.locationtech.geomesa.fs.storage.converter.ConverterStorage$;
import org.locationtech.geomesa.fs.storage.converter.ConverterStorageFactory$;
import org.locationtech.geomesa.utils.geotools.SftArgResolver$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0002\u0004\u0001'!)!\u0006\u0001C\u0001W!)a\u0006\u0001C!_!)1\b\u0001C!y!)\u0001\f\u0001C!3\nA2i\u001c8wKJ$XM]'fi\u0006$\u0017\r^1GC\u000e$xN]=\u000b\u0005\u001dA\u0011!C2p]Z,'\u000f^3s\u0015\tI!\"A\u0004ti>\u0014\u0018mZ3\u000b\u0005-a\u0011A\u00014t\u0015\tia\"A\u0004hK>lWm]1\u000b\u0005=\u0001\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!\"\u0004\t\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011aA1qS&\u0011q\u0004\b\u0002\u0017'R|'/Y4f\u001b\u0016$\u0018\rZ1uC\u001a\u000b7\r^8ssB\u0011\u0011\u0005K\u0007\u0002E)\u00111\u0005J\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003K\u0019\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002O\u0005\u00191m\\7\n\u0005%\u0012#a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u0017\u0011\u00055\u0002Q\"\u0001\u0004\u0002\t9\fW.Z\u000b\u0002aA\u0011\u0011\u0007\u000f\b\u0003eY\u0002\"a\r\f\u000e\u0003QR!!\u000e\n\u0002\rq\u0012xn\u001c;?\u0013\t9d#\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c\u0017\u0003\u0011aw.\u00193\u0015\u0005u\u001a\u0005cA\u000b?\u0001&\u0011qH\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005m\t\u0015B\u0001\"\u001d\u0005=\u0019Fo\u001c:bO\u0016lU\r^1eCR\f\u0007\"\u0002#\u0004\u0001\u0004)\u0015aB2p]R,\u0007\u0010\u001e\t\u0003\rVs!aR*\u000f\u0005!\u0013fBA%R\u001d\tQ\u0005K\u0004\u0002L\u001f:\u0011AJ\u0014\b\u0003g5K\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\ti\u0002\"\u0003\u0002U9\u00059\u0001/Y2lC\u001e,\u0017B\u0001,X\u0005E1\u0015\u000e\\3TsN$X-\\\"p]R,\u0007\u0010\u001e\u0006\u0003)r\taa\u0019:fCR,G\u0003\u0002![7\u0002DQ\u0001\u0012\u0003A\u0002\u0015CQ\u0001\u0018\u0003A\u0002u\u000baaY8oM&<\u0007\u0003B\u0019_aAJ!a\u0018\u001e\u0003\u00075\u000b\u0007\u000fC\u0003b\t\u0001\u0007!-\u0001\u0003nKR\f\u0007C\u0001$d\u0013\t!wK\u0001\u0005NKR\fG-\u0019;b\u0001")
public class ConverterMetadataFactory
implements StorageMetadataFactory,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ConverterMetadataFactory converterMetadataFactory = this;
        synchronized (converterMetadataFactory) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String name() {
        return ConverterStorage$.MODULE$.Encoding();
    }

    public Option<StorageMetadata> load(package.FileSystemContext context) {
        None$ none$;
        if (!Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.ConverterPathParam())).contains((Object)context.root().getName())) {
            return None$.MODULE$;
        }
        try {
            String sftArg = (String)Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.SftConfigParam())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.SftNameParam()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("Must provide either simple feature type config or name");
            });
            Either either = SftArgResolver$.MODULE$.getArg((Object)new SftArgs(sftArg, null));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                throw new IllegalArgumentException("Could not load SimpleFeatureType with provided parameters", e);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            SimpleFeatureType schema = (SimpleFeatureType)right.value();
            SimpleFeatureType sft = schema;
            Map partitionSchemeOpts = (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(context.conf().getValByRegex(new StringBuilder(2).append(Pattern.quote(ConverterStorageFactory$.MODULE$.PartitionOptsPrefix())).append(".*").toString())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.substring(ConverterStorageFactory$.MODULE$.PartitionOptsPrefix().length())), (Object)v);
                }
                throw new MatchError((Object)tuple2);
            }, Map$.MODULE$.canBuildFrom());
            String partitionSchemeName = (String)Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.PartitionSchemeParam())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("Must provide partition scheme name");
            });
            PartitionScheme scheme = PartitionSchemeFactory$.MODULE$.load(sft, new package.NamedOptions(partitionSchemeName, partitionSchemeOpts.toMap(Predef$.MODULE$.$conforms())));
            boolean leafStorage = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.LeafStorageParam())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConverterMetadataFactory.$anonfun$load$5(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                Option deprecated = partitionSchemeOpts.get((Object)"leaf-storage").map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConverterMetadataFactory.$anonfun$load$7(this, s)));
                return BoxesRunTime.unboxToBoolean((Object)deprecated.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
            }));
            none$ = new Some((Object)new ConverterMetadata(context, sft, scheme, leafStorage));
        }
        catch (IllegalArgumentException e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(44).append("Couldn't create converter storage metadata: ").append(e).toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public StorageMetadata create(package.FileSystemContext context, scala.collection.immutable.Map<String, String> config, package.Metadata meta) {
        throw new NotImplementedError("Converter storage is read only");
    }

    public static final /* synthetic */ boolean $anonfun$load$5(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$load$7(ConverterMetadataFactory $this, String s) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isWarnEnabled()) {
            $this.logger().underlying().warn(new StringBuilder(90).append("Using deprecated leaf-storage partition-scheme option. Please define leaf-storage using ").append("'").append(ConverterStorageFactory$.MODULE$.LeafStorageParam()).append("'").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).toBoolean();
    }

    public ConverterMetadataFactory() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

