/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.converter.pathfilter;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.PathFilter;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.converter.pathfilter.DtgPathFiltering$;
import org.locationtech.geomesa.fs.storage.converter.pathfilter.DtgPathFiltering$Config$;
import org.locationtech.geomesa.fs.storage.converter.pathfilter.PathFiltering;
import org.locationtech.geomesa.fs.storage.converter.pathfilter.PathFilteringFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001\u0002\u000f\u001e\u00011B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!!\b\u0001\t\u0003\nybB\u0004\u0002\"uA\t!a\t\u0007\rqi\u0002\u0012AA\u0013\u0011\u0019I'\u0002\"\u0001\u0002(!I\u0011\u0011\u0006\u0006C\u0002\u0013\u0005\u00111\u0006\u0005\t\u0003oQ\u0001\u0015!\u0003\u0002.\u001d9\u0011\u0011\b\u0006\t\u0002\u0005mbaBA \u0015!\u0005\u0011\u0011\t\u0005\u0007S>!\t!a\u0011\t\u0013\u0005\u0015sB1A\u0005\u0002\u0005-\u0002\u0002CA$\u001f\u0001\u0006I!!\f\t\u0013\u0005%sB1A\u0005\u0002\u0005-\u0002\u0002CA&\u001f\u0001\u0006I!!\f\t\u0013\u00055sB1A\u0005\u0002\u0005-\u0002\u0002CA(\u001f\u0001\u0006I!!\f\t\u0013\u0005EsB1A\u0005\u0002\u0005-\u0002\u0002CA*\u001f\u0001\u0006I!!\f\u0007\r\u0005U#\u0002AA,\u0011\u0019I\u0017\u0004\"\u0001\u0002`!9\u00111M\r\u0005B\u0005\u0015$\u0001\u0005#uOB\u000bG\u000f\u001b$jYR,'/\u001b8h\u0015\tqr$\u0001\u0006qCRDg-\u001b7uKJT!\u0001I\u0011\u0002\u0013\r|gN^3si\u0016\u0014(B\u0001\u0012$\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001J\u0013\u0002\u0005\u0019\u001c(B\u0001\u0014(\u0003\u001d9Wm\\7fg\u0006T!\u0001K\u0015\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00174oA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001b\u000e\u0003uI!AN\u000f\u0003\u001bA\u000bG\u000f\u001b$jYR,'/\u001b8h!\tAt(D\u0001:\u0015\tQ4(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002={\u0005AA/\u001f9fg\u00064WMC\u0001?\u0003\r\u0019w.\\\u0005\u0003\u0001f\u00121\u0002T1{s2{wmZ5oO\u0006I\u0011\r\u001e;sS\n,H/\u001a\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015{S\"\u0001$\u000b\u0005\u001d[\u0013A\u0002\u001fs_>$h(\u0003\u0002J_\u00051\u0001K]3eK\u001aL!a\u0013'\u0003\rM#(/\u001b8h\u0015\tIu&A\u0004qCR$XM\u001d8\u0011\u0005=3V\"\u0001)\u000b\u0005E\u0013\u0016!\u0002:fO\u0016D(BA*U\u0003\u0011)H/\u001b7\u000b\u0003U\u000bAA[1wC&\u0011q\u000b\u0015\u0002\b!\u0006$H/\u001a:o\u0003\u00191wN]7biB\u0011!LX\u0007\u00027*\u0011\u0001\f\u0018\u0006\u0003;R\u000bA\u0001^5nK&\u0011ql\u0017\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\u0018A\u00022vM\u001a,'\u000f\u0005\u0002cO6\t1M\u0003\u0002eK\u0006AA-\u001e:bi&|gN\u0003\u0002g_\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005!\u001c'\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0015YG.\u001c8p!\t!\u0004\u0001C\u0003B\u000b\u0001\u0007!\tC\u0003N\u000b\u0001\u0007a\nC\u0003Y\u000b\u0001\u0007\u0011\fC\u0003a\u000b\u0001\u0007\u0011-A\u0003baBd\u0017\u0010\u0006\u0002swB\u00111/_\u0007\u0002i*\u0011A%\u001e\u0006\u0003m^\fa\u0001[1e_>\u0004(B\u0001=*\u0003\u0019\t\u0007/Y2iK&\u0011!\u0010\u001e\u0002\u000b!\u0006$\bNR5mi\u0016\u0014\b\"\u0002?\u0007\u0001\u0004i\u0018A\u00024jYR,'\u000fE\u0002\u007f\u0003\u0013i\u0011a \u0006\u0004y\u0006\u0005!\u0002BA\u0002\u0003\u000b\t1!\u00199j\u0015\r\t9!K\u0001\tO\u0016|Go\\8mg&\u0019\u00111B@\u0003\r\u0019KG\u000e^3s\u0003!\u0001\u0018M]:f\tR<G\u0003BA\t\u00033\u0001B!a\u0005\u0002\u00165\tA,C\u0002\u0002\u0018q\u0013QBW8oK\u0012$\u0015\r^3US6,\u0007BBA\u000e\u000f\u0001\u0007!)\u0001\u0003oC6,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\t\u000b\u0001\u0003\u0012;h!\u0006$\bNR5mi\u0016\u0014\u0018N\\4\u0011\u0005QR1c\u0001\u0006.oQ\u0011\u00111E\u0001\u0005\u001d\u0006lW-\u0006\u0002\u0002.A!\u0011qFA\u001b\u001b\t\t\tDC\u0002\u00024Q\u000bA\u0001\\1oO&\u00191*!\r\u0002\u000b9\u000bW.\u001a\u0011\u0002\r\r{gNZ5h!\r\tidD\u0007\u0002\u0015\t11i\u001c8gS\u001e\u001c\"aD\u0017\u0015\u0005\u0005m\u0012!C!uiJL'-\u001e;f\u0003)\tE\u000f\u001e:jEV$X\rI\u0001\b!\u0006$H/\u001a:o\u0003!\u0001\u0016\r\u001e;fe:\u0004\u0013A\u0002$pe6\fG/A\u0004G_Jl\u0017\r\u001e\u0011\u0002\r\t+hMZ3s\u0003\u001d\u0011UO\u001a4fe\u0002\u0012q\u0003\u0012;h!\u0006$\bNR5mi\u0016\u0014\u0018N\\4GC\u000e$xN]=\u0014\tei\u0013\u0011\f\t\u0004i\u0005m\u0013bAA/;\t!\u0002+\u0019;i\r&dG/\u001a:j]\u001e4\u0015m\u0019;pef$\"!!\u0019\u0011\u0007\u0005u\u0012$\u0001\u0003m_\u0006$G\u0003BA4\u0003[\u0002BALA5g%\u0019\u00111N\u0018\u0003\r=\u0003H/[8o\u0011\u001d\tyg\u0007a\u0001\u0003c\naaY8oM&<\u0007\u0003BA:\u0003'sA!!\u001e\u0002\u000e:!\u0011qOAF\u001d\u0011\tI(!#\u000f\t\u0005m\u0014q\u0011\b\u0005\u0003{\n)I\u0004\u0003\u0002\u0000\u0005\rebA#\u0002\u0002&\t!&\u0003\u0002)S%\u0011aeJ\u0005\u0003I\u0015J!AI\u0012\n\u0007\u0005\r\u0011%\u0003\u0003\u0002\u0010\u0006E\u0015a\u00029bG.\fw-\u001a\u0006\u0004\u0003\u0007\t\u0013\u0002BAK\u0003/\u0013ABT1nK\u0012|\u0005\u000f^5p]NTA!a$\u0002\u0012\u0002")
public class DtgPathFiltering
implements PathFiltering,
LazyLogging {
    private final String attribute;
    private final Pattern pattern;
    private final DateTimeFormatter format;
    private final Duration buffer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String Name() {
        return DtgPathFiltering$.MODULE$.Name();
    }

    private Logger logger$lzycompute() {
        DtgPathFiltering dtgPathFiltering = this;
        synchronized (dtgPathFiltering) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public PathFilter apply(Filter filter) {
        Filter x$1 = filter;
        String x$2 = this.attribute;
        boolean x$3 = true;
        boolean x$4 = FilterHelper$.MODULE$.extractIntervals$default$3();
        FilterValues filterIntervals = FilterHelper$.MODULE$.extractIntervals(x$1, x$2, x$4, x$3);
        return path -> {
            boolean bl;
            try {
                BoxedUnit boxedUnit;
                Instant time = this.parseDtg(path.getName()).toInstant();
                long millis = $this.buffer.toMillis();
                ZonedDateTime lower = ZonedDateTime.ofInstant(time.minusMillis(millis), ZoneOffset.UTC);
                ZonedDateTime upper = ZonedDateTime.ofInstant(time.plusMillis(millis), ZoneOffset.UTC);
                Bounds buffered = new Bounds(Bounds.Bound$.MODULE$.inclusive((Object)lower), Bounds.Bound$.MODULE$.inclusive((Object)upper));
                boolean included = filterIntervals.exists((Function1 & Serializable & scala.Serializable)bounds -> BoxesRunTime.boxToBoolean((boolean)bounds.intersects(buffered)));
                if (this.logger().underlying().isDebugEnabled()) {
                    if (included) {
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Including path {} for filter {}", new Object[]{path.getName(), filter});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Excluding path {} for filter {}", new Object[]{path.getName(), filter});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = included;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable ex = (Throwable)option.get();
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(37).append("Failed to evaluate filter for path '").append(path.getName()).append("'").toString(), ex);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    bl = true;
                }
                throw throwable;
            }
            return bl;
        };
    }

    private ZonedDateTime parseDtg(String name) {
        return (ZonedDateTime)Option$.MODULE$.apply((Object)name).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.pattern.matcher((CharSequence)x$1)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DtgPathFiltering.$anonfun$parseDtg$3(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.group(1)).map((Function1 & Serializable & scala.Serializable)x$4 -> ZonedDateTime.parse(x$4, $this.format)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(63).append("Failed to parse ").append(ZonedDateTime.class.getName()).append(" ").append("from file name '").append(name).append("' for pattern '").append($this.pattern).append("' and format '").append($this.format).append("'").toString());
        });
    }

    public String toString() {
        return new StringBuilder(48).append(this.getClass().getName()).append("(attribute = ").append(this.attribute).append(", pattern = ").append(this.pattern).append(", format = ").append(this.format).append(", buffer = ").append(this.buffer).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$parseDtg$3(Matcher x$2) {
        return x$2.groupCount() > 0;
    }

    public DtgPathFiltering(String attribute, Pattern pattern, DateTimeFormatter format, Duration buffer) {
        this.attribute = attribute;
        this.pattern = pattern;
        this.format = format;
        this.buffer = buffer;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class DtgPathFilteringFactory
    implements PathFilteringFactory {
        @Override
        public Option<PathFiltering> load(package.NamedOptions config) {
            BoxedUnit boxedUnit;
            String string = config.name();
            String string2 = DtgPathFiltering$.MODULE$.Name();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return None$.MODULE$;
            }
            String attribute = (String)config.options().getOrElse((Object)DtgPathFiltering$Config$.MODULE$.Attribute(), (Function0 & Serializable & scala.Serializable)() -> null);
            Predef$.MODULE$.require(attribute != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append(DtgPathFiltering$.MODULE$.Name()).append(" path filter requires a dtg attribute config '").append(DtgPathFiltering$Config$.MODULE$.Attribute()).append("'").toString());
            String patternConfig = (String)config.options().getOrElse((Object)DtgPathFiltering$Config$.MODULE$.Pattern(), (Function0 & Serializable & scala.Serializable)() -> null);
            Predef$.MODULE$.require(patternConfig != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append(DtgPathFiltering$.MODULE$.Name()).append(" path filter requires a dtg pattern config '").append(DtgPathFiltering$Config$.MODULE$.Pattern()).append("'").toString());
            String formatConfig = (String)config.options().getOrElse((Object)DtgPathFiltering$Config$.MODULE$.Format(), (Function0 & Serializable & scala.Serializable)() -> null);
            Predef$.MODULE$.require(formatConfig != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append(DtgPathFiltering$.MODULE$.Name()).append(" path filter requires a dtg format config '").append(DtgPathFiltering$Config$.MODULE$.Format()).append("'").toString());
            String bufferConfig = (String)config.options().getOrElse((Object)DtgPathFiltering$Config$.MODULE$.Buffer(), (Function0 & Serializable & scala.Serializable)() -> null);
            Predef$.MODULE$.require(bufferConfig != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append(DtgPathFiltering$.MODULE$.Name()).append(" path filter requires a buffer duration config '").append(DtgPathFiltering$Config$.MODULE$.Buffer()).append("'").toString());
            Pattern pattern = Pattern.compile(patternConfig);
            DateTimeFormatter format = DateTimeFormatter.ofPattern(formatConfig).withZone(ZoneOffset.UTC);
            Duration buffer = Duration$.MODULE$.apply(bufferConfig);
            DtgPathFiltering pathFiltering = new DtgPathFiltering(attribute, pattern, format, buffer);
            if (DtgPathFiltering$.MODULE$.logger().underlying().isInfoEnabled()) {
                DtgPathFiltering$.MODULE$.logger().underlying().info("Loaded PathFiltering: {}", new Object[]{pathFiltering});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Some((Object)pathFiltering);
        }
    }
}

