/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.converter;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.converter.pathfilter.PathFiltering;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.hadoop.HadoopDelegate;
import org.locationtech.geomesa.utils.io.PathUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0006\r\u0001eA\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u001b\u0001\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\bA!A!\u0002\u0013!\b\"B>\u0001\t\u0003a\bBCA\u0005\u0001!\u0015\r\u0011\"\u0003\u0002\f!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0005e\u0019uN\u001c<feR,'OR5mKNK8\u000f^3n%\u0016\fG-\u001a:\u000b\u00055q\u0011!C2p]Z,'\u000f^3s\u0015\ty\u0001#A\u0004ti>\u0014\u0018mZ3\u000b\u0005E\u0011\u0012A\u00014t\u0015\t\u0019B#A\u0004hK>lWm]1\u000b\u0005U1\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Q\u0002\u0005\u000f\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005*dB\u0001\u00123\u001d\t\u0019\u0003G\u0004\u0002%_9\u0011QE\f\b\u0003M5r!a\n\u0017\u000f\u0005!ZS\"A\u0015\u000b\u0005)B\u0012A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t)b#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI!!\r\b\u0002\r\r|W.\\8o\u0013\t\u0019D'A\rBEN$(/Y2u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,'BA\u0019\u000f\u0013\t1tG\u0001\u000bGS2,7+_:uK6\u0004\u0016\r\u001e5SK\u0006$WM\u001d\u0006\u0003gQ\u0002\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005ur\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003}\n1aY8n\u0013\t\t%HA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\t\u0003\u0007&k\u0011\u0001\u0012\u0006\u0003#\u0015S!AR$\u0002\r!\fGm\\8q\u0015\tAe#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0015\u0012\u0013!BR5mKNK8\u000f^3n!\tau*D\u0001N\u0015\tq%#\u0001\u0005d_:4XM\u001d;3\u0013\t\u0001VJ\u0001\fTS6\u0004H.\u001a$fCR,(/Z\"p]Z,'\u000f^3s\u0003\u00191\u0017\u000e\u001c;feB\u00191dU+\n\u0005Qc\"AB(qi&|g\u000e\u0005\u0002W96\tqK\u0003\u0002R1*\u0011\u0011LW\u0001\u0004CBL'BA.\u0017\u0003!9Wm\u001c;p_2\u001c\u0018BA/X\u0005\u00191\u0015\u000e\u001c;fe\u0006IAO]1og\u001a|'/\u001c\t\u00047M\u0003\u0007\u0003B\u000ebG.L!A\u0019\u000f\u0003\rQ+\b\u000f\\33!\t!\u0007N\u0004\u0002fMB\u0011\u0001\u0006H\u0005\u0003Or\ta\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011q\r\b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\faa]5na2,'B\u00019Y\u0003\u001d1W-\u0019;ve\u0016L!A]7\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-A\u0007qCRDg)\u001b7uKJLgn\u001a\t\u00047M+\bC\u0001<z\u001b\u00059(B\u0001=\r\u0003)\u0001\u0018\r\u001e5gS2$XM]\u0005\u0003u^\u0014Q\u0002U1uQ\u001aKG\u000e^3sS:<\u0017A\u0002\u001fj]&$h\b\u0006\u0006~\u007f\u0006\u0005\u00111AA\u0003\u0003\u000f\u0001\"A \u0001\u000e\u00031AQ!\u0005\u0004A\u0002\tCQ!\u0004\u0004A\u0002-CQ!\u0015\u0004A\u0002ICQA\u0018\u0004A\u0002}CQa\u001d\u0004A\u0002Q\f!\u0002]1uQ\u001aKG\u000e^3s+\t\ti\u0001\u0005\u0003\u001c'\u0006=\u0001cA\"\u0002\u0012%\u0019\u00111\u0003#\u0003\u0015A\u000bG\u000f\u001b$jYR,'/\u0001\u0003sK\u0006$G\u0003BA\r\u0003_\u0001b!a\u0007\u0002&\u0005%RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0015\r|G\u000e\\3di&|gNC\u0002\u0002$I\tQ!\u001e;jYNLA!a\n\u0002\u001e\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u00071\fY#C\u0002\u0002.5\u0014QbU5na2,g)Z1ukJ,\u0007bBA\u0019\u0011\u0001\u0007\u00111G\u0001\u0005a\u0006$\b\u000eE\u0002D\u0003kI1!a\u000eE\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0011\u0019LG\u000e^3sK\u0012$B!!\u0007\u0002>!9\u0011qH\u0005A\u0002\u0005e\u0011AA5o\u0003-!(/\u00198tM>\u0014X.\u001a3\u0015\t\u0005e\u0011Q\t\u0005\b\u0003\u007fQ\u0001\u0019AA\r\u0001")
public class ConverterFileSystemReader
implements AbstractFileSystemStorage.FileSystemPathReader,
StrictLogging {
    private Option<PathFilter> pathFilter;
    private final FileSystem fs;
    private final SimpleFeatureConverter converter;
    private final Option<Filter> filter;
    private final Option<Tuple2<String, SimpleFeatureType>> transform;
    private Option<PathFiltering> pathFiltering;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Option<PathFilter> pathFilter$lzycompute() {
        ConverterFileSystemReader converterFileSystemReader = this;
        synchronized (converterFileSystemReader) {
            if (!this.bitmap$0) {
                this.pathFilter = this.pathFiltering.flatMap((Function1 & Serializable & scala.Serializable)pf -> $this.filter.map((Function1 & Serializable & scala.Serializable)filter -> pf.apply((Filter)filter)));
                this.bitmap$0 = true;
            }
        }
        this.pathFiltering = null;
        return this.pathFilter;
    }

    private Option<PathFilter> pathFilter() {
        if (!this.bitmap$0) {
            return this.pathFilter$lzycompute();
        }
        return this.pathFilter;
    }

    public CloseableIterator<SimpleFeature> read(Path path) {
        if (this.pathFilter().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accept(path)))) {
            CloseableIterator closeableIterator;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Opening file {}", new Object[]{path});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            try {
                String string = PathUtils$.MODULE$.getUncompressedExtension(path.getName()).toLowerCase(Locale.US);
                HadoopDelegate.HadoopTarHandle handle = "tar".equals(string) ? new HadoopDelegate.HadoopTarHandle(this.fs, path) : (("zip".equals(string) ? true : "jar".equals(string)) ? new HadoopDelegate.HadoopZipHandle(this.fs, path) : new HadoopDelegate.HadoopFileHandle(this.fs, path));
                closeableIterator = handle.open().flatMap(arg_0 -> ConverterFileSystemReader.$anonfun$read$2(this, (HadoopDelegate.HadoopFileHandle)handle, arg_0));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit2;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(23).append("Error processing uri '").append(path).append("'").toString(), e);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    closeableIterator = CloseableIterator$.MODULE$.empty();
                }
                throw throwable;
            }
            CloseableIterator iter = closeableIterator;
            return this.transformed(this.filtered((CloseableIterator<SimpleFeature>)iter));
        }
        return CloseableIterator$.MODULE$.empty();
    }

    private CloseableIterator<SimpleFeature> filtered(CloseableIterator<SimpleFeature> in) {
        Option<Filter> option = this.filter;
        if (None$.MODULE$.equals(option)) {
            return in;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Filter f = (Filter)some.value();
            return in.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)f.evaluate(x$1)));
        }
        throw new MatchError(option);
    }

    private CloseableIterator<SimpleFeature> transformed(CloseableIterator<SimpleFeature> in) {
        Some some;
        Tuple2 tuple2;
        Option<Tuple2<String, SimpleFeatureType>> option = this.transform;
        if (None$.MODULE$.equals(option)) {
            return in;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String tdefs = (String)tuple2._1();
            SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
            TransformSimpleFeature feature = TransformSimpleFeature$.MODULE$.apply(this.converter.targetSft(), tsft, tdefs);
            return in.map((Function1 & Serializable & scala.Serializable)f -> ScalaSimpleFeature$.MODULE$.copy((SimpleFeature)feature.setFeature(f)));
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ CloseableIterator $anonfun$read$2(ConverterFileSystemReader $this, HadoopDelegate.HadoopFileHandle handle$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option name = (Option)tuple2._1();
            InputStream is = (InputStream)tuple2._2();
            Map params = EvaluationContext$.MODULE$.inputFileParam((String)name.getOrElse((Function0 & Serializable & scala.Serializable)() -> handle$1.path())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable($this.filter.map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)EvaluationContext$.MODULE$.FilterKey()), x$2))));
            return $this.converter.process(is, $this.converter.createEvaluationContext(params));
        }
        throw new MatchError((Object)tuple2);
    }

    public ConverterFileSystemReader(FileSystem fs, SimpleFeatureConverter converter, Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform, Option<PathFiltering> pathFiltering) {
        this.fs = fs;
        this.converter = converter;
        this.filter = filter;
        this.transform = transform;
        this.pathFiltering = pathFiltering;
        StrictLogging.$init$((StrictLogging)this);
    }
}

