/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.converter;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.locationtech.geomesa.convert.ConfArgs;
import org.locationtech.geomesa.convert.ConverterConfigResolver$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorageFactory;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.converter.ConverterStorage;
import org.locationtech.geomesa.fs.storage.converter.ConverterStorageFactory$;
import org.locationtech.geomesa.fs.storage.converter.pathfilter.PathFiltering;
import org.locationtech.geomesa.fs.storage.converter.pathfilter.PathFilteringFactory$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\u000f\u001e\u0001)BQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\u0005c\t\u0003\u0004S\u0001\u0001\u0006Ia\u0012\u0005\u0006'\u0002!\t\u0005V\u0004\u0006evA\ta\u001d\u0004\u00069uA\t\u0001\u001e\u0005\u0006\u0003\u001a!\t!\u001e\u0005\bm\u001a\u0011\r\u0011\"\u0001x\u0011\u0019yh\u0001)A\u0005q\"A\u0011\u0011\u0001\u0004C\u0002\u0013\u0005q\u000fC\u0004\u0002\u0004\u0019\u0001\u000b\u0011\u0002=\t\u0011\u0005\u0015aA1A\u0005\u0002]Dq!a\u0002\u0007A\u0003%\u0001\u0010\u0003\u0005\u0002\n\u0019\u0011\r\u0011\"\u0001x\u0011\u001d\tYA\u0002Q\u0001\naD\u0001\"!\u0004\u0007\u0005\u0004%\ta\u001e\u0005\b\u0003\u001f1\u0001\u0015!\u0003y\u0011!\t\tB\u0002b\u0001\n\u00039\bbBA\n\r\u0001\u0006I\u0001\u001f\u0005\t\u0003+1!\u0019!C\u0001o\"9\u0011q\u0003\u0004!\u0002\u0013A\b\u0002CA\r\r\t\u0007I\u0011A<\t\u000f\u0005ma\u0001)A\u0005q\"A\u0011Q\u0004\u0004C\u0002\u0013\u0005q\u000fC\u0004\u0002 \u0019\u0001\u000b\u0011\u0002=\t\u0011\u0005\u0005bA1A\u0005\u0002]Dq!a\t\u0007A\u0003%\u0001PA\fD_:4XM\u001d;feN#xN]1hK\u001a\u000b7\r^8ss*\u0011adH\u0001\nG>tg/\u001a:uKJT!\u0001I\u0011\u0002\u000fM$xN]1hK*\u0011!eI\u0001\u0003MNT!\u0001J\u0013\u0002\u000f\u001d,w.\\3tC*\u0011aeJ\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M!\u0001aK\u00198!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!'N\u0007\u0002g)\u0011AgH\u0001\u0004CBL\u0017B\u0001\u001c4\u0005a1\u0015\u000e\\3TsN$X-\\*u_J\fw-\u001a$bGR|'/\u001f\t\u0003q}j\u0011!\u000f\u0006\u0003um\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001P\u001f\u0002\u0011QL\b/Z:bM\u0016T\u0011AP\u0001\u0004G>l\u0017B\u0001!:\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\u0019\u0005C\u0001#\u0001\u001b\u0005i\u0012\u0001C3oG>$\u0017N\\4\u0016\u0003\u001d\u0003\"\u0001S(\u000f\u0005%k\u0005C\u0001&.\u001b\u0005Y%B\u0001'*\u0003\u0019a$o\\8u}%\u0011a*L\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002O[\u0005IQM\\2pI&tw\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0004+bk\u0007C\u0001\u001aW\u0013\t96GA\tGS2,7+_:uK6\u001cFo\u001c:bO\u0016DQ!\u0017\u0003A\u0002i\u000bqaY8oi\u0016DH\u000f\u0005\u0002\\U:\u0011A\f\u001b\b\u0003;\u001et!A\u00184\u000f\u0005}+gB\u00011e\u001d\t\t7M\u0004\u0002KE&\t\u0001&\u0003\u0002'O%\u0011A%J\u0005\u0003E\rJ!\u0001I\u0011\n\u0005Qz\u0012BA54\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003#\u0019KG.Z*zgR,WnQ8oi\u0016DHO\u0003\u0002jg!)a\u000e\u0002a\u0001_\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u00023a&\u0011\u0011o\r\u0002\u0010'R|'/Y4f\u001b\u0016$\u0018\rZ1uC\u000692i\u001c8wKJ$XM]*u_J\fw-\u001a$bGR|'/\u001f\t\u0003\t\u001a\u0019\"AB\u0016\u0015\u0003M\f!cQ8om\u0016\u0014H/\u001a:OC6,\u0007+\u0019:b[V\t\u0001\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006!A.\u00198h\u0015\u0005i\u0018\u0001\u00026bm\u0006L!\u0001\u0015>\u0002'\r{gN^3si\u0016\u0014h*Y7f!\u0006\u0014\u0018-\u001c\u0011\u0002)\r{gN^3si\u0016\u00148i\u001c8gS\u001e\u0004\u0016M]1n\u0003U\u0019uN\u001c<feR,'oQ8oM&<\u0007+\u0019:b[\u0002\n!cQ8om\u0016\u0014H/\u001a:QCRD\u0007+\u0019:b[\u0006\u00192i\u001c8wKJ$XM\u001d)bi\"\u0004\u0016M]1nA\u0005a1K\u001a;OC6,\u0007+\u0019:b[\u0006i1K\u001a;OC6,\u0007+\u0019:b[\u0002\nab\u00154u\u0007>tg-[4QCJ\fW.A\bTMR\u001cuN\u001c4jOB\u000b'/Y7!\u0003AaU-\u00194Ti>\u0014\u0018mZ3QCJ\fW.A\tMK\u000647\u000b^8sC\u001e,\u0007+\u0019:b[\u0002\nA\u0003U1si&$\u0018n\u001c8TG\",W.\u001a)be\u0006l\u0017!\u0006)beRLG/[8o'\u000eDW-\\3QCJ\fW\u000eI\u0001\u0014!\u0006\u0014H/\u001b;j_:|\u0005\u000f^:Qe\u00164\u0017\u000e_\u0001\u0015!\u0006\u0014H/\u001b;j_:|\u0005\u000f^:Qe\u00164\u0017\u000e\u001f\u0011\u0002\u001dA\u000bG\u000f\u001b$jYR,'OT1nK\u0006y\u0001+\u0019;i\r&dG/\u001a:OC6,\u0007%\u0001\u000bQCRDg)\u001b7uKJ|\u0005\u000f^:Qe\u00164\u0017\u000e_\u0001\u0016!\u0006$\bNR5mi\u0016\u0014x\n\u001d;t!J,g-\u001b=!\u0001")
public class ConverterStorageFactory
implements FileSystemStorageFactory,
LazyLogging {
    private final String encoding;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String PathFilterOptsPrefix() {
        return ConverterStorageFactory$.MODULE$.PathFilterOptsPrefix();
    }

    public static String PathFilterName() {
        return ConverterStorageFactory$.MODULE$.PathFilterName();
    }

    public static String PartitionOptsPrefix() {
        return ConverterStorageFactory$.MODULE$.PartitionOptsPrefix();
    }

    public static String PartitionSchemeParam() {
        return ConverterStorageFactory$.MODULE$.PartitionSchemeParam();
    }

    public static String LeafStorageParam() {
        return ConverterStorageFactory$.MODULE$.LeafStorageParam();
    }

    public static String SftConfigParam() {
        return ConverterStorageFactory$.MODULE$.SftConfigParam();
    }

    public static String SftNameParam() {
        return ConverterStorageFactory$.MODULE$.SftNameParam();
    }

    public static String ConverterPathParam() {
        return ConverterStorageFactory$.MODULE$.ConverterPathParam();
    }

    public static String ConverterConfigParam() {
        return ConverterStorageFactory$.MODULE$.ConverterConfigParam();
    }

    public static String ConverterNameParam() {
        return ConverterStorageFactory$.MODULE$.ConverterNameParam();
    }

    private Logger logger$lzycompute() {
        ConverterStorageFactory converterStorageFactory = this;
        synchronized (converterStorageFactory) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String encoding() {
        return this.encoding;
    }

    public FileSystemStorage apply(package.FileSystemContext context, StorageMetadata metadata) {
        String convertArg = (String)Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.ConverterConfigParam())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.ConverterNameParam()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Must provide either converter config or name");
        });
        Either either = ConverterConfigResolver$.MODULE$.getArg((Object)new ConfArgs(convertArg));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable e = (Throwable)left.value();
            throw new IllegalArgumentException("Could not load Converter with provided parameters", e);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        Config c = (Config)right.value();
        Config converterConfig = c;
        SimpleFeatureConverter converter = SimpleFeatureConverter$.MODULE$.apply(metadata.sft(), converterConfig);
        Map pathFilteringOpts = (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(context.conf().getValByRegex(new StringBuilder(2).append(Pattern.quote(ConverterStorageFactory$.MODULE$.PathFilterOptsPrefix())).append(".*").toString())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.substring(ConverterStorageFactory$.MODULE$.PathFilterOptsPrefix().length())), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        Option pathFiltering = Option$.MODULE$.apply((Object)context.conf().get(ConverterStorageFactory$.MODULE$.PathFilterName())).flatMap((Function1 & Serializable & scala.Serializable)name -> {
            Option<PathFiltering> factory = PathFilteringFactory$.MODULE$.load(new package.NamedOptions(name, pathFilteringOpts.toMap(Predef$.MODULE$.$conforms())));
            if (factory.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(29).append("Failed to load ").append(PathFiltering.class.getName()).append(" for config '").append((String)name).append("'").toString());
            }
            return factory;
        });
        return new ConverterStorage(context, metadata, converter, (Option<PathFiltering>)pathFiltering);
    }

    public ConverterStorageFactory() {
        LazyLogging.$init$((LazyLogging)this);
        this.encoding = "converter";
    }
}

