/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet;

import com.vividsolutions.jts.geom.Point;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.locationtech.geomesa.parquet.AttributeWriter$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tecaB\u0001\u0003!\u0003\r\na\u0003\u0002\u0010\u0003R$(/\u001b2vi\u0016<&/\u001b;fe*\u00111\u0001B\u0001\ba\u0006\u0014\u0018/^3u\u0015\t)a!A\u0004hK>lWm]1\u000b\u0005\u001dA\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0001\u0019\u0005A#A\u0003baBd\u0017\u0010F\u0002\u00161\u0015\u0002\"!\u0004\f\n\u0005]q!\u0001B+oSRDQ!\u0007\nA\u0002i\taB]3d_J$7i\u001c8tk6,'\u000f\u0005\u0002\u001cG5\tAD\u0003\u0002\u001e=\u0005\u0019\u0011\r]5\u000b\u0005}\u0001\u0013AA5p\u0015\t\u0019\u0011E\u0003\u0002#\u0011\u00051\u0011\r]1dQ\u0016L!\u0001\n\u000f\u0003\u001dI+7m\u001c:e\u0007>t7/^7fe\")aE\u0005a\u0001\u0019\u0005)a/\u00197vK\u001e)\u0001F\u0001E\u0001S\u0005y\u0011\t\u001e;sS\n,H/Z,sSR,'\u000f\u0005\u0002+W5\t!AB\u0003\u0002\u0005!\u0005Af\u0005\u0002,\u0019!)af\u000bC\u0001_\u00051A(\u001b8jiz\"\u0012!\u000b\u0005\u0006'-\"\t!\r\u000b\u0004eMz\u0004C\u0001\u0016\u0001\u0011\u0015!\u0004\u00071\u00016\u0003)!Wm]2sSB$xN\u001d\t\u0003muj\u0011a\u000e\u0006\u0003qe\nA\u0001^=qK*\u0011!hO\u0001\bM\u0016\fG/\u001e:f\u0015\ta\u0004\"A\u0004pa\u0016tw-[:\n\u0005y:$aE!uiJL'-\u001e;f\t\u0016\u001c8M]5qi>\u0014\b\"\u0002!1\u0001\u0004\t\u0015!B5oI\u0016D\bCA\u0007C\u0013\t\u0019eBA\u0002J]RDQaE\u0016\u0005\u0002\u0015#RA\r$P!*DQa\u0012#A\u0002!\u000bAA\\1nKB\u0011\u0011\n\u0014\b\u0003\u001b)K!a\u0013\b\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017:AQ\u0001\u0011#A\u0002\u0005CQ!\u0015#A\u0002I\u000b!b\u001c2kK\u000e$H+\u001f9f!\t\u0019vM\u0004\u0002UI:\u0011Q+\u0019\b\u0003-~s!a\u00160\u000f\u0005akfBA-]\u001b\u0005Q&BA.\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003A\u0012\t\u0001BZ3biV\u0014Xm]\u0005\u0003E\u000e\fQb]3sS\u0006d\u0017N_1uS>t'B\u00011\u0005\u0013\t)g-\u0001\u0006PE*,7\r\u001e+za\u0016T!AY2\n\u0005!L'AC(cU\u0016\u001cG\u000fV=qK*\u0011QM\u001a\u0005\u0006W\u0012\u0003\r\u0001\\\u0001\tE&tG-\u001b8hgB\u0019QN\u001d*\u000f\u00059\u0004hBA-p\u0013\u0005y\u0011BA9\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001d;\u0003\u0007M+\u0017O\u0003\u0002r\u001d\u0019)aoKA\u0001o\n9\u0012IY:ue\u0006\u001cG/\u0011;ue&\u0014W\u000f^3Xe&$XM]\n\u0004k2\u0011\u0004\u0002C=v\u0005\u0003\u0005\u000b\u0011\u0002%\u0002\u0013\u0019LW\r\u001c3OC6,\u0007\u0002C>v\u0005\u0003\u0005\u000b\u0011B!\u0002\u0015\u0019LW\r\u001c3J]\u0012,\u0007\u0010C\u0003/k\u0012\u0005Q\u0010F\u0003\u007f\u0003\u0003\t\u0019\u0001\u0005\u0002\u0000k6\t1\u0006C\u0003zy\u0002\u0007\u0001\nC\u0003|y\u0002\u0007\u0011\tC\u0004\u0002\bU4\t!!\u0003\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000bU\tY!!\u0004\t\re\t)\u00011\u0001\u001b\u0011\u00191\u0013Q\u0001a\u0001\u0019!11#\u001eC!\u0003#!R!FA\n\u0003+Aa!GA\b\u0001\u0004Q\u0002B\u0002\u0014\u0002\u0010\u0001\u0007AB\u0002\u0004\u0002\u001a-\u0002\u00111\u0004\u0002\u0015!>Lg\u000e^!uiJL'-\u001e;f/JLG/\u001a:\u0014\u0007\u0005]a\u0010C\u0005z\u0003/\u0011\t\u0011)A\u0005\u0011\"I10a\u0006\u0003\u0002\u0003\u0006I!\u0011\u0005\b]\u0005]A\u0011AA\u0012)\u0019\t)#a\n\u0002*A\u0019q0a\u0006\t\re\f\t\u00031\u0001I\u0011\u0019Y\u0018\u0011\u0005a\u0001\u0003\"A\u0011qAA\f\t\u0003\ni\u0003F\u0003\u0016\u0003_\t\t\u0004\u0003\u0004\u001a\u0003W\u0001\rA\u0007\u0005\u0007M\u0005-\u0002\u0019\u0001\u0007\u0007\r\u0005U2\u0006AA\u001c\u0005)!\u0015\r^3Xe&$XM]\n\u0004\u0003gq\b\"C=\u00024\t\u0005\t\u0015!\u0003I\u0011%Y\u00181\u0007B\u0001B\u0003%\u0011\tC\u0004/\u0003g!\t!a\u0010\u0015\r\u0005\u0005\u00131IA#!\ry\u00181\u0007\u0005\u0007s\u0006u\u0002\u0019\u0001%\t\rm\fi\u00041\u0001B\u0011!\t9!a\r\u0005B\u0005%C#B\u000b\u0002L\u00055\u0003BB\r\u0002H\u0001\u0007!\u0004\u0003\u0004'\u0003\u000f\u0002\r\u0001\u0004\u0004\u0007\u0003#Z\u0003!a\u0015\u0003\u0019\u0011{WO\u00197f/JLG/\u001a:\u0014\u0007\u0005=c\u0010C\u0005z\u0003\u001f\u0012\t\u0011)A\u0005\u0011\"I10a\u0014\u0003\u0002\u0003\u0006I!\u0011\u0005\b]\u0005=C\u0011AA.)\u0019\ti&a\u0018\u0002bA\u0019q0a\u0014\t\re\fI\u00061\u0001I\u0011\u0019Y\u0018\u0011\fa\u0001\u0003\"A\u0011qAA(\t\u0003\n)\u0007F\u0003\u0016\u0003O\nI\u0007\u0003\u0004\u001a\u0003G\u0002\rA\u0007\u0005\u0007M\u0005\r\u0004\u0019\u0001\u0007\u0007\r\u000554\u0006AA8\u0005-1En\\1u/JLG/\u001a:\u0014\u0007\u0005-d\u0010C\u0005z\u0003W\u0012\t\u0011)A\u0005\u0011\"I10a\u001b\u0003\u0002\u0003\u0006I!\u0011\u0005\b]\u0005-D\u0011AA<)\u0019\tI(a\u001f\u0002~A\u0019q0a\u001b\t\re\f)\b1\u0001I\u0011\u0019Y\u0018Q\u000fa\u0001\u0003\"A\u0011qAA6\t\u0003\n\t\tF\u0003\u0016\u0003\u0007\u000b)\t\u0003\u0004\u001a\u0003\u007f\u0002\rA\u0007\u0005\u0007M\u0005}\u0004\u0019\u0001\u0007\u0007\r\u0005%5\u0006AAF\u00055Ie\u000e^3hKJ<&/\u001b;feN\u0019\u0011q\u0011@\t\u0013e\f9I!A!\u0002\u0013A\u0005\"C>\u0002\b\n\u0005\t\u0015!\u0003B\u0011\u001dq\u0013q\u0011C\u0001\u0003'#b!!&\u0002\u0018\u0006e\u0005cA@\u0002\b\"1\u00110!%A\u0002!Caa_AI\u0001\u0004\t\u0005\u0002CA\u0004\u0003\u000f#\t%!(\u0015\u000bU\ty*!)\t\re\tY\n1\u0001\u001b\u0011\u00191\u00131\u0014a\u0001\u0019\u00191\u0011QU\u0016\u0001\u0003O\u0013!\u0002T8oO^\u0013\u0018\u000e^3s'\r\t\u0019K \u0005\ns\u0006\r&\u0011!Q\u0001\n!C\u0011b_AR\u0005\u0003\u0005\u000b\u0011B!\t\u000f9\n\u0019\u000b\"\u0001\u00020R1\u0011\u0011WAZ\u0003k\u00032a`AR\u0011\u0019I\u0018Q\u0016a\u0001\u0011\"110!,A\u0002\u0005C\u0001\"a\u0002\u0002$\u0012\u0005\u0013\u0011\u0018\u000b\u0006+\u0005m\u0016Q\u0018\u0005\u00073\u0005]\u0006\u0019\u0001\u000e\t\r\u0019\n9\f1\u0001\r\r\u0019\t\tm\u000b\u0001\u0002D\na1\u000b\u001e:j]\u001e<&/\u001b;feN\u0019\u0011q\u0018@\t\u0013e\fyL!A!\u0002\u0013A\u0005\"C>\u0002@\n\u0005\t\u0015!\u0003B\u0011\u001dq\u0013q\u0018C\u0001\u0003\u0017$b!!4\u0002P\u0006E\u0007cA@\u0002@\"1\u00110!3A\u0002!Caa_Ae\u0001\u0004\t\u0005\u0002CA\u0004\u0003\u007f#\t%!6\u0015\u000bU\t9.!7\t\re\t\u0019\u000e1\u0001\u001b\u0011\u00191\u00131\u001ba\u0001\u0019\u00191\u0011Q\\\u0016\u0001\u0003?\u0014!\u0002T5ti^\u0013\u0018\u000e^3s'\r\tYN \u0005\ns\u0006m'\u0011!Q\u0001\n!C\u0011b_An\u0005\u0003\u0005\u000b\u0011B!\t\u0015\u0005\u001d\u00181\u001cB\u0001B\u0003%!+A\u0005wC2,X\rV=qK\"9a&a7\u0005\u0002\u0005-H\u0003CAw\u0003_\f\t0a=\u0011\u0007}\fY\u000e\u0003\u0004z\u0003S\u0004\r\u0001\u0013\u0005\u0007w\u0006%\b\u0019A!\t\u000f\u0005\u001d\u0018\u0011\u001ea\u0001%\"Q\u0011q_An\u0005\u0004%\t!!?\u0002\u001b\u0015dW-\\3oi^\u0013\u0018\u000e^3s+\u0005\u0011\u0004\u0002CA\u007f\u00037\u0004\u000b\u0011\u0002\u001a\u0002\u001d\u0015dW-\\3oi^\u0013\u0018\u000e^3sA!A\u0011qAAn\t\u0003\u0012\t\u0001F\u0003\u0016\u0005\u0007\u0011)\u0001\u0003\u0004\u001a\u0003\u007f\u0004\rA\u0007\u0005\u0007M\u0005}\b\u0019\u0001\u0007\u0007\r\t%1\u0006\u0001B\u0006\u0005%i\u0015\r],sSR,'oE\u0002\u0003\byD\u0011\"\u001fB\u0004\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0013m\u00149A!A!\u0002\u0013\t\u0005B\u0003B\n\u0005\u000f\u0011\t\u0011)A\u0005%\u000691.Z=UsB,\u0007BCAt\u0005\u000f\u0011\t\u0011)A\u0005%\"9aFa\u0002\u0005\u0002\teAC\u0003B\u000e\u0005;\u0011yB!\t\u0003$A\u0019qPa\u0002\t\re\u00149\u00021\u0001I\u0011\u0019Y(q\u0003a\u0001\u0003\"9!1\u0003B\f\u0001\u0004\u0011\u0006bBAt\u0005/\u0001\rA\u0015\u0005\u000b\u0005O\u00119A1A\u0005\u0002\u0005e\u0018!C6fs^\u0013\u0018\u000e^3s\u0011!\u0011YCa\u0002!\u0002\u0013\u0011\u0014AC6fs^\u0013\u0018\u000e^3sA!Q!q\u0006B\u0004\u0005\u0004%\t!!?\u0002\u0017Y\fG.^3Xe&$XM\u001d\u0005\t\u0005g\u00119\u0001)A\u0005e\u0005aa/\u00197vK^\u0013\u0018\u000e^3sA!A\u0011q\u0001B\u0004\t\u0003\u00129\u0004F\u0003\u0016\u0005s\u0011Y\u0004\u0003\u0004\u001a\u0005k\u0001\rA\u0007\u0005\u0007M\tU\u0002\u0019\u0001\u0007\u0007\r\t}2\u0006\u0001B!\u0005))V+\u0013#Xe&$XM]\n\u0004\u0005{q\b\"C=\u0003>\t\u0005\t\u0015!\u0003I\u0011%Y(Q\bB\u0001B\u0003%\u0011\tC\u0004/\u0005{!\tA!\u0013\u0015\r\t-#Q\nB(!\ry(Q\b\u0005\u0007s\n\u001d\u0003\u0019\u0001%\t\rm\u00149\u00051\u0001B\u0011!\t9A!\u0010\u0005B\tMC#B\u000b\u0003V\t]\u0003BB\r\u0003R\u0001\u0007!\u0004\u0003\u0004'\u0005#\u0002\r\u0001\u0004")
public interface AttributeWriter {
    public void apply(RecordConsumer var1, Object var2);

    public static class MapWriter
    extends AbstractAttributeWriter {
        private final String fieldName;
        private final AttributeWriter keyWriter;
        private final AttributeWriter valueWriter;

        public AttributeWriter keyWriter() {
            return this.keyWriter;
        }

        public AttributeWriter valueWriter() {
            return this.valueWriter;
        }

        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.startGroup();
            Map themap = (Map)value;
            if (themap != null && themap.nonEmpty()) {
                recordConsumer.startField(this.fieldName, 0);
                themap.foreach((Function1)new Serializable(this, recordConsumer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MapWriter $outer;
                    private final RecordConsumer recordConsumer$2;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object k = tuple2._1();
                            Object v = tuple2._2();
                            this.recordConsumer$2.startGroup();
                            this.$outer.keyWriter().apply(this.recordConsumer$2, k);
                            if (v != null) {
                                this.$outer.valueWriter().apply(this.recordConsumer$2, v);
                            }
                            this.recordConsumer$2.endGroup();
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.recordConsumer$2 = recordConsumer$2;
                    }
                });
                recordConsumer.endField(this.fieldName, 0);
            }
            recordConsumer.endGroup();
        }

        public MapWriter(String fieldName, int fieldIndex, Enumeration.Value keyType, Enumeration.Value valueType) {
            this.fieldName = fieldName;
            super(fieldName, fieldIndex);
            this.keyWriter = AttributeWriter$.MODULE$.apply("key", 0, keyType, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.empty()));
            this.valueWriter = AttributeWriter$.MODULE$.apply("value", 1, valueType, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.empty()));
        }
    }

    public static class DateWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addLong(((Date)value).getTime());
        }

        public DateWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class LongWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addLong(BoxesRunTime.unboxToLong((Object)value));
        }

        public LongWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class ListWriter
    extends AbstractAttributeWriter {
        private final String fieldName;
        private final AttributeWriter elementWriter;

        public AttributeWriter elementWriter() {
            return this.elementWriter;
        }

        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.startGroup();
            List thelist = (List)value;
            if (thelist != null && thelist.nonEmpty()) {
                recordConsumer.startField(this.fieldName, 0);
                thelist.foreach((Function1)new Serializable(this, recordConsumer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ListWriter $outer;
                    private final RecordConsumer recordConsumer$1;

                    public final void apply(Object e) {
                        this.recordConsumer$1.startGroup();
                        if (e != null) {
                            this.$outer.elementWriter().apply(this.recordConsumer$1, e);
                        }
                        this.recordConsumer$1.endGroup();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.recordConsumer$1 = recordConsumer$1;
                    }
                });
                recordConsumer.endField(this.fieldName, 0);
            }
            recordConsumer.endGroup();
        }

        public ListWriter(String fieldName, int fieldIndex, Enumeration.Value valueType) {
            this.fieldName = fieldName;
            super(fieldName, fieldIndex);
            this.elementWriter = AttributeWriter$.MODULE$.apply("element", 0, valueType, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.empty()));
        }
    }

    public static class UUIDWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            UUID uuid = (UUID)value;
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            recordConsumer.addBinary(Binary.fromConstantByteArray((byte[])bb.array()));
        }

        public UUIDWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class FloatWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addFloat(Predef$.MODULE$.Float2float((Float)value));
        }

        public FloatWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class DoubleWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addDouble(Predef$.MODULE$.Double2double((Double)value));
        }

        public DoubleWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class StringWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addBinary(Binary.fromString((String)((String)value)));
        }

        public StringWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class IntegerWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            recordConsumer.addInteger(Predef$.MODULE$.Integer2int((Integer)value));
        }

        public IntegerWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static class PointAttributeWriter
    extends AbstractAttributeWriter {
        @Override
        public void write(RecordConsumer recordConsumer, Object value) {
            Point pt = (Point)value;
            recordConsumer.startGroup();
            recordConsumer.startField("x", 0);
            recordConsumer.addDouble(pt.getX());
            recordConsumer.endField("x", 0);
            recordConsumer.startField("y", 1);
            recordConsumer.addDouble(pt.getY());
            recordConsumer.endField("y", 1);
            recordConsumer.endGroup();
        }

        public PointAttributeWriter(String fieldName, int fieldIndex) {
            super(fieldName, fieldIndex);
        }
    }

    public static abstract class AbstractAttributeWriter
    implements AttributeWriter {
        private final String fieldName;
        private final int fieldIndex;

        public abstract void write(RecordConsumer var1, Object var2);

        @Override
        public void apply(RecordConsumer recordConsumer, Object value) {
            if (value != null) {
                recordConsumer.startField(this.fieldName, this.fieldIndex);
                this.write(recordConsumer, value);
                recordConsumer.endField(this.fieldName, this.fieldIndex);
            }
        }

        public AbstractAttributeWriter(String fieldName, int fieldIndex) {
            this.fieldName = fieldName;
            this.fieldIndex = fieldIndex;
        }
    }
}

