/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.parquet.hadoop.ParquetReader;
import org.locationtech.geomesa.fs.storage.api.FileSystemPartitionIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001-\u0011\u0011CR5mi\u0016\u0014\u0018N\\4Ji\u0016\u0014\u0018\r^8s\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011aB4f_6,7/\u0019\u0006\u0003\u000f!\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011!b\u0004\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)B$D\u0001\u0017\u0015\t9\u0002$A\u0002ba&T!!\u0007\u000e\u0002\u000fM$xN]1hK*\u00111\u0004B\u0001\u0003MNL!!\b\f\u00037\u0019KG.Z*zgR,W\u000eU1si&$\u0018n\u001c8Ji\u0016\u0014\u0018\r^8s!\tyb%D\u0001!\u0015\t\t#%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002$I\u0005AA/\u001f9fg\u00064WMC\u0001&\u0003\r\u0019w.\\\u0005\u0003O\u0001\u00121\u0002T1{s2{wmZ5oO\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0005qCJ$\u0018\u000e^5p]B\u00111&\r\b\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'L\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021[!AQ\u0007\u0001B\u0001B\u0003%a'A\u0004ck&dG-\u001a:\u0011\u0007]\u00025I\u0004\u00029}5\t\u0011H\u0003\u0002;w\u00051\u0001.\u00193p_BT!a\u0001\u001f\u000b\u0005uB\u0011AB1qC\u000eDW-\u0003\u0002@s\u0005i\u0001+\u0019:rk\u0016$(+Z1eKJL!!\u0011\"\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011q(\u000f\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000baa]5na2,'B\u0001%J\u0003\u001d1W-\u0019;ve\u0016T!A\u0013\u0005\u0002\u000f=\u0004XM\\4jg&\u0011A*\u0012\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u00119\u0003!\u0011!Q\u0001\n=\u000b\u0001b\u001a;GS2$XM\u001d\t\u0003!Nk\u0011!\u0015\u0006\u0003%&\u000baAZ5mi\u0016\u0014\u0018B\u0001+R\u0005\u00191\u0015\u000e\u001c;fe\")a\u000b\u0001C\u0001/\u00061A(\u001b8jiz\"B\u0001\u0017.\\9B\u0011\u0011\fA\u0007\u0002\u0005!)\u0011&\u0016a\u0001U!)Q'\u0016a\u0001m!)a*\u0016a\u0001\u001f\"Aa\f\u0001EC\u0002\u0013%q,\u0001\u0004sK\u0006$WM]\u000b\u0002AB\u0019\u0001(Y\"\n\u0005\tL$!\u0004)beF,X\r\u001e*fC\u0012,'\u000f\u0003\u0005e\u0001!\u0005\t\u0015)\u0003a\u0003\u001d\u0011X-\u00193fe\u0002B\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011B4\u0002\rM$\u0018mZ3e+\u0005\u0019\u0005\"C5\u0001\u0001\u0004\u0005\r\u0011\"\u0003k\u0003)\u0019H/Y4fI~#S-\u001d\u000b\u0003W:\u0004\"\u0001\f7\n\u00055l#\u0001B+oSRDqa\u001c5\u0002\u0002\u0003\u00071)A\u0002yIEBa!\u001d\u0001!B\u0013\u0019\u0015aB:uC\u001e,G\r\t\u0005\bg\u0002\u0001\r\u0011\"\u0003u\u0003\u0011!wN\\3\u0016\u0003U\u0004\"\u0001\f<\n\u0005]l#a\u0002\"p_2,\u0017M\u001c\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0003!!wN\\3`I\u0015\fHCA6|\u0011\u001dy\u00070!AA\u0002UDa! \u0001!B\u0013)\u0018!\u00023p]\u0016\u0004\u0003BB@\u0001\t\u0003\n\t!A\u0003dY>\u001cX\rF\u0001l\u0011\u001d\t)\u0001\u0001C!\u0003\u000f\tAA\\3yiR\t1\tC\u0004\u0002\f\u0001!\t%!\u0004\u0002\u000f!\f7OT3yiR\tQ\u000fC\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u0019\u001d,G\u000fU1si&$\u0018n\u001c8\u0015\u0003)\u0002")
public class FilteringIterator
implements FileSystemPartitionIterator,
LazyLogging {
    private final String partition;
    private final ParquetReader.Builder<SimpleFeature> builder;
    private final Filter gtFilter;
    private ParquetReader<SimpleFeature> reader;
    private SimpleFeature staged;
    private boolean done;
    private final Logger logger;
    private volatile byte bitmap$0;

    private ParquetReader reader$lzycompute() {
        FilteringIterator filteringIterator = this;
        synchronized (filteringIterator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Opening reader for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.reader = this.builder.build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
            this.builder = null;
            return this.reader;
        }
    }

    private Logger logger$lzycompute() {
        FilteringIterator filteringIterator = this;
        synchronized (filteringIterator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private ParquetReader<SimpleFeature> reader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reader$lzycompute() : this.reader;
    }

    private SimpleFeature staged() {
        return this.staged;
    }

    private void staged_$eq(SimpleFeature x$1) {
        this.staged = x$1;
    }

    private boolean done() {
        return this.done;
    }

    private void done_$eq(boolean x$1) {
        this.done = x$1;
    }

    public void close() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing parquet reader for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.reader().close();
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeature next() {
        void var1_1;
        SimpleFeature res = this.staged();
        this.staged_$eq(null);
        return var1_1;
    }

    public boolean hasNext() {
        while (this.staged() == null && !this.done()) {
            SimpleFeature f = (SimpleFeature)this.reader().read();
            if (f == null) {
                this.done_$eq(true);
                continue;
            }
            if (!this.gtFilter.evaluate((Object)f)) continue;
            this.staged_$eq(f);
        }
        return this.staged() != null;
    }

    public String getPartition() {
        return this.partition;
    }

    public FilteringIterator(String partition, ParquetReader.Builder<SimpleFeature> builder, Filter gtFilter) {
        this.partition = partition;
        this.builder = builder;
        this.gtFilter = gtFilter;
        LazyLogging.class.$init$((LazyLogging)this);
        this.done = false;
    }
}

