/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet;

import com.google.common.cache.Cache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.geotools.data.Query;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.fs.storage.api.FileSystemPartitionIterator;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.FileSystemWriter;
import org.locationtech.geomesa.fs.storage.api.Metadata;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.common.FileMetadata;
import org.locationtech.geomesa.fs.storage.common.FileMetadata$;
import org.locationtech.geomesa.fs.storage.common.FileType$;
import org.locationtech.geomesa.fs.storage.common.PartitionScheme$;
import org.locationtech.geomesa.fs.storage.common.StorageUtils$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.parquet.FilterConverter;
import org.locationtech.geomesa.parquet.FilteringIterator;
import org.locationtech.geomesa.parquet.FilteringTransformIterator;
import org.locationtech.geomesa.parquet.MultiIterator;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.parquet.SimpleFeatureParquetWriter$;
import org.locationtech.geomesa.parquet.SimpleFeatureReadSupport;
import org.locationtech.geomesa.parquet.SimpleFeatureReadSupport$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0001\u0003\u0001-\u0011\u0001\u0004U1scV,GOR5mKNK8\u000f^3n'R|'/Y4f\u0015\t\u0019A!A\u0004qCJ\fX/\u001a;\u000b\u0005\u00151\u0011aB4f_6,7/\u0019\u0006\u0003\u000f!\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!C\u0001\u0004_J<7\u0001A\n\u0005\u00011!b\u0004\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)B$D\u0001\u0017\u0015\t9\u0002$A\u0002ba&T!!\u0007\u000e\u0002\u000fM$xN]1hK*\u00111\u0004B\u0001\u0003MNL!!\b\f\u0003#\u0019KG.Z*zgR,Wn\u0015;pe\u0006<W\r\u0005\u0002 M5\t\u0001E\u0003\u0002\"E\u0005a1oY1mC2|wmZ5oO*\u00111\u0005J\u0001\tif\u0004Xm]1gK*\tQ%A\u0002d_6L!a\n\u0011\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005!!o\\8u!\tY\u0013'D\u0001-\u0015\tYRF\u0003\u0002/_\u00051\u0001.\u00193p_BT!\u0001\r\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u0011DF\u0001\u0003QCRD\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0011\u0005-*\u0014B\u0001\u001c-\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\tq\u0001\u0011\t\u0011)A\u0005s\u0005!1m\u001c8g!\tQD(D\u0001<\u0015\tAT&\u0003\u0002>w\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\tIN\u0004\u0016M]1ngB!\u0011\t\u0012$Q\u001b\u0005\u0011%BA\"\u0011\u0003\u0011)H/\u001b7\n\u0005\u0015\u0013%aA'baB\u0011q)\u0014\b\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*S\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M\u0013B\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bE\u0001\u0003S>L!!\u0016*\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b]\u0003A\u0011\u0001-\u0002\rqJg.\u001b;?)\u0015I6\fX/_!\tQ\u0006!D\u0001\u0003\u0011\u0015Ic\u000b1\u0001+\u0011\u0015Yb\u000b1\u00015\u0011\u0015Ad\u000b1\u0001:\u0011\u0015yd\u000b1\u0001A\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\f\u0011\u0002^=qK:\u000bW.Z:\u0016\u0003\t\u00042a\u00195G\u001b\u0005!'BA3g\u0003\u001diW\u000f^1cY\u0016T!aZ%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002jI\nQA*[:u\u0005V4g-\u001a:\t\r-\u0004\u0001\u0015!\u0003c\u0003)!\u0018\u0010]3OC6,7\u000f\t\u0005\u0006[\u0002!\tE\\\u0001\u000eY&\u001cH\u000fV=qK:\u000bW.Z:\u0015\u0003=\u00042!\u00119G\u0013\t\t(I\u0001\u0003MSN$\b\"B:\u0001\t\u0013!\u0018\u0001C7fi\u0006$\u0017\r^1\u0015\u0005UD\bCA\u000bw\u0013\t9hC\u0001\u0005NKR\fG-\u0019;b\u0011\u0015I(\u000f1\u0001G\u0003!!\u0018\u0010]3OC6,\u0007\"B>\u0001\t\u0003b\u0018AD4fi\u001a+\u0017\r^;sKRK\b/\u001a\u000b\u0004{\u0006=\u0001c\u0001@\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011AB:j[BdWM\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u00024fCR,(/\u001a\u0006\u0004\u0003\u0013A\u0011aB8qK:<\u0017n]\u0005\u0004\u0003\u001by(!E*j[BdWMR3biV\u0014X\rV=qK\")\u0011P\u001fa\u0001\r\"9\u00111\u0003\u0001\u0005\n\u0005U\u0011AE2sK\u0006$XMR5mK6+G/\u00193bi\u0006$B!a\u0006\u0002$A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001ea\taaY8n[>t\u0017\u0002BA\u0011\u00037\u0011ABR5mK6+G/\u00193bi\u0006Dq!!\n\u0002\u0012\u0001\u0007Q0A\u0002tMRDq!!\u000b\u0001\t\u0003\nY#\u0001\u000bde\u0016\fG/\u001a(fo\u001a+\u0017\r^;sKRK\b/\u001a\u000b\u0007\u0003[\t\u0019$!\u000e\u0011\u0007!\u000by#C\u0002\u00022%\u0013A!\u00168ji\"9\u0011QEA\u0014\u0001\u0004i\b\u0002CA\u001c\u0003O\u0001\r!!\u000f\u0002\rM\u001c\u0007.Z7f!\r)\u00121H\u0005\u0004\u0003{1\"a\u0004)beRLG/[8o'\u000eDW-\\3\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u0005\u0001B.[:u\r\u0016\fG/\u001e:f)f\u0004Xm\u001d\u000b\u0003\u0003\u000b\u00022!\u00119~\u0011\u001d\tI\u0005\u0001C!\u0003\u0017\na\u0002\\5tiB\u000b'\u000f^5uS>t7\u000fF\u0002p\u0003\u001bBa!_A$\u0001\u00041\u0005bBA)\u0001\u0011\u0005\u00131K\u0001\u0013O\u0016$\b+\u0019:uSRLwN\u001c*fC\u0012,'\u000f\u0006\u0005\u0002V\u0005m\u0013QLA9!\r)\u0012qK\u0005\u0004\u000332\"a\u0007$jY\u0016\u001c\u0016p\u001d;f[B\u000b'\u000f^5uS>t\u0017\n^3sCR|'\u000fC\u0004\u0002&\u0005=\u0003\u0019A?\t\u0011\u0005}\u0013q\na\u0001\u0003C\n\u0011!\u001d\t\u0005\u0003G\ni'\u0004\u0002\u0002f)!\u0011qMA5\u0003\u0011!\u0017\r^1\u000b\u0007\u0005-\u0004\"\u0001\u0005hK>$xn\u001c7t\u0013\u0011\ty'!\u001a\u0003\u000bE+XM]=\t\u000f\u0005M\u0014q\na\u0001\r\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003o\u0002A\u0011IA=\u0003%9W\r^,sSR,'\u000f\u0006\u0004\u0002|\u0005\u0005\u00151\u0011\t\u0004+\u0005u\u0014bAA@-\t\u0001b)\u001b7f'f\u001cH/Z7Xe&$XM\u001d\u0005\u0007s\u0006U\u0004\u0019\u0001$\t\u000f\u0005M\u0014Q\u000fa\u0001\r\"9\u0011q\u0011\u0001\u0005B\u0005%\u0015AE4fiB\u000b'\u000f^5uS>t7k\u00195f[\u0016$B!!\u000f\u0002\f\"1\u00110!\"A\u0002\u0019Cq!a$\u0001\t\u0003\n\t*\u0001\u0005hKR\u0004\u0016\r\u001e5t)\u0019\t\u0019*!)\u0002$B!\u0011\t]AK!\u0011\t9*!(\u000e\u0005\u0005e%bAAN!\u0005\u0019a.\u001a;\n\t\u0005}\u0015\u0011\u0014\u0002\u0004+JK\u0005BB=\u0002\u000e\u0002\u0007a\tC\u0004\u0002t\u00055\u0005\u0019\u0001$\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\u0006Yq-\u001a;NKR\fG-\u0019;b)\r)\u00181\u0016\u0005\u0007s\u0006\u0015\u0006\u0019\u0001$\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\u0006a1\r\\3b]\n\u000b7m[;qgR!\u0011QFAZ\u0011\u0019I\u0018Q\u0016a\u0001\r\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0016A\u00042bG.,\b/T3uC\u0012\fG/\u0019\u000b\u0005\u0003[\tY\f\u0003\u0004z\u0003k\u0003\rA\u0012\u0005\b\u0003\u007f\u0003A\u0011IAa\u00039)\b\u000fZ1uK6+G/\u00193bi\u0006$B!!\f\u0002D\"1\u00110!0A\u0002\u0019Cq!a2\u0001\t\u0003\nI-A\u0004d_6\u0004\u0018m\u0019;\u0015\r\u00055\u00121ZAg\u0011\u0019I\u0018Q\u0019a\u0001\r\"9\u00111OAc\u0001\u00041uaBAi\u0005!\u0005\u00111[\u0001\u0019!\u0006\u0014\u0018/^3u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0007c\u0001.\u0002V\u001a1\u0011A\u0001E\u0001\u0003/\u001cB!!6\u0002ZB\u0019\u0001*a7\n\u0007\u0005u\u0017J\u0001\u0004B]f\u0014VM\u001a\u0005\b/\u0006UG\u0011AAq)\t\t\u0019\u000e\u0003\u0006\u0002f\u0006U'\u0019!C\u0001\u0003O\fq\u0002U1scV,G/\u00128d_\u0012LgnZ\u000b\u0003\u0003S\u00042!DAv\u0013\tqe\u0002C\u0005\u0002p\u0006U\u0007\u0015!\u0003\u0002j\u0006\u0001\u0002+\u0019:rk\u0016$XI\\2pI&tw\r\t\u0005\u000b\u0003g\f)N1A\u0005\u0002\u0005\u001d\u0018!\u0004$jY\u0016,\u0005\u0010^3og&|g\u000eC\u0005\u0002x\u0006U\u0007\u0015!\u0003\u0002j\u0006qa)\u001b7f\u000bb$XM\\:j_:\u0004\u0003BCA~\u0003+\u0014\r\u0011\"\u0001\u0002h\u0006\u0001R*\u001a;bI\u0006$\u0018MR5mK:\u000bW.\u001a\u0005\n\u0003\u007f\f)\u000e)A\u0005\u0003S\f\u0011#T3uC\u0012\fG/\u0019$jY\u0016t\u0015-\\3!\u0011)\u0011\u0019!!6C\u0002\u0013\u0005\u0011q]\u0001\u0016!\u0006\u0014\u0018/^3u\u0007>l\u0007O]3tg&|gn\u00149u\u0011%\u00119!!6!\u0002\u0013\tI/\u0001\fQCJ\fX/\u001a;D_6\u0004(/Z:tS>tw\n\u001d;!\u0011)\u0011Y!!6C\u0002\u0013\u0005!QB\u0001\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\t=\u0001c\u0002B\t\u0005;\u0011\t#^\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005)1-Y2iK*!\u0011Q\u0004B\r\u0015\r\u0011Y\u0002J\u0001\u0007O>|w\r\\3\n\t\t}!1\u0003\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0006\u0011\n\r\"FR\u0005\u0004\u0005KI%A\u0002+va2,'\u0007C\u0005\u0003*\u0005U\u0007\u0015!\u0003\u0003\u0010\u0005qQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0003")
public class ParquetFileSystemStorage
implements FileSystemStorage,
LazyLogging {
    public final Path org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root;
    public final FileSystem org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs;
    public final Configuration org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$conf;
    private final ListBuffer<String> typeNames;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static Cache<Tuple2<Path, String>, Metadata> MetadataCache() {
        return ParquetFileSystemStorage$.MODULE$.MetadataCache();
    }

    public static String ParquetCompressionOpt() {
        return ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt();
    }

    public static String MetadataFileName() {
        return ParquetFileSystemStorage$.MODULE$.MetadataFileName();
    }

    public static String FileExtension() {
        return ParquetFileSystemStorage$.MODULE$.FileExtension();
    }

    public static String ParquetEncoding() {
        return ParquetFileSystemStorage$.MODULE$.ParquetEncoding();
    }

    private Logger logger$lzycompute() {
        ParquetFileSystemStorage parquetFileSystemStorage = this;
        synchronized (parquetFileSystemStorage) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private ListBuffer<String> typeNames() {
        return this.typeNames;
    }

    public List<String> listTypeNames() {
        return Collections.unmodifiableList(JavaConversions$.MODULE$.bufferAsJavaList(this.typeNames()));
    }

    public Metadata org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(String typeName) {
        return (Metadata)ParquetFileSystemStorage$.MODULE$.MetadataCache().get((Object)new Tuple2((Object)this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, (Object)typeName), (Callable)new Callable<Metadata>(this, typeName){
            private final /* synthetic */ ParquetFileSystemStorage $outer;
            private final String typeName$1;

            public Metadata call() {
                BoxedUnit boxedUnit;
                long start = System.currentTimeMillis();
                Path typePath = new Path(this.$outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, this.typeName$1);
                Path metaFile = new Path(typePath, ParquetFileSystemStorage$.MODULE$.MetadataFileName());
                FileMetadata metadata = FileMetadata$.MODULE$.read(this.$outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs, metaFile, this.$outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$conf);
                long end = System.currentTimeMillis();
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded metadata in ", "ms for type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(end - start)), this.typeName$1})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return metadata;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.typeName$1 = typeName$1;
            }
        });
    }

    public SimpleFeatureType getFeatureType(String typeName) {
        return this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getSimpleFeatureType();
    }

    private FileMetadata createFileMetadata(SimpleFeatureType sft) {
        String typeName = sft.getTypeName();
        Path typePath = new Path(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, typeName);
        PartitionScheme scheme = PartitionScheme$.MODULE$.extractFromSft(sft);
        Path metaPath = new Path(typePath, ParquetFileSystemStorage$.MODULE$.MetadataFileName());
        return FileMetadata$.MODULE$.create(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs, metaPath, sft, ParquetFileSystemStorage$.MODULE$.ParquetEncoding(), scheme, this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$conf);
    }

    public void createNewFeatureType(SimpleFeatureType sft, PartitionScheme scheme) {
        String typeName = sft.getTypeName();
        if (this.typeNames().contains((Object)typeName)) {
            List newDesc = sft.getAttributeDescriptors();
            List existing = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getSimpleFeatureType().getAttributeDescriptors();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), JavaConversions$.MODULE$.asScalaBuffer(newDesc).length()).foreach$mVc$sp((Function1)new scala.Serializable(this, newDesc, existing){
                public static final long serialVersionUID = 0L;
                public final List newDesc$1;
                public final List existing$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Predef$.MODULE$.require(BoxesRunTime.equals((Object)JavaConversions$.MODULE$.asScalaBuffer(this.newDesc$1).apply(i), (Object)JavaConversions$.MODULE$.asScalaBuffer(this.existing$1).apply(i)), (Function0)new scala.Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$createNewFeatureType$1 $outer;
                        private final int i$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New Attribute Descriptor ", " is not"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((AttributeDescriptor)JavaConversions$.MODULE$.asScalaBuffer(this.$outer.newDesc$1).apply(this.i$1)).getLocalName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"equivalent to existing descriptor ", " at index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((AttributeDescriptor)JavaConversions$.MODULE$.asScalaBuffer(this.$outer.existing$1).apply(this.i$1)).getLocalName(), BoxesRunTime.boxToInteger((int)this.i$1)}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.i$1 = i$1;
                        }
                    });
                }
                {
                    this.newDesc$1 = newDesc$1;
                    this.existing$1 = existing$1;
                }
            });
        } else {
            Cache<Tuple2<Path, String>, Metadata> cache = ParquetFileSystemStorage$.MODULE$.MetadataCache();
            Tuple2 tuple2 = new Tuple2((Object)this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, (Object)typeName);
            FileMetadata metadata = this.createFileMetadata(sft);
            this.typeNames().$plus$eq((Object)typeName);
            cache.put((Object)tuple2, (Object)metadata);
        }
    }

    public List<SimpleFeatureType> listFeatureTypes() {
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.typeNames().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileSystemStorage $outer;

            public final SimpleFeatureType apply(String typeName) {
                return this.$outer.getFeatureType(typeName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ListBuffer$.MODULE$.canBuildFrom()));
    }

    public List<String> listPartitions(String typeName) {
        return this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getPartitions();
    }

    public FileSystemPartitionIterator getPartitionReader(SimpleFeatureType sft, Query q, String partition) {
        Option option;
        block11: {
            Tuple2 tuple2;
            block10: {
                Tuple2 tuple22;
                block9: {
                    option = QueryHints$.MODULE$.RichHints(q.getHints()).getTransformSchema();
                    if (!None$.MODULE$.equals(option)) break block9;
                    tuple2 = new Tuple2((Object)sft, (Object)sft);
                    break block10;
                }
                if (!(option instanceof Some)) break block11;
                Some some = (Some)option;
                SimpleFeatureType tsft = (SimpleFeatureType)some.x();
                Buffer transforms = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(tsft.getAttributeDescriptors()).map((Function1)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AttributeDescriptor x$4) {
                        return x$4.getLocalName();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                Seq filters = (Seq)((SeqLike)FilterHelper$.MODULE$.propertyNames(q.getFilter(), sft).filterNot((Function1)new scala.Serializable(this, transforms){
                    public static final long serialVersionUID = 0L;
                    private final Buffer transforms$1;

                    public final boolean apply(Object elem) {
                        return this.transforms$1.contains(elem);
                    }
                    {
                        this.transforms$1 = transforms$1;
                    }
                })).distinct();
                if (filters.isEmpty()) {
                    tuple22 = new Tuple2((Object)tsft, (Object)tsft);
                } else {
                    SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                    builder.init(tsft);
                    filters.foreach((Function1)new scala.Serializable(this, sft, builder){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;
                        private final SimpleFeatureTypeBuilder builder$1;

                        public final void apply(String f) {
                            this.builder$1.add(this.sft$1.getDescriptor(f));
                        }
                        {
                            this.sft$1 = sft$1;
                            this.builder$1 = builder$1;
                        }
                    });
                    SimpleFeatureType psft = builder.buildFeatureType();
                    psft.getUserData().putAll(sft.getUserData());
                    tuple22 = new Tuple2((Object)psft, (Object)tsft);
                }
                tuple2 = tuple22;
            }
            Tuple2 tuple23 = tuple2;
            if (tuple23 != null) {
                Tuple2 tuple24;
                SimpleFeatureType parquetSft = (SimpleFeatureType)tuple23._1();
                SimpleFeatureType returnSft = (SimpleFeatureType)tuple23._2();
                Tuple2 tuple25 = tuple24 = new Tuple2((Object)parquetSft, (Object)returnSft);
                SimpleFeatureType parquetSft2 = (SimpleFeatureType)tuple25._1();
                SimpleFeatureType returnSft2 = (SimpleFeatureType)tuple25._2();
                Tuple2<Option<FilterPredicate>, Filter> tuple26 = new FilterConverter(parquetSft2).convert(q.getFilter());
                if (tuple26 != null) {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple27;
                    Option fc = (Option)tuple26._1();
                    Filter residualFilter2 = (Filter)tuple26._2();
                    Tuple2 tuple28 = tuple27 = new Tuple2((Object)fc, (Object)residualFilter2);
                    Option fc2 = (Option)tuple28._1();
                    Filter residualFilter3 = (Filter)tuple28._2();
                    FilterCompat.Filter parquetFilter = (FilterCompat.Filter)fc2.map((Function1)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final FilterCompat.Filter apply(FilterPredicate x$1) {
                            return FilterCompat.get((FilterPredicate)x$1);
                        }
                    }).getOrElse((Function0)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final FilterCompat.Filter apply() {
                            return FilterCompat.NOOP;
                        }
                    });
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parquet filter: ", " and modified gt filter ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parquetFilter, residualFilter3})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    None$ transform = parquetSft2 == returnSft2 ? None$.MODULE$ : new Some((Object)returnSft2);
                    Iterator paths = JavaConversions$.MODULE$.asScalaBuffer(this.getPaths(sft.getTypeName(), partition)).toIterator().map((Function1)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(URI x$7) {
                            return new Path(x$7);
                        }
                    }).filter((Function1)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ParquetFileSystemStorage $outer;

                        public final boolean apply(Path x$1) {
                            return this.$outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs.exists(x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    Iterator iters = paths.map((Function1)new scala.Serializable(this, partition, parquetSft2, residualFilter3, parquetFilter, (Option)transform){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ParquetFileSystemStorage $outer;
                        private final String partition$1;
                        private final SimpleFeatureType parquetSft$1;
                        private final Filter residualFilter$1;
                        private final FilterCompat.Filter parquetFilter$1;
                        private final Option transform$1;

                        public final FilteringIterator apply(Path path) {
                            Option option;
                            block4: {
                                FilteringIterator filteringIterator;
                                block3: {
                                    ParquetReader.Builder builder;
                                    block2: {
                                        SimpleFeatureReadSupport support = new SimpleFeatureReadSupport();
                                        Configuration c = new Configuration(this.$outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$conf);
                                        SimpleFeatureReadSupport$.MODULE$.setSft(this.parquetSft$1, c);
                                        Configuration queryConf = c;
                                        builder = ParquetReader.builder((ReadSupport)support, (Path)path).withFilter(this.parquetFilter$1).withConf(queryConf);
                                        option = this.transform$1;
                                        if (!None$.MODULE$.equals(option)) break block2;
                                        filteringIterator = new FilteringIterator(this.partition$1, (ParquetReader.Builder<SimpleFeature>)builder, this.residualFilter$1);
                                        break block3;
                                    }
                                    if (!(option instanceof Some)) break block4;
                                    Some some = (Some)option;
                                    SimpleFeatureType tsft = (SimpleFeatureType)some.x();
                                    filteringIterator = new FilteringTransformIterator(this.partition$1, (ParquetReader.Builder<SimpleFeature>)builder, this.residualFilter$1, this.parquetSft$1, tsft);
                                }
                                return filteringIterator;
                            }
                            throw new MatchError((Object)option);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                            this.parquetSft$1 = parquetSft$1;
                            this.residualFilter$1 = residualFilter$1;
                            this.parquetFilter$1 = parquetFilter$1;
                            this.transform$1 = transform$1;
                        }
                    });
                    return new MultiIterator(partition, (Iterator<FileSystemPartitionIterator>)iters);
                }
                throw new MatchError(tuple26);
            }
            throw new MatchError((Object)tuple23);
        }
        throw new MatchError((Object)option);
    }

    public FileSystemWriter getWriter(String typeName, String partition) {
        return new FileSystemWriter(this, typeName, partition){
            private final Metadata meta;
            private final SimpleFeatureType sft;
            private final Configuration sftConf;
            private final boolean leaf;
            private final Path dataPath;
            private final ParquetWriter<SimpleFeature> writer;

            private Metadata meta() {
                return this.meta;
            }

            private SimpleFeatureType sft() {
                return this.sft;
            }

            private Configuration sftConf() {
                return this.sftConf;
            }

            private boolean leaf() {
                return this.leaf;
            }

            private Path dataPath() {
                return this.dataPath;
            }

            private ParquetWriter<SimpleFeature> writer() {
                return this.writer;
            }

            public void write(SimpleFeature f) {
                this.writer().write((Object)f);
            }

            public void flush() {
            }

            public void close() {
                CloseQuietly$.MODULE$.apply(this.writer());
            }
            {
                this.meta = $outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName$2);
                this.sft = this.meta().getSimpleFeatureType();
                Configuration c = new Configuration($outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$conf);
                SimpleFeatureReadSupport$.MODULE$.setSft(this.sft(), c);
                this.sftConf = c;
                this.leaf = this.meta().getPartitionScheme().isLeafStorage();
                this.dataPath = StorageUtils$.MODULE$.nextFile($outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs, $outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, typeName$2, partition$2, this.leaf(), ParquetFileSystemStorage$.MODULE$.FileExtension(), FileType$.MODULE$.Written());
                this.writer = SimpleFeatureParquetWriter$.MODULE$.builder(this.dataPath(), this.sftConf()).build();
                this.meta().addFile(partition$2, this.dataPath().getName());
            }
        };
    }

    public PartitionScheme getPartitionScheme(String typeName) {
        return this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getPartitionScheme();
    }

    public List<URI> getPaths(String typeName, String partition) {
        PartitionScheme scheme = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getPartitionScheme();
        Path baseDir = scheme.isLeafStorage() ? StorageUtils$.MODULE$.partitionPath(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, typeName, partition).getParent() : StorageUtils$.MODULE$.partitionPath(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, typeName, partition);
        List files = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getFiles(partition);
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(files).map((Function1)new scala.Serializable(this, baseDir){
            public static final long serialVersionUID = 0L;
            private final Path baseDir$1;

            public final URI apply(String x$8) {
                return new Path(this.baseDir$1, x$8).toUri();
            }
            {
                this.baseDir$1 = baseDir$1;
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public Metadata getMetadata(String typeName) {
        return this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName);
    }

    private void cleanBackups(String typeName) {
        Path typePath = new Path(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, typeName);
        RemoteIterator fileItr = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs.listFiles(typePath, false);
        ListBuffer backupFiles = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (fileItr.hasNext()) {
            Path nextPath = ((FileStatus)fileItr.next()).getPath();
            Object object = nextPath.getName().matches(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\\.", "\\\\.old\\\\.\\\\d+.*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ParquetFileSystemStorage$.MODULE$.MetadataFileName()}))) ? backupFiles.$plus$eq((Object)nextPath) : BoxedUnit.UNIT;
        }
        ((TraversableForwarder)((IterableLike)backupFiles.sortBy((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$9) {
                return x$9.getName();
            }
        }, (Ordering)Ordering.String$.MODULE$)).dropRight(5)).foreach((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileSystemStorage $outer;

            public final boolean apply(Path p) {
                BoxedUnit boxedUnit;
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing old metadata backup ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.$outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs.delete(p, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void backupMetadata(String typeName) {
        Path typePath = new Path(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, typeName);
        Path metaPath = new Path(typePath, ParquetFileSystemStorage$.MODULE$.MetadataFileName());
        Path backupFile = new Path(typePath, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".old.", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ParquetFileSystemStorage$.MODULE$.MetadataFileName(), BoxesRunTime.boxToLong((long)System.currentTimeMillis()), BoxesRunTime.boxToLong((long)System.nanoTime())})));
        this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs.rename(metaPath, backupFile);
        IntRef tryNum = IntRef.create((int)0);
        BooleanRef backupComplete = BooleanRef.create((boolean)false);
        do {
            ++tryNum.elem;
        } while (this.waitOnBackup$1(metaPath, backupFile, tryNum, backupComplete) && tryNum.elem <= 3);
        if (backupComplete.elem) {
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to properly backup metadata after ", " tries"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tryNum.elem)})));
    }

    public void updateMetadata(String typeName) {
        BoxedUnit boxedUnit;
        long s = System.currentTimeMillis();
        PartitionScheme scheme = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getPartitionScheme();
        SimpleFeatureType sft = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).getSimpleFeatureType();
        Map parts = StorageUtils$.MODULE$.partitionsAndFiles(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs, typeName, scheme, ParquetFileSystemStorage$.MODULE$.FileExtension());
        this.backupMetadata(typeName);
        this.cleanBackups(typeName);
        FileMetadata newMetadata = this.createFileMetadata(sft);
        ParquetFileSystemStorage$.MODULE$.MetadataCache().invalidate((Object)new Tuple2((Object)this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, (Object)typeName));
        ParquetFileSystemStorage$.MODULE$.MetadataCache().put((Object)new Tuple2((Object)this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, (Object)typeName), (Object)newMetadata);
        this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName).addPartitions(parts);
        long e = System.currentTimeMillis();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metadata Update took in ", "ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(e - s))})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void compact(String typeName, String partition) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        List<URI> existingFiles = this.getPaths(typeName, partition);
        Metadata meta = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$metadata(typeName);
        SimpleFeatureType sft = meta.getSimpleFeatureType();
        Configuration c = new Configuration(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$conf);
        SimpleFeatureReadSupport$.MODULE$.setSft(sft, c);
        Configuration sftConf = c;
        boolean leaf = meta.getPartitionScheme().isLeafStorage();
        Path dataPath = StorageUtils$.MODULE$.nextFile(this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs, this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root, typeName, partition, leaf, ParquetFileSystemStorage$.MODULE$.FileExtension(), FileType$.MODULE$.Compacted());
        ParquetWriter writer = SimpleFeatureParquetWriter$.MODULE$.builder(dataPath, sftConf).build();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compacting data files: [", "] to into file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(existingFiles).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(URI x$10) {
                    return x$10.toString();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(", "), dataPath})));
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        SimpleFeatureReadSupport support = new SimpleFeatureReadSupport();
        long written = BoxesRunTime.unboxToLong((Object)((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(existingFiles).map((Function1)new scala.Serializable(this, sftConf, writer, support){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileSystemStorage $outer;
            private final Configuration sftConf$1;
            private final ParquetWriter writer$1;
            private final SimpleFeatureReadSupport support$1;

            /*
             * WARNING - void declaration
             */
            public final long apply(URI f) {
                BoxedUnit boxedUnit;
                if (this.$outer.logger().underlying().isDebugEnabled()) {
                    this.$outer.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ParquetReader reader = ParquetReader.builder((ReadSupport)this.support$1, (Path)new Path(f)).withConf(this.sftConf$1).build();
                SimpleFeature sf = (SimpleFeature)reader.read();
                long count = 0L;
                while (sf != null) {
                    void var2_2;
                    void var4_4;
                    SimpleFeature simpleFeature;
                    this.writer$1.write((Object)simpleFeature);
                    ++var4_4;
                    simpleFeature = (SimpleFeature)var2_2.read();
                }
                return count;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sftConf$1 = sftConf$1;
                this.writer$1 = writer$1;
                this.support$1 = support$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        writer.close();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrote compacted file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataPath})));
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting old files [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(existingFiles).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(URI x$11) {
                    return x$11.toString();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")})));
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        boolean deleteResult = JavaConversions$.MODULE$.asScalaBuffer(existingFiles).forall((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileSystemStorage $outer;

            public final boolean apply(URI f) {
                return this.$outer.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs.delete(new Path(f), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (deleteResult) {
            boxedUnit3 = BoxedUnit.UNIT;
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete all files: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(existingFiles).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(URI x$12) {
                    return x$12.toString();
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")})));
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating metadata for type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.updateMetadata(typeName);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compacted ", " records into file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)written), dataPath})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final boolean waitOnBackup$1(Path metaPath$1, Path backupFile$1, IntRef tryNum$1, BooleanRef backupComplete$1) {
        boolean bl = backupComplete$1.elem = this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs.exists(backupFile$1) && !this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs.exists(metaPath$1);
        if (!backupComplete$1.elem) {
            int secs = 2 ^ tryNum$1.elem;
            Thread.sleep(1000 * secs);
        }
        return !backupComplete$1.elem;
    }

    public ParquetFileSystemStorage(Path root, FileSystem fs, Configuration conf, Map<String, Serializable> dsParams) {
        BoxedUnit boxedUnit;
        this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$root = root;
        this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$fs = fs;
        this.org$locationtech$geomesa$parquet$ParquetFileSystemStorage$$conf = conf;
        LazyLogging.class.$init$((LazyLogging)this);
        long s = System.currentTimeMillis();
        ListBuffer b = (ListBuffer)ListBuffer$.MODULE$.empty();
        if (fs.exists(root)) {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(root)).filter((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus x$1) {
                    return x$1.isDirectory();
                }
            })).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$2) {
                    return x$2.getPath().getName();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new scala.Serializable(this, b){
                public static final long serialVersionUID = 0L;
                private final ListBuffer b$1;

                public final ListBuffer<String> apply(String x$3) {
                    return this.b$1.$plus$eq((Object)x$3);
                }
                {
                    this.b$1 = b$1;
                }
            });
        }
        long e = System.currentTimeMillis();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Type loading took ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(e - s))})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.typeNames = b;
    }
}

