/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorageFactory;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u0017\ty\u0002+\u0019:rk\u0016$h)\u001b7f'f\u001cH/Z7Ti>\u0014\u0018mZ3GC\u000e$xN]=\u000b\u0005\r!\u0011a\u00029beF,X\r\u001e\u0006\u0003\u000b\u0019\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\b\u0011\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+qi\u0011A\u0006\u0006\u0003/a\t1!\u00199j\u0015\tI\"$A\u0004ti>\u0014\u0018mZ3\u000b\u0005m!\u0011A\u00014t\u0013\tibC\u0001\rGS2,7+_:uK6\u001cFo\u001c:bO\u00164\u0015m\u0019;pefDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"\u0001\u0002\t\u000b\u0011\u0002A\u0011I\u0013\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t9!i\\8mK\u0006t\u0007\"B\u0017$\u0001\u0004q\u0013A\u00029be\u0006l7\u000f\u0005\u00030eQZT\"\u0001\u0019\u000b\u0005E\u0002\u0012\u0001B;uS2L!a\r\u0019\u0003\u00075\u000b\u0007\u000f\u0005\u00026q9\u0011qEN\u0005\u0003o!\na\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011q\u0007\u000b\t\u0003y}j\u0011!\u0010\u0006\u0003}A\t!![8\n\u0005\u0001k$\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\"\u0001\t\u0003\u001a\u0015!\u00022vS2$GC\u0001#H!\t\u0011S)\u0003\u0002G\u0005\tA\u0002+\u0019:rk\u0016$h)\u001b7f'f\u001cH/Z7Ti>\u0014\u0018mZ3\t\u000b5\n\u0005\u0019\u0001\u0018")
public class ParquetFileSystemStorageFactory
implements FileSystemStorageFactory {
    public boolean canProcess(Map<String, Serializable> params) {
        return params.containsKey("fs.path") && params.containsKey("fs.encoding") && ((String)((Object)params.get("fs.encoding"))).equals(ParquetFileSystemStorage$.MODULE$.ParquetEncoding());
    }

    public ParquetFileSystemStorage build(Map<String, Serializable> params) {
        String path = (String)((Object)params.get("fs.path"));
        Path root = new Path(path);
        Configuration conf = new Configuration();
        if (params.containsKey(ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt())) {
            conf.set(ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt(), (String)((Object)params.get(ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt())));
        } else if (System.getProperty(ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt()) != null) {
            conf.set(ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt(), System.getProperty(ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt()));
        }
        conf.set("parquet.filter.dictionary.enabled", "true");
        return new ParquetFileSystemStorage(root, root.getFileSystem(conf), conf, params);
    }
}

