/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.locationtech.geomesa.parquet.SimpleFeatureParquetWriter;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

public final class SimpleFeatureParquetWriter$
implements LazyLogging {
    public static final SimpleFeatureParquetWriter$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SimpleFeatureParquetWriter$();
    }

    private Logger logger$lzycompute() {
        SimpleFeatureParquetWriter$ simpleFeatureParquetWriter$ = this;
        synchronized (simpleFeatureParquetWriter$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public SimpleFeatureParquetWriter.Builder builder(Path file, Configuration conf) {
        BoxedUnit boxedUnit;
        CompressionCodecName codec = CompressionCodecName.fromConf((String)conf.get("parquet.compression", "SNAPPY"));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using Parquet Compression codec ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{codec.name()})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (SimpleFeatureParquetWriter.Builder)new SimpleFeatureParquetWriter.Builder(file).withConf(conf).withCompressionCodec(codec).withDictionaryEncoding(true).withDictionaryPageSize(0x100000).withMaxPaddingSize(0).withPageSize(0x100000).withValidation(false).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0).withRowGroupSize(0x8000000);
    }

    private SimpleFeatureParquetWriter$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

