/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet.io;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchema;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchema$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureWriteSupport$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureWriteSupport$MultiPolygonAttributeWriter$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureWriteSupport$SimpleFeatureWriter$;
import org.locationtech.geomesa.utils.text.WKBUtils$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0015Ec\u0001B\u0001\u0003\u00015\u0011\u0011dU5na2,g)Z1ukJ,wK]5uKN+\b\u000f]8si*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\u000fA\f'/];fi*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002E\u0002\u0010/ei\u0011\u0001\u0005\u0006\u0003#I\t1!\u00199j\u0015\t\u0019B#\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003\u000bUQ!A\u0006\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tA\u0002C\u0001\u0007Xe&$XmU;qa>\u0014H\u000f\u0005\u0002\u001bC5\t1D\u0003\u0002\u001d;\u000511/[7qY\u0016T!AH\u0010\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0001EC\u0001\b_B,gnZ5t\u0013\t\u00113DA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\u0006I\u0001!\t!J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0002\"a\n\u0001\u000e\u0003\tA\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0002\u0016\u0002\r]\u0014\u0018\u000e^3s+\u0005Y\u0003C\u0001\u0017;\u001d\t9SfB\u0003/\u0005!\u0005q&A\rTS6\u0004H.\u001a$fCR,(/Z,sSR,7+\u001e9q_J$\bCA\u00141\r\u0015\t!\u0001#\u00012'\t\u0001$\u0007\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DG\u0001\u0004B]f\u0014VM\u001a\u0005\u0006IA\"\t!\u000f\u000b\u0002_\u0019!1\b\r\u0001=\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s'\tQ$\u0007\u0003\u0005?u\t\u0005\t\u0015!\u0003@\u0003)\tG\u000f\u001e:jEV$Xm\u001d\t\u0004g\u0001\u0013\u0015BA!5\u0005\u0015\t%O]1z!\r\u0019EIM\u0007\u0002a\u0019)Q\tMA\u0001\r\ny\u0011\t\u001e;sS\n,H/Z,sSR,'/\u0006\u0002H7N\u0011AI\r\u0005\t\u0013\u0012\u0013\t\u0011)A\u0005\u0015\u0006!a.Y7f!\tYeJ\u0004\u00024\u0019&\u0011Q\nN\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002Ni!A!\u000b\u0012B\u0001B\u0003%1+A\u0003j]\u0012,\u0007\u0010\u0005\u00024)&\u0011Q\u000b\u000e\u0002\u0004\u0013:$\b\"\u0002\u0013E\t\u00039Fc\u0001-bEB\u00191\tR-\u0011\u0005i[F\u0002\u0001\u0003\u00069\u0012\u0013\r!\u0018\u0002\u0002)F\u0011aL\r\t\u0003g}K!\u0001\u0019\u001b\u0003\u000f9{G\u000f[5oO\")\u0011J\u0016a\u0001\u0015\")!K\u0016a\u0001'\")A\r\u0012C\u0001K\u0006)\u0011\r\u001d9msR\u0019a-[9\u0011\u0005M:\u0017B\u000155\u0005\u0011)f.\u001b;\t\u000b)\u001c\u0007\u0019A6\u0002\u0011\r|gn];nKJ\u0004\"\u0001\\8\u000e\u00035T!!\u00058\u000b\u0005\r!\u0012B\u00019n\u00059\u0011VmY8sI\u000e{gn];nKJDQA]2A\u0002e\u000bQA^1mk\u0016DQ\u0001\u001e#\u0007\u0012U\fQa\u001e:ji\u0016$2A\u001a<x\u0011\u0015Q7\u000f1\u0001l\u0011\u0015\u00118\u000f1\u0001Z\u0011\u0015!#\b\"\u0001z)\tQ8\u0010\u0005\u0002Du!)a\b\u001fa\u0001\u007f!9QP\u000fb\u0001\n\u0013q\u0018\u0001\u00024jIN,\u0012a \t\u0004\u0007\u0006\u0005aABA\u0002a\u0001\t)AA\u0005GS\u0012<&/\u001b;feN!\u0011\u0011AA\u0004!\r\u0019EI\u0013\u0005\n%\u0006\u0005!\u0011!Q\u0001\nMCq\u0001JA\u0001\t\u0003\ti\u0001F\u0002\u0000\u0003\u001fAaAUA\u0006\u0001\u0004\u0019\u0006b\u0002;\u0002\u0002\u0011E\u00131\u0003\u000b\u0006M\u0006U\u0011q\u0003\u0005\u0007U\u0006E\u0001\u0019A6\t\rI\f\t\u00021\u0001K\u0011\u001d\tYB\u000fQ\u0001\n}\fQAZ5eg\u0002Ba\u0001\u001e\u001e\u0005\u0002\u0005}A#\u00024\u0002\"\u0005\r\u0002B\u00026\u0002\u001e\u0001\u00071\u000e\u0003\u0004s\u0003;\u0001\r!G\u0004\b\u0003O\u0001\u0004\u0012AA\u0015\u0003M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s!\r\u0019\u00151\u0006\u0004\u0007wAB\t!!\f\u0014\u0007\u0005-\"\u0007C\u0004%\u0003W!\t!!\r\u0015\u0005\u0005%\u0002b\u00023\u0002,\u0011\u0005\u0011Q\u0007\u000b\u0004u\u0006]\u0002\u0002CA\u001d\u0003g\u0001\r!a\u000f\u0002\u0007M4G\u000fE\u0002\u001b\u0003{I1!a\u0010\u001c\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\b\u0003\u0007\u0002D\u0011AA#\u0003%\tG\u000f\u001e:jEV$X\r\u0006\u0004\u0002H\u0005e\u0013\u0011\u000e\u0019\u0005\u0003\u0013\ni\u0005\u0005\u0003D\t\u0006-\u0003c\u0001.\u0002N\u0011a\u0011qJA!\u0003\u0003\u0005\tQ!\u0001\u0002R\t\u0019q\fJ\u0019\u0012\u0007y\u000b\u0019\u0006E\u00024\u0003+J1!a\u00165\u0005\r\te.\u001f\u0005\t\u00037\n\t\u00051\u0001\u0002^\u0005QA-Z:de&\u0004Ho\u001c:\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019\u001e\u0003\u0011!\u0018\u0010]3\n\t\u0005\u001d\u0014\u0011\r\u0002\u0014\u0003R$(/\u001b2vi\u0016$Um]2sSB$xN\u001d\u0005\u0007%\u0006\u0005\u0003\u0019A*\t\u000f\u0005\r\u0003\u0007\"\u0001\u0002nQA\u0011qNA=\u0003w\ni\b\r\u0003\u0002r\u0005U\u0004\u0003B\"E\u0003g\u00022AWA;\t1\t9(a\u001b\u0002\u0002\u0003\u0005)\u0011AA)\u0005\ryFE\r\u0005\u0007\u0013\u0006-\u0004\u0019\u0001&\t\rI\u000bY\u00071\u0001T\u0011!\ty(a\u001bA\u0002\u0005\u0005\u0015\u0001\u00032j]\u0012LgnZ:\u0011\r\u0005\r\u00151SAM\u001d\u0011\t))a$\u000f\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#\r\u0003\u0019a$o\\8u}%\tQ'C\u0002\u0002\u0012R\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0006]%aA*fc*\u0019\u0011\u0011\u0013\u001b\u0011\t\u0005m\u0015Q\u0018\b\u0005\u0003;\u000b9L\u0004\u0003\u0002 \u0006Ef\u0002BAQ\u0003[sA!a)\u0002,:!\u0011QUAU\u001d\u0011\t9)a*\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011bAAX\r\u0005)Q\u000f^5mg&!\u00111WA[\u0003!9Wm\u001c;p_2\u001c(bAAX\r%!\u0011\u0011XA^\u0003)y%M[3diRK\b/\u001a\u0006\u0005\u0003g\u000b),\u0003\u0003\u0002@\u0006\u0005'AC(cU\u0016\u001cG\u000fV=qK*!\u0011\u0011XA^\u0011\u001d\t)\r\rC\u0005\u0003\u000f\f\u0001bZ3p[\u0016$(/\u001f\u000b\t\u0003\u0013\f\u0019.!6\u0002XB\"\u00111ZAh!\u0011\u0019E)!4\u0011\u0007i\u000by\r\u0002\u0007\u0002R\u0006\r\u0017\u0011!A\u0001\u0006\u0003\t\tFA\u0002`IMBa!SAb\u0001\u0004Q\u0005B\u0002*\u0002D\u0002\u00071\u000b\u0003\u0005\u0002Z\u0006\r\u0007\u0019AAM\u0003\u001d\u0011\u0017N\u001c3j]\u001e4a!!81\u0001\u0005}'A\u0003#bi\u0016<&/\u001b;feN!\u00111\\Aq!\u0011\u0019E)a9\u0011\t\u0005\u0015\u0018q^\u0007\u0003\u0003OTA!!;\u0002l\u0006!Q\u000f^5m\u0015\t\ti/\u0001\u0003kCZ\f\u0017\u0002BAy\u0003O\u0014A\u0001R1uK\"I\u0011*a7\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\u0006m'\u0011!Q\u0001\nMCq\u0001JAn\t\u0003\tI\u0010\u0006\u0004\u0002|\u0006u\u0018q \t\u0004\u0007\u0006m\u0007BB%\u0002x\u0002\u0007!\n\u0003\u0004S\u0003o\u0004\ra\u0015\u0005\bi\u0006mG\u0011\u000bB\u0002)\u00151'Q\u0001B\u0004\u0011\u0019Q'\u0011\u0001a\u0001W\"9!O!\u0001A\u0002\u0005\rhA\u0002B\u0006a\u0001\u0011iA\u0001\u0007E_V\u0014G.Z,sSR,'o\u0005\u0003\u0003\n\t=\u0001\u0003B\"E\u0005#\u0001BAa\u0005\u0003\u001a5\u0011!Q\u0003\u0006\u0005\u0005/\tY/\u0001\u0003mC:<\u0017\u0002\u0002B\u000e\u0005+\u0011a\u0001R8vE2,\u0007\"C%\u0003\n\t\u0005\t\u0015!\u0003K\u0011%\u0011&\u0011\u0002B\u0001B\u0003%1\u000bC\u0004%\u0005\u0013!\tAa\t\u0015\r\t\u0015\"q\u0005B\u0015!\r\u0019%\u0011\u0002\u0005\u0007\u0013\n\u0005\u0002\u0019\u0001&\t\rI\u0013\t\u00031\u0001T\u0011\u001d!(\u0011\u0002C)\u0005[!RA\u001aB\u0018\u0005cAaA\u001bB\u0016\u0001\u0004Y\u0007b\u0002:\u0003,\u0001\u0007!\u0011\u0003\u0004\u0007\u0005k\u0001\u0004Aa\u000e\u0003\u0017\u0019cw.\u0019;Xe&$XM]\n\u0005\u0005g\u0011I\u0004\u0005\u0003D\t\nm\u0002\u0003\u0002B\n\u0005{IAAa\u0010\u0003\u0016\t)a\t\\8bi\"I\u0011Ja\r\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\nM\"\u0011!Q\u0001\nMCq\u0001\nB\u001a\t\u0003\u00119\u0005\u0006\u0004\u0003J\t-#Q\n\t\u0004\u0007\nM\u0002BB%\u0003F\u0001\u0007!\n\u0003\u0004S\u0005\u000b\u0002\ra\u0015\u0005\bi\nMB\u0011\u000bB))\u00151'1\u000bB+\u0011\u0019Q'q\na\u0001W\"9!Oa\u0014A\u0002\tmbA\u0002B-a\u0001\u0011YFA\u0007J]R,w-\u001a:Xe&$XM]\n\u0005\u0005/\u0012i\u0006\u0005\u0003D\t\n}\u0003\u0003\u0002B\n\u0005CJAAa\u0019\u0003\u0016\t9\u0011J\u001c;fO\u0016\u0014\b\"C%\u0003X\t\u0005\t\u0015!\u0003K\u0011%\u0011&q\u000bB\u0001B\u0003%1\u000bC\u0004%\u0005/\"\tAa\u001b\u0015\r\t5$q\u000eB9!\r\u0019%q\u000b\u0005\u0007\u0013\n%\u0004\u0019\u0001&\t\rI\u0013I\u00071\u0001T\u0011\u001d!(q\u000bC)\u0005k\"RA\u001aB<\u0005sBaA\u001bB:\u0001\u0004Y\u0007b\u0002:\u0003t\u0001\u0007!q\f\u0004\u0007\u0005{\u0002\u0004Aa \u0003\u00151{gnZ,sSR,'o\u0005\u0003\u0003|\t\u0005\u0005\u0003B\"E\u0005\u0007\u0003BAa\u0005\u0003\u0006&!!q\u0011B\u000b\u0005\u0011auN\\4\t\u0013%\u0013YH!A!\u0002\u0013Q\u0005\"\u0003*\u0003|\t\u0005\t\u0015!\u0003T\u0011\u001d!#1\u0010C\u0001\u0005\u001f#bA!%\u0003\u0014\nU\u0005cA\"\u0003|!1\u0011J!$A\u0002)CaA\u0015BG\u0001\u0004\u0019\u0006b\u0002;\u0003|\u0011E#\u0011\u0014\u000b\u0006M\nm%Q\u0014\u0005\u0007U\n]\u0005\u0019A6\t\u000fI\u00149\n1\u0001\u0003\u0004\u001a1!\u0011\u0015\u0019\u0001\u0005G\u0013Ab\u0015;sS:<wK]5uKJ\u001cBAa(\u0002\b!I\u0011Ja(\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\n}%\u0011!Q\u0001\nMCq\u0001\nBP\t\u0003\u0011Y\u000b\u0006\u0004\u0003.\n=&\u0011\u0017\t\u0004\u0007\n}\u0005BB%\u0003*\u0002\u0007!\n\u0003\u0004S\u0005S\u0003\ra\u0015\u0005\bi\n}E\u0011\u000bB[)\u00151'q\u0017B]\u0011\u0019Q'1\u0017a\u0001W\"1!Oa-A\u0002)3aA!01\u0001\t}&a\u0003\"zi\u0016\u001cxK]5uKJ\u001cBAa/\u0003BB!1\t\u0012Bb!\u0011\u0019\u0004I!2\u0011\u0007M\u00129-C\u0002\u0003JR\u0012AAQ=uK\"I\u0011Ja/\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\nm&\u0011!Q\u0001\nMCq\u0001\nB^\t\u0003\u0011\t\u000e\u0006\u0004\u0003T\nU'q\u001b\t\u0004\u0007\nm\u0006BB%\u0003P\u0002\u0007!\n\u0003\u0004S\u0005\u001f\u0004\ra\u0015\u0005\bi\nmF\u0011\u000bBn)\u00151'Q\u001cBp\u0011\u0019Q'\u0011\u001ca\u0001W\"9!O!7A\u0002\t\rgA\u0002Bra\u0001\u0011)OA\u0007C_>dW-\u00198Xe&$XM]\n\u0005\u0005C\u00149\u000f\u0005\u0003D\t\n%\b\u0003\u0002B\n\u0005WLAA!<\u0003\u0016\t9!i\\8mK\u0006t\u0007\"C%\u0003b\n\u0005\t\u0015!\u0003K\u0011%\u0011&\u0011\u001dB\u0001B\u0003%1\u000bC\u0004%\u0005C$\tA!>\u0015\r\t](\u0011 B~!\r\u0019%\u0011\u001d\u0005\u0007\u0013\nM\b\u0019\u0001&\t\rI\u0013\u0019\u00101\u0001T\u0011\u001d!(\u0011\u001dC)\u0005\u007f$RAZB\u0001\u0007\u0007AaA\u001bB\u007f\u0001\u0004Y\u0007b\u0002:\u0003~\u0002\u0007!\u0011\u001e\u0004\u0007\u0007\u000f\u0001\u0004a!\u0003\u0003\u00151K7\u000f^,sSR,'o\u0005\u0003\u0004\u0006\r-\u0001\u0003B\"E\u0007\u001b\u0001R!!:\u0004\u0010IJAa!\u0005\u0002h\n!A*[:u\u0011%I5Q\u0001B\u0001B\u0003%!\nC\u0005S\u0007\u000b\u0011\t\u0011)A\u0005'\"Y1\u0011DB\u0003\u0005\u0003\u0005\u000b\u0011BAM\u0003%1\u0018\r\\;f)f\u0004X\rC\u0004%\u0007\u000b!\ta!\b\u0015\u0011\r}1\u0011EB\u0012\u0007K\u00012aQB\u0003\u0011\u0019I51\u0004a\u0001\u0015\"1!ka\u0007A\u0002MC\u0001b!\u0007\u0004\u001c\u0001\u0007\u0011\u0011\u0014\u0005\u000b\u0007S\u0019)A1A\u0005\n\r-\u0012!D3mK6,g\u000e^,sSR,'/F\u0001C\u0011!\u0019yc!\u0002!\u0002\u0013\u0011\u0015AD3mK6,g\u000e^,sSR,'\u000f\t\u0005\bi\u000e\u0015A\u0011KB\u001a)\u001517QGB\u001c\u0011\u0019Q7\u0011\u0007a\u0001W\"9!o!\rA\u0002\r5aABB\u001ea\u0001\u0019iDA\u0005NCB<&/\u001b;feN!1\u0011HB !\u0011\u0019Ei!\u0011\u0011\r\u0005\u001581\t\u001a3\u0013\u0011\u0019)%a:\u0003\u00075\u000b\u0007\u000fC\u0005J\u0007s\u0011\t\u0011)A\u0005\u0015\"I!k!\u000f\u0003\u0002\u0003\u0006Ia\u0015\u0005\f\u0007\u001b\u001aID!A!\u0002\u0013\tI*A\u0004lKf$\u0016\u0010]3\t\u0017\re1\u0011\bB\u0001B\u0003%\u0011\u0011\u0014\u0005\bI\reB\u0011AB*))\u0019)fa\u0016\u0004Z\rm3Q\f\t\u0004\u0007\u000ee\u0002BB%\u0004R\u0001\u0007!\n\u0003\u0004S\u0007#\u0002\ra\u0015\u0005\t\u0007\u001b\u001a\t\u00061\u0001\u0002\u001a\"A1\u0011DB)\u0001\u0004\tI\n\u0003\u0006\u0004b\re\"\u0019!C\u0005\u0007W\t\u0011b[3z/JLG/\u001a:\t\u0011\r\u00154\u0011\bQ\u0001\n\t\u000b!b[3z/JLG/\u001a:!\u0011)\u0019Ig!\u000fC\u0002\u0013%11F\u0001\fm\u0006dW/Z,sSR,'\u000f\u0003\u0005\u0004n\re\u0002\u0015!\u0003C\u000311\u0018\r\\;f/JLG/\u001a:!\u0011\u001d!8\u0011\bC)\u0007c\"RAZB:\u0007kBaA[B8\u0001\u0004Y\u0007b\u0002:\u0004p\u0001\u00071\u0011\t\u0004\u0007\u0007s\u0002\u0004aa\u001f\u0003\u0015U+\u0018\u000eZ,sSR,'o\u0005\u0003\u0004x\ru\u0004\u0003B\"E\u0007\u007f\u0002B!!:\u0004\u0002&!11QAt\u0005\u0011)V+\u0013#\t\u0013%\u001b9H!A!\u0002\u0013Q\u0005\"\u0003*\u0004x\t\u0005\t\u0015!\u0003T\u0011\u001d!3q\u000fC\u0001\u0007\u0017#ba!$\u0004\u0010\u000eE\u0005cA\"\u0004x!1\u0011j!#A\u0002)CaAUBE\u0001\u0004\u0019\u0006b\u0002;\u0004x\u0011E3Q\u0013\u000b\u0006M\u000e]5\u0011\u0014\u0005\u0007U\u000eM\u0005\u0019A6\t\u000fI\u001c\u0019\n1\u0001\u0004\u0000\u001911Q\u0014\u0019\u0001\u0007?\u0013A\u0003U8j]R\fE\u000f\u001e:jEV$Xm\u0016:ji\u0016\u00148\u0003BBN\u0007C\u0003Ba\u0011#\u0004$B!1QUBX\u001b\t\u00199K\u0003\u0003\u0004*\u000e-\u0016\u0001B4f_6T1a!,\t\u0003\rQGo]\u0005\u0005\u0007c\u001b9KA\u0003Q_&tG\u000fC\u0005J\u00077\u0013\t\u0011)A\u0005\u0015\"I!ka'\u0003\u0002\u0003\u0006Ia\u0015\u0005\bI\rmE\u0011AB])\u0019\u0019Yl!0\u0004@B\u00191ia'\t\r%\u001b9\f1\u0001K\u0011\u0019\u00116q\u0017a\u0001'\"9Aoa'\u0005B\r\rG#\u00024\u0004F\u000e\u001d\u0007B\u00026\u0004B\u0002\u00071\u000eC\u0004s\u0007\u0003\u0004\raa)\u0007\r\r-\u0007\u0007ABg\u0005ea\u0015N\\3TiJLgnZ!uiJL'-\u001e;f/JLG/\u001a:\u0014\t\r%7q\u001a\t\u0005\u0007\u0012\u001b\t\u000e\u0005\u0003\u0004&\u000eM\u0017\u0002BBk\u0007O\u0013!\u0002T5oKN#(/\u001b8h\u0011%I5\u0011\u001aB\u0001B\u0003%!\nC\u0005S\u0007\u0013\u0014\t\u0011)A\u0005'\"9Ae!3\u0005\u0002\ruGCBBp\u0007C\u001c\u0019\u000fE\u0002D\u0007\u0013Da!SBn\u0001\u0004Q\u0005B\u0002*\u0004\\\u0002\u00071\u000bC\u0004u\u0007\u0013$\tea:\u0015\u000b\u0019\u001cIoa;\t\r)\u001c)\u000f1\u0001l\u0011\u001d\u00118Q\u001da\u0001\u0007#4aaa<1\u0001\rE(!G'vYRL\u0007k\\5oi\u0006#HO]5ckR,wK]5uKJ\u001cBa!<\u0004tB!1\tRB{!\u0011\u0019)ka>\n\t\re8q\u0015\u0002\u000b\u001bVdG/\u001b)pS:$\b\"C%\u0004n\n\u0005\t\u0015!\u0003K\u0011%\u00116Q\u001eB\u0001B\u0003%1\u000bC\u0004%\u0007[$\t\u0001\"\u0001\u0015\r\u0011\rAQ\u0001C\u0004!\r\u00195Q\u001e\u0005\u0007\u0013\u000e}\b\u0019\u0001&\t\rI\u001by\u00101\u0001T\u0011\u001d!8Q\u001eC!\t\u0017!RA\u001aC\u0007\t\u001fAaA\u001bC\u0005\u0001\u0004Y\u0007b\u0002:\u0005\n\u0001\u00071Q\u001f\u0004\b\t'\u0001\u0014\u0011\u0001C\u000b\u0005M\t%m\u001d;sC\u000e$H*\u001b8fg^\u0013\u0018\u000e^3s+\u0011!9\u0002\"\b\u0014\t\u0011EA\u0011\u0004\t\u0005\u0007\u0012#Y\u0002E\u0002[\t;!q\u0001\u0018C\t\u0005\u0004!y\"E\u0002_\tC\u0001Ba!*\u0005$%!AQEBT\u0005!9Um\\7fiJL\b\"C%\u0005\u0012\t\u0005\t\u0015!\u0003K\u0011%\u0011F\u0011\u0003B\u0001B\u0003%1\u000bC\u0004%\t#!\t\u0001\"\f\u0015\r\u0011=B\u0011\u0007C\u001a!\u0015\u0019E\u0011\u0003C\u000e\u0011\u0019IE1\u0006a\u0001\u0015\"1!\u000bb\u000bA\u0002MC\u0001\u0002b\u000e\u0005\u0012\u0019EA\u0011H\u0001\u0006Y&tWm\u001d\u000b\u0005\tw!i\u0004\u0005\u0004\u0002\u0004\u0006M5\u0011\u001b\u0005\be\u0012U\u0002\u0019\u0001C\u000e\u0011\u001d!H\u0011\u0003C!\t\u0003\"RA\u001aC\"\t\u000bBaA\u001bC \u0001\u0004Y\u0007b\u0002:\u0005@\u0001\u0007A1\u0004\u0004\u0007\t\u0013\u0002\u0004\u0001b\u0013\u0003-A{G._4p]\u0006#HO]5ckR,wK]5uKJ\u001cB\u0001b\u0012\u0005NA)1\t\"\u0005\u0005PA!1Q\u0015C)\u0013\u0011!\u0019fa*\u0003\u000fA{G._4p]\"I\u0011\nb\u0012\u0003\u0002\u0003\u0006IA\u0013\u0005\n%\u0012\u001d#\u0011!Q\u0001\nMCq\u0001\nC$\t\u0003!Y\u0006\u0006\u0004\u0005^\u0011}C\u0011\r\t\u0004\u0007\u0012\u001d\u0003BB%\u0005Z\u0001\u0007!\n\u0003\u0004S\t3\u0002\ra\u0015\u0005\t\to!9\u0005\"\u0015\u0005fQ!A1\bC4\u0011\u001d\u0011H1\ra\u0001\t\u001f2a\u0001b\u001b1\u0001\u00115$AH'vYRLG*\u001b8f'R\u0014\u0018N\\4BiR\u0014\u0018NY;uK^\u0013\u0018\u000e^3s'\u0011!I\u0007b\u001c\u0011\u000b\r#\t\u0002\"\u001d\u0011\t\r\u0015F1O\u0005\u0005\tk\u001a9KA\bNk2$\u0018\u000eT5oKN#(/\u001b8h\u0011%IE\u0011\u000eB\u0001B\u0003%!\nC\u0005S\tS\u0012\t\u0011)A\u0005'\"9A\u0005\"\u001b\u0005\u0002\u0011uDC\u0002C@\t\u0003#\u0019\tE\u0002D\tSBa!\u0013C>\u0001\u0004Q\u0005B\u0002*\u0005|\u0001\u00071\u000b\u0003\u0005\u00058\u0011%D\u0011\u000bCD)\u0011!Y\u0004\"#\t\u000fI$)\t1\u0001\u0005r\u00191AQ\u0012\u0019\u0001\t\u001f\u00131$T;mi&\u0004v\u000e\\=h_:\fE\u000f\u001e:jEV$Xm\u0016:ji\u0016\u00148\u0003\u0002CF\t#\u0003Ba\u0011#\u0005\u0014B!1Q\u0015CK\u0013\u0011!9ja*\u0003\u00195+H\u000e^5Q_2Lxm\u001c8\t\u0013%#YI!A!\u0002\u0013Q\u0005\"\u0003*\u0005\f\n\u0005\t\u0015!\u0003T\u0011\u001d!C1\u0012C\u0001\t?#b\u0001\")\u0005$\u0012\u0015\u0006cA\"\u0005\f\"1\u0011\n\"(A\u0002)CaA\u0015CO\u0001\u0004\u0019\u0006b\u0002;\u0005\f\u0012\u0005C\u0011\u0016\u000b\u0006M\u0012-FQ\u0016\u0005\u0007U\u0012\u001d\u0006\u0019A6\t\u000fI$9\u000b1\u0001\u0005\u0014\"9A\u0011\u0017\u0019\u0005\n\u0011M\u0016\u0001E<sSR,G*\u001b8f'R\u0014\u0018N\\4Y)\u00151GQ\u0017C\\\u0011\u0019QGq\u0016a\u0001W\"AA\u0011\u0018CX\u0001\u0004\u0019\t.\u0001\u0003sS:<\u0007b\u0002C_a\u0011%AqX\u0001\u0011oJLG/\u001a'j]\u0016\u001cFO]5oOf#RA\u001aCa\t\u0007DaA\u001bC^\u0001\u0004Y\u0007\u0002\u0003C]\tw\u0003\ra!5\u0007\r\u0011\u001d\u0007\u0007\u0001Ce\u0005i9Um\\7fiJLxk\u001b2BiR\u0014\u0018NY;uK^\u0013\u0018\u000e^3s'\u0011!)\rb3\u0011\t\r#E\u0011\u0005\u0005\n\u0013\u0012\u0015'\u0011!Q\u0001\n)C\u0011B\u0015Cc\u0005\u0003\u0005\u000b\u0011B*\t\u000f\u0011\")\r\"\u0001\u0005TR1AQ\u001bCl\t3\u00042a\u0011Cc\u0011\u0019IE\u0011\u001ba\u0001\u0015\"1!\u000b\"5A\u0002MCq\u0001\u001eCc\t#\"i\u000eF\u0003g\t?$\t\u000f\u0003\u0004k\t7\u0004\ra\u001b\u0005\be\u0012m\u0007\u0019\u0001C\u0011\u0011-!)\u000f\u0001a\u0001\u0002\u0004%I\u0001b:\u0002\u0015]\u0014\u0018\u000e^3s?\u0012*\u0017\u000fF\u0002g\tSD\u0011\u0002b;\u0005d\u0006\u0005\t\u0019A\u0016\u0002\u0007a$\u0013\u0007C\u0004\u0005p\u0002\u0001\u000b\u0015B\u0016\u0002\u000f]\u0014\u0018\u000e^3sA!Q!\u000e\u0001a\u0001\u0002\u0004%I\u0001b=\u0016\u0003-D1\u0002b>\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0005z\u0006a1m\u001c8tk6,'o\u0018\u0013fcR\u0019a\rb?\t\u0013\u0011-HQ_A\u0001\u0002\u0004Y\u0007b\u0002C\u0000\u0001\u0001\u0006Ka[\u0001\nG>t7/^7fe\u0002B\u0011\"b\u0001\u0001\u0005\u0004%\t%\"\u0002\u0002\u000f\u001d,GOT1nKV\t!\nC\u0004\u0006\n\u0001\u0001\u000b\u0011\u0002&\u0002\u0011\u001d,GOT1nK\u0002Bq!\"\u0004\u0001\t\u0003*y!\u0001\u0003j]&$H\u0003BC\t\u000b_\u0001B!b\u0005\u0006*9!QQCC\u0013\u001d\u0011)9\"b\t\u000f\t\u0015eQ\u0011\u0005\b\u0005\u000b7)yB\u0004\u0003\u0002&\u0016u\u0011B\u0001\f\u000b\u0013\t)Q#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0004\u000bO\u0001\u0012\u0001D,sSR,7+\u001e9q_J$\u0018\u0002BC\u0016\u000b[\u0011Ab\u0016:ji\u0016\u001cuN\u001c;fqRT1!b\n\u0011\u0011!)\t$b\u0003A\u0002\u0015M\u0012\u0001B2p]\u001a\u0004B!\"\u000e\u0006<5\u0011Qq\u0007\u0006\u0005\u000bc)ID\u0003\u0002\u0014+%!QQHC\u001c\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9Q\u0011\t\u0001\u0005B\u0015\r\u0013a\u00049sKB\f'/\u001a$pe^\u0013\u0018\u000e^3\u0015\u0007\u0019,)\u0005C\u0004\u0006H\u0015}\u0002\u0019A6\u0002\u001dI,7m\u001c:e\u0007>t7/^7fe\"1A\u000f\u0001C!\u000b\u0017\"2AZC'\u0011\u001d)y%\"\u0013A\u0002e\taA]3d_J$\u0007")
public class SimpleFeatureWriteSupport
extends WriteSupport<SimpleFeature> {
    private SimpleFeatureWriter writer;
    private RecordConsumer consumer;
    private final String getName;

    public static AttributeWriter<?> attribute(String string, int n, Seq<Enumeration.Value> seq) {
        return SimpleFeatureWriteSupport$.MODULE$.attribute(string, n, seq);
    }

    public static AttributeWriter<?> attribute(AttributeDescriptor attributeDescriptor, int n) {
        return SimpleFeatureWriteSupport$.MODULE$.attribute(attributeDescriptor, n);
    }

    private SimpleFeatureWriter writer() {
        return this.writer;
    }

    private void writer_$eq(SimpleFeatureWriter x$1) {
        this.writer = x$1;
    }

    private RecordConsumer consumer() {
        return this.consumer;
    }

    private void consumer_$eq(RecordConsumer x$1) {
        this.consumer = x$1;
    }

    public String getName() {
        return this.getName;
    }

    public WriteSupport.WriteContext init(Configuration conf) {
        SimpleFeatureParquetSchema schema = (SimpleFeatureParquetSchema)SimpleFeatureParquetSchema$.MODULE$.write(conf).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Could not extract SimpleFeatureType from write context");
            }
        });
        this.writer_$eq(SimpleFeatureWriteSupport$SimpleFeatureWriter$.MODULE$.apply(schema.sft()));
        return new WriteSupport.WriteContext(schema.schema(), schema.metadata());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.consumer_$eq(recordConsumer);
    }

    public void write(SimpleFeature record) {
        this.writer().write(this.consumer(), record);
    }

    public SimpleFeatureWriteSupport() {
        this.getName = "SimpleFeatureWriteSupport";
    }

    public static class FidWriter
    extends AttributeWriter<String> {
        @Override
        public void write(RecordConsumer consumer, String value) {
            consumer.addBinary(Binary.fromString((String)value));
        }

        public FidWriter(int index) {
            super(SimpleFeatureParquetSchema$.MODULE$.FeatureIdField(), index);
        }
    }

    public static class MapWriter
    extends AttributeWriter<Map<Object, Object>> {
        private final AttributeWriter<Object> keyWriter;
        private final AttributeWriter<Object> valueWriter;

        private AttributeWriter<Object> keyWriter() {
            return this.keyWriter;
        }

        private AttributeWriter<Object> valueWriter() {
            return this.valueWriter;
        }

        @Override
        public void write(RecordConsumer consumer, Map<Object, Object> value) {
            consumer.startGroup();
            if (!value.isEmpty()) {
                consumer.startField("map", 0);
                for (Map.Entry<Object, Object> entry : value.entrySet()) {
                    consumer.startGroup();
                    this.keyWriter().apply(consumer, entry.getKey());
                    Object v = entry.getValue();
                    if (v != null) {
                        this.valueWriter().apply(consumer, v);
                    }
                    consumer.endGroup();
                }
                consumer.endField("map", 0);
            }
            consumer.endGroup();
        }

        public MapWriter(String name, int index, Enumeration.Value keyType, Enumeration.Value valueType) {
            super(name, index);
            this.keyWriter = SimpleFeatureWriteSupport$.MODULE$.attribute("key", 0, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{keyType}))));
            this.valueWriter = SimpleFeatureWriteSupport$.MODULE$.attribute("value", 1, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{valueType}))));
        }
    }

    public static class DateWriter
    extends AttributeWriter<Date> {
        @Override
        public void write(RecordConsumer consumer, Date value) {
            consumer.addLong(value.getTime());
        }

        public DateWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class LongWriter
    extends AttributeWriter<Long> {
        @Override
        public void write(RecordConsumer consumer, Long value) {
            consumer.addLong(Predef$.MODULE$.Long2long(value));
        }

        public LongWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class ListWriter
    extends AttributeWriter<List<Object>> {
        private final AttributeWriter<Object> elementWriter;

        private AttributeWriter<Object> elementWriter() {
            return this.elementWriter;
        }

        @Override
        public void write(RecordConsumer consumer, List<Object> value) {
            consumer.startGroup();
            if (!value.isEmpty()) {
                consumer.startField("list", 0);
                Iterator<Object> iter = value.iterator();
                while (iter.hasNext()) {
                    consumer.startGroup();
                    Object item = iter.next();
                    if (item != null) {
                        this.elementWriter().apply(consumer, item);
                    }
                    consumer.endGroup();
                }
                consumer.endField("list", 0);
            }
            consumer.endGroup();
        }

        public ListWriter(String name, int index, Enumeration.Value valueType) {
            super(name, index);
            this.elementWriter = SimpleFeatureWriteSupport$.MODULE$.attribute("element", 0, (Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{valueType}))));
        }
    }

    public static class UuidWriter
    extends AttributeWriter<UUID> {
        @Override
        public void write(RecordConsumer consumer, UUID value) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(value.getMostSignificantBits());
            bb.putLong(value.getLeastSignificantBits());
            consumer.addBinary(Binary.fromConstantByteArray((byte[])bb.array()));
        }

        public UuidWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class FloatWriter
    extends AttributeWriter<Float> {
        @Override
        public void write(RecordConsumer consumer, Float value) {
            consumer.addFloat(Predef$.MODULE$.Float2float(value));
        }

        public FloatWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class BytesWriter
    extends AttributeWriter<byte[]> {
        @Override
        public void write(RecordConsumer consumer, byte[] value) {
            consumer.addBinary(Binary.fromConstantByteArray((byte[])value));
        }

        public BytesWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class DoubleWriter
    extends AttributeWriter<Double> {
        @Override
        public void write(RecordConsumer consumer, Double value) {
            consumer.addDouble(Predef$.MODULE$.Double2double(value));
        }

        public DoubleWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class StringWriter
    extends AttributeWriter<String> {
        @Override
        public void write(RecordConsumer consumer, String value) {
            consumer.addBinary(Binary.fromString((String)value));
        }

        public StringWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class IntegerWriter
    extends AttributeWriter<Integer> {
        @Override
        public void write(RecordConsumer consumer, Integer value) {
            consumer.addInteger(Predef$.MODULE$.Integer2int(value));
        }

        public IntegerWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class BooleanWriter
    extends AttributeWriter<Boolean> {
        @Override
        public void write(RecordConsumer consumer, Boolean value) {
            consumer.addBoolean(Predef$.MODULE$.Boolean2boolean(value));
        }

        public BooleanWriter(String name, int index) {
            super(name, index);
        }
    }

    public static abstract class AttributeWriter<T> {
        private final String name;
        private final int index;

        public void apply(RecordConsumer consumer, T value) {
            if (value != null) {
                consumer.startField(this.name, this.index);
                this.write(consumer, value);
                consumer.endField(this.name, this.index);
            }
        }

        public abstract void write(RecordConsumer var1, T var2);

        public AttributeWriter(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }

    public static class SimpleFeatureWriter {
        private final AttributeWriter<Object>[] attributes;
        private final FidWriter fids;

        private FidWriter fids() {
            return this.fids;
        }

        public void write(RecordConsumer consumer, SimpleFeature value) {
            consumer.startMessage();
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].apply(consumer, value.getAttribute(i));
            }
            this.fids().apply(consumer, value.getID());
            consumer.endMessage();
        }

        public SimpleFeatureWriter(AttributeWriter<Object>[] attributes) {
            this.attributes = attributes;
            this.fids = new FidWriter(attributes.length);
        }
    }

    public static abstract class AbstractLinesWriter<T extends Geometry>
    extends AttributeWriter<T> {
        public abstract Seq<LineString> lines(T var1);

        @Override
        public void write(RecordConsumer consumer, T value) {
            Seq<LineString> lines2 = this.lines(value);
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startGroup();
            consumer.startField("list", 0);
            lines2.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                private final RecordConsumer consumer$1;

                public final void apply(LineString line) {
                    this.consumer$1.startGroup();
                    SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringX(this.consumer$1, line);
                    this.consumer$1.endGroup();
                }
                {
                    this.consumer$1 = consumer$1;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.startGroup();
            consumer.startField("list", 0);
            lines2.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                private final RecordConsumer consumer$1;

                public final void apply(LineString line) {
                    this.consumer$1.startGroup();
                    SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringY(this.consumer$1, line);
                    this.consumer$1.endGroup();
                }
                {
                    this.consumer$1 = consumer$1;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public AbstractLinesWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class PointAttributeWriter
    extends AttributeWriter<Point> {
        @Override
        public void write(RecordConsumer consumer, Point value) {
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.addDouble(value.getX());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.addDouble(value.getY());
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public PointAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class PolygonAttributeWriter
    extends AbstractLinesWriter<Polygon> {
        @Override
        public Seq<LineString> lines(Polygon value) {
            return (Seq)Seq$.MODULE$.tabulate(value.getNumInteriorRing() + 1, (Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final Polygon value$1;

                public final LineString apply(int i) {
                    return i == 0 ? this.value$1.getExteriorRing() : this.value$1.getInteriorRingN(i - 1);
                }
                {
                    this.value$1 = value$1;
                }
            });
        }

        public PolygonAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class LineStringAttributeWriter
    extends AttributeWriter<LineString> {
        @Override
        public void write(RecordConsumer consumer, LineString value) {
            int i;
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(value.getCoordinateN((int)i).x);
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(value.getCoordinateN((int)i).y);
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public LineStringAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class MultiPointAttributeWriter
    extends AttributeWriter<MultiPoint> {
        @Override
        public void write(RecordConsumer consumer, MultiPoint value) {
            int i;
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(((Point)value.getGeometryN(i)).getX());
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            for (i = 0; i < value.getNumPoints(); ++i) {
                consumer.addDouble(((Point)value.getGeometryN(i)).getY());
            }
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public MultiPointAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class GeometryWkbAttributeWriter
    extends AttributeWriter<Geometry> {
        @Override
        public void write(RecordConsumer consumer, Geometry value) {
            consumer.addBinary(Binary.fromConstantByteArray((byte[])WKBUtils$.MODULE$.write(value)));
        }

        public GeometryWkbAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class MultiPolygonAttributeWriter
    extends AttributeWriter<MultiPolygon> {
        @Override
        public void write(RecordConsumer consumer, MultiPolygon value) {
            Seq polys = (Seq)Seq$.MODULE$.tabulate(value.getNumGeometries(), (Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final MultiPolygon value$3;

                public final Seq<LinearRing> apply(int i) {
                    Polygon poly = (Polygon)this.value$3.getGeometryN(i);
                    return (Seq)Seq$.MODULE$.tabulate(poly.getNumInteriorRing() + 1, (Function1)new Serializable(this, poly){
                        public static final long serialVersionUID = 0L;
                        private final Polygon poly$1;

                        public final LinearRing apply(int i) {
                            return i == 0 ? this.poly$1.getExteriorRing() : this.poly$1.getInteriorRingN(i - 1);
                        }
                        {
                            this.poly$1 = poly$1;
                        }
                    });
                }
                {
                    this.value$3 = value$3;
                }
            });
            consumer.startGroup();
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startGroup();
            consumer.startField("list", 0);
            polys.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                public final RecordConsumer consumer$2;

                public final void apply(Seq<LinearRing> lines2) {
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("element", 0);
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("list", 0);
                    lines2.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MultiPolygonAttributeWriter$$anonfun$write$3 $outer;

                        public final void apply(LinearRing line) {
                            this.$outer.consumer$2.startGroup();
                            SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringX(this.$outer.consumer$2, (LineString)line);
                            this.$outer.consumer$2.endGroup();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.consumer$2.endField("list", 0);
                    this.consumer$2.endGroup();
                    this.consumer$2.endField("element", 0);
                    this.consumer$2.endGroup();
                }
                {
                    this.consumer$2 = consumer$2;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnX(), 0);
            consumer.startField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.startGroup();
            consumer.startField("list", 0);
            polys.foreach((Function1)new Serializable(this, consumer){
                public static final long serialVersionUID = 0L;
                public final RecordConsumer consumer$2;

                public final void apply(Seq<LinearRing> lines2) {
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("element", 0);
                    this.consumer$2.startGroup();
                    this.consumer$2.startField("list", 0);
                    lines2.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ MultiPolygonAttributeWriter$$anonfun$write$4 $outer;

                        public final void apply(LinearRing line) {
                            this.$outer.consumer$2.startGroup();
                            SimpleFeatureWriteSupport$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureWriteSupport$$writeLineStringY(this.$outer.consumer$2, (LineString)line);
                            this.$outer.consumer$2.endGroup();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.consumer$2.endField("list", 0);
                    this.consumer$2.endGroup();
                    this.consumer$2.endField("element", 0);
                    this.consumer$2.endGroup();
                }
                {
                    this.consumer$2 = consumer$2;
                }
            });
            consumer.endField("list", 0);
            consumer.endGroup();
            consumer.endField(SimpleFeatureParquetSchema$.MODULE$.GeometryColumnY(), 1);
            consumer.endGroup();
        }

        public MultiPolygonAttributeWriter(String name, int index) {
            super(name, index);
        }
    }

    public static class MultiLineStringAttributeWriter
    extends AbstractLinesWriter<MultiLineString> {
        @Override
        public Seq<LineString> lines(MultiLineString value) {
            return (Seq)Seq$.MODULE$.tabulate(value.getNumGeometries(), (Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final MultiLineString value$2;

                public final LineString apply(int i) {
                    return (LineString)this.value$2.getGeometryN(i);
                }
                {
                    this.value$2 = value$2;
                }
            });
        }

        public MultiLineStringAttributeWriter(String name, int index) {
            super(name, index);
        }
    }
}

