/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet.jobs;

import org.apache.hadoop.mapreduce.Job;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureReadSupport;
import org.locationtech.geomesa.parquet.io.SimpleFeatureWriteSupport;
import org.locationtech.geomesa.parquet.jobs.ParquetPartitionOutputFormat;
import org.locationtech.geomesa.parquet.jobs.ParquetStorageConfiguration;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public abstract class ParquetStorageConfiguration$class {
    public static void configureOutput(ParquetStorageConfiguration $this, SimpleFeatureType sft, Job job) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        job.setOutputFormatClass(ParquetPartitionOutputFormat.class);
        StorageConfiguration$.MODULE$.setSft(job.getConfiguration(), sft);
        ParquetInputFormat.setReadSupportClass((Job)job, SimpleFeatureReadSupport.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, SimpleFeatureWriteSupport.class);
        String summaryLevel = (String)Option$.MODULE$.apply((Object)job.getConfiguration().get("parquet.summary.metadata.level")).orElse((Function0)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)((String)this.sft$1.getUserData().get("parquet.summary.metadata.level")));
            }
            {
                this.sft$1 = sft$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ParquetOutputFormat.JobSummaryLevel.NONE.toString();
            }
        });
        job.getConfiguration().set("parquet.summary.metadata.level", summaryLevel);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Parquet metadata summary level is {}", new Object[]{summaryLevel});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        CompressionCodecName compression = (CompressionCodecName)Option$.MODULE$.apply((Object)job.getConfiguration().get("parquet.compression")).orElse((Function0)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)((String)this.sft$1.getUserData().get("parquet.compression")));
            }
            {
                this.sft$1 = sft$1;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final CompressionCodecName apply(String x$1) {
                return CompressionCodecName.valueOf((String)x$1);
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final CompressionCodecName apply() {
                return CompressionCodecName.SNAPPY;
            }
        });
        ParquetOutputFormat.setCompression((Job)job, (CompressionCodecName)compression);
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Parquet compression is {}", new Object[]{compression});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void $init$(ParquetStorageConfiguration $this) {
    }
}

