/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet.jobs;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.geotools.data.Query;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureReadSupport;
import org.locationtech.geomesa.parquet.package;
import org.locationtech.geomesa.parquet.package$ReadFilter$;
import org.locationtech.geomesa.parquet.package$ReadSchema$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ParquetSimpleFeatureInputFormat$ {
    public static ParquetSimpleFeatureInputFormat$ MODULE$;

    static {
        new ParquetSimpleFeatureInputFormat$();
    }

    public void configure(Configuration conf, SimpleFeatureType sft, Query query) {
        Query q = QueryRunner$.MODULE$.configureDefaultQuery(sft, query);
        Option filter = Option$.MODULE$.apply((Object)q.getFilter()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetSimpleFeatureInputFormat$.$anonfun$configure$1(x$1)));
        package.ReadSchema readSchema = package$ReadSchema$.MODULE$.apply(sft, (Option<Filter>)filter, (Option<Tuple2<String, SimpleFeatureType>>)QueryHints$.MODULE$.RichHints(q.getHints()).getTransform());
        if (readSchema == null) {
            throw new MatchError((Object)readSchema);
        }
        SimpleFeatureType readSft = readSchema.read();
        Option<Tuple2<String, SimpleFeatureType>> readTransform = readSchema.transform();
        Tuple2 tuple2 = new Tuple2((Object)readSft, readTransform);
        Tuple2 tuple22 = tuple2;
        SimpleFeatureType readSft2 = (SimpleFeatureType)tuple22._1();
        Option readTransform2 = (Option)tuple22._2();
        package.ReadFilter readFilter = package$ReadFilter$.MODULE$.apply(readSft2, (Option<Filter>)filter);
        if (readFilter == null) {
            throw new MatchError((Object)readFilter);
        }
        Option<FilterPredicate> parquetFilter = readFilter.parquet();
        Option<Filter> residualFilter = readFilter.residual();
        Tuple2 tuple23 = new Tuple2(parquetFilter, residualFilter);
        Tuple2 tuple24 = tuple23;
        Option parquetFilter2 = (Option)tuple24._1();
        Option residualFilter2 = (Option)tuple24._2();
        parquetFilter2.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ParquetSimpleFeatureInputFormat$.$anonfun$configure$2(conf, x$4);
            return BoxedUnit.UNIT;
        });
        StorageConfiguration$.MODULE$.setSft(conf, readSft2);
        residualFilter2.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            StorageConfiguration$.MODULE$.setFilter(conf, x$5);
            return BoxedUnit.UNIT;
        });
        readTransform2.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            StorageConfiguration$.MODULE$.setTransforms(conf, x$6);
            return BoxedUnit.UNIT;
        });
        conf.set("parquet.filter.dictionary.enabled", "true");
        conf.set("parquet.read.support.class", SimpleFeatureReadSupport.class.getName());
        conf.set("mapreduce.input.fileinputformat.input.dir.recursive", "true");
    }

    public static final /* synthetic */ boolean $anonfun$configure$1(Filter x$1) {
        Filter filter = x$1;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    public static final /* synthetic */ void $anonfun$configure$2(Configuration conf$1, FilterPredicate x$4) {
        ParquetInputFormat.setFilterPredicate((Configuration)conf$1, (FilterPredicate)x$4);
    }

    private ParquetSimpleFeatureInputFormat$() {
        MODULE$ = this;
    }
}

