/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import scala.runtime.BoxedUnit;

public final class ParquetFileSystemStorage$
implements LazyLogging {
    public static ParquetFileSystemStorage$ MODULE$;
    private final String Encoding;
    private final String FileExtension;
    private final String ParquetCompressionOpt;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ParquetFileSystemStorage$();
    }

    private Logger logger$lzycompute() {
        ParquetFileSystemStorage$ parquetFileSystemStorage$ = this;
        synchronized (parquetFileSystemStorage$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String Encoding() {
        return this.Encoding;
    }

    public String FileExtension() {
        return this.FileExtension;
    }

    public String ParquetCompressionOpt() {
        return this.ParquetCompressionOpt;
    }

    public void validateParquetFile(Path file) {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).build();){
            try {
                BoxedUnit boxedUnit;
                Group record = (Group)reader.read();
                while (record != null) {
                    record = (Group)reader.read();
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("{} is a valid Parquet file", new Object[]{file});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuilder(42).append("Unable to validate ").append(file).append(": File may be corrupted").toString(), e);
            }
        }
    }

    private ParquetFileSystemStorage$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.Encoding = "parquet";
        this.FileExtension = "parquet";
        this.ParquetCompressionOpt = "parquet.compression";
    }
}

