/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetWriter;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetPathReader;
import org.locationtech.geomesa.fs.storage.parquet.SimpleFeatureParquetWriter$;
import org.locationtech.geomesa.fs.storage.parquet.package;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadFilter$;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadSchema$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001B\u0010!\u00015B\u0011\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!N'\t\u00139\u0003!\u0011!Q\u0001\n=\u001b\u0006\"\u0002+\u0001\t\u0003)\u0006\"\u0002.\u0001\t#Z\u0006\"B;\u0001\t#2xaBA'A!\u0005\u0011q\n\u0004\u0007?\u0001B\t!!\u0015\t\rQ;A\u0011AA7\u0011%\tyg\u0002b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0002\u001e\u0001\u000b\u0011BA:\u0011%\t\u0019i\u0002b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0006\u001e\u0001\u000b\u0011BA:\u0011%\t9i\u0002b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\n\u001e\u0001\u000b\u0011BA:\r\u0019\tYi\u0002\u0001\u0002\u000e\"Q\u0011QS\b\u0003\u0002\u0003\u0006I!!\u0010\t\u0011\u0011|!\u0011!Q\u0001\n\u0015D!\"a&\u0010\u0005\u0003\u0005\u000b\u0011BAM\u0011!ywB!A!\u0002\u0013\u0001\bB\u0002+\u0010\t\u0003\t\u0019\u000bC\u0005\u00022>\u0011\r\u0011\"\u0003\u00024\"A\u0011qY\b!\u0002\u0013\t)\fC\u0004\u0002J>!\t%a3\t\u000f\u0005]w\u0002\"\u0011\u0002Z\"9\u00111\\\b\u0005B\u0005ew!CAo\u000f\u0005\u0005\t\u0012AAp\r%\tYiBA\u0001\u0012\u0003\t\t\u000f\u0003\u0004U7\u0011\u0005\u00111\u001d\u0005\n\u0003K\\\u0012\u0013!C\u0001\u0003ODq!!@\b\t\u0003\tyP\u0001\rQCJ\fX/\u001a;GS2,7+_:uK6\u001cFo\u001c:bO\u0016T!!\t\u0012\u0002\u000fA\f'/];fi*\u00111\u0005J\u0001\bgR|'/Y4f\u0015\t)c%\u0001\u0002gg*\u0011q\u0005K\u0001\bO\u0016|W.Z:b\u0015\tI#&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001,\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0006\u0005\u00020e5\t\u0001G\u0003\u00022E\u000511m\\7n_:L!a\r\u0019\u00033\u0005\u00137\u000f\u001e:bGR4\u0015\u000e\\3TsN$X-\\*u_J\fw-Z\u0001\bG>tG/\u001a=u!\t1$J\u0004\u00028\u000f:\u0011\u0001(\u0012\b\u0003s\u0011s!AO\"\u000f\u0005m\u0012eB\u0001\u001fB\u001d\ti\u0004)D\u0001?\u0015\tyD&\u0001\u0004=e>|GOP\u0005\u0002W%\u0011\u0011FK\u0005\u0003O!J!!\n\u0014\n\u0005\r\"\u0013B\u0001$#\u0003\r\t\u0007/[\u0005\u0003\u0011&\u000bq\u0001]1dW\u0006<WM\u0003\u0002GE%\u00111\n\u0014\u0002\u0012\r&dWmU=ti\u0016l7i\u001c8uKb$(B\u0001%J\u0013\t!$'\u0001\u0005nKR\fG-\u0019;b!\t\u0001\u0016+D\u0001J\u0013\t\u0011\u0016JA\bTi>\u0014\u0018mZ3NKR\fG-\u0019;b\u0013\tq%'\u0001\u0004=S:LGO\u0010\u000b\u0004-bK\u0006CA,\u0001\u001b\u0005\u0001\u0003\"\u0002\u001b\u0004\u0001\u0004)\u0004\"\u0002(\u0004\u0001\u0004y\u0015\u0001D2sK\u0006$Xm\u0016:ji\u0016\u0014Hc\u0001/d]B\u0011Q\f\u0019\b\u0003oyK!aX%\u0002#\u0019KG.Z*zgR,Wn\u0015;pe\u0006<W-\u0003\u0002bE\n\u0001b)\u001b7f'f\u001cH/Z7Xe&$XM\u001d\u0006\u0003?&CQ\u0001\u001a\u0003A\u0002\u0015\fAAZ5mKB\u0011a\r\\\u0007\u0002O*\u0011Q\u0005\u001b\u0006\u0003S*\fa\u0001[1e_>\u0004(BA6+\u0003\u0019\t\u0007/Y2iK&\u0011Qn\u001a\u0002\u0005!\u0006$\b\u000eC\u0003p\t\u0001\u0007\u0001/\u0001\u0005pEN,'O^3s!\t\t8/D\u0001s\u0015\ty\u0007'\u0003\u0002ue\n\u0011b)\u001b7f'f\u001cH/Z7PEN,'O^3s\u00031\u0019'/Z1uKJ+\u0017\rZ3s)\u00159\u0018\u0011AA\u0011!\tAXP\u0004\u0002zw:\u0011\u0001H_\u0005\u0003c\tJ!\u0001 \u0019\u00023\u0005\u00137\u000f\u001e:bGR4\u0015\u000e\\3TsN$X-\\*u_J\fw-Z\u0005\u0003}~\u0014ACR5mKNK8\u000f^3n!\u0006$\bNU3bI\u0016\u0014(B\u0001?1\u0011\u001d\t\u0019!\u0002a\u0001\u0003\u000b\taAZ5mi\u0016\u0014\bCBA\u0004\u0003\u001b\t\t\"\u0004\u0002\u0002\n)\u0011\u00111B\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u001f\tIA\u0001\u0004PaRLwN\u001c\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u00111AA\f\u0015\r1\u0015\u0011\u0004\u0006\u0004\u00037Q\u0013\u0001C4f_R|w\u000e\\:\n\t\u0005}\u0011Q\u0003\u0002\u0007\r&dG/\u001a:\t\u000f\u0005\rR\u00011\u0001\u0002&\u0005IAO]1og\u001a|'/\u001c\t\u0007\u0003\u000f\ti!a\n\u0011\u0011\u0005\u001d\u0011\u0011FA\u0017\u0003{IA!a\u000b\u0002\n\t1A+\u001e9mKJ\u0002B!a\f\u000289!\u0011\u0011GA\u001a!\ri\u0014\u0011B\u0005\u0005\u0003k\tI!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYD\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003k\tI\u0001\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\rMLW\u000e\u001d7f\u0015\u0011\t9%a\u0006\u0002\u000f\u0019,\u0017\r^;sK&!\u00111JA!\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0019!\u0006\u0014\u0018/^3u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0007CA,\b'\u00159\u00111KA-!\u0011\t9!!\u0016\n\t\u0005]\u0013\u0011\u0002\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005m\u0013\u0011N\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005a1oY1mC2|wmZ5oO*!\u00111MA3\u0003!!\u0018\u0010]3tC\u001a,'BAA4\u0003\r\u0019w.\\\u0005\u0005\u0003W\niFA\u0006MCjLHj\\4hS:<GCAA(\u0003!)enY8eS:<WCAA:!\u0011\t)(a \u000e\u0005\u0005]$\u0002BA=\u0003w\nA\u0001\\1oO*\u0011\u0011QP\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002:\u0005]\u0014!C#oG>$\u0017N\\4!\u000351\u0015\u000e\\3FqR,gn]5p]\u0006qa)\u001b7f\u000bb$XM\\:j_:\u0004\u0013!\u0006)beF,X\r^\"p[B\u0014Xm]:j_:|\u0005\u000f^\u0001\u0017!\u0006\u0014\u0018/^3u\u0007>l\u0007O]3tg&|gn\u00149uA\t9\u0002+\u0019:rk\u0016$h)\u001b7f'f\u001cH/Z7Xe&$XM]\n\u0005\u001f\u0005=E\f\u0005\u0003\u0002v\u0005E\u0015\u0002BAJ\u0003o\u0012aa\u00142kK\u000e$\u0018aA:gi\u0006!1m\u001c8g!\u0011\tY*a(\u000e\u0005\u0005u%bAALQ&!\u0011\u0011UAO\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]RQ\u0011QUAU\u0003W\u000bi+a,\u0011\u0007\u0005\u001dv\"D\u0001\b\u0011\u001d\t)\n\u0006a\u0001\u0003{AQ\u0001\u001a\u000bA\u0002\u0015Dq!a&\u0015\u0001\u0004\tI\nC\u0004p)A\u0005\t\u0019\u00019\u0002\r]\u0014\u0018\u000e^3s+\t\t)\f\u0005\u0004\u00028\u0006u\u0016\u0011Y\u0007\u0003\u0003sS1![A^\u0015\t\t#.\u0003\u0003\u0002@\u0006e&!\u0004)beF,X\r^,sSR,'\u000f\u0005\u0003\u0002@\u0005\r\u0017\u0002BAc\u0003\u0003\u0012QbU5na2,g)Z1ukJ,\u0017aB<sSR,'\u000fI\u0001\u0006oJLG/\u001a\u000b\u0005\u0003\u001b\f\u0019\u000e\u0005\u0003\u0002\b\u0005=\u0017\u0002BAi\u0003\u0013\u0011A!\u00168ji\"9\u0011Q[\fA\u0002\u0005\u0005\u0017!\u00014\u0002\u000b\u0019dWo\u001d5\u0015\u0005\u00055\u0017!B2m_N,\u0017a\u0006)beF,X\r\u001e$jY\u0016\u001c\u0016p\u001d;f[^\u0013\u0018\u000e^3s!\r\t9kG\n\u00047\u0005MCCAAp\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u001e\u0016\u0004a\u0006-8FAAw!\u0011\ty/!?\u000e\u0005\u0005E(\u0002BAz\u0003k\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005]\u0018\u0011B\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA~\u0003c\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M1\u0018\r\\5eCR,\u0007+\u0019:rk\u0016$h)\u001b7f)\u0011\tiM!\u0001\t\u000b\u0011t\u0002\u0019A3")
public class ParquetFileSystemStorage
extends AbstractFileSystemStorage {
    public static void validateParquetFile(Path path) {
        ParquetFileSystemStorage$.MODULE$.validateParquetFile(path);
    }

    public static String ParquetCompressionOpt() {
        return ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt();
    }

    public static String FileExtension() {
        return ParquetFileSystemStorage$.MODULE$.FileExtension();
    }

    public static String Encoding() {
        return ParquetFileSystemStorage$.MODULE$.Encoding();
    }

    public FileSystemStorage.FileSystemWriter createWriter(Path file, FileSystemObserver observer) {
        Configuration sftConf = new Configuration(super.context().conf());
        StorageConfiguration$.MODULE$.setSft(sftConf, super.metadata().sft());
        return new ParquetFileSystemWriter(super.metadata().sft(), file, sftConf, observer);
    }

    public AbstractFileSystemStorage.FileSystemPathReader createReader(Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        BoxedUnit boxedUnit;
        package.ReadSchema readSchema = package$ReadSchema$.MODULE$.apply(super.metadata().sft(), filter, transform);
        if (readSchema == null) {
            throw new MatchError((Object)readSchema);
        }
        SimpleFeatureType readSft = readSchema.read();
        Option<Tuple2<String, SimpleFeatureType>> readTransform = readSchema.transform();
        Tuple2 tuple2 = new Tuple2((Object)readSft, readTransform);
        SimpleFeatureType readSft2 = (SimpleFeatureType)tuple2._1();
        Option readTransform2 = (Option)tuple2._2();
        package.ReadFilter readFilter = package$ReadFilter$.MODULE$.apply(readSft2, filter);
        if (readFilter == null) {
            throw new MatchError((Object)readFilter);
        }
        Option<FilterPredicate> fc = readFilter.parquet();
        Option<Filter> residualFilter = readFilter.residual();
        Tuple2 tuple22 = new Tuple2(fc, residualFilter);
        Option fc2 = (Option)tuple22._1();
        Option residualFilter2 = (Option)tuple22._2();
        FilterCompat.Filter parquetFilter = (FilterCompat.Filter)fc2.map((Function1 & Serializable & scala.Serializable)x$1 -> FilterCompat.get((FilterPredicate)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> FilterCompat.NOOP);
        Option gtFilter = residualFilter2.map((Function1 & Serializable & scala.Serializable)x$3 -> FastFilterFactory$.MODULE$.optimize(readSft2, x$3));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Parquet filter: {} and modified gt filter: {}", new Object[]{parquetFilter, gtFilter.getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Configuration conf = new Configuration(super.context().conf());
        StorageConfiguration$.MODULE$.setSft(conf, readSft2);
        return new ParquetPathReader(conf, readSft2, parquetFilter, (Option<Filter>)gtFilter, (Option<Tuple2<String, SimpleFeatureType>>)readTransform2);
    }

    public ParquetFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata) {
        super(context, metadata, ParquetFileSystemStorage$.MODULE$.FileExtension());
    }

    public static class ParquetFileSystemWriter
    implements FileSystemStorage.FileSystemWriter {
        private final Path file;
        private final FileSystemObserver observer;
        private final ParquetWriter<SimpleFeature> writer;

        private ParquetWriter<SimpleFeature> writer() {
            return this.writer;
        }

        public void write(SimpleFeature f) {
            this.writer().write((Object)f);
            this.observer.write(f);
        }

        public void flush() {
            this.observer.flush();
        }

        public void close() {
            package.CloseQuietly$.MODULE$.apply((Object)new .colon.colon(this.writer(), (List)new .colon.colon((Object)this.observer, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                throw e;
            });
            if (new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.FileValidationEnabled().get())).toBoolean()) {
                ParquetFileSystemStorage$.MODULE$.validateParquetFile(this.file);
                return;
            }
        }

        public ParquetFileSystemWriter(SimpleFeatureType sft, Path file, Configuration conf, FileSystemObserver observer) {
            this.file = file;
            this.observer = observer;
            this.writer = SimpleFeatureParquetWriter$.MODULE$.builder(file, conf).build();
        }
    }
}

