/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.locationtech.geomesa.fs.storage.parquet.SimpleFeatureParquetWriter;
import scala.runtime.BoxedUnit;

public final class SimpleFeatureParquetWriter$
implements LazyLogging {
    public static SimpleFeatureParquetWriter$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SimpleFeatureParquetWriter$();
    }

    private Logger logger$lzycompute() {
        SimpleFeatureParquetWriter$ simpleFeatureParquetWriter$ = this;
        synchronized (simpleFeatureParquetWriter$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public SimpleFeatureParquetWriter.Builder builder(Path file, Configuration conf) {
        BoxedUnit boxedUnit;
        CompressionCodecName codec = CompressionCodecName.fromConf((String)conf.get("parquet.compression", "SNAPPY"));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Using Parquet Compression codec {}", new Object[]{codec.name()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (SimpleFeatureParquetWriter.Builder)new SimpleFeatureParquetWriter.Builder(file).withConf(conf).withCompressionCodec(codec).withDictionaryEncoding(true).withDictionaryPageSize(0x100000).withMaxPaddingSize(0x800000).withPageSize(0x100000).withValidation(false).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0).withRowGroupSize(0x800000);
    }

    private SimpleFeatureParquetWriter$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

