/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.locationtech.geomesa.features.serialization.TwkbSerialization;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureParquetSchema;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureParquetSchema$Binding$;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureParquetSchemaV0$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SimpleFeatureParquetSchema$
implements scala.Serializable {
    public static SimpleFeatureParquetSchema$ MODULE$;
    private final String FeatureIdField;
    private final String SchemaVersionKey;
    private final int CurrentSchemaVersion;
    private final String GeometryColumnX;
    private final String GeometryColumnY;

    static {
        new SimpleFeatureParquetSchema$();
    }

    public String FeatureIdField() {
        return this.FeatureIdField;
    }

    public String SchemaVersionKey() {
        return this.SchemaVersionKey;
    }

    public int CurrentSchemaVersion() {
        return this.CurrentSchemaVersion;
    }

    public String GeometryColumnX() {
        return this.GeometryColumnX;
    }

    public String GeometryColumnY() {
        return this.GeometryColumnY;
    }

    public Option<SimpleFeatureParquetSchema> read(InitContext context) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(context.getKeyValueMetadata()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Set v = (Set)tuple2._2();
                if (!v.isEmpty()) {
                    return metadata.put(k, (String)v.iterator().next());
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        Configuration conf = context.getConfiguration();
        ((IterableLike)new .colon.colon((Object)StorageConfiguration$.MODULE$.SftNameKey(), (List)new .colon.colon((Object)StorageConfiguration$.MODULE$.SftSpecKey(), (List)new .colon.colon((Object)this.SchemaVersionKey(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            String value = conf.get(key);
            if (value != null) {
                return metadata.put((String)key, value);
            }
            return BoxedUnit.UNIT;
        });
        return this.apply(metadata);
    }

    public Option<SimpleFeatureParquetSchema> read(FileMetaData footer) {
        return this.apply(footer.getKeyValueMetaData());
    }

    public Option<SimpleFeatureParquetSchema> write(Configuration conf) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(this.SchemaVersionKey(), Integer.toString(this.CurrentSchemaVersion()));
        ((IterableLike)new .colon.colon((Object)StorageConfiguration$.MODULE$.SftNameKey(), (List)new .colon.colon((Object)StorageConfiguration$.MODULE$.SftSpecKey(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            String value = conf.get(key);
            if (value != null) {
                return metadata.put((String)key, value);
            }
            return BoxedUnit.UNIT;
        });
        return this.apply(metadata);
    }

    private Option<SimpleFeatureParquetSchema> apply(Map<String, String> metadata) {
        return Option$.MODULE$.apply((Object)metadata.get(StorageConfiguration$.MODULE$.SftNameKey())).flatMap((Function1 & Serializable & scala.Serializable)name -> Option$.MODULE$.apply(metadata.get(StorageConfiguration$.MODULE$.SftSpecKey())).map((Function1 & Serializable & scala.Serializable)spec -> {
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(name, spec);
            int n = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(metadata.get(MODULE$.SchemaVersionKey())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)SimpleFeatureParquetSchema$.$anonfun$apply$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            switch (n) {
                case 1: {
                    return new SimpleFeatureParquetSchema(sft, MODULE$.schema(sft));
                }
                case 0: {
                    return new SimpleFeatureParquetSchema(sft, SimpleFeatureParquetSchemaV0$.MODULE$.apply(sft));
                }
            }
            throw new IllegalArgumentException(new StringBuilder(44).append("Unknown SimpleFeatureParquetSchema version: ").append(n).toString());
        }));
    }

    private MessageType schema(SimpleFeatureType sft) {
        PrimitiveType id = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8).named(this.FeatureIdField());
        Buffer fields = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)descriptor -> MODULE$.schema((AttributeDescriptor)descriptor), Buffer$.MODULE$.canBuildFrom())).$colon$plus((Object)id, Buffer$.MODULE$.canBuildFrom());
        return new MessageType(StringSerialization$.MODULE$.alphaNumericSafeString(sft.getTypeName()), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(fields).asJava());
    }

    private Type schema(AttributeDescriptor descriptor) {
        Types.Builder<?, ? extends Type> builder;
        Seq bindings = ObjectType$.MODULE$.selectType(descriptor);
        Enumeration.Value value = (Enumeration.Value)bindings.head();
        Enumeration.Value value2 = ObjectType$.MODULE$.GEOMETRY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            builder = this.geometry((Enumeration.Value)bindings.apply(1));
        } else {
            Enumeration.Value value4 = ObjectType$.MODULE$.LIST();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                builder = SimpleFeatureParquetSchema$Binding$.MODULE$.apply((Enumeration.Value)bindings.apply(1)).list();
            } else {
                Enumeration.Value value6 = ObjectType$.MODULE$.MAP();
                Enumeration.Value value7 = value;
                builder = !(value6 != null ? !value6.equals(value7) : value7 != null) ? SimpleFeatureParquetSchema$Binding$.MODULE$.apply((Enumeration.Value)bindings.apply(1)).key((Enumeration.Value)bindings.apply(2)) : SimpleFeatureParquetSchema$Binding$.MODULE$.apply(value).primitive();
            }
        }
        Types.Builder<?, ? extends Type> builder2 = builder;
        return (Type)builder2.named(StringSerialization$.MODULE$.alphaNumericSafeString(descriptor.getLocalName()));
    }

    private Types.Builder<?, ? extends Type> geometry(Enumeration.Value binding) {
        Enumeration.Value value = binding;
        Enumeration.Value value2 = ObjectType$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (Types.Builder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)SimpleFeatureParquetSchema$.group$1().id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbPoint())).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnX())).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnY());
        }
        Enumeration.Value value4 = ObjectType$.MODULE$.LINESTRING();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return (Types.Builder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)SimpleFeatureParquetSchema$.group$1().id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbLineString())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnX())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnY());
        }
        Enumeration.Value value6 = ObjectType$.MODULE$.MULTIPOINT();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return (Types.Builder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)SimpleFeatureParquetSchema$.group$1().id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbMultiPoint())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnX())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnY());
        }
        Enumeration.Value value8 = ObjectType$.MODULE$.POLYGON();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return (Types.Builder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)SimpleFeatureParquetSchema$.group$1().id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbPolygon())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnX())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnY());
        }
        Enumeration.Value value10 = ObjectType$.MODULE$.MULTILINESTRING();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return (Types.Builder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)SimpleFeatureParquetSchema$.group$1().id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbMultiLineString())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnX())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnY());
        }
        Enumeration.Value value12 = ObjectType$.MODULE$.MULTIPOLYGON();
        Enumeration.Value value13 = value;
        if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
            return (Types.Builder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)SimpleFeatureParquetSchema$.group$1().id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbMultiPolygon())).requiredList().requiredListElement().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnX())).requiredList().requiredListElement().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnY());
        }
        Enumeration.Value value14 = ObjectType$.MODULE$.GEOMETRY();
        Enumeration.Value value15 = value;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            return Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL);
        }
        throw new NotImplementedError(new StringBuilder(37).append("No mapping defined for geometry type ").append(binding).toString());
    }

    public SimpleFeatureParquetSchema apply(SimpleFeatureType sft, MessageType schema) {
        return new SimpleFeatureParquetSchema(sft, schema);
    }

    public Option<Tuple2<SimpleFeatureType, MessageType>> unapply(SimpleFeatureParquetSchema x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.sft(), (Object)x$0.schema()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ int $anonfun$apply$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    private static final Types.GroupBuilder group$1() {
        return Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL);
    }

    private SimpleFeatureParquetSchema$() {
        MODULE$ = this;
        this.FeatureIdField = "__fid__";
        this.SchemaVersionKey = "geomesa.parquet.version";
        this.CurrentSchemaVersion = 1;
        this.GeometryColumnX = "x";
        this.GeometryColumnY = "y";
    }
}

