/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetWriter;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.common.package$;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetPathReader;
import org.locationtech.geomesa.fs.storage.parquet.SimpleFeatureParquetWriter$;
import org.locationtech.geomesa.fs.storage.parquet.package;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadFilter$;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadSchema$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-a\u0001B\u0011#\u0001=B\u0011B\u000e\u0001\u0003\u0002\u0003\u0006IaN(\t\u0013A\u0003!\u0011!Q\u0001\nE+\u0006\"\u0002,\u0001\t\u00039\u0006\"\u0002/\u0001\t#j\u0006\"B<\u0001\t#BxaBA)E!\u0005\u00111\u000b\u0004\u0007C\tB\t!!\u0016\t\rY;A\u0011AA9\u0011%\t\u0019h\u0002b\u0001\n\u0003\t)\b\u0003\u0005\u0002\u0006\u001e\u0001\u000b\u0011BA<\u0011%\t9i\u0002b\u0001\n\u0003\t)\b\u0003\u0005\u0002\n\u001e\u0001\u000b\u0011BA<\u0011%\tYi\u0002b\u0001\n\u0003\t)\b\u0003\u0005\u0002\u000e\u001e\u0001\u000b\u0011BA<\r\u0019\tyi\u0002\u0001\u0002\u0012\"Q\u0011\u0011T\b\u0003\u0002\u0003\u0006I!!\u0011\t\u0011Yz!\u0011!Q\u0001\n]B\u0001BZ\b\u0003\u0002\u0003\u0006Ia\u001a\u0005\tc>\u0011\t\u0011)A\u0005e\"1ak\u0004C\u0001\u00037C\u0011\"!+\u0010\u0005\u0004%I!a+\t\u0011\u0005]v\u0002)A\u0005\u0003[C\u0011\"!/\u0010\u0005\u0004%I!a/\t\u0011\u0005=w\u0002)A\u0005\u0003{Cq!!5\u0010\t\u0003\n\u0019\u000eC\u0004\u0002`>!\t%!9\t\u000f\u0005\rx\u0002\"\u0011\u0002b\u001eI\u0011Q]\u0004\u0002\u0002#\u0005\u0011q\u001d\u0004\n\u0003\u001f;\u0011\u0011!E\u0001\u0003SDaAV\u000f\u0005\u0002\u0005-\b\"CAw;E\u0005I\u0011AAx\u0011\u001d\u0011)a\u0002C\u0001\u0005\u000f\u0011\u0001\u0004U1scV,GOR5mKNK8\u000f^3n'R|'/Y4f\u0015\t\u0019C%A\u0004qCJ\fX/\u001a;\u000b\u0005\u00152\u0013aB:u_J\fw-\u001a\u0006\u0003O!\n!AZ:\u000b\u0005%R\u0013aB4f_6,7/\u0019\u0006\u0003W1\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011!L\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0013\u0002\r\r|W.\\8o\u0013\t)$GA\rBEN$(/Y2u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0017aB2p]R,\u0007\u0010\u001e\t\u0003q1s!!O%\u000f\u0005i:eBA\u001eG\u001d\taTI\u0004\u0002>\t:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003:\na\u0001\u0010:p_Rt\u0014\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002&M%\u0011\u0001\nJ\u0001\u0004CBL\u0017B\u0001&L\u0003\u001d\u0001\u0018mY6bO\u0016T!\u0001\u0013\u0013\n\u00055s%!\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000e{g\u000e^3yi*\u0011!jS\u0005\u0003mQ\n\u0001\"\\3uC\u0012\fG/\u0019\t\u0003%Nk\u0011aS\u0005\u0003).\u0013qb\u0015;pe\u0006<W-T3uC\u0012\fG/Y\u0005\u0003!R\na\u0001P5oSRtDc\u0001-[7B\u0011\u0011\fA\u0007\u0002E!)ag\u0001a\u0001o!)\u0001k\u0001a\u0001#\u0006a1M]3bi\u0016<&/\u001b;feR\u0019a,\u001a9\u0011\u0005}\u0013gBA\u001da\u0013\t\t7*A\tGS2,7+_:uK6\u001cFo\u001c:bO\u0016L!a\u00193\u0003!\u0019KG.Z*zgR,Wn\u0016:ji\u0016\u0014(BA1L\u0011\u00151G\u00011\u0001h\u0003\u00111\u0017\u000e\\3\u0011\u0005!tW\"A5\u000b\u0005\u001dR'BA6m\u0003\u0019A\u0017\rZ8pa*\u0011Q\u000eL\u0001\u0007CB\f7\r[3\n\u0005=L'\u0001\u0002)bi\"DQ!\u001d\u0003A\u0002I\f\u0001b\u001c2tKJ4XM\u001d\t\u0003gVl\u0011\u0001\u001e\u0006\u0003cJJ!A\u001e;\u0003%\u0019KG.Z*zgR,Wn\u00142tKJ4XM]\u0001\rGJ,\u0017\r^3SK\u0006$WM\u001d\u000b\u0006s\u0006\u0015\u0011Q\u0005\t\u0003u~t!a_?\u000f\u0005ib\u0018BA\u001a%\u0013\tq('A\rBEN$(/Y2u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u0011ACR5mKNK8\u000f^3n!\u0006$\bNU3bI\u0016\u0014(B\u0001@3\u0011\u001d\t9!\u0002a\u0001\u0003\u0013\taAZ5mi\u0016\u0014\bCBA\u0006\u0003#\t)\"\u0004\u0002\u0002\u000e)\u0011\u0011qB\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003'\tiA\u0001\u0004PaRLwN\u001c\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u0011qAA\u000e\u0015\rA\u0015Q\u0004\u0006\u0004\u0003?a\u0013\u0001C4f_R|w\u000e\\:\n\t\u0005\r\u0012\u0011\u0004\u0002\u0007\r&dG/\u001a:\t\u000f\u0005\u001dR\u00011\u0001\u0002*\u0005IAO]1og\u001a|'/\u001c\t\u0007\u0003\u0017\t\t\"a\u000b\u0011\u0011\u0005-\u0011QFA\u0019\u0003\u0003JA!a\f\u0002\u000e\t1A+\u001e9mKJ\u0002B!a\r\u0002<9!\u0011QGA\u001c!\ry\u0014QB\u0005\u0005\u0003s\ti!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\tyD\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003s\ti\u0001\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\rMLW\u000e\u001d7f\u0015\u0011\tY%a\u0007\u0002\u000f\u0019,\u0017\r^;sK&!\u0011qJA#\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0019!\u0006\u0014\u0018/^3u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0007CA-\b'\u00159\u0011qKA/!\u0011\tY!!\u0017\n\t\u0005m\u0013Q\u0002\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005}\u0013QN\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005a1oY1mC2|wmZ5oO*!\u0011qMA5\u0003!!\u0018\u0010]3tC\u001a,'BAA6\u0003\r\u0019w.\\\u0005\u0005\u0003_\n\tGA\u0006MCjLHj\\4hS:<GCAA*\u0003!)enY8eS:<WCAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA\u0001\\1oO*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002>\u0005m\u0014!C#oG>$\u0017N\\4!\u000351\u0015\u000e\\3FqR,gn]5p]\u0006qa)\u001b7f\u000bb$XM\\:j_:\u0004\u0013!\u0006)beF,X\r^\"p[B\u0014Xm]:j_:|\u0005\u000f^\u0001\u0017!\u0006\u0014\u0018/^3u\u0007>l\u0007O]3tg&|gn\u00149uA\t9\u0002+\u0019:rk\u0016$h)\u001b7f'f\u001cH/Z7Xe&$XM]\n\u0005\u001f\u0005Me\f\u0005\u0003\u0002z\u0005U\u0015\u0002BAL\u0003w\u0012aa\u00142kK\u000e$\u0018aA:giRQ\u0011QTAQ\u0003G\u000b)+a*\u0011\u0007\u0005}u\"D\u0001\b\u0011\u001d\tI\n\u0006a\u0001\u0003\u0003BQA\u000e\u000bA\u0002]BQA\u001a\u000bA\u0002\u001dDq!\u001d\u000b\u0011\u0002\u0003\u0007!/\u0001\u0003d_:4WCAAW!\u0011\ty+a-\u000e\u0005\u0005E&bAAUU&!\u0011QWAY\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006)1m\u001c8gA\u00051qO]5uKJ,\"!!0\u0011\r\u0005}\u0016QYAe\u001b\t\t\tMC\u0002l\u0003\u0007T!a\t7\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u000e!\u0006\u0014\u0018/^3u/JLG/\u001a:\u0011\t\u0005\r\u00131Z\u0005\u0005\u0003\u001b\f)EA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\boJLG/\u001a:!\u0003\u00159(/\u001b;f)\u0011\t).a7\u0011\t\u0005-\u0011q[\u0005\u0005\u00033\fiA\u0001\u0003V]&$\bbBAo3\u0001\u0007\u0011\u0011Z\u0001\u0002M\u0006)a\r\\;tQR\u0011\u0011Q[\u0001\u0006G2|7/Z\u0001\u0018!\u0006\u0014\u0018/^3u\r&dWmU=ti\u0016lwK]5uKJ\u00042!a(\u001e'\ri\u0012q\u000b\u000b\u0003\u0003O\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAAyU\r\u0011\u00181_\u0016\u0003\u0003k\u0004B!a>\u0003\u00025\u0011\u0011\u0011 \u0006\u0005\u0003w\fi0A\u0005v]\u000eDWmY6fI*!\u0011q`A\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\tIPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1C^1mS\u0012\fG/\u001a)beF,X\r\u001e$jY\u0016$B!!6\u0003\n!)a\r\ta\u0001O\u0002")
public class ParquetFileSystemStorage
extends AbstractFileSystemStorage {
    public static void validateParquetFile(Path path) {
        ParquetFileSystemStorage$.MODULE$.validateParquetFile(path);
    }

    public static String ParquetCompressionOpt() {
        return ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt();
    }

    public static String FileExtension() {
        return ParquetFileSystemStorage$.MODULE$.FileExtension();
    }

    public static String Encoding() {
        return ParquetFileSystemStorage$.MODULE$.Encoding();
    }

    public FileSystemStorage.FileSystemWriter createWriter(Path file, FileSystemObserver observer) {
        return new ParquetFileSystemWriter(super.metadata().sft(), super.context(), file, observer);
    }

    public AbstractFileSystemStorage.FileSystemPathReader createReader(Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        BoxedUnit boxedUnit;
        package.ReadSchema readSchema = package$ReadSchema$.MODULE$.apply(super.metadata().sft(), filter, transform);
        if (readSchema == null) {
            throw new MatchError((Object)readSchema);
        }
        SimpleFeatureType readSft = readSchema.read();
        Option<Tuple2<String, SimpleFeatureType>> readTransform = readSchema.transform();
        Tuple2 tuple2 = new Tuple2((Object)readSft, readTransform);
        SimpleFeatureType readSft2 = (SimpleFeatureType)tuple2._1();
        Option readTransform2 = (Option)tuple2._2();
        package.ReadFilter readFilter = package$ReadFilter$.MODULE$.apply(readSft2, filter);
        if (readFilter == null) {
            throw new MatchError((Object)readFilter);
        }
        Option<FilterPredicate> fc = readFilter.parquet();
        Option<Filter> residualFilter = readFilter.residual();
        Tuple2 tuple22 = new Tuple2(fc, residualFilter);
        Option fc2 = (Option)tuple22._1();
        Option residualFilter2 = (Option)tuple22._2();
        FilterCompat.Filter parquetFilter = (FilterCompat.Filter)fc2.map((Function1 & Serializable & scala.Serializable)x$1 -> FilterCompat.get((FilterPredicate)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> FilterCompat.NOOP);
        Option gtFilter = residualFilter2.map((Function1 & Serializable & scala.Serializable)x$3 -> FastFilterFactory$.MODULE$.optimize(readSft2, x$3));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Parquet filter: {} and modified gt filter: {}", new Object[]{parquetFilter, gtFilter.getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Configuration conf = new Configuration(super.context().conf());
        StorageConfiguration$.MODULE$.setSft(conf, readSft2);
        return new ParquetPathReader(conf, readSft2, parquetFilter, (Option<Filter>)gtFilter, (Option<Tuple2<String, SimpleFeatureType>>)readTransform2);
    }

    public ParquetFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata) {
        super(context, metadata, ParquetFileSystemStorage$.MODULE$.FileExtension());
    }

    public static class ParquetFileSystemWriter
    implements FileSystemStorage.FileSystemWriter {
        private final package.FileSystemContext context;
        private final Path file;
        private final FileSystemObserver observer;
        private final Configuration conf;
        private final ParquetWriter<SimpleFeature> writer;

        private Configuration conf() {
            return this.conf;
        }

        private ParquetWriter<SimpleFeature> writer() {
            return this.writer;
        }

        public void write(SimpleFeature f) {
            this.writer().write((Object)f);
            this.observer.write(f);
        }

        public void flush() {
            this.observer.flush();
        }

        public void close() {
            package.CloseQuietly$.MODULE$.apply((Object)new .colon.colon(this.writer(), (List)new .colon.colon((Object)this.observer, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                throw e;
            });
            PathCache$.MODULE$.register(this.context.fs(), this.file);
            if (BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.FileValidationEnabled().toBoolean().get())) {
                ParquetFileSystemStorage$.MODULE$.validateParquetFile(this.file);
                return;
            }
        }

        public ParquetFileSystemWriter(SimpleFeatureType sft, package.FileSystemContext context, Path file, FileSystemObserver observer) {
            this.context = context;
            this.file = file;
            this.observer = observer;
            Configuration conf = new Configuration(context.conf());
            StorageConfiguration$.MODULE$.setSft(conf, sft);
            this.conf = conf;
            this.writer = SimpleFeatureParquetWriter$.MODULE$.builder(file, this.conf()).build();
        }
    }
}

