/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import java.io.Serializable;
import java.util.Date;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.io.api.Binary;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.FilterValues;
import org.locationtech.geomesa.filter.visitor.FilterExtractingVisitor$;
import org.locationtech.geomesa.fs.storage.parquet.FilterConverter$MillisToMicrosVisitor$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$BoundingBoxField$;
import org.locationtech.geomesa.index.strategies.SpatialFilterStrategy$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class FilterConverter$ {
    public static FilterConverter$ MODULE$;

    static {
        new FilterConverter$();
    }

    public Tuple2<Option<FilterPredicate>, Option<Filter>> convert(SimpleFeatureType sft, Filter filter) {
        Filter filter2 = filter;
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
            return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        return (Tuple2)FilterHelper$.MODULE$.propertyNames(filter).foldLeft((Object)new Tuple2((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.apply((Object)filter)), (Function2 & Serializable & scala.Serializable)(result, name) -> MODULE$.reduce(sft, (Tuple2<Option<FilterPredicate>, Option<Filter>>)result, (String)name));
    }

    private Tuple2<Option<FilterPredicate>, Option<Filter>> reduce(SimpleFeatureType sft, Tuple2<Option<FilterPredicate>, Option<Filter>> result, String name) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        Tuple2<Option<FilterPredicate>, Option<Filter>> tuple23 = result;
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Option parquet = (Option)tuple23._1();
        Option geotools = (Option)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)parquet, (Object)geotools);
        Option parquet2 = (Option)tuple24._1();
        Option geotools2 = (Option)tuple24._2();
        Filter filter = (Filter)geotools2.orNull(Predef$.MODULE$.$conforms());
        if (filter == null) {
            return result;
        }
        Seq bindings = ObjectType$.MODULE$.selectType(sft.getDescriptor(name));
        String col = StringSerialization$.MODULE$.alphaNumericSafeString(name);
        Enumeration.Value value = (Enumeration.Value)bindings.head();
        Enumeration.Value value2 = ObjectType$.MODULE$.GEOMETRY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple22 = this.spatial(sft, name, filter, col, (Enumeration.Value)bindings.last());
        } else {
            Enumeration.Value value4 = ObjectType$.MODULE$.DATE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple22 = this.temporal(sft, name, filter, FilterApi.longColumn((String)col));
            } else {
                Enumeration.Value value6 = ObjectType$.MODULE$.STRING();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    tuple22 = this.attribute(sft, name, filter, (Operators.Column)FilterApi.binaryColumn((String)col), (Function1)(Function1 & Serializable & scala.Serializable)x$1 -> Binary.fromString((String)x$1), (ClassTag)ClassTag$.MODULE$.apply(String.class));
                } else {
                    Enumeration.Value value8 = ObjectType$.MODULE$.INT();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        tuple22 = this.attribute(sft, name, filter, (Operators.Column)FilterApi.intColumn((String)col), (Function1)(Function1 & Serializable & scala.Serializable)x -> (Integer)Predef$.MODULE$.identity(x), (ClassTag)ClassTag$.MODULE$.apply(Integer.class));
                    } else {
                        Enumeration.Value value10 = ObjectType$.MODULE$.LONG();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            tuple22 = this.attribute(sft, name, filter, (Operators.Column)FilterApi.longColumn((String)col), (Function1)(Function1 & Serializable & scala.Serializable)x -> (Long)Predef$.MODULE$.identity(x), (ClassTag)ClassTag$.MODULE$.apply(Long.class));
                        } else {
                            Enumeration.Value value12 = ObjectType$.MODULE$.FLOAT();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                tuple22 = this.attribute(sft, name, filter, (Operators.Column)FilterApi.floatColumn((String)col), (Function1)(Function1 & Serializable & scala.Serializable)x -> (Float)Predef$.MODULE$.identity(x), (ClassTag)ClassTag$.MODULE$.apply(Float.class));
                            } else {
                                Enumeration.Value value14 = ObjectType$.MODULE$.DOUBLE();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    tuple22 = this.attribute(sft, name, filter, (Operators.Column)FilterApi.doubleColumn((String)col), (Function1)(Function1 & Serializable & scala.Serializable)x -> (Double)Predef$.MODULE$.identity(x), (ClassTag)ClassTag$.MODULE$.apply(Double.class));
                                } else {
                                    Enumeration.Value value16 = ObjectType$.MODULE$.BOOLEAN();
                                    Enumeration.Value value17 = value;
                                    tuple22 = !(value16 != null ? !value16.equals(value17) : value17 != null) ? this.boolean(sft, name, filter, FilterApi.booleanColumn((String)col)) : (tuple2 = new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)filter)));
                                }
                            }
                        }
                    }
                }
            }
        }
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option predicate = (Option)tuple2._1();
        Option remaining = (Option)tuple2._2();
        Tuple2 tuple25 = new Tuple2((Object)predicate, (Object)remaining);
        Option predicate2 = (Option)tuple25._1();
        Option remaining2 = (Option)tuple25._2();
        return new Tuple2((Object)((TraversableOnce)Option$.MODULE$.option2Iterable(predicate2).toSeq().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(parquet2), Seq$.MODULE$.canBuildFrom())).reduceLeftOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2)), (Object)remaining2);
    }

    private Tuple2<Option<FilterPredicate>, Option<Filter>> spatial(SimpleFeatureType sft, String name, Filter filter2, String col, Enumeration.Value typed) {
        Tuple2 tuple2 = FilterExtractingVisitor$.MODULE$.apply(filter2, name, sft, (Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)SpatialFilterStrategy$.MODULE$.spatialCheck(filter)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option spatial = (Option)tuple2._1();
        Option spatial2 = spatial;
        Option xyBounds = spatial2.map((Function1 & Serializable & scala.Serializable)x$3 -> FilterHelper$.MODULE$.extractGeometries(x$3, name, FilterHelper$.MODULE$.extractGeometries$default$3())).flatMap((Function1 & Serializable & scala.Serializable)extracted -> new Some(extracted).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FilterConverter$.$anonfun$spatial$4(e))).map((Function1 & Serializable & scala.Serializable)e -> (Tuple4)((TraversableOnce)e.values().map((Function1 & Serializable & scala.Serializable)geometry -> GeometryUtils$.MODULE$.bounds(geometry), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> new Tuple4((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)a._1()), BoxesRunTime.unboxToDouble((Object)b._1()))), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)a._2()), BoxesRunTime.unboxToDouble((Object)b._2()))), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)a._3()), BoxesRunTime.unboxToDouble((Object)b._3()))), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)a._4()), BoxesRunTime.unboxToDouble((Object)b._4())))))));
        Option predicate = xyBounds.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                String bboxGroup = GeometrySchema$BoundingBoxField$.MODULE$.apply(col, true).bbox();
                Operators.FloatColumn bboxXminCol = FilterApi.floatColumn((String)new StringBuilder(1).append(bboxGroup).append(".").append(GeometrySchema$BoundingBoxField$.MODULE$.XMin()).toString());
                Operators.FloatColumn yminCol = FilterApi.floatColumn((String)new StringBuilder(1).append(bboxGroup).append(".").append(GeometrySchema$BoundingBoxField$.MODULE$.YMin()).toString());
                Operators.FloatColumn xmaxCol = FilterApi.floatColumn((String)new StringBuilder(1).append(bboxGroup).append(".").append(GeometrySchema$BoundingBoxField$.MODULE$.XMax()).toString());
                Operators.FloatColumn ymaxCol = FilterApi.floatColumn((String)new StringBuilder(1).append(bboxGroup).append(".").append(GeometrySchema$BoundingBoxField$.MODULE$.YMax()).toString());
                FilterPredicate bbox = (FilterPredicate)((TraversableOnce)new .colon.colon((Object)FilterApi.ltEq((Operators.Column)bboxXminCol, (Comparable)BoxesRunTime.boxToFloat((float)((float)xmax))), (List)new .colon.colon((Object)FilterApi.gtEq((Operators.Column)xmaxCol, (Comparable)BoxesRunTime.boxToFloat((float)((float)xmin))), (List)new .colon.colon((Object)FilterApi.ltEq((Operators.Column)yminCol, (Comparable)BoxesRunTime.boxToFloat((float)((float)ymax))), (List)new .colon.colon((Object)FilterApi.gtEq((Operators.Column)ymaxCol, (Comparable)BoxesRunTime.boxToFloat((float)((float)ymin))), (List)Nil$.MODULE$))))).reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
                Enumeration.Value value = typed;
                Enumeration.Value value2 = ObjectType$.MODULE$.POINT();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    Operators.DoubleColumn xcol = FilterApi.doubleColumn((String)new StringBuilder(2).append(col).append(".x").toString());
                    Operators.DoubleColumn ycol = FilterApi.doubleColumn((String)new StringBuilder(2).append(col).append(".y").toString());
                    FilterPredicate xy = (FilterPredicate)((TraversableOnce)new .colon.colon((Object)FilterApi.gtEq((Operators.Column)xcol, (Comparable)BoxesRunTime.boxToDouble((double)xmin)), (List)new .colon.colon((Object)FilterApi.gtEq((Operators.Column)ycol, (Comparable)BoxesRunTime.boxToDouble((double)ymin)), (List)new .colon.colon((Object)FilterApi.ltEq((Operators.Column)xcol, (Comparable)BoxesRunTime.boxToDouble((double)xmax)), (List)new .colon.colon((Object)FilterApi.ltEq((Operators.Column)ycol, (Comparable)BoxesRunTime.boxToDouble((double)ymax)), (List)Nil$.MODULE$))))).reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
                    return FilterApi.or((FilterPredicate)bbox, (FilterPredicate)xy);
                }
                return FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)bboxXminCol, null), (FilterPredicate)bbox);
            }
            throw new MatchError((Object)tuple4);
        });
        return new Tuple2((Object)predicate, (Object)new Some((Object)filter2));
    }

    private Tuple2<Option<FilterPredicate>, Option<Filter>> temporal(SimpleFeatureType sft, String name, Filter filter, Operators.LongColumn col) {
        Tuple2<Option<FilterPredicate>, Option<Filter>> tuple2 = this.attribute(sft, name, filter, (Operators.Column)col, (Function1)(Function1 & Serializable & scala.Serializable)x$4 -> Predef$.MODULE$.long2Long(x$4.getTime()), (ClassTag)ClassTag$.MODULE$.apply(Date.class));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option predicate = (Option)tuple2._1();
        Option remaining = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)predicate, (Object)remaining);
        Option predicate2 = (Option)tuple22._1();
        Option remaining2 = (Option)tuple22._2();
        Option millisOrMicros = predicate2.map((Function1 & Serializable & scala.Serializable)p -> FilterApi.or((FilterPredicate)p, (FilterPredicate)((FilterPredicate)p.accept((FilterPredicate.Visitor)FilterConverter$MillisToMicrosVisitor$.MODULE$))));
        return new Tuple2((Object)millisOrMicros, (Object)remaining2);
    }

    private <T, U extends Comparable<U>> Tuple2<Option<FilterPredicate>, Option<Filter>> attribute(SimpleFeatureType sft, String name, Filter filter, Operators.Column<U> col, Function1<T, U> conversion, ClassTag<T> evidence$1) {
        Tuple2 tuple2 = FilterExtractingVisitor$.MODULE$.apply(filter, name, sft, FilterExtractingVisitor$.MODULE$.apply$default$4());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option attribute = (Option)tuple2._1();
        Option nonAttribute = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)attribute, (Object)nonAttribute);
        Option attribute2 = (Option)tuple22._1();
        Option nonAttribute2 = (Option)tuple22._2();
        Class binding = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        Option bounds = attribute2.map((Function1 & Serializable & scala.Serializable)x$7 -> FilterHelper$.MODULE$.extractAttributeBounds(x$7, name, binding));
        Option predicate = bounds.flatMap((Function1 & Serializable & scala.Serializable)extracted -> new Some(extracted).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FilterConverter$.$anonfun$attribute$3(e))).map((Function1 & Serializable & scala.Serializable)e -> {
            Seq filters = (Seq)e.values().map((Function1 & Serializable & scala.Serializable)bounds -> {
                Option upper;
                if (bounds.isEquals()) {
                    return FilterApi.eq((Operators.Column)col, (Comparable)((Comparable)conversion.apply(bounds.lower().value().get())));
                }
                Option lower = bounds.lower().value().map((Function1 & Serializable & scala.Serializable)value -> {
                    Comparable converted = (Comparable)conversion.apply(value);
                    if (bounds.lower().inclusive()) {
                        return FilterApi.gtEq((Operators.Column)col, (Comparable)converted);
                    }
                    return FilterApi.gt((Operators.Column)col, (Comparable)converted);
                });
                Tuple2 tuple2 = new Tuple2((Object)lower, (Object)(upper = bounds.upper().value().map((Function1 & Serializable & scala.Serializable)value -> {
                    Comparable converted = (Comparable)conversion.apply(value);
                    if (bounds.upper().inclusive()) {
                        return FilterApi.ltEq((Operators.Column)col, (Comparable)converted);
                    }
                    return FilterApi.lt((Operators.Column)col, (Comparable)converted);
                })));
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option2 = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FilterPredicate lo = (FilterPredicate)some.value();
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            FilterPredicate hi = (FilterPredicate)some2.value();
                            return FilterApi.and((FilterPredicate)lo, (FilterPredicate)hi);
                        }
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option3 = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FilterPredicate f = (FilterPredicate)some.value();
                        if (None$.MODULE$.equals(option3)) {
                            return f;
                        }
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option4 = (Option)tuple2._2();
                    if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                        Some some = (Some)option4;
                        FilterPredicate f = (FilterPredicate)some.value();
                        return f;
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option5 = (Option)tuple2._2();
                    if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option5)) {
                        throw new IllegalStateException();
                    }
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            return MODULE$.merge((Seq<FilterPredicate>)filters);
        }));
        Option remaining = bounds.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.precise())) ? nonAttribute2 : new Some((Object)filter);
        return new Tuple2((Object)predicate, (Object)remaining);
    }

    private Tuple2<Option<FilterPredicate>, Option<Filter>> boolean(SimpleFeatureType sft, String name, Filter filter, Operators.BooleanColumn col) {
        Tuple2 tuple2 = FilterExtractingVisitor$.MODULE$.apply(filter, name, sft, FilterExtractingVisitor$.MODULE$.apply$default$4());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option attribute = (Option)tuple2._1();
        Option nonAttribute = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)attribute, (Object)nonAttribute);
        Option attribute2 = (Option)tuple22._1();
        Option nonAttribute2 = (Option)tuple22._2();
        Option bounds = attribute2.map((Function1 & Serializable & scala.Serializable)x$11 -> FilterHelper$.MODULE$.extractAttributeBounds(x$11, name, Boolean.class));
        Option predicate = bounds.flatMap((Function1 & Serializable & scala.Serializable)extracted -> new Some(extracted).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FilterConverter$.$anonfun$boolean$3(e))).map((Function1 & Serializable & scala.Serializable)e -> (FilterPredicate)((TraversableOnce)e.values().map((Function1 & Serializable & scala.Serializable)bounds -> FilterApi.eq((Operators.Column)col, (Comparable)((Comparable)bounds.lower().value().get())), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.or((FilterPredicate)x$1, (FilterPredicate)x$2))));
        Option remaining = bounds.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.precise())) ? nonAttribute2 : new Some((Object)filter);
        return new Tuple2((Object)predicate, (Object)remaining);
    }

    private <T extends Comparable<T>> FilterPredicate merge(Seq<FilterPredicate> filters) {
        LazyRef values$lzy = new LazyRef();
        if (filters.lengthCompare(2) == 0 && filters.exists((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)FilterConverter$.$anonfun$merge$1(x$14))) && filters.exists((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)FilterConverter$.$anonfun$merge$2(x$15))) && FilterConverter$.values$1(values$lzy, filters).lengthCompare(1) == 0) {
            return FilterApi.notEq((Operators.Column)((Operators.Column)((Tuple2)FilterConverter$.values$1(values$lzy, filters).head())._1()), (Comparable)((Comparable)((Tuple2)FilterConverter$.values$1(values$lzy, filters).head())._2()));
        }
        return (FilterPredicate)filters.reduce((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.or((FilterPredicate)x$1, (FilterPredicate)x$2));
    }

    public static final /* synthetic */ boolean $anonfun$spatial$4(FilterValues e) {
        return e.nonEmpty() && !e.disjoint();
    }

    public static final /* synthetic */ boolean $anonfun$attribute$3(FilterValues e) {
        return e.nonEmpty() && !e.disjoint() && e.values().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isBounded()));
    }

    public static final /* synthetic */ boolean $anonfun$boolean$3(FilterValues e) {
        return e.nonEmpty() && !e.disjoint() && e.values().forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isEquals()));
    }

    private static final /* synthetic */ Seq values$lzycompute$1(LazyRef values$lzy$1, Seq filters$1) {
        Seq seq;
        LazyRef lazyRef = values$lzy$1;
        synchronized (lazyRef) {
            seq = values$lzy$1.initialized() ? (Seq)values$lzy$1.value() : (Seq)values$lzy$1.initialize(((SeqLike)filters$1.collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends FilterPredicate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Operators.Lt) {
                        Operators.Lt lt = (Operators.Lt)A1;
                        return (B1)new Tuple2((Object)lt.getColumn(), (Object)lt.getValue());
                    }
                    if (A1 instanceof Operators.Gt) {
                        Operators.Gt gt = (Operators.Gt)A1;
                        return (B1)new Tuple2((Object)gt.getColumn(), (Object)gt.getValue());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(FilterPredicate x1) {
                    FilterPredicate filterPredicate = x1;
                    if (filterPredicate instanceof Operators.Lt) {
                        return true;
                    }
                    return filterPredicate instanceof Operators.Gt;
                }
            }, Seq$.MODULE$.canBuildFrom())).distinct());
        }
        return seq;
    }

    private static final Seq values$1(LazyRef values$lzy$1, Seq filters$1) {
        if (values$lzy$1.initialized()) {
            return (Seq)values$lzy$1.value();
        }
        return FilterConverter$.values$lzycompute$1(values$lzy$1, filters$1);
    }

    public static final /* synthetic */ boolean $anonfun$merge$1(FilterPredicate x$14) {
        return x$14 instanceof Operators.Lt;
    }

    public static final /* synthetic */ boolean $anonfun$merge$2(FilterPredicate x$15) {
        return x$15 instanceof Operators.Gt;
    }

    private FilterConverter$() {
        MODULE$ = this;
    }
}

