/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import java.io.Serializable;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetWriter;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.common.utils.PathCache$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetPathReader;
import org.locationtech.geomesa.fs.storage.parquet.SimpleFeatureParquetWriter$;
import org.locationtech.geomesa.fs.storage.parquet.package;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadFilter$;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadSchema$;
import org.locationtech.geomesa.security.AuthUtils$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.VisibilityUtils$;
import org.locationtech.geomesa.security.package$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0012%\u0001EB\u0011\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O)\t\u0013I\u0003!\u0011!Q\u0001\nM;\u0006\"\u0002-\u0001\t\u0003I\u0006b\u00020\u0001\u0005\u0004%Ia\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000b\u001d\u0004A\u0011\u000b5\t\u000f\u0005\u0015\u0001\u0001\"\u0015\u0002\b\u001d9\u0011q\r\u0013\t\u0002\u0005%dAB\u0012%\u0011\u0003\tY\u0007\u0003\u0004Y\u0013\u0011\u0005\u0011q\u0011\u0005\n\u0003\u0013K!\u0019!C\u0001\u0003\u0017C\u0001\"a'\nA\u0003%\u0011Q\u0012\u0005\n\u0003;K!\u0019!C\u0001\u0003\u0017C\u0001\"a(\nA\u0003%\u0011Q\u0012\u0005\n\u0003CK!\u0019!C\u0001\u0003\u0017C\u0001\"a)\nA\u0003%\u0011Q\u0012\u0004\u0007\u0003KK\u0001!a*\t\u0015\u0005=\u0016C!A!\u0002\u0013\t9\u0006\u0003\u00059#\t\u0005\t\u0015!\u0003:\u0011!\t\u0018C!A!\u0002\u0013\u0011\b\u0002\u0003?\u0012\u0005\u0003\u0005\u000b\u0011B?\t\ra\u000bB\u0011AAY\u0011%\ty,\u0005b\u0001\n\u0013\t\t\r\u0003\u0005\u0002NF\u0001\u000b\u0011BAb\u0011%\ty-\u0005b\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002fF\u0001\u000b\u0011BAj\u0011\u001d\t9/\u0005C!\u0003SDq!!>\u0012\t\u0003\n9\u0010C\u0004\u0002zF!\t%a>\b\u0013\u0005m\u0018\"!A\t\u0002\u0005uh!CAS\u0013\u0005\u0005\t\u0012AA\u0000\u0011\u0019Av\u0004\"\u0001\u0003\u0002!I!1A\u0010\u0012\u0002\u0013\u0005!Q\u0001\u0005\b\u00057IA\u0011\u0001B\u000f\u0005a\u0001\u0016M]9vKR4\u0015\u000e\\3TsN$X-\\*u_J\fw-\u001a\u0006\u0003K\u0019\nq\u0001]1scV,GO\u0003\u0002(Q\u000591\u000f^8sC\u001e,'BA\u0015+\u0003\t17O\u0003\u0002,Y\u00059q-Z8nKN\f'BA\u0017/\u00031awnY1uS>tG/Z2i\u0015\u0005y\u0013aA8sO\u000e\u00011C\u0001\u00013!\t\u0019d'D\u00015\u0015\t)d%\u0001\u0004d_6lwN\\\u0005\u0003oQ\u0012\u0011$\u00112tiJ\f7\r\u001e$jY\u0016\u001c\u0016p\u001d;f[N#xN]1hK\u000691m\u001c8uKb$\bC\u0001\u001eO\u001d\tY4J\u0004\u0002=\u0013:\u0011Q\b\u0013\b\u0003}\u001ds!a\u0010$\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"1\u0003\u0019a$o\\8u}%\tq&\u0003\u0002.]%\u00111\u0006L\u0005\u0003S)J!a\n\u0015\n\u0005)3\u0013aA1qS&\u0011A*T\u0001\ba\u0006\u001c7.Y4f\u0015\tQe%\u0003\u0002P!\n\tb)\u001b7f'f\u001cH/Z7D_:$X\r\u001f;\u000b\u00051k\u0015B\u0001\u001d7\u0003!iW\r^1eCR\f\u0007C\u0001+V\u001b\u0005i\u0015B\u0001,N\u0005=\u0019Fo\u001c:bO\u0016lU\r^1eCR\f\u0017B\u0001*7\u0003\u0019a\u0014N\\5u}Q\u0019!\fX/\u0011\u0005m\u0003Q\"\u0001\u0013\t\u000ba\u001a\u0001\u0019A\u001d\t\u000bI\u001b\u0001\u0019A*\u0002\u0019\u0005,H\u000f\u001b)s_ZLG-\u001a:\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0016\u0002\u0011M,7-\u001e:jifL!!\u001a2\u0003-\u0005+H\u000f[8sSj\fG/[8ogB\u0013xN^5eKJ\fQ\"Y;uQB\u0013xN^5eKJ\u0004\u0013\u0001D2sK\u0006$Xm\u0016:ji\u0016\u0014HcA5qwB\u0011!.\u001c\b\u0003w-L!\u0001\\'\u0002#\u0019KG.Z*zgR,Wn\u0015;pe\u0006<W-\u0003\u0002o_\n\u0001b)\u001b7f'f\u001cH/Z7Xe&$XM\u001d\u0006\u0003Y6CQ!\u001d\u0004A\u0002I\fAAZ5mKB\u00111/_\u0007\u0002i*\u0011\u0011&\u001e\u0006\u0003m^\fa\u0001[1e_>\u0004(B\u0001=/\u0003\u0019\t\u0007/Y2iK&\u0011!\u0010\u001e\u0002\u0005!\u0006$\b\u000eC\u0003}\r\u0001\u0007Q0\u0001\u0005pEN,'O^3s!\rq\u0018\u0011A\u0007\u0002\u007f*\u0011A\u0010N\u0005\u0004\u0003\u0007y(A\u0005$jY\u0016\u001c\u0016p\u001d;f[>\u00137/\u001a:wKJ\fAb\u0019:fCR,'+Z1eKJ$b!!\u0003\u0002\u001c\u0005m\u0002\u0003BA\u0006\u0003+qA!!\u0004\u0002\u00129\u0019A(a\u0004\n\u0005U2\u0013bAA\ni\u0005I\u0012IY:ue\u0006\u001cGOR5mKNK8\u000f^3n'R|'/Y4f\u0013\u0011\t9\"!\u0007\u0003)\u0019KG.Z*zgR,W\u000eU1uQJ+\u0017\rZ3s\u0015\r\t\u0019\u0002\u000e\u0005\b\u0003;9\u0001\u0019AA\u0010\u0003\u00191\u0017\u000e\u001c;feB1\u0011\u0011EA\u0014\u0003Wi!!a\t\u000b\u0005\u0005\u0015\u0012!B:dC2\f\u0017\u0002BA\u0015\u0003G\u0011aa\u00149uS>t\u0007\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005u\u0011\u0011\u0007\u0006\u0004\u0015\u0006M\"bAA\u001b]\u0005Aq-Z8u_>d7/\u0003\u0003\u0002:\u0005=\"A\u0002$jYR,'\u000fC\u0004\u0002>\u001d\u0001\r!a\u0010\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007CBA\u0011\u0003O\t\t\u0005\u0005\u0005\u0002\"\u0005\r\u0013qIA,\u0013\u0011\t)%a\t\u0003\rQ+\b\u000f\\33!\u0011\tI%!\u0015\u000f\t\u0005-\u0013Q\n\t\u0004\u0003\u0006\r\u0012\u0002BA(\u0003G\ta\u0001\u0015:fI\u00164\u0017\u0002BA*\u0003+\u0012aa\u0015;sS:<'\u0002BA(\u0003G\u0001B!!\u0017\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003C\n\t$A\u0004gK\u0006$XO]3\n\t\u0005\u0015\u00141\f\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001\u0007)beF,X\r\u001e$jY\u0016\u001c\u0016p\u001d;f[N#xN]1hKB\u00111,C\n\u0006\u0013\u00055\u00141\u000f\t\u0005\u0003C\ty'\u0003\u0003\u0002r\u0005\r\"AB!osJ+g\r\u0005\u0003\u0002v\u0005\rUBAA<\u0015\u0011\tI(a\u001f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005u\u0014qP\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011Q\u0001\u0004G>l\u0017\u0002BAC\u0003o\u00121\u0002T1{s2{wmZ5oOR\u0011\u0011\u0011N\u0001\t\u000b:\u001cw\u000eZ5oOV\u0011\u0011Q\u0012\t\u0005\u0003\u001f\u000bI*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0015\u0001\u00026bm\u0006LA!a\u0015\u0002\u0012\u0006IQI\\2pI&tw\rI\u0001\u000e\r&dW-\u0012=uK:\u001c\u0018n\u001c8\u0002\u001d\u0019KG.Z#yi\u0016t7/[8oA\u0005)\u0002+\u0019:rk\u0016$8i\\7qe\u0016\u001c8/[8o\u001fB$\u0018A\u0006)beF,X\r^\"p[B\u0014Xm]:j_:|\u0005\u000f\u001e\u0011\u0003/A\u000b'/];fi\u001aKG.Z*zgR,Wn\u0016:ji\u0016\u00148\u0003B\t\u0002*&\u0004B!a$\u0002,&!\u0011QVAI\u0005\u0019y%M[3di\u0006\u00191O\u001a;\u0015\u0015\u0005M\u0016qWA]\u0003w\u000bi\fE\u0002\u00026Fi\u0011!\u0003\u0005\b\u0003_3\u0002\u0019AA,\u0011\u0015Ad\u00031\u0001:\u0011\u0015\th\u00031\u0001s\u0011\u001dah\u0003%AA\u0002u\fAaY8oMV\u0011\u00111\u0019\t\u0005\u0003\u000b\fI-\u0004\u0002\u0002H*\u0019\u0011qX;\n\t\u0005-\u0017q\u0019\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000b\r|gN\u001a\u0011\u0002\r]\u0014\u0018\u000e^3s+\t\t\u0019\u000e\u0005\u0004\u0002V\u0006m\u0017q\\\u0007\u0003\u0003/T1A^Am\u0015\t)s/\u0003\u0003\u0002^\u0006]'!\u0004)beF,X\r^,sSR,'\u000f\u0005\u0003\u0002Z\u0005\u0005\u0018\u0002BAr\u00037\u0012QbU5na2,g)Z1ukJ,\u0017aB<sSR,'\u000fI\u0001\u0006oJLG/\u001a\u000b\u0005\u0003W\f\t\u0010\u0005\u0003\u0002\"\u00055\u0018\u0002BAx\u0003G\u0011A!\u00168ji\"9\u00111_\u000eA\u0002\u0005}\u0017!\u00014\u0002\u000b\u0019dWo\u001d5\u0015\u0005\u0005-\u0018!B2m_N,\u0017a\u0006)beF,X\r\u001e$jY\u0016\u001c\u0016p\u001d;f[^\u0013\u0018\u000e^3s!\r\t)lH\n\u0004?\u00055DCAA\u007f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0001\u0016\u0004{\n%1F\u0001B\u0006!\u0011\u0011iAa\u0006\u000e\u0005\t=!\u0002\u0002B\t\u0005'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tU\u00111E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\r\u0005\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M1\u0018\r\\5eCR,\u0007+\u0019:rk\u0016$h)\u001b7f)\u0011\tYOa\b\t\u000bE\u0014\u0003\u0019\u0001:")
public class ParquetFileSystemStorage
extends AbstractFileSystemStorage {
    private final AuthorizationsProvider authProvider;

    public static void validateParquetFile(Path path) {
        ParquetFileSystemStorage$.MODULE$.validateParquetFile(path);
    }

    public static String ParquetCompressionOpt() {
        return ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt();
    }

    public static String FileExtension() {
        return ParquetFileSystemStorage$.MODULE$.FileExtension();
    }

    public static String Encoding() {
        return ParquetFileSystemStorage$.MODULE$.Encoding();
    }

    private AuthorizationsProvider authProvider() {
        return this.authProvider;
    }

    public FileSystemStorage.FileSystemWriter createWriter(Path file, FileSystemObserver observer) {
        return new ParquetFileSystemWriter(super.metadata().sft(), super.context(), file, observer);
    }

    public AbstractFileSystemStorage.FileSystemPathReader createReader(Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        BoxedUnit boxedUnit;
        package.ReadSchema readSchema = package$ReadSchema$.MODULE$.apply(super.metadata().sft(), filter, transform);
        if (readSchema == null) {
            throw new MatchError((Object)readSchema);
        }
        SimpleFeatureType readSft = readSchema.read();
        Option<Tuple2<String, SimpleFeatureType>> readTransform = readSchema.transform();
        Tuple2 tuple2 = new Tuple2((Object)readSft, readTransform);
        SimpleFeatureType readSft2 = (SimpleFeatureType)tuple2._1();
        Option readTransform2 = (Option)tuple2._2();
        package.ReadFilter readFilter = package$ReadFilter$.MODULE$.apply(readSft2, filter);
        if (readFilter == null) {
            throw new MatchError((Object)readFilter);
        }
        Option<FilterPredicate> fc = readFilter.parquet();
        Option<Filter> residualFilter = readFilter.residual();
        Tuple2 tuple22 = new Tuple2(fc, residualFilter);
        Option fc2 = (Option)tuple22._1();
        Option residualFilter2 = (Option)tuple22._2();
        FilterCompat.Filter parquetFilter = (FilterCompat.Filter)fc2.map((Function1 & Serializable & scala.Serializable)x$1 -> FilterCompat.get((FilterPredicate)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> FilterCompat.NOOP);
        Option gtFilter = residualFilter2.map((Function1 & Serializable & scala.Serializable)x$4 -> FastFilterFactory$.MODULE$.optimize(readSft2, x$4));
        Function1 visFilter = VisibilityUtils$.MODULE$.visible((Option)new Some((Object)this.authProvider()));
        if (this.logger().underlying().isDebugEnabled()) {
            FilterCompat.Filter filter2;
            Logger logger = this.logger().underlying();
            StringBuilder stringBuilder = new StringBuilder(41).append("Parquet filter: ");
            FilterCompat.Filter filter3 = parquetFilter;
            if (filter3 instanceof FilterCompat.FilterPredicateCompat) {
                FilterCompat.FilterPredicateCompat filterPredicateCompat = (FilterCompat.FilterPredicateCompat)filter3;
                filter2 = filterPredicateCompat.getFilterPredicate();
            } else {
                filter2 = filter3;
            }
            logger.debug(stringBuilder.append(filter2).append(" ").append("and modified gt filter: ").append(gtFilter.getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Configuration conf = new Configuration(super.context().conf());
        StorageConfiguration$.MODULE$.setSft(conf, readSft2);
        return new ParquetPathReader(conf, readSft2, parquetFilter, (Option<Filter>)gtFilter, (Function1<SimpleFeature, Object>)visFilter, (Option<Tuple2<String, SimpleFeatureType>>)readTransform2);
    }

    public static final /* synthetic */ boolean $anonfun$authProvider$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public ParquetFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata) {
        super(context, metadata, ParquetFileSystemStorage$.MODULE$.FileExtension());
        this.authProvider = AuthUtils$.MODULE$.getProvider(Collections.emptyMap(), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])super.context().conf().get(package$.MODULE$.AuthsParam().key, "").split(","))).toSeq().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ParquetFileSystemStorage.$anonfun$authProvider$1(x$1))));
    }

    public static class ParquetFileSystemWriter
    implements FileSystemStorage.FileSystemWriter {
        private final package.FileSystemContext context;
        private final Path file;
        private final FileSystemObserver observer;
        private final Configuration conf;
        private final ParquetWriter<SimpleFeature> writer;

        private Configuration conf() {
            return this.conf;
        }

        private ParquetWriter<SimpleFeature> writer() {
            return this.writer;
        }

        public void write(SimpleFeature f) {
            this.writer().write((Object)f);
            this.observer.write(f);
        }

        public void flush() {
            this.observer.flush();
        }

        public void close() {
            package.CloseQuietly$.MODULE$.apply((Object)new .colon.colon(this.writer(), (List)new .colon.colon((Object)this.observer, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable()).foreach((Function1 & Serializable & scala.Serializable)e -> {
                throw e;
            });
            PathCache$.MODULE$.register(this.context.fs(), this.file);
            if (BoxesRunTime.unboxToBoolean((Object)org.locationtech.geomesa.fs.storage.common.package$.MODULE$.FileValidationEnabled().toBoolean().get())) {
                ParquetFileSystemStorage$.MODULE$.validateParquetFile(this.file);
                return;
            }
        }

        public ParquetFileSystemWriter(SimpleFeatureType sft, package.FileSystemContext context, Path file, FileSystemObserver observer) {
            this.context = context;
            this.file = file;
            this.observer = observer;
            Configuration conf = new Configuration(context.conf());
            StorageConfiguration$.MODULE$.setSft(conf, sft);
            this.conf = conf;
            this.writer = SimpleFeatureParquetWriter$.MODULE$.builder(file, this.conf()).build();
        }
    }
}

