/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.locationtech.geomesa.fs.storage.parquet.io.GeoParquetMetadata;
import org.locationtech.geomesa.fs.storage.parquet.io.GeoParquetMetadata$GeoParquetColumnEncoding$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeoParquetMetadata$GeoParquetColumnType$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeoParquetMetadata$RichJsonObject$;
import org.locationtech.jts.geom.Envelope;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;

public final class GeoParquetMetadata$
implements scala.Serializable {
    public static GeoParquetMetadata$ MODULE$;
    private final String GeoParquetMetadataKey;
    private final Gson gson;

    static {
        new GeoParquetMetadata$();
    }

    public String GeoParquetMetadataKey() {
        return this.GeoParquetMetadataKey;
    }

    private Gson gson() {
        return this.gson;
    }

    public String toJson(GeoParquetMetadata metadata) {
        JsonObject model = new JsonObject();
        model.addProperty("version", "1.1.0");
        model.addProperty("primary_column", metadata.primaryGeometry());
        JsonObject cols = GeoParquetMetadata$RichJsonObject$.MODULE$.addObject$extension(this.RichJsonObject(model), "columns");
        metadata.geometries().foreach((Function1 & Serializable & scala.Serializable)column -> {
            GeoParquetMetadata$.$anonfun$toJson$1(cols, column);
            return BoxedUnit.UNIT;
        });
        return this.gson().toJson((JsonElement)model);
    }

    public GeoParquetMetadata fromJson(String json) {
        JsonObject obj = (JsonObject)this.gson().fromJson(json, JsonObject.class);
        String primary = obj.get("primary_column").getAsString();
        Set cols = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(obj.getAsJsonObject("columns").entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
            String name = (String)entry.getKey();
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            Enumeration.Value encoding = GeoParquetMetadata$GeoParquetColumnEncoding$.MODULE$.withName(obj.get("encoding").getAsString());
            Buffer types = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(obj.getAsJsonArray("geometry_types").asList()).asScala()).map((Function1 & Serializable & scala.Serializable)t -> GeoParquetMetadata$GeoParquetColumnType$.MODULE$.withName(t.getAsString()), Buffer$.MODULE$.canBuildFrom());
            Option covering = Option$.MODULE$.apply((Object)obj.getAsJsonObject("covering")).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAsJsonObject("bbox").getAsJsonArray("xmin").get(0).getAsString());
            Envelope bounds = new Envelope();
            Option$.MODULE$.apply((Object)obj.getAsJsonArray("bbox")).foreach((Function1 & Serializable & scala.Serializable)bbox -> {
                GeoParquetMetadata$.$anonfun$fromJson$4(bounds, bbox);
                return BoxedUnit.UNIT;
            });
            return new GeoParquetMetadata.ColumnMetadata(name, encoding, (Seq<Enumeration.Value>)types.toSeq(), (Option<String>)covering, bounds);
        }, Set$.MODULE$.canBuildFrom());
        return new GeoParquetMetadata(primary, (Seq<GeoParquetMetadata.ColumnMetadata>)cols.toSeq());
    }

    private JsonObject RichJsonObject(JsonObject o) {
        return o;
    }

    public GeoParquetMetadata apply(String primaryGeometry, Seq<GeoParquetMetadata.ColumnMetadata> geometries) {
        return new GeoParquetMetadata(primaryGeometry, geometries);
    }

    public Option<Tuple2<String, Seq<GeoParquetMetadata.ColumnMetadata>>> unapply(GeoParquetMetadata x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.primaryGeometry(), x$0.geometries()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$toJson$4(JsonObject bbox$1, String c$1, String name) {
        JsonArray bound = GeoParquetMetadata$RichJsonObject$.MODULE$.addArray$extension(MODULE$.RichJsonObject(bbox$1), name, 2);
        bound.add(c$1);
        bound.add(name);
    }

    public static final /* synthetic */ void $anonfun$toJson$3(JsonObject metadata$1, String c) {
        JsonObject bbox = GeoParquetMetadata$RichJsonObject$.MODULE$.addObject$extension(MODULE$.RichJsonObject(GeoParquetMetadata$RichJsonObject$.MODULE$.addObject$extension(MODULE$.RichJsonObject(metadata$1), "covering")), "bbox");
        ((IterableLike)new .colon.colon((Object)"xmin", (List)new .colon.colon((Object)"ymin", (List)new .colon.colon((Object)"xmax", (List)new .colon.colon((Object)"ymax", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            GeoParquetMetadata$.$anonfun$toJson$4(bbox, c, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$toJson$1(JsonObject cols$1, GeoParquetMetadata.ColumnMetadata column) {
        JsonObject metadata = GeoParquetMetadata$RichJsonObject$.MODULE$.addObject$extension(MODULE$.RichJsonObject(cols$1), column.name());
        metadata.addProperty("encoding", column.encoding().toString());
        JsonArray types = GeoParquetMetadata$RichJsonObject$.MODULE$.addArray$extension(MODULE$.RichJsonObject(metadata), "geometry_types", 1);
        column.types().foreach((Function1 & Serializable & scala.Serializable)t -> {
            types.add(t.toString());
            return BoxedUnit.UNIT;
        });
        if (!column.bounds().isNull()) {
            JsonArray bbox = GeoParquetMetadata$RichJsonObject$.MODULE$.addArray$extension(MODULE$.RichJsonObject(metadata), "bbox", 4);
            bbox.add((Number)Predef$.MODULE$.double2Double(column.bounds().getMinX()));
            bbox.add((Number)Predef$.MODULE$.double2Double(column.bounds().getMinY()));
            bbox.add((Number)Predef$.MODULE$.double2Double(column.bounds().getMaxX()));
            bbox.add((Number)Predef$.MODULE$.double2Double(column.bounds().getMaxY()));
        }
        column.covering().foreach((Function1 & Serializable & scala.Serializable)c -> {
            GeoParquetMetadata$.$anonfun$toJson$3(metadata, c);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fromJson$4(Envelope bounds$1, JsonArray bbox) {
        bounds$1.expandToInclude(bbox.get(0).getAsDouble(), bbox.get(1).getAsDouble());
        bounds$1.expandToInclude(bbox.get(2).getAsDouble(), bbox.get(3).getAsDouble());
    }

    private GeoParquetMetadata$() {
        MODULE$ = this;
        this.GeoParquetMetadataKey = "geo";
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
    }
}

