/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.locationtech.geomesa.fs.storage.parquet.SimpleFeatureParquetWriter;
import scala.runtime.BoxedUnit;

public final class SimpleFeatureParquetWriter$
implements LazyLogging {
    public static final SimpleFeatureParquetWriter$ MODULE$ = new SimpleFeatureParquetWriter$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        SimpleFeatureParquetWriter$ simpleFeatureParquetWriter$ = this;
        synchronized (simpleFeatureParquetWriter$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public SimpleFeatureParquetWriter.Builder builder(Path file, Configuration conf) {
        BoxedUnit boxedUnit;
        CompressionCodecName codec = CompressionCodecName.fromConf((String)conf.get("parquet.compression", "SNAPPY"));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Using Parquet Compression codec {}", (Object)codec.name());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (SimpleFeatureParquetWriter.Builder)new SimpleFeatureParquetWriter.Builder(file).withConf(conf).withCompressionCodec(codec).withDictionaryEncoding(true).withDictionaryPageSize(0x100000).withMaxPaddingSize(0x800000).withPageSize(0x100000).withValidation(false).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0).withRowGroupSize(0x800000);
    }

    private SimpleFeatureParquetWriter$() {
    }
}

