/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetWriter;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.api.package;
import org.locationtech.geomesa.fs.storage.common.AbstractFileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.observer.FileSystemObserver;
import org.locationtech.geomesa.fs.storage.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetPathReader;
import org.locationtech.geomesa.fs.storage.parquet.SimpleFeatureParquetWriter$;
import org.locationtech.geomesa.fs.storage.parquet.package;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadFilter$;
import org.locationtech.geomesa.fs.storage.parquet.package$ReadSchema$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0010 \u00011B\u0011b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e'\t\u00135\u0003!\u0011!Q\u0001\n9\u0013\u0006\"B*\u0001\t\u0003!\u0006\"B-\u0001\t#R\u0006\"\u0002;\u0001\t#*xaBA%?!\u0005\u00111\n\u0004\u0007=}A\t!!\u0014\t\rM;A\u0011AA+\u0011%\t9f\u0002b\u0001\n\u0003\tI\u0006\u0003\u0005\u0002j\u001d\u0001\u000b\u0011BA.\u0011%\tYg\u0002b\u0001\n\u0003\tI\u0006\u0003\u0005\u0002n\u001d\u0001\u000b\u0011BA.\u0011%\tyg\u0002b\u0001\n\u0003\tI\u0006\u0003\u0005\u0002r\u001d\u0001\u000b\u0011BA.\r\u0019\t\u0019h\u0002\u0001\u0002v!Q\u0011QP\b\u0003\u0002\u0003\u0006I!!\u000f\t\u0011\r|!\u0011!Q\u0001\n\u0011D!\"a \u0010\u0005\u0003\u0005\u000b\u0011BAA\u0011!qwB!A!\u0002\u0013y\u0007BB*\u0010\t\u0003\tY\tC\u0005\u0002\u001a>\u0011\r\u0011\"\u0003\u0002\u001c\"A\u0011qV\b!\u0002\u0013\ti\nC\u0004\u00022>!\t%a-\t\u000f\u0005}v\u0002\"\u0011\u0002B\"9\u00111Y\b\u0005B\u0005\u0005w!CAc\u000f\u0005\u0005\t\u0012AAd\r%\t\u0019hBA\u0001\u0012\u0003\tI\r\u0003\u0004T7\u0011\u0005\u00111\u001a\u0005\n\u0003\u001b\\\u0012\u0013!C\u0001\u0003\u001f\u0014\u0001\u0004U1scV,GOR5mKNK8\u000f^3n'R|'/Y4f\u0015\t\u0001\u0013%A\u0004qCJ\fX/\u001a;\u000b\u0005\t\u001a\u0013aB:u_J\fw-\u001a\u0006\u0003I\u0015\n!AZ:\u000b\u0005\u0019:\u0013aB4f_6,7/\u0019\u0006\u0003Q%\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011AK\u0001\u0004_J<7\u0001A\n\u0003\u00015\u0002\"AL\u0019\u000e\u0003=R!\u0001M\u0011\u0002\r\r|W.\\8o\u0013\t\u0011tFA\rBEN$(/Y2u\r&dWmU=ti\u0016l7\u000b^8sC\u001e,\u0017aB2p]R,\u0007\u0010\u001e\t\u0003k%s!A\u000e$\u000f\u0005]\"eB\u0001\u001dD\u001d\tI$I\u0004\u0002;\u0003:\u00111\b\u0011\b\u0003y}j\u0011!\u0010\u0006\u0003}-\na\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0005!J\u0013B\u0001\u0014(\u0013\t!S%\u0003\u0002#G%\u0011Q)I\u0001\u0004CBL\u0017BA$I\u0003\u001d\u0001\u0018mY6bO\u0016T!!R\u0011\n\u0005)[%!\u0005$jY\u0016\u001c\u0016p\u001d;f[\u000e{g\u000e^3yi*\u0011q\tS\u0005\u0003gE\n\u0001\"\\3uC\u0012\fG/\u0019\t\u0003\u001fBk\u0011\u0001S\u0005\u0003#\"\u0013qb\u0015;pe\u0006<W-T3uC\u0012\fG/Y\u0005\u0003\u001bF\na\u0001P5oSRtDcA+X1B\u0011a\u000bA\u0007\u0002?!)1g\u0001a\u0001i!)Qj\u0001a\u0001\u001d\u0006a1M]3bi\u0016<&/\u001b;feR\u00191LY7\u0011\u0005q{fB\u0001\u001c^\u0013\tq\u0006*A\tGS2,7+_:uK6\u001cFo\u001c:bO\u0016L!\u0001Y1\u0003!\u0019KG.Z*zgR,Wn\u0016:ji\u0016\u0014(B\u00010I\u0011\u0015\u0019G\u00011\u0001e\u0003\u00111\u0017\u000e\\3\u0011\u0005\u0015\\W\"\u00014\u000b\u0005\u0011:'B\u00015j\u0003\u0019A\u0017\rZ8pa*\u0011!.K\u0001\u0007CB\f7\r[3\n\u000514'\u0001\u0002)bi\"DQA\u001c\u0003A\u0002=\f\u0001b\u001c2tKJ4XM\u001d\t\u0003aJl\u0011!\u001d\u0006\u0003]>J!a]9\u0003%\u0019KG.Z*zgR,Wn\u00142tKJ4XM]\u0001\rGJ,\u0017\r^3SK\u0006$WM\u001d\u000b\u0005m~\fi\u0002\u0005\u0002xy:\u0011\u0001P\u001f\b\u0003oeL!\u0001M\u0011\n\u0005m|\u0013!G!cgR\u0014\u0018m\u0019;GS2,7+_:uK6\u001cFo\u001c:bO\u0016L!! @\u0003)\u0019KG.Z*zgR,W\u000eU1uQJ+\u0017\rZ3s\u0015\tYx\u0006C\u0004\u0002\u0002\u0015\u0001\r!a\u0001\u0002\r\u0019LG\u000e^3s!\u0019\t)!a\u0003\u0002\u00105\u0011\u0011q\u0001\u0006\u0003\u0003\u0013\tQa]2bY\u0006LA!!\u0004\u0002\b\t1q\n\u001d;j_:\u0004B!!\u0005\u0002\u001a5\u0011\u00111\u0003\u0006\u0005\u0003\u0003\t)BC\u0002\u0002\u0018%\nqa\u001c9f]\u001eL7/\u0003\u0003\u0002\u001c\u0005M!A\u0002$jYR,'\u000fC\u0004\u0002 \u0015\u0001\r!!\t\u0002\u0013Q\u0014\u0018M\\:g_Jl\u0007CBA\u0003\u0003\u0017\t\u0019\u0003\u0005\u0005\u0002\u0006\u0005\u0015\u0012\u0011FA\u001d\u0013\u0011\t9#a\u0002\u0003\rQ+\b\u000f\\33!\u0011\tY#a\r\u000f\t\u00055\u0012q\u0006\t\u0004y\u0005\u001d\u0011\u0002BA\u0019\u0003\u000f\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001b\u0003o\u0011aa\u0015;sS:<'\u0002BA\u0019\u0003\u000f\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003\u0007\n)\"A\u0004gK\u0006$XO]3\n\t\u0005\u001d\u0013Q\b\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017\u0001\u0007)beF,X\r\u001e$jY\u0016\u001c\u0016p\u001d;f[N#xN]1hKB\u0011akB\n\u0004\u000f\u0005=\u0003\u0003BA\u0003\u0003#JA!a\u0015\u0002\b\t1\u0011I\\=SK\u001a$\"!a\u0013\u0002\u0011\u0015s7m\u001c3j]\u001e,\"!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005!A.\u00198h\u0015\t\t)'\u0001\u0003kCZ\f\u0017\u0002BA\u001b\u0003?\n\u0011\"\u00128d_\u0012Lgn\u001a\u0011\u0002\u001b\u0019KG.Z#yi\u0016t7/[8o\u000391\u0015\u000e\\3FqR,gn]5p]\u0002\nQ\u0003U1scV,GoQ8naJ,7o]5p]>\u0003H/\u0001\fQCJ\fX/\u001a;D_6\u0004(/Z:tS>tw\n\u001d;!\u0005]\u0001\u0016M]9vKR4\u0015\u000e\\3TsN$X-\\,sSR,'o\u0005\u0003\u0010\u0003oZ\u0006\u0003BA/\u0003sJA!a\u001f\u0002`\t1qJ\u00196fGR\f1a\u001d4u\u0003\u0011\u0019wN\u001c4\u0011\t\u0005\r\u0015qQ\u0007\u0003\u0003\u000bS1!a h\u0013\u0011\tI)!\"\u0003\u001b\r{gNZ5hkJ\fG/[8o))\ti)!%\u0002\u0014\u0006U\u0015q\u0013\t\u0004\u0003\u001f{Q\"A\u0004\t\u000f\u0005uD\u00031\u0001\u0002:!)1\r\u0006a\u0001I\"9\u0011q\u0010\u000bA\u0002\u0005\u0005\u0005b\u00028\u0015!\u0003\u0005\ra\\\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005u\u0005CBAP\u0003K\u000bI+\u0004\u0002\u0002\"*\u0019\u0001.a)\u000b\u0005\u0001J\u0017\u0002BAT\u0003C\u0013Q\u0002U1scV,Go\u0016:ji\u0016\u0014\b\u0003BA\u001e\u0003WKA!!,\u0002>\ti1+[7qY\u00164U-\u0019;ve\u0016\fqa\u001e:ji\u0016\u0014\b%A\u0003xe&$X\r\u0006\u0003\u00026\u0006m\u0006\u0003BA\u0003\u0003oKA!!/\u0002\b\t!QK\\5u\u0011\u001d\til\u0006a\u0001\u0003S\u000b\u0011AZ\u0001\u0006M2,8\u000f\u001b\u000b\u0003\u0003k\u000bQa\u00197pg\u0016\fq\u0003U1scV,GOR5mKNK8\u000f^3n/JLG/\u001a:\u0011\u0007\u0005=5dE\u0002\u001c\u0003\u001f\"\"!a2\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\tNK\u0002p\u0003'\\#!!6\u0011\t\u0005]\u0017\u0011]\u0007\u0003\u00033TA!a7\u0002^\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0003?\f9!\u0001\u0006b]:|G/\u0019;j_:LA!a9\u0002Z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ParquetFileSystemStorage
extends AbstractFileSystemStorage {
    public static String ParquetCompressionOpt() {
        return ParquetFileSystemStorage$.MODULE$.ParquetCompressionOpt();
    }

    public static String FileExtension() {
        return ParquetFileSystemStorage$.MODULE$.FileExtension();
    }

    public static String Encoding() {
        return ParquetFileSystemStorage$.MODULE$.Encoding();
    }

    public FileSystemStorage.FileSystemWriter createWriter(Path file, FileSystemObserver observer) {
        Configuration sftConf = new Configuration(super.context().conf());
        StorageConfiguration$.MODULE$.setSft(sftConf, super.metadata().sft());
        return new ParquetFileSystemWriter(super.metadata().sft(), file, sftConf, observer);
    }

    public AbstractFileSystemStorage.FileSystemPathReader createReader(Option<Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform) {
        BoxedUnit boxedUnit;
        package.ReadSchema readSchema = package$ReadSchema$.MODULE$.apply(super.metadata().sft(), filter, transform);
        if (readSchema == null) {
            throw new MatchError((Object)readSchema);
        }
        SimpleFeatureType readSft = readSchema.read();
        Option<Tuple2<String, SimpleFeatureType>> readTransform = readSchema.transform();
        Tuple2 tuple2 = new Tuple2((Object)readSft, readTransform);
        SimpleFeatureType readSft2 = (SimpleFeatureType)tuple2._1();
        Option readTransform2 = (Option)tuple2._2();
        package.ReadFilter readFilter = package$ReadFilter$.MODULE$.apply(readSft2, filter);
        if (readFilter == null) {
            throw new MatchError((Object)readFilter);
        }
        Option<FilterPredicate> fc = readFilter.parquet();
        Option<Filter> residualFilter = readFilter.residual();
        Tuple2 tuple22 = new Tuple2(fc, residualFilter);
        Option fc2 = (Option)tuple22._1();
        Option residualFilter2 = (Option)tuple22._2();
        FilterCompat.Filter parquetFilter = (FilterCompat.Filter)fc2.map((Function1 & Serializable)x$1 -> FilterCompat.get((FilterPredicate)x$1)).getOrElse((Function0 & Serializable)() -> FilterCompat.NOOP);
        Option gtFilter = residualFilter2.map((Function1 & Serializable)x$3 -> FastFilterFactory$.MODULE$.optimize(readSft2, x$3));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Parquet filter: {} and modified gt filter: {}", new Object[]{parquetFilter, gtFilter.getOrElse((Function0 & Serializable)() -> Filter.INCLUDE)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Configuration conf = new Configuration(super.context().conf());
        StorageConfiguration$.MODULE$.setSft(conf, readSft2);
        return new ParquetPathReader(conf, readSft2, parquetFilter, (Option<Filter>)gtFilter, (Option<Tuple2<String, SimpleFeatureType>>)readTransform2);
    }

    public ParquetFileSystemStorage(package.FileSystemContext context, StorageMetadata metadata) {
        super(context, metadata, ParquetFileSystemStorage$.MODULE$.FileExtension());
    }

    public static class ParquetFileSystemWriter
    implements FileSystemStorage.FileSystemWriter {
        private final FileSystemObserver observer;
        private final ParquetWriter<SimpleFeature> writer;

        private ParquetWriter<SimpleFeature> writer() {
            return this.writer;
        }

        public void write(SimpleFeature f) {
            this.writer().write((Object)f);
            this.observer.write(f);
        }

        public void flush() {
            this.observer.flush();
        }

        public void close() {
            package.CloseQuietly$.MODULE$.apply((Object)new .colon.colon(this.writer(), (List)new .colon.colon((Object)this.observer, (List)Nil$.MODULE$)), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable()).foreach((Function1 & Serializable)e -> {
                throw e;
            });
        }

        public ParquetFileSystemWriter(SimpleFeatureType sft, Path file, Configuration conf, FileSystemObserver observer) {
            this.observer = observer;
            this.writer = SimpleFeatureParquetWriter$.MODULE$.builder(file, conf).build();
        }
    }
}

