/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import scala.runtime.BoxedUnit;

public final class ParquetFileSystemStorage$
implements LazyLogging {
    public static final ParquetFileSystemStorage$ MODULE$ = new ParquetFileSystemStorage$();
    private static final String Encoding;
    private static final String FileExtension;
    private static final String ParquetCompressionOpt;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        Encoding = "parquet";
        FileExtension = "parquet";
        ParquetCompressionOpt = "parquet.compression";
    }

    private Logger logger$lzycompute() {
        ParquetFileSystemStorage$ parquetFileSystemStorage$ = this;
        synchronized (parquetFileSystemStorage$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String Encoding() {
        return Encoding;
    }

    public String FileExtension() {
        return FileExtension;
    }

    public String ParquetCompressionOpt() {
        return ParquetCompressionOpt;
    }

    public void validateParquetFile(Path file) {
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).build();){
            try {
                BoxedUnit boxedUnit;
                Group record = (Group)reader.read();
                while (record != null) {
                    record = (Group)reader.read();
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("{} is a valid Parquet file", (Object)file);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(new StringBuilder(42).append("Unable to validate ").append(file).append(": File may be corrupted").toString(), e);
            }
        }
    }

    private ParquetFileSystemStorage$() {
    }
}

