/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class ParquetFileSystemStorage$
implements LazyLogging {
    public static final ParquetFileSystemStorage$ MODULE$ = new ParquetFileSystemStorage$();
    private static final String Encoding;
    private static final String FileExtension;
    private static final String ParquetCompressionOpt;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        Encoding = "parquet";
        FileExtension = "parquet";
        ParquetCompressionOpt = "parquet.compression";
    }

    private Logger logger$lzycompute() {
        ParquetFileSystemStorage$ parquetFileSystemStorage$ = this;
        synchronized (parquetFileSystemStorage$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String Encoding() {
        return Encoding;
    }

    public String FileExtension() {
        return FileExtension;
    }

    public String ParquetCompressionOpt() {
        return ParquetCompressionOpt;
    }

    public void validateParquetFile(Path file) {
        try (ParquetReader reader = null;){
            try {
                BoxedUnit boxedUnit;
                reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).build();
                Group record = (Group)reader.read();
                while (record != null) {
                    record = (Group)reader.read();
                }
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace("{} is a valid Parquet file", (Object)file);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new RuntimeException(new StringBuilder(42).append("Unable to validate ").append(file).append(": File may be corrupted").toString(), e);
                }
                throw throwable;
            }
        }
    }

    private ParquetFileSystemStorage$() {
    }
}

