/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.parquet.io;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$BoundingBoxField$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$GeometryEncoding$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$GeometryEncoding$GeoMesaV0$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$GeometryEncoding$GeoMesaV1$;
import org.locationtech.geomesa.fs.storage.parquet.io.GeometrySchema$GeometryEncoding$GeoParquetWkb$;
import org.locationtech.geomesa.fs.storage.parquet.io.SimpleFeatureParquetSchema;
import org.locationtech.geomesa.fs.storage.parquet.io.package;
import org.locationtech.geomesa.fs.storage.parquet.io.package$DateEncoding$;
import org.locationtech.geomesa.fs.storage.parquet.io.package$Encodings$;
import org.locationtech.geomesa.fs.storage.parquet.io.package$ListEncoding$;
import org.locationtech.geomesa.fs.storage.parquet.io.package$UuidEncoding$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class SimpleFeatureParquetSchema$
implements LazyLogging,
Serializable {
    public static final SimpleFeatureParquetSchema$ MODULE$ = new SimpleFeatureParquetSchema$();
    private static final String FeatureIdField;
    private static final String VisibilitiesField;
    private static final String SchemaVersionKey;
    private static final String GeometryEncodingKey;
    private static final String BBoxEncodingKey;
    private static final String VisibilityEncodingKey;
    private static final String GeometryColumnX;
    private static final String GeometryColumnY;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        FeatureIdField = "__fid__";
        VisibilitiesField = "__vis__";
        SchemaVersionKey = "geomesa.parquet.version";
        GeometryEncodingKey = "geomesa.parquet.geometries";
        BBoxEncodingKey = "geomesa.parquet.bounding-boxes";
        VisibilityEncodingKey = "geomesa.fs.visibilities";
        GeometryColumnX = GeometrySchema$.MODULE$.GeometryColumnX();
        GeometryColumnY = GeometrySchema$.MODULE$.GeometryColumnY();
    }

    private Logger logger$lzycompute() {
        SimpleFeatureParquetSchema$ simpleFeatureParquetSchema$ = this;
        synchronized (simpleFeatureParquetSchema$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String FeatureIdField() {
        return FeatureIdField;
    }

    public String VisibilitiesField() {
        return VisibilitiesField;
    }

    public String SchemaVersionKey() {
        return SchemaVersionKey;
    }

    public String GeometryEncodingKey() {
        return GeometryEncodingKey;
    }

    public String BBoxEncodingKey() {
        return BBoxEncodingKey;
    }

    public String VisibilityEncodingKey() {
        return VisibilityEncodingKey;
    }

    public String GeometryColumnX() {
        return GeometryColumnX;
    }

    public String GeometryColumnY() {
        return GeometryColumnY;
    }

    public Option<SimpleFeatureParquetSchema> read(InitContext context) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(context.getKeyValueMetadata()).asScala()).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Set v = (Set)tuple2._2();
                if (!v.isEmpty()) {
                    return metadata.put(k, (String)v.iterator().next());
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        ParquetConfiguration conf = context.getParquetConfiguration();
        new .colon.colon((Object)StorageConfiguration$.MODULE$.SftNameKey(), (List)new .colon.colon((Object)StorageConfiguration$.MODULE$.SftSpecKey(), (List)new .colon.colon((Object)this.GeometryEncodingKey(), (List)new .colon.colon((Object)this.SchemaVersionKey(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)key -> {
            SimpleFeatureParquetSchema$.$anonfun$read$2(conf, metadata, key);
            return BoxedUnit.UNIT;
        });
        return this.read(context.getFileSchema(), metadata);
    }

    public Option<SimpleFeatureParquetSchema> read(FileMetaData footer) {
        return this.read(footer.getSchema(), footer.getKeyValueMetaData());
    }

    public Option<SimpleFeatureParquetSchema> write(Configuration conf) {
        String vis = conf.get(this.VisibilityEncodingKey());
        return this.write(conf.get(StorageConfiguration$.MODULE$.SftNameKey()), conf.get(StorageConfiguration$.MODULE$.SftSpecKey()), conf.get(this.GeometryEncodingKey()), conf.get(this.BBoxEncodingKey()), vis);
    }

    public Option<SimpleFeatureParquetSchema> write(ParquetConfiguration conf) {
        String vis = conf.get(this.VisibilityEncodingKey());
        return this.write(conf.get(StorageConfiguration$.MODULE$.SftNameKey()), conf.get(StorageConfiguration$.MODULE$.SftSpecKey()), conf.get(this.GeometryEncodingKey()), conf.get(this.BBoxEncodingKey()), vis);
    }

    private Option<SimpleFeatureParquetSchema> read(MessageType fileSchema, Map<String, String> metadata) {
        return Option$.MODULE$.apply((Object)metadata.get(StorageConfiguration$.MODULE$.SftNameKey())).flatMap((Function1 & Serializable)name -> Option$.MODULE$.apply(metadata.get(StorageConfiguration$.MODULE$.SftSpecKey())).map((Function1 & Serializable)spec -> {
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(name, spec);
            GeometrySchema.GeometryEncoding geometries = (GeometrySchema.GeometryEncoding)Option$.MODULE$.apply(metadata.get(MODULE$.GeometryEncodingKey())).map((Function1 & Serializable)name -> GeometrySchema$GeometryEncoding$.MODULE$.apply((String)name)).getOrElse((Function0 & Serializable)() -> {
                Object v = metadata.get(MODULE$.SchemaVersionKey());
                String string = "1";
                if (!(v != null ? !v.equals(string) : string != null)) {
                    return GeometrySchema$GeometryEncoding$GeoMesaV1$.MODULE$;
                }
                return GeometrySchema$GeometryEncoding$GeoMesaV0$.MODULE$;
            });
            package.Encodings encodings = package$Encodings$.MODULE$.apply(geometries);
            Seq bboxes = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fileSchema.getFields()).asScala()).map((Function1 & Serializable)x$3 -> x$3.getName())).flatMap((Function1 & Serializable)bbox -> GeometrySchema$BoundingBoxField$.MODULE$.fromBoundingBox((String)bbox))).toSeq();
            boolean visibilities = fileSchema.containsField(MODULE$.VisibilitiesField());
            return new SimpleFeatureParquetSchema(sft, encodings, visibilities, (Seq<GeometrySchema.BoundingBoxField>)bboxes, Collections.unmodifiableMap(metadata));
        }));
    }

    private Option<SimpleFeatureParquetSchema> write(String sftName, String sftSpec, String geoms, String bboxOpt, String vis) {
        return Option$.MODULE$.apply((Object)sftName).flatMap((Function1 & Serializable)name -> Option$.MODULE$.apply((Object)sftSpec).map((Function1 & Serializable)spec -> {
            SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(name, spec);
            GeometrySchema.GeometryEncoding geometries = (GeometrySchema.GeometryEncoding)Option$.MODULE$.apply((Object)geoms).map((Function1 & Serializable)name -> GeometrySchema$GeometryEncoding$.MODULE$.apply((String)name)).getOrElse((Function0 & Serializable)() -> GeometrySchema$GeometryEncoding$GeoParquetWkb$.MODULE$);
            Seq bboxes = bboxOpt != null && !StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(bboxOpt)) ? (Seq)package$.MODULE$.Seq().empty() : GeometrySchema$BoundingBoxField$.MODULE$.apply(sft, geometries);
            boolean visibilities = Option$.MODULE$.apply(sft.getUserData().get(MODULE$.VisibilityEncodingKey())).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)vis)).forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$4.toString()))));
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(StorageConfiguration$.MODULE$.SftNameKey(), (String)name);
            metadata.put(StorageConfiguration$.MODULE$.SftSpecKey(), (String)spec);
            metadata.put(MODULE$.GeometryEncodingKey(), geometries.toString());
            GeometrySchema.GeometryEncoding geometryEncoding = geometries;
            GeometrySchema$GeometryEncoding$GeoMesaV1$ geometrySchema$GeometryEncoding$GeoMesaV1$ = GeometrySchema$GeometryEncoding$GeoMesaV1$.MODULE$;
            Object object = !(geometryEncoding != null ? !geometryEncoding.equals(geometrySchema$GeometryEncoding$GeoMesaV1$) : geometrySchema$GeometryEncoding$GeoMesaV1$ != null) ? metadata.put(MODULE$.SchemaVersionKey(), "1") : BoxedUnit.UNIT;
            package.Encodings encodings = package$Encodings$.MODULE$.apply(geometries);
            return new SimpleFeatureParquetSchema(sft, encodings, visibilities, (Seq<GeometrySchema.BoundingBoxField>)bboxes, Collections.unmodifiableMap(metadata));
        }));
    }

    public MessageType org$locationtech$geomesa$fs$storage$parquet$io$SimpleFeatureParquetSchema$$schema(SimpleFeatureType sft, package.Encodings encodings, Seq<String> bboxes, boolean visibilities) {
        GeometrySchema.GeometryEncoding geometryEncoding = encodings.geometry();
        GeometrySchema$GeometryEncoding$GeoMesaV0$ geometrySchema$GeometryEncoding$GeoMesaV0$ = GeometrySchema$GeometryEncoding$GeoMesaV0$.MODULE$;
        boolean isV0 = !(geometryEncoding != null ? !geometryEncoding.equals(geometrySchema$GeometryEncoding$GeoMesaV0$) : geometrySchema$GeometryEncoding$GeoMesaV0$ != null);
        PrimitiveType.PrimitiveTypeName primitive = PrimitiveType.PrimitiveTypeName.BINARY;
        Types.PrimitiveBuilder builder = isV0 ? Types.primitive((PrimitiveType.PrimitiveTypeName)primitive, (Type.Repetition)Type.Repetition.REPEATED) : Types.required((PrimitiveType.PrimitiveTypeName)primitive);
        PrimitiveType id = (PrimitiveType)builder.as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()).named(this.FeatureIdField());
        None$ vis = !visibilities ? None$.MODULE$ : new Some(Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()).named(this.VisibilitiesField()));
        Seq boundingBoxes = (Seq)bboxes.map((Function1 & Serializable)bbox -> GeometrySchema$BoundingBoxField$.MODULE$.schema((String)bbox));
        Buffer fields = (Buffer)((IterableOps)((IterableOps)((SeqOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable)x$5 -> MODULE$.schema((AttributeDescriptor)x$5, encodings))).$colon$plus((Object)id)).$plus$plus((IterableOnce)vis)).$plus$plus((IterableOnce)boundingBoxes);
        String name = isV0 ? sft.getTypeName() : StringSerialization$.MODULE$.alphaNumericSafeString(sft.getTypeName());
        return new MessageType(name, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(fields).asJava());
    }

    private Type schema(AttributeDescriptor descriptor, package.Encodings encodings) {
        GeometrySchema.GeometryEncoding geometryEncoding = encodings.geometry();
        GeometrySchema$GeometryEncoding$GeoMesaV0$ geometrySchema$GeometryEncoding$GeoMesaV0$ = GeometrySchema$GeometryEncoding$GeoMesaV0$.MODULE$;
        boolean isV0 = !(geometryEncoding != null ? !geometryEncoding.equals(geometrySchema$GeometryEncoding$GeoMesaV0$) : geometrySchema$GeometryEncoding$GeoMesaV0$ != null);
        String name = isV0 ? descriptor.getLocalName() : StringSerialization$.MODULE$.alphaNumericSafeString(descriptor.getLocalName());
        return this.buildType(name, (Seq<Enumeration.Value>)ObjectType$.MODULE$.selectType(descriptor), encodings, this.buildType$default$4());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type buildType(String name, Seq<Enumeration.Value> bindings, package.Encodings encodings, Type.Repetition repetition) {
        Types.BaseListBuilder baseListBuilder;
        Enumeration.Value value = (Enumeration.Value)bindings.head();
        Enumeration.Value value2 = ObjectType$.MODULE$.STRING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        } else {
            Enumeration.Value value4 = ObjectType$.MODULE$.INT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
            } else {
                Enumeration.Value value6 = ObjectType$.MODULE$.DOUBLE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition);
                } else {
                    Enumeration.Value value8 = ObjectType$.MODULE$.LONG();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition);
                    } else {
                        Enumeration.Value value10 = ObjectType$.MODULE$.FLOAT();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition);
                        } else {
                            Enumeration.Value value12 = ObjectType$.MODULE$.BOOLEAN();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition);
                            } else {
                                Enumeration.Value value14 = ObjectType$.MODULE$.BYTES();
                                Enumeration.Value value15 = value;
                                if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                                    baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
                                } else {
                                    Enumeration.Value value16 = ObjectType$.MODULE$.DATE();
                                    Enumeration.Value value17 = value;
                                    if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                                        LogicalTypeAnnotation.TimeUnit timeUnit;
                                        Enumeration.Value value18 = encodings.date();
                                        Enumeration.Value value19 = package$DateEncoding$.MODULE$.Micros();
                                        Enumeration.Value value20 = value18;
                                        if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                                            timeUnit = LogicalTypeAnnotation.TimeUnit.MICROS;
                                        } else {
                                            Enumeration.Value value21 = package$DateEncoding$.MODULE$.Millis();
                                            Enumeration.Value value22 = value18;
                                            if (value21 != null ? !value21.equals(value22) : value22 != null) throw new NotImplementedError(encodings.date().toString());
                                            timeUnit = LogicalTypeAnnotation.TimeUnit.MILLIS;
                                        }
                                        LogicalTypeAnnotation.TimeUnit unit = timeUnit;
                                        baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)unit));
                                    } else {
                                        Enumeration.Value value23 = ObjectType$.MODULE$.UUID();
                                        Enumeration.Value value24 = value;
                                        if (!(value23 != null ? !value23.equals(value24) : value24 != null)) {
                                            Enumeration.Value value25 = encodings.uuid();
                                            Enumeration.Value value26 = package$UuidEncoding$.MODULE$.FixedLength();
                                            Enumeration.Value value27 = value25;
                                            if (!(value26 != null ? !value26.equals(value27) : value27 != null)) {
                                                baseListBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(16).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType());
                                            } else {
                                                Enumeration.Value value28 = package$UuidEncoding$.MODULE$.Bytes();
                                                Enumeration.Value value29 = value25;
                                                if (value28 != null ? !value28.equals(value29) : value29 != null) throw new NotImplementedError(encodings.uuid().toString());
                                                baseListBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
                                            }
                                        } else {
                                            Enumeration.Value value30 = ObjectType$.MODULE$.LIST();
                                            Enumeration.Value value31 = value;
                                            if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
                                                Enumeration.Value value32 = encodings.list();
                                                Enumeration.Value value33 = package$ListEncoding$.MODULE$.ThreeLevel();
                                                Enumeration.Value value34 = value32;
                                                if (!(value33 != null ? !value33.equals(value34) : value34 != null)) {
                                                    baseListBuilder = Types.optionalList().requiredGroupElement().addField(this.buildType("element", (Seq<Enumeration.Value>)((Seq)bindings.drop(1)), encodings, Type.Repetition.REQUIRED));
                                                } else {
                                                    Enumeration.Value value35 = package$ListEncoding$.MODULE$.TwoLevel();
                                                    Enumeration.Value value36 = value32;
                                                    if (value35 != null ? !value35.equals(value36) : value36 != null) throw new NotImplementedError(encodings.list().toString());
                                                    baseListBuilder = Types.optionalList().element(this.buildType("element", (Seq<Enumeration.Value>)((Seq)bindings.drop(1)), encodings, this.buildType$default$4()));
                                                }
                                            } else {
                                                Enumeration.Value value37 = ObjectType$.MODULE$.MAP();
                                                Enumeration.Value value38 = value;
                                                if (!(value37 != null ? !value37.equals(value38) : value38 != null)) {
                                                    baseListBuilder = Types.optionalMap().key(this.buildType("key", (Seq<Enumeration.Value>)((Seq)bindings.slice(1, 2)), encodings, Type.Repetition.REQUIRED)).value(this.buildType("value", (Seq<Enumeration.Value>)((Seq)bindings.slice(2, 3)), encodings, this.buildType$default$4()));
                                                } else {
                                                    Enumeration.Value value39 = ObjectType$.MODULE$.GEOMETRY();
                                                    Enumeration.Value value40 = value;
                                                    if (value39 != null ? !value39.equals(value40) : value40 != null) throw new NotImplementedError(new StringBuilder(28).append("No mapping defined for type ").append(value).toString());
                                                    baseListBuilder = GeometrySchema$.MODULE$.apply((Enumeration.Value)bindings.apply(1), encodings.geometry());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Types.BaseListBuilder builder = baseListBuilder;
        return (Type)builder.named(name);
    }

    private Type.Repetition buildType$default$4() {
        return Type.Repetition.OPTIONAL;
    }

    public SimpleFeatureParquetSchema apply(SimpleFeatureType sft, package.Encodings encodings, boolean hasVisibilities, Seq<GeometrySchema.BoundingBoxField> boundingBoxes, Map<String, String> metadata) {
        return new SimpleFeatureParquetSchema(sft, encodings, hasVisibilities, boundingBoxes, metadata);
    }

    public Option<Tuple5<SimpleFeatureType, package.Encodings, Object, Seq<GeometrySchema.BoundingBoxField>, Map<String, String>>> unapply(SimpleFeatureParquetSchema x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.sft(), (Object)x$0.encodings(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.hasVisibilities()), x$0.boundingBoxes(), x$0.metadata()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SimpleFeatureParquetSchema$.class);
    }

    public static final /* synthetic */ void $anonfun$read$2(ParquetConfiguration conf$1, HashMap metadata$1, String key) {
        Option$.MODULE$.apply((Object)conf$1.get(key)).foreach((Function1 & Serializable)x$2 -> metadata$1.put(key, x$2));
    }

    private SimpleFeatureParquetSchema$() {
    }
}

