/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.compact;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.PartitionMetadata;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemStorage$;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$FsParams$class;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$PartitionParam$class;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$class;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob;
import org.locationtech.geomesa.fs.tools.ingest.FsIngestCommand;
import org.locationtech.geomesa.fs.tools.ingest.FsIngestCommand$TempDirParam$class;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage$;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.locationtech.geomesa.tools.ingest.AbstractIngest$;
import org.locationtech.geomesa.utils.classpath.ClassPathUtils$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.text.TextTools$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.parallel.ParIterableLike;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001=\u0011abQ8na\u0006\u001cGoQ8n[\u0006tGM\u0003\u0002\u0004\t\u000591m\\7qC\u000e$(BA\u0003\u0007\u0003\u0015!xn\u001c7t\u0015\t9\u0001\"\u0001\u0002gg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001C\u0006\u000e\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0005\u0013\tIBA\u0001\nGg\u0012\u000bG/Y*u_J,7i\\7nC:$\u0007CA\u000e#\u001b\u0005a\"BA\u000f\u001f\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0002%\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0013aA2p[&\u00111\u0005\b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u0002\u0005!9!\u0006\u0001b\u0001\n\u0013Y\u0013a\u00047jE*\f'o\u001d$jY\u0016t\u0015-\\3\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\t1\fgn\u001a\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019dF\u0001\u0004TiJLgn\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0017\u0002!1L'M[1sg\u001aKG.\u001a(b[\u0016\u0004\u0003\"B\u001c\u0001\t\u0013A\u0014!\u00057jE*\f'o]*fCJ\u001c\u0007\u000eU1uQV\t\u0011\bE\u0002;\u0005\u0016s!a\u000f!\u000f\u0005qzT\"A\u001f\u000b\u0005yr\u0011A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t\t%#A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%\u0001C%uKJ\fGo\u001c:\u000b\u0005\u0005\u0013\u0002cA\tG\u0011&\u0011qI\u0005\u0002\n\rVt7\r^5p]B\u00022AO%L\u0013\tQEIA\u0002TKF\u0004\"\u0001T(\u000e\u00035S!A\u0014\u0019\u0002\u0005%|\u0017B\u0001)N\u0005\u00111\u0015\u000e\\3\t\u000fI\u0003!\u0019!C!'\u0006!a.Y7f+\u0005!\u0006CA+Y\u001d\t\tb+\u0003\u0002X%\u00051\u0001K]3eK\u001aL!aM-\u000b\u0005]\u0013\u0002BB.\u0001A\u0003%A+A\u0003oC6,\u0007\u0005C\u0004^\u0001\t\u0007I\u0011\t0\u0002\rA\f'/Y7t+\u0005y\u0006C\u00011u\u001d\t\tWN\u0004\u0002cY:\u00111m\u001b\b\u0003I*t!!Z5\u000f\u0005\u0019DgB\u0001\u001fh\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119QA\u001c\u0002\t\u0002=\fabQ8na\u0006\u001cGoQ8n[\u0006tG\r\u0005\u0002)a\u001a)\u0011A\u0001E\u0001cN\u0011\u0001\u000f\u0005\u0005\u0006KA$\ta\u001d\u000b\u0002_\u001a!Q\u000f\u001d\u0001w\u00055\u0019u.\u001c9bGR\u0004\u0016M]1ngNQA\u000fE<\u007f\u0003\u000f\ti\"a\t\u0011\u0005a\\hB\u00012z\u0013\tQH!\u0001\nGg\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017B\u0001?~\u0005!15\u000fU1sC6\u001c(B\u0001>\u0005!\ry\u00181A\u0007\u0003\u0003\u0003Q!!\u0002\u0005\n\t\u0005\u0015\u0011\u0011\u0001\u0002\u0016%\u0016\fX/\u001b:fIRK\b/\u001a(b[\u0016\u0004\u0016M]1n!\u0011\tI!a\u0006\u000f\t\u0005-\u0011\u0011\u0003\b\u0004E\u00065\u0011bAA\b\t\u00051\u0011N\\4fgRLA!a\u0005\u0002\u0016\u0005yai]%oO\u0016\u001cHoQ8n[\u0006tGMC\u0002\u0002\u0010\u0011IA!!\u0007\u0002\u001c\taA+Z7q\t&\u0014\b+\u0019:b[*!\u00111CA\u000b!\rA\u0018qD\u0005\u0004\u0003Ci(A\u0004)beRLG/[8o!\u0006\u0014\u0018-\u001c\t\u0004\u007f\u0006\u0015\u0012\u0002BA\u0014\u0003\u0003\u00111\u0003R5tiJL'-\u001e;fIJ+h\u000eU1sC6Da!\n;\u0005\u0002\u0005-BCAA\u0017!\r\ty\u0003^\u0007\u0002a\":A/a\r\u0002D\u0005\u0015\u0003\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u000bU\u000e|W.\\1oI\u0016\u0014(bAA\u001fA\u0005)!-Z;ti&!\u0011\u0011IA\u001c\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.\t\u0002\u0002H\u0005\u00112i\\7qC\u000e$\b\u0005]1si&$\u0018n\u001c8t\u0011\u001d\tY\u0005\u0001Q\u0001\n}\u000bq\u0001]1sC6\u001c\b\u0005C\u0004\u0002P\u0001!\t%!\u0015\u0002\u000f\u0015DXmY;uKR\u0011\u00111\u000b\t\u0004#\u0005U\u0013bAA,%\t!QK\\5u\u0011\u0019\u0019\u0001\u0001\"\u0001\u0002\\Q!\u00111KA/\u0011!\ty&!\u0017A\u0002\u0005\u0005\u0014A\u00013t!\u0011\t\u0019'!\u001a\u000e\u0003\u0019I1!a\u001a\u0007\u0005M1\u0015\u000e\\3TsN$X-\u001c#bi\u0006\u001cFo\u001c:f\u0001")
public class CompactCommand
implements FsDataStoreCommand,
LazyLogging {
    private final String libjarsFileName;
    private final String name;
    private final CompactParams params;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CompactCommand compactCommand = this;
        synchronized (compactCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public Map<String, String> connection() {
        return FsDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    private String libjarsFileName() {
        return this.libjarsFileName;
    }

    private Iterator<Function0<Seq<File>>> libjarsSearchPath() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("GEOMESA_FS_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(FileSystemDataStore.class);
            }
        }}));
    }

    public String name() {
        return this.name;
    }

    @Override
    public CompactParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactCommand $outer;

            public final void apply(FileSystemDataStore ds) {
                this.$outer.compact(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void compact(FileSystemDataStore ds) {
        Enumeration.Value value;
        block9: {
            void var12_13;
            block12: {
                Tuple2<Object, Object> tuple2;
                block13: {
                    block8: {
                        Tuple2.mcJJ.sp sp2;
                        FileSystemCompactionJob fileSystemCompactionJob;
                        Buffer toCompact;
                        block11: {
                            String encoding;
                            block10: {
                                FileSystemStorage storage;
                                block7: {
                                    Buffer buffer;
                                    Command$.MODULE$.user().info("Beginning compaction process...");
                                    storage = ds.storage(this.params().featureName());
                                    Buffer allPartitions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(storage.getPartitions()).asScala();
                                    if (this.params().partitions().isEmpty()) {
                                        buffer = allPartitions;
                                    } else {
                                        Buffer filtered = (Buffer)allPartitions.filterNot((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ CompactCommand $outer;

                                            public final boolean apply(PartitionMetadata p) {
                                                return this.$outer.params().partitions().contains(p.name());
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        if (filtered.lengthCompare(this.params().partitions().size()) != 0) {
                                            Buffer unmatched = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().partitions()).asScala()).filterNot((Function1)new Serializable(this, allPartitions){
                                                public static final long serialVersionUID = 0L;
                                                private final Buffer allPartitions$1;

                                                public final boolean apply(String name) {
                                                    return this.allPartitions$1.exists((Function1)new Serializable(this, name){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String name$1;

                                                        public final boolean apply(PartitionMetadata x$1) {
                                                            String string = x$1.name();
                                                            String string2 = this.name$1;
                                                            return !(string != null ? !string.equals(string2) : string2 != null);
                                                        }
                                                        {
                                                            this.name$1 = name$1;
                                                        }
                                                    });
                                                }
                                                {
                                                    this.allPartitions$1 = allPartitions$1;
                                                }
                                            });
                                            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition(s) ", " cannot be found in metadata"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unmatched.mkString(", ")})));
                                        }
                                        buffer = filtered;
                                    }
                                    toCompact = buffer;
                                    Enumeration.Value mode = (Enumeration.Value)Option$.MODULE$.apply((Object)this.params().mode()).getOrElse((Function0)new Serializable(this, storage){
                                        public static final long serialVersionUID = 0L;
                                        private final FileSystemStorage storage$1;

                                        public final Enumeration.Value apply() {
                                            return PathUtils$.MODULE$.isRemote(this.storage$1.getMetadata().getRoot().toString()) ? DistributedRunParam.RunModes$.MODULE$.Distributed() : DistributedRunParam.RunModes$.MODULE$.Local();
                                        }
                                        {
                                            this.storage$1 = storage$1;
                                        }
                                    });
                                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compacting ", " partitions in ", " mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)toCompact.size()), mode.toString().toLowerCase(Locale.US)})));
                                    storage.getMetadata().compact();
                                    value = mode;
                                    Enumeration.Value value2 = DistributedRunParam.RunModes$.MODULE$.Local();
                                    Enumeration.Value value3 = value;
                                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block7;
                                    ((ParIterableLike)toCompact.par()).foreach((Function1)new Serializable(this, storage){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ CompactCommand $outer;
                                        private final FileSystemStorage storage$1;

                                        public final void apply(PartitionMetadata p) {
                                            BoxedUnit boxedUnit;
                                            if (this.$outer.logger().underlying().isInfoEnabled()) {
                                                this.$outer.logger().underlying().info("Compacting {}", new Object[]{p.name()});
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                            this.storage$1.compact(p.name());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.storage$1 = storage$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block8;
                                }
                                Enumeration.Value value4 = DistributedRunParam.RunModes$.MODULE$.Distributed();
                                Enumeration.Value value5 = value;
                                if (value4 != null ? !value4.equals(value5) : value5 != null) break block9;
                                String string = encoding = storage.getMetadata().getEncoding();
                                String string2 = ParquetFileSystemStorage$.MODULE$.ParquetEncoding();
                                if (string != null ? !string.equals(string2) : string2 != null) break block10;
                                fileSystemCompactionJob = new FileSystemCompactionJob.ParquetCompactionJob();
                                break block11;
                            }
                            String string = encoding;
                            String string3 = OrcFileSystemStorage$.MODULE$.OrcEncoding();
                            if (string != null ? !string.equals(string3) : string3 != null) break block12;
                            fileSystemCompactionJob = new FileSystemCompactionJob.OrcCompactionJob();
                        }
                        FileSystemCompactionJob.ParquetCompactionJob job = fileSystemCompactionJob;
                        Option tempDir = Option$.MODULE$.apply((Object)this.params().tempDir()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Path apply(String t) {
                                return new Path(t);
                            }
                        });
                        AbstractIngest.PrintProgress statusCallback = new AbstractIngest.PrintProgress(System.err, TextTools$.MODULE$.buildString(' ', 60), '=', '>', '>');
                        long start = System.currentTimeMillis();
                        tuple2 = job.run(this.connection(), this.params().featureName(), (Seq<PartitionMetadata>)toCompact, (Option<Path>)tempDir, this.libjarsFileName(), this.libjarsSearchPath(), (AbstractIngest.StatusCallback)statusCallback);
                        if (tuple2 == null) break block13;
                        long success = tuple2._1$mcJ$sp();
                        long failed = tuple2._2$mcJ$sp();
                        Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(success, failed);
                        long success2 = sp3._1$mcJ$sp();
                        long failed2 = sp3._2$mcJ$sp();
                        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distributed compaction complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
                        Command$.MODULE$.user().info(AbstractIngest$.MODULE$.getStatInfo(success2, failed2, "Compacted", AbstractIngest$.MODULE$.getStatInfo$default$4()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction completed"})).s((Seq)Nil$.MODULE$));
                    return;
                }
                throw new MatchError(tuple2);
            }
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction is not supported for encoding '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_13})));
        }
        Enumeration.Value value6 = DistributedRunParam.RunModes$.MODULE$.DistributedCombine();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            throw new RuntimeException("DistributedCombine run mode is not supported with this command.");
        }
        throw new MatchError((Object)value);
    }

    public CompactCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        FsDataStoreCommand$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.libjarsFileName = "org/locationtech/geomesa/fs/tools/ingest-libjars.list";
        this.name = "compact";
        this.params = new CompactParams();
    }

    @Parameters(commandDescription="Compact partitions")
    public static class CompactParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam,
    FsIngestCommand.TempDirParam,
    FsDataStoreCommand.PartitionParam,
    DistributedRunParam {
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false, converter=DistributedRunParam.ModeConverter.class)
        private Enumeration.Value mode;
        @Parameter(names={"--partitions"}, description="Partitions to operate on (if empty all partitions will be used)", required=false, variableArity=true)
        private List<String> partitions;
        @Parameter(names={"--temp-path"}, description="Path to temp dir for writing output. Note that this may be useful when using s3 since it is slow as a sink", required=false)
        private String tempDir;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", required=false, variableArity=true)
        private List<String> configuration;

        public Enumeration.Value mode() {
            return this.mode;
        }

        public void mode_$eq(Enumeration.Value x$1) {
            this.mode = x$1;
        }

        @Override
        public List<String> partitions() {
            return this.partitions;
        }

        @Override
        @TraitSetter
        public void partitions_$eq(List<String> x$1) {
            this.partitions = x$1;
        }

        @Override
        public String tempDir() {
            return this.tempDir;
        }

        @Override
        public void tempDir_$eq(String x$1) {
            this.tempDir = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public CompactParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            FsIngestCommand$TempDirParam$class.$init$(this);
            FsDataStoreCommand$PartitionParam$class.$init$(this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
        }
    }
}

