/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.compact;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.geotools.data.DataStoreFinder;
import org.locationtech.geomesa.fs.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.PartitionMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.common.jobs.PartitionInputFormat;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob$;
import org.locationtech.geomesa.fs.tools.ingest.StorageJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FileSystemCompactionJob$class {
    /*
     * WARNING - void declaration
     */
    public static Tuple2 run(FileSystemCompactionJob $this, scala.collection.immutable.Map dsParams, String typeName, Seq partitions, Option tempPath, String libjarsFile, Iterator libjarsPaths2, AbstractIngest.StatusCallback statusCallback) {
        Tuple2.mcJJ.sp sp2;
        FileSystemDataStore ds = (FileSystemDataStore)DataStoreFinder.getDataStore((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)dsParams));
        try {
            int stageCount;
            SimpleFeatureType sft = ds.getSchema(typeName);
            Job job = Job.getInstance((Configuration)new Configuration(), (String)"GeoMesa Storage Compaction");
            $this.setLibJars(job, libjarsFile, libjarsPaths2);
            job.setJarByClass($this.getClass());
            job.setInputFormatClass(PartitionInputFormat.class);
            job.setMapperClass(FileSystemCompactionJob.CompactionMapper.class);
            job.setNumReduceTasks(0);
            job.setMapOutputKeyClass(Void.class);
            job.setMapOutputValueClass(SimpleFeature.class);
            job.setOutputKeyClass(Void.class);
            job.setOutputValueClass(SimpleFeature.class);
            FileSystemStorage storage = ds.storage(sft.getTypeName());
            StorageMetadata metadata = storage.getMetadata();
            Path root = metadata.getRoot();
            FileContext fileContext = metadata.getFileContext();
            Option qualifiedTempPath = tempPath.map((Function1)new Serializable($this, fileContext){
                public static final long serialVersionUID = 0L;
                private final FileContext eta$0$1$1;

                public final Path apply(Path x$1) {
                    return this.eta$0$1$1.makeQualified(x$1);
                }
                {
                    this.eta$0$1$1 = eta$0$1$1;
                }
            });
            StorageConfiguration$.MODULE$.setSft(job.getConfiguration(), sft);
            StorageConfiguration$.MODULE$.setPath(job.getConfiguration(), root.toUri().toString());
            StorageConfiguration$.MODULE$.setEncoding(job.getConfiguration(), metadata.getEncoding());
            StorageConfiguration$.MODULE$.setPartitions(job.getConfiguration(), (String[])((TraversableOnce)partitions.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionMetadata x$1) {
                    return x$1.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
            StorageConfiguration$.MODULE$.setFileType(job.getConfiguration(), StorageUtils.FileType$.MODULE$.Compacted());
            FileOutputFormat.setOutputPath((Job)job, (Path)((Path)qualifiedTempPath.getOrElse((Function0)new Serializable($this, root){
                public static final long serialVersionUID = 0L;
                private final Path root$1;

                public final Path apply() {
                    return this.root$1;
                }
                {
                    this.root$1 = root$1;
                }
            })));
            job.getConfiguration().set("mapred.map.tasks.speculative.execution", "false");
            job.getConfiguration().set("mapreduce.job.user.classpath.first", "true");
            $this.configureOutput(sft, job);
            List existingDataFiles = ((TraversableOnce)partitions.map((Function1)new Serializable($this, storage){
                public static final long serialVersionUID = 0L;
                private final FileSystemStorage storage$1;

                public final Tuple2<PartitionMetadata, java.util.List<Path>> apply(PartitionMetadata p) {
                    return new Tuple2((Object)p, (Object)this.storage$1.getFilePaths(p.name()));
                }
                {
                    this.storage$1 = storage$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).toList();
            Command$.MODULE$.user().info("Submitting job - please wait...");
            job.submit();
            Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
            int n = stageCount = qualifiedTempPath.isDefined() ? 2 : 1;
            while (true) {
                if (!job.isComplete()) break block7;
                statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Map (stage 1/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageCount)})), job.mapProgress(), FileSystemCompactionJob$class.mapCounters$1($this, job), true);
                statusCallback.reset();
                Tuple2.mcJJ.sp counterResult = new Tuple2.mcJJ.sp(FileSystemCompactionJob$class.written($this, job), FileSystemCompactionJob$class.failed($this, job));
                if (job.isSuccessful()) {
                    boolean copied = qualifiedTempPath.forall((Function1)new Serializable($this, root, stageCount, statusCallback){
                        public static final long serialVersionUID = 0L;
                        private final Path root$1;
                        private final int stageCount$1;
                        private final AbstractIngest.StatusCallback statusCallback$1;

                        public final boolean apply(Path tp) {
                            return StorageJobUtils$.MODULE$.distCopy(tp, this.root$1, this.statusCallback$1, 2, this.stageCount$1);
                        }
                        {
                            this.root$1 = root$1;
                            this.stageCount$1 = stageCount$1;
                            this.statusCallback$1 = statusCallback$1;
                        }
                    });
                    if (copied) {
                        Command$.MODULE$.user().info("Removing old files");
                        FileContext fc = metadata.getFileContext();
                        existingDataFiles.foreach((Function1)new Serializable($this, storage, fc){
                            public static final long serialVersionUID = 0L;
                            private final FileSystemStorage storage$1;
                            public final FileContext fc$1;

                            public final void apply(Tuple2<PartitionMetadata, java.util.List<Path>> x0$1) {
                                Tuple2<PartitionMetadata, java.util.List<Path>> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    PartitionMetadata partition = (PartitionMetadata)tuple2._1();
                                    java.util.List files = (java.util.List)tuple2._2();
                                    JavaConversions$.MODULE$.asScalaBuffer(files).foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ FileSystemCompactionJob$.anonfun.run.3 $outer;

                                        public final boolean apply(Path x$2) {
                                            return this.$outer.fc$1.delete(x$2, false);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    this.storage$1.getMetadata().removePartition(partition);
                                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " files in partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)files.size()), partition.name()})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.storage$1 = storage$1;
                                this.fc$1 = fc$1;
                            }
                        });
                        Command$.MODULE$.user().info("Compacting metadata");
                        storage.getMetadata().compact();
                        Command$.MODULE$.user().info("Done");
                    }
                } else {
                    Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job failed with state ", " due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getState(), job.getStatus().getFailureInfo()})));
                }
                sp2 = counterResult;
                break;
            }
        }
        catch (Throwable throwable) {
            void var8_8;
            var8_8.dispose();
            throw throwable;
        }
        {
            void var18_17;
            float mapProgress;
            void var11_10;
            block7: {
                ds.dispose();
                return sp2;
            }
            Thread.sleep(1000L);
            JobStatus.State state = var11_10.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            if (!(state == null ? state2 != null : !state.equals(state2)) || !((mapProgress = var11_10.mapProgress()) < 1.0f)) continue;
            statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Map (stage 1/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)var18_17)})), mapProgress, FileSystemCompactionJob$class.mapCounters$1($this, (Job)var11_10), false);
            continue;
        }
    }

    private static long written(FileSystemCompactionJob $this, Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()).getValue();
    }

    private static long failed(FileSystemCompactionJob $this, Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Failed()).getValue();
    }

    private static final Seq mapCounters$1(FileSystemCompactionJob $this, Job job$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"mapped", (Object)BoxesRunTime.boxToLong((long)FileSystemCompactionJob$class.written($this, job$1))), new Tuple2((Object)"failed", (Object)BoxesRunTime.boxToLong((long)FileSystemCompactionJob$class.failed($this, job$1)))}));
    }

    public static void $init$(FileSystemCompactionJob $this) {
    }
}

