/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.compact;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.fs.storage.api.PartitionMetadata;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcStorageConfiguration;
import org.locationtech.geomesa.fs.tools.compact.FileSystemCompactionJob$class;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.jobs.mapreduce.JobWithLibJars;
import org.locationtech.geomesa.parquet.jobs.ParquetStorageConfiguration;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\teaaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0018\r&dWmU=ti\u0016l7i\\7qC\u000e$\u0018n\u001c8K_\nT!a\u0001\u0003\u0002\u000f\r|W\u000e]1di*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\t!AZ:\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0003\u00171\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A1\u0002\u0005\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAA[8cg*\u00111\u0004H\u0001\u0007G>lWn\u001c8\u000b\u0005u1\u0011aB:u_J\fw-Z\u0005\u0003?a\u0011Ac\u0015;pe\u0006<WmQ8oM&<WO]1uS>t\u0007CA\u0011&\u001b\u0005\u0011#BA\u0012%\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002\u001a\u0011%\u0011aE\t\u0002\u000f\u0015>\u0014w+\u001b;i\u0019&\u0014'*\u0019:t\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019!\u0013N\\5uIQ\t!\u0006\u0005\u0002\u0012W%\u0011AF\u0005\u0002\u0005+:LG\u000fC\u0003/\u0001\u0011\u0005q&A\u0002sk:$\u0002\u0002\r\u001cC\tb3\u0007.\u001f\t\u0005#E\u001a4'\u0003\u00023%\t1A+\u001e9mKJ\u0002\"!\u0005\u001b\n\u0005U\u0012\"\u0001\u0002'p]\u001eDQaN\u0017A\u0002a\n\u0001\u0002Z:QCJ\fWn\u001d\t\u0005sqztH\u0004\u0002\u0012u%\u00111HE\u0001\u0007!J,G-\u001a4\n\u0005ur$aA'ba*\u00111H\u0005\t\u0003s\u0001K!!\u0011 \u0003\rM#(/\u001b8h\u0011\u0015\u0019U\u00061\u0001@\u0003!!\u0018\u0010]3OC6,\u0007\"B#.\u0001\u00041\u0015A\u00039beRLG/[8ogB\u0019qi\u0014*\u000f\u0005!keBA%M\u001b\u0005Q%BA&\u000f\u0003\u0019a$o\\8u}%\t1#\u0003\u0002O%\u00059\u0001/Y2lC\u001e,\u0017B\u0001)R\u0005\r\u0019V-\u001d\u0006\u0003\u001dJ\u0001\"a\u0015,\u000e\u0003QS!!\u0016\u000f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002X)\n\t\u0002+\u0019:uSRLwN\\'fi\u0006$\u0017\r^1\t\u000bek\u0003\u0019\u0001.\u0002\u0011Q,W\u000e\u001d)bi\"\u00042!E.^\u0013\ta&C\u0001\u0004PaRLwN\u001c\t\u0003=\u0012l\u0011a\u0018\u0006\u0003\u000f\u0001T!!\u00192\u0002\r!\fGm\\8q\u0015\t\u0019G\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003K~\u0013A\u0001U1uQ\")q-\fa\u0001\u007f\u0005YA.\u001b2kCJ\u001ch)\u001b7f\u0011\u0015IW\u00061\u0001k\u00031a\u0017N\u00196beN\u0004\u0016\r\u001e5t!\r95.\\\u0005\u0003YF\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004#9\u0004\u0018BA8\u0013\u0005%1UO\\2uS>t\u0007\u0007E\u0002H\u001fF\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\u0005%|'\"\u0001<\u0002\t)\fg/Y\u0005\u0003qN\u0014AAR5mK\")!0\fa\u0001w\u0006q1\u000f^1ukN\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u0001?\u0002\u001a9\u0019Q0a\u0005\u000f\u0007y\fiAD\u0002\u0000\u0003\u0017qA!!\u0001\u0002\n9!\u00111AA\u0004\u001d\rI\u0015QA\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!!\u0002\u0005\n\t\u0005=\u0011\u0011C\u0001\u0007S:<Wm\u001d;\u000b\u0005\u0015A\u0011\u0002BA\u000b\u0003/\ta\"\u00112tiJ\f7\r^%oO\u0016\u001cHO\u0003\u0003\u0002\u0010\u0005E\u0011\u0002BA\u000e\u0003;\u0011ab\u0015;biV\u001c8)\u00197mE\u0006\u001c7N\u0003\u0003\u0002\u0016\u0005]\u0001bBA\u0011\u0001\u0011%\u00111E\u0001\boJLG\u000f^3o)\r\u0019\u0014Q\u0005\u0005\t\u0003O\ty\u00021\u0001\u0002*\u0005\u0019!n\u001c2\u0011\t\u0005-\u0012qF\u0007\u0003\u0003[Q!a\t1\n\t\u0005E\u0012Q\u0006\u0002\u0004\u0015>\u0014\u0007bBA\u001b\u0001\u0011%\u0011qG\u0001\u0007M\u0006LG.\u001a3\u0015\u0007M\nI\u0004\u0003\u0005\u0002(\u0005M\u0002\u0019AA\u0015\u000f\u001d\tiD\u0001E\u0001\u0003\u007f\tqCR5mKNK8\u000f^3n\u0007>l\u0007/Y2uS>t'j\u001c2\u0011\t\u0005\u0005\u00131I\u0007\u0002\u0005\u00191\u0011A\u0001E\u0001\u0003\u000b\u001a2!a\u0011\u0011\u0011!\tI%a\u0011\u0005\u0002\u0005-\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0002@\u00199\u0011qJA\"\u0001\u0005E#\u0001\u0006)beF,X\r^\"p[B\f7\r^5p]*{'mE\u0004\u0002NA\t\u0019&!\u0016\u0011\u0007\u0005\u0005\u0003\u0001\u0005\u0003\u0002X\u0005}SBAA-\u0015\rI\u00121\f\u0006\u0004\u0003;B\u0011a\u00029beF,X\r^\u0005\u0005\u0003C\nIFA\u000eQCJ\fX/\u001a;Ti>\u0014\u0018mZ3D_:4\u0017nZ;sCRLwN\u001c\u0005\t\u0003\u0013\ni\u0005\"\u0001\u0002fQ\u0011\u0011q\r\t\u0005\u0003S\ni%\u0004\u0002\u0002D\u00199\u0011QNA\"\u0001\u0005=$\u0001E(sG\u000e{W\u000e]1di&|gNS8c'\u001d\tY\u0007EA*\u0003c\u0002B!a\u001d\u0002|5\u0011\u0011Q\u000f\u0006\u00043\u0005]$bAA=9\u0005\u0019qN]2\n\t\u0005u\u0014Q\u000f\u0002\u0018\u001fJ\u001c7\u000b^8sC\u001e,7i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"!\u0013\u0002l\u0011\u0005\u0011\u0011\u0011\u000b\u0003\u0003\u0007\u0003B!!\u001b\u0002l\u00199\u0011qQA\"\u0001\u0005%%\u0001E\"p[B\f7\r^5p]6\u000b\u0007\u000f]3s'\u0019\t))a#\u00022Ba\u00111FAG\u0003#\u000bi*!%\u0002\u001e&!\u0011qRA\u0017\u0005\u0019i\u0015\r\u001d9feB!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018V\fA\u0001\\1oO&!\u00111TAK\u0005\u00111v.\u001b3\u0011\t\u0005}\u0015QV\u0007\u0003\u0003CSA!a)\u0002&\u000611/[7qY\u0016TA!a*\u0002*\u00069a-Z1ukJ,'bAAV\u0019\u00059q\u000e]3oO&\u001c\u0018\u0002BAX\u0003C\u0013QbU5na2,g)Z1ukJ,\u0007\u0003BAZ\u0003\u0003l!!!.\u000b\t\u0005]\u0016\u0011X\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0005\u0003w\u000bi,\u0001\u0005usB,7/\u00194f\u0015\t\ty,A\u0002d_6LA!a1\u00026\nYA*\u0019>z\u0019><w-\u001b8h\u0011!\tI%!\"\u0005\u0002\u0005\u001dGCAAe!\u0011\tI'!\"\u0006\u000f\u00055\u0017Q\u0011\u0001\u0002P\n91i\u001c8uKb$\b\u0003BAF\u0003#LA!!4\u0002\u000e\"a\u0011\u0011EAC\u0001\u0004\u0005\r\u0011\"\u0003\u0002VV\u0011\u0011q\u001b\t\u0005\u0003W\tI.\u0003\u0003\u0002\\\u00065\"aB\"pk:$XM\u001d\u0005\r\u0003?\f)\t1AA\u0002\u0013%\u0011\u0011]\u0001\foJLG\u000f^3o?\u0012*\u0017\u000fF\u0002+\u0003GD!\"!:\u0002^\u0006\u0005\t\u0019AAl\u0003\rAH%\r\u0005\n\u0003S\f)\t)Q\u0005\u0003/\f\u0001b\u001e:jiR,g\u000e\t\u0005\r\u0003[\f)\t1AA\u0002\u0013%\u0011Q[\u0001\u0007[\u0006\u0004\b/\u001a3\t\u0019\u0005E\u0018Q\u0011a\u0001\u0002\u0004%I!a=\u0002\u00155\f\u0007\u000f]3e?\u0012*\u0017\u000fF\u0002+\u0003kD!\"!:\u0002p\u0006\u0005\t\u0019AAl\u0011%\tI0!\"!B\u0013\t9.A\u0004nCB\u0004X\r\u001a\u0011\t\u0011\u0005u\u0018Q\u0011C!\u0003\u007f\fQa]3ukB$2A\u000bB\u0001\u0011!\u0011\u0019!a?A\u0002\t\u0015\u0011aB2p]R,\u0007\u0010\u001e\t\u0005\u0005\u000f\tY-\u0004\u0002\u0002\u0006\"A!1BAC\t\u0003\u0012i!A\u0002nCB$rA\u000bB\b\u0005'\u00119\u0002\u0003\u0005\u0003\u0012\t%\u0001\u0019AAI\u0003\rYW-\u001f\u0005\t\u0005+\u0011I\u00011\u0001\u0002\u001e\u0006\u00111O\u001a\u0005\t\u0005\u0007\u0011I\u00011\u0001\u0003\u0006\u0001")
public interface FileSystemCompactionJob
extends StorageConfiguration,
JobWithLibJars {
    public Tuple2<Object, Object> run(Map<String, String> var1, String var2, Seq<PartitionMetadata> var3, Option<Path> var4, String var5, Iterator<Function0<Seq<File>>> var6, AbstractIngest.StatusCallback var7);

    public static class OrcCompactionJob
    implements FileSystemCompactionJob,
    OrcStorageConfiguration {
        public void configureOutput(SimpleFeatureType sft, Job job) {
            OrcStorageConfiguration.class.configureOutput((OrcStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        @Override
        public Tuple2<Object, Object> run(Map<String, String> dsParams, String typeName, Seq<PartitionMetadata> partitions, Option<Path> tempPath, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths2, AbstractIngest.StatusCallback statusCallback) {
            return FileSystemCompactionJob$class.run(this, dsParams, typeName, partitions, tempPath, libjarsFile, libjarsPaths2, statusCallback);
        }

        public void setLibJars(Job job, String fileName, Iterator<Function0<Seq<File>>> searchPath) {
            JobWithLibJars.class.setLibJars((JobWithLibJars)this, (Job)job, (String)fileName, searchPath);
        }

        public OrcCompactionJob() {
            JobWithLibJars.class.$init$((JobWithLibJars)this);
            FileSystemCompactionJob$class.$init$(this);
            OrcStorageConfiguration.class.$init$((OrcStorageConfiguration)this);
        }
    }

    public static class CompactionMapper
    extends Mapper<Void, SimpleFeature, Void, SimpleFeature>
    implements LazyLogging {
        private Counter written;
        private Counter mapped;
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            CompactionMapper compactionMapper = this;
            synchronized (compactionMapper) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        private Counter written() {
            return this.written;
        }

        private void written_$eq(Counter x$1) {
            this.written = x$1;
        }

        private Counter mapped() {
            return this.mapped;
        }

        private void mapped_$eq(Counter x$1) {
            this.mapped = x$1;
        }

        public void setup(Mapper.Context context) {
            super.setup(context);
            this.written_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()));
            this.mapped_$eq(context.getCounter("org.locationtech.geomesa.fs.compaction", "mapped"));
        }

        public void map(Void key, SimpleFeature sf, Mapper.Context context) {
            sf.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
            this.mapped().increment(1L);
            context.write(null, (Object)sf);
            this.written().increment(1L);
        }

        public CompactionMapper() {
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }

    public static class ParquetCompactionJob
    implements FileSystemCompactionJob,
    ParquetStorageConfiguration {
        private final Logger logger;
        private volatile boolean bitmap$0;

        public void configureOutput(SimpleFeatureType sft, Job job) {
            ParquetStorageConfiguration.class.configureOutput((ParquetStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        private Logger logger$lzycompute() {
            ParquetCompactionJob parquetCompactionJob = this;
            synchronized (parquetCompactionJob) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        @Override
        public Tuple2<Object, Object> run(Map<String, String> dsParams, String typeName, Seq<PartitionMetadata> partitions, Option<Path> tempPath, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths2, AbstractIngest.StatusCallback statusCallback) {
            return FileSystemCompactionJob$class.run(this, dsParams, typeName, partitions, tempPath, libjarsFile, libjarsPaths2, statusCallback);
        }

        public void setLibJars(Job job, String fileName, Iterator<Function0<Seq<File>>> searchPath) {
            JobWithLibJars.class.setLibJars((JobWithLibJars)this, (Job)job, (String)fileName, searchPath);
        }

        public ParquetCompactionJob() {
            JobWithLibJars.class.$init$((JobWithLibJars)this);
            FileSystemCompactionJob$class.$init$(this);
            LazyLogging.class.$init$((LazyLogging)this);
            ParquetStorageConfiguration.class.$init$((ParquetStorageConfiguration)this);
        }
    }
}

