/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.fs.FileSystemDataStore;
import org.locationtech.geomesa.fs.FileSystemDataStoreFactory;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$FsParams$class;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$class;
import org.locationtech.geomesa.fs.tools.export.FsExportCommand$OptionalQueryThreads$class;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportParams;
import org.locationtech.geomesa.tools.export.FileExportParams;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001=\u0011qBR:FqB|'\u000f^\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\ta!\u001a=q_J$(BA\u0003\u0007\u0003\u0015!xn\u001c7t\u0015\t9\u0001\"\u0001\u0002gg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001C\u0006\u0011\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\r9\"\u0004H\u0007\u00021)\u00111!\u0007\u0006\u0003\u000b!I!a\u0007\r\u0003\u001b\u0015C\bo\u001c:u\u0007>lW.\u00198e!\tib$D\u0001\u0007\u0013\tybAA\nGS2,7+_:uK6$\u0015\r^1Ti>\u0014X\r\u0005\u0002\"E5\tA!\u0003\u0002$\t\t\u0011bi\u001d#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t!\u0001C\u0004+\u0001\t\u0007I\u0011I\u0016\u0002\rA\f'/Y7t+\u0005a\u0003CA\u0017E\u001d\tqSH\u0004\u00020y9\u0011\u0001g\u000f\b\u0003cir!AM\u001d\u000f\u0005MBdB\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!\u0002 \u0003\u0011\u0003y\u0014a\u0004$t\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u0011\u0005!\u0002e!B\u0001\u0003\u0011\u0003\t5C\u0001!\u0011\u0011\u0015)\u0003\t\"\u0001D)\u0005yd\u0001B#A\u0001\u0019\u0013aBR:FqB|'\u000f\u001e)be\u0006l7o\u0005\u0004E!\u001dS\u0015+\u0016\t\u0003/!K!!\u0013\r\u0003\u0019\u0015C\bo\u001c:u!\u0006\u0014\u0018-\\:\u0011\u0005-seBA\u0018M\u0013\tiE!\u0001\nGg\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017BA(Q\u0005!15\u000fU1sC6\u001c(BA'\u0005!\t\u00116+D\u0001\u001a\u0013\t!\u0016DA\u000bSKF,\u0018N]3e)f\u0004XMT1nKB\u000b'/Y7\u0011\u0005Y;V\"\u0001!\u0007\u000fa\u0003\u0005\u0013aA\u00013\n!r\n\u001d;j_:\fG.U;fef$\u0006N]3bIN\u001c\"a\u0016\t\t\u000bm;F\u0011\u0001/\u0002\r\u0011Jg.\u001b;%)\u0005i\u0006CA\t_\u0013\ty&C\u0001\u0003V]&$\bbB1X\u0001\u0004%\tAY\u0001\bi\"\u0014X-\u00193t+\u0005\u0019\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\u0011a\u0017M\\4\u000b\u0003!\fAA[1wC&\u0011!.\u001a\u0002\b\u0013:$XmZ3s\u0011\u001daw\u000b1A\u0005\u00025\f1\u0002\u001e5sK\u0006$7o\u0018\u0013fcR\u0011QL\u001c\u0005\b_.\f\t\u00111\u0001d\u0003\rAH%\r\u0005\u0007c^\u0003\u000b\u0015B2\u0002\u0011QD'/Z1eg\u0002BC\u0002]:~}\u0006\r\u0011QAA\u0005\u0003\u0017\u0001\"\u0001^>\u000e\u0003UT!A^<\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002ys\u0006)!-Z;ti*\t!0A\u0002d_6L!\u0001`;\u0003\u0013A\u000b'/Y7fi\u0016\u0014\u0018!\u00028b[\u0016\u001cH&A@\"\u0005\u0005\u0005\u0011aD\u0017.cV,'/_\u0017uQJ,\u0017\rZ:\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003\u000f\ta\u0003\u001e5sK\u0006$7\u000f\t\u0015ti\u0006\u0014H\u000fI<ji\"\u0004\u0013'K\u0001\te\u0016\fX/\u001b:fIf\t\u0001\u0001\u0003\u0004&\t\u0012\u0005\u0011q\u0002\u000b\u0003\u0003#\u0001\"A\u0016#)\u000f\u0011\u000b)\"a\u0007\u0002\u001eA\u0019A/a\u0006\n\u0007\u0005eQO\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\u0012\u0011qD\u0001*\u000bb\u0004xN\u001d;!M\u0016\fG/\u001e:fg\u00022'o\\7!C\u0002:Um\\'fg\u0006\u0004C-\u0019;bAM$xN]3\t\u000f\u0005\r\u0002\u0001)A\u0005Y\u00059\u0001/\u0019:b[N\u0004\u0003bBA\u0014\u0001\u0011\u0005\u0013\u0011F\u0001\u000bG>tg.Z2uS>tWCAA\u0016!!\ti#a\r\u0002:\u0005ebbA\t\u00020%\u0019\u0011\u0011\u0007\n\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\u00075\u000b\u0007OC\u0002\u00022I\u0001B!!\f\u0002<%!\u0011QHA\u001c\u0005\u0019\u0019FO]5oO\u0002")
public class FsExportCommand
implements ExportCommand<FileSystemDataStore>,
FsDataStoreCommand {
    private final FsExportParams params;
    private final String name;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public SimpleFeatureType getSchema(DataStore ds) {
        return ExportCommand.class.getSchema((ExportCommand)this, (DataStore)ds);
    }

    public SimpleFeatureCollection getFeatures(DataStore ds, Query query) {
        return ExportCommand.class.getFeatures((ExportCommand)this, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        FsExportCommand fsExportCommand = this;
        synchronized (fsExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    @Override
    public FsExportParams params() {
        return this.params;
    }

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return FsDataStoreCommand$class.connection(this).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FileSystemDataStoreFactory.FileSystemDataStoreParams$.MODULE$.ReadThreadsParam().getName()), (Object)this.params().threads().toString()));
    }

    public FsExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        FsDataStoreCommand$class.$init$(this);
        this.params = new FsExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class FsExportParams
    implements ExportParams,
    FsDataStoreCommand.FsParams,
    RequiredTypeNameParam,
    OptionalQueryThreads {
        @Parameter(names={"--query-threads"}, description="threads (start with 1)", required=false)
        private Integer threads;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", required=false, variableArity=true)
        private List<String> configuration;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private File file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet)", converter=ParameterConverters.DataFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        @Override
        public Integer threads() {
            return this.threads;
        }

        @Override
        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public File file() {
            return this.file;
        }

        public void file_$eq(File x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public FsExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            FileExportParams.class.$init$((FileExportParams)this);
            ExportParams.class.$init$((ExportParams)this);
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            FsExportCommand$OptionalQueryThreads$class.$init$(this);
        }
    }

    public static interface OptionalQueryThreads {
        public Integer threads();

        @TraitSetter
        public void threads_$eq(Integer var1);
    }
}

