/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.ingest;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.geotools.data.DataStoreFinder;
import org.locationtech.geomesa.fs.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.common.utils.StorageUtils;
import org.locationtech.geomesa.fs.tools.ingest.FileSystemConverterJob;
import org.locationtech.geomesa.fs.tools.ingest.StorageJobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FileSystemConverterJob$class {
    /*
     * WARNING - void declaration
     */
    public static Option run(FileSystemConverterJob $this, scala.collection.immutable.Map dsParams, String typeName, Config converterConfig, Seq inputPaths, Option tempPath, int reducers, String libjarsFile, Iterator libjarsPaths2, AbstractIngest.StatusCallback statusCallback, boolean waitForCompletion) {
        None$ none$;
        FileSystemDataStore ds;
        block12: {
            ds = (FileSystemDataStore)DataStoreFinder.getDataStore((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)dsParams));
            try {
                int stageCount;
                SimpleFeatureType sft = ds.getSchema(typeName);
                Job job = Job.getInstance((Configuration)new Configuration(), (String)"GeoMesa Storage Ingest");
                $this.setLibJars(job, libjarsFile, libjarsPaths2);
                job.setJarByClass($this.getClass());
                job.setInputFormatClass(ConverterInputFormat.class);
                job.setMapperClass(FileSystemConverterJob.IngestMapper.class);
                job.setReducerClass(FileSystemConverterJob.DummyReducer.class);
                job.setNumReduceTasks(reducers);
                job.setMapOutputKeyClass(Text.class);
                job.setMapOutputValueClass(BytesWritable.class);
                job.setOutputKeyClass(Void.class);
                job.setOutputValueClass(SimpleFeature.class);
                FileSystemStorage storage = ds.storage(typeName);
                StorageMetadata metadata = storage.getMetadata();
                FileContext fileContext = metadata.getFileContext();
                Option qualifiedTempPath = tempPath.map((Function1)new Serializable($this, fileContext){
                    public static final long serialVersionUID = 0L;
                    private final FileContext eta$0$1$1;

                    public final Path apply(Path x$1) {
                        return this.eta$0$1$1.makeQualified(x$1);
                    }
                    {
                        this.eta$0$1$1 = eta$0$1$1;
                    }
                });
                qualifiedTempPath.foreach((Function1)new Serializable($this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final StorageMetadata metadata$1;

                    public final Object apply(Path tp) {
                        Object object;
                        if (this.metadata$1.getFileContext().util().exists(tp)) {
                            Command$.MODULE$.user().info("Deleting temp path");
                            object = BoxesRunTime.boxToBoolean((boolean)this.metadata$1.getFileContext().delete(tp, true));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                StorageConfiguration$.MODULE$.setSft(job.getConfiguration(), sft);
                StorageConfiguration$.MODULE$.setPath(job.getConfiguration(), metadata.getRoot().toUri().toString());
                StorageConfiguration$.MODULE$.setEncoding(job.getConfiguration(), metadata.getEncoding());
                StorageConfiguration$.MODULE$.setFileType(job.getConfiguration(), StorageUtils.FileType$.MODULE$.Written());
                ConverterInputFormat$.MODULE$.setConverterConfig(job, converterConfig.root().render(ConfigRenderOptions.concise()));
                ConverterInputFormat$.MODULE$.setSft(job, sft);
                FileInputFormat.setInputPaths((Job)job, (String)inputPaths.mkString(","));
                FileOutputFormat.setOutputPath((Job)job, (Path)((Path)qualifiedTempPath.getOrElse((Function0)new Serializable($this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final StorageMetadata metadata$1;

                    public final Path apply() {
                        return this.metadata$1.getRoot();
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                })));
                job.getConfiguration().set("mapred.map.tasks.speculative.execution", "false");
                job.getConfiguration().set("mapred.reduce.tasks.speculative.execution", "false");
                job.getConfiguration().set("mapreduce.job.user.classpath.first", "true");
                job.getConfiguration().set("mapreduce.job.reduce.slowstart.completedmaps", ".90");
                $this.configureOutput(sft, job);
                Command$.MODULE$.user().info("Submitting job - please wait...");
                job.submit();
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
                int n = stageCount = qualifiedTempPath.isDefined() ? 3 : 2;
                if (waitForCompletion) {
                    boolean mapping = true;
                    while (true) {
                        if (job.isComplete()) {
                            statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reduce (stage 2/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageCount)})), job.reduceProgress(), FileSystemConverterJob$class.reduceCounters$1($this, job), true);
                            Tuple2.mcJJ.sp counterResult = new Tuple2.mcJJ.sp($this.written(job), $this.failed(job));
                            if (job.isSuccessful()) {
                                qualifiedTempPath.foreach((Function1)new Serializable($this, metadata, stageCount, statusCallback){
                                    public static final long serialVersionUID = 0L;
                                    private final StorageMetadata metadata$1;
                                    private final int stageCount$1;
                                    private final AbstractIngest.StatusCallback statusCallback$1;

                                    public final boolean apply(Path tp) {
                                        return StorageJobUtils$.MODULE$.distCopy(tp, this.metadata$1.getRoot(), this.statusCallback$1, 3, this.stageCount$1);
                                    }
                                    {
                                        this.metadata$1 = metadata$1;
                                        this.stageCount$1 = stageCount$1;
                                        this.statusCallback$1 = statusCallback$1;
                                    }
                                });
                            } else {
                                Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job failed with state ", " due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getState(), job.getStatus().getFailureInfo()})));
                            }
                            none$ = new Some((Object)counterResult);
                            break block12;
                        }
                        JobStatus.State state = job.getStatus().getState();
                        JobStatus.State state2 = JobStatus.State.PREP;
                        if (state == null ? state2 != null : !state.equals(state2)) {
                            boolean bl;
                            if (bl) {
                                float mapProgress = job.mapProgress();
                                if (mapProgress < 1.0f) {
                                    statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Map (stage 1/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageCount)})), mapProgress, FileSystemConverterJob$class.mapCounters$1($this, job), false);
                                } else {
                                    statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Map (stage 1/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageCount)})), mapProgress, FileSystemConverterJob$class.mapCounters$1($this, job), true);
                                    statusCallback.reset();
                                    bl = false;
                                }
                            } else {
                                statusCallback.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reduce (stage 2/", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)stageCount)})), job.reduceProgress(), FileSystemConverterJob$class.reduceCounters$1($this, job), false);
                            }
                        }
                        Thread.sleep(500L);
                    }
                }
                Command$.MODULE$.user().info("Job Submitted");
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                void var11_11;
                var11_11.dispose();
                throw throwable;
            }
        }
        ds.dispose();
        return none$;
    }

    public static boolean run$default$10(FileSystemConverterJob $this) {
        return true;
    }

    public static long written(FileSystemConverterJob $this, Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()).getValue();
    }

    public static long failed(FileSystemConverterJob $this, Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Failed()).getValue();
    }

    public static long reduced(FileSystemConverterJob $this, Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), "reduced").getValue();
    }

    private static final Seq mapCounters$1(FileSystemConverterJob $this, Job job$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"mapped", (Object)BoxesRunTime.boxToLong((long)$this.written(job$1))), new Tuple2((Object)"failed", (Object)BoxesRunTime.boxToLong((long)$this.failed(job$1)))}));
    }

    private static final Seq reduceCounters$1(FileSystemConverterJob $this, Job job$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"written", (Object)BoxesRunTime.boxToLong((long)$this.reduced(job$1)))}));
    }

    public static void $init$(FileSystemConverterJob $this) {
    }
}

