/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.ingest;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.fs.storage.api.PartitionScheme;
import org.locationtech.geomesa.fs.storage.common.PartitionScheme$;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcStorageConfiguration;
import org.locationtech.geomesa.fs.tools.ingest.FileSystemConverterJob$class;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.jobs.mapreduce.JobWithLibJars;
import org.locationtech.geomesa.parquet.jobs.ParquetStorageConfiguration;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r\u0015aaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0017\r&dWmU=ti\u0016l7i\u001c8wKJ$XM\u001d&pE*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\t17O\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u0011-\u0001:\u0003CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u0018=5\t\u0001D\u0003\u0002\u001a5\u0005!!n\u001c2t\u0015\tYB$\u0001\u0004d_6lwN\u001c\u0006\u0003;\u0019\tqa\u001d;pe\u0006<W-\u0003\u0002 1\t!2\u000b^8sC\u001e,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"!I\u0013\u000e\u0003\tR!a\t\u0013\u0002\u00135\f\u0007O]3ek\u000e,'BA\r\t\u0013\t1#E\u0001\bK_\n<\u0016\u000e\u001e5MS\nT\u0015M]:\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0017.\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0018\u0002\u0007\r|W.\u0003\u00021S\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019!\u0013N\\5uIQ\tA\u0007\u0005\u0002\u0012k%\u0011aG\u0005\u0002\u0005+:LG\u000fC\u00039\u0001\u0011\u0005\u0011(A\u0002sk:$RBO\"P#f;7\u000f\u001f>\u0002\u0018\u0005\u0005\u0003cA\t<{%\u0011AH\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tEq\u0004\tQ\u0005\u0003\u007fI\u0011a\u0001V;qY\u0016\u0014\u0004CA\tB\u0013\t\u0011%C\u0001\u0003M_:<\u0007\"\u0002#8\u0001\u0004)\u0015\u0001\u00033t!\u0006\u0014\u0018-\\:\u0011\t\u0019KE\n\u0014\b\u0003#\u001dK!\u0001\u0013\n\u0002\rA\u0013X\rZ3g\u0013\tQ5JA\u0002NCBT!\u0001\u0013\n\u0011\u0005\u0019k\u0015B\u0001(L\u0005\u0019\u0019FO]5oO\")\u0001k\u000ea\u0001\u0019\u0006AA/\u001f9f\u001d\u0006lW\rC\u0003So\u0001\u00071+A\bd_:4XM\u001d;fe\u000e{gNZ5h!\t!v+D\u0001V\u0015\t16&\u0001\u0004d_:4\u0017nZ\u0005\u00031V\u0013aaQ8oM&<\u0007\"\u0002.8\u0001\u0004Y\u0016AC5oaV$\b+\u0019;igB\u0019A\f\u001a'\u000f\u0005u\u0013gB\u00010b\u001b\u0005y&B\u00011\u000f\u0003\u0019a$o\\8u}%\t1#\u0003\u0002d%\u00059\u0001/Y2lC\u001e,\u0017BA3g\u0005\r\u0019V-\u001d\u0006\u0003GJAQ\u0001[\u001cA\u0002%\f\u0001\u0002^3naB\u000bG\u000f\u001b\t\u0004#mR\u0007CA6r\u001b\u0005a'BA\u0004n\u0015\tqw.\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003a2\ta!\u00199bG\",\u0017B\u0001:m\u0005\u0011\u0001\u0016\r\u001e5\t\u000bQ<\u0004\u0019A;\u0002\u0011I,G-^2feN\u0004\"!\u0005<\n\u0005]\u0014\"aA%oi\")\u0011p\u000ea\u0001\u0019\u0006YA.\u001b2kCJ\u001ch)\u001b7f\u0011\u0015Yx\u00071\u0001}\u00031a\u0017N\u00196beN\u0004\u0016\r\u001e5t!\raVp`\u0005\u0003}\u001a\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0006#\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007\u0011\"!\u0003$v]\u000e$\u0018n\u001c81!\u0011aF-a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005\u0011\u0011n\u001c\u0006\u0003\u0003#\tAA[1wC&!\u0011QCA\u0006\u0005\u00111\u0015\u000e\\3\t\u000f\u0005eq\u00071\u0001\u0002\u001c\u0005q1\u000f^1ukN\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003BA\u000f\u0003wqA!a\b\u000269!\u0011\u0011EA\u0019\u001d\u0011\t\u0019#a\f\u000f\t\u0005\u0015\u0012Q\u0006\b\u0005\u0003O\tYCD\u0002_\u0003SI\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u0015A\u0011bA\u0002\u00024)\u0011Q\u0001C\u0005\u0005\u0003o\tI$\u0001\bBEN$(/Y2u\u0013:<Wm\u001d;\u000b\u0007\r\t\u0019$\u0003\u0003\u0002>\u0005}\"AD*uCR,8oQ1mY\n\f7m\u001b\u0006\u0005\u0003o\tI\u0004C\u0005\u0002D]\u0002\n\u00111\u0001\u0002F\u0005\tr/Y5u\r>\u00148i\\7qY\u0016$\u0018n\u001c8\u0011\u0007E\t9%C\u0002\u0002JI\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002N\u0001!\t!a\u0014\u0002\u000f]\u0014\u0018\u000e\u001e;f]R\u0019\u0001)!\u0015\t\u0011\u0005M\u00131\na\u0001\u0003+\n1A[8c!\u0011\t9&a\u0017\u000e\u0005\u0005e#BA\u0012n\u0013\u0011\ti&!\u0017\u0003\u0007){'\rC\u0004\u0002b\u0001!\t!a\u0019\u0002\r\u0019\f\u0017\u000e\\3e)\r\u0001\u0015Q\r\u0005\t\u0003'\ny\u00061\u0001\u0002V!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014a\u0002:fIV\u001cW\r\u001a\u000b\u0004\u0001\u00065\u0004\u0002CA*\u0003O\u0002\r!!\u0016\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005M\u0014A\u0004:v]\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0003kRC!!\u0012\u0002x-\u0012\u0011\u0011\u0010\t\u0005\u0003w\n))\u0004\u0002\u0002~)!\u0011qPAA\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004J\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9)! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0004\u0002\f\nA\t!!$\u0002-\u0019KG.Z*zgR,WnQ8om\u0016\u0014H/\u001a:K_\n\u0004B!a$\u0002\u00126\t!A\u0002\u0004\u0002\u0005!\u0005\u00111S\n\u0004\u0003#\u0003\u0002\u0002CAL\u0003##\t!!'\u0002\rqJg.\u001b;?)\t\tiIB\u0004\u0002\u001e\u0006E\u0005!a(\u0003'A\u000b'/];fi\u000e{gN^3si\u0016\u0014(j\u001c2\u0014\u000f\u0005m\u0005#!)\u0002$B\u0019\u0011q\u0012\u0001\u0011\t\u0005\u0015\u0016QV\u0007\u0003\u0003OS1!GAU\u0015\r\tY\u000bC\u0001\ba\u0006\u0014\u0018/^3u\u0013\u0011\ty+a*\u00037A\u000b'/];fiN#xN]1hK\u000e{gNZ5hkJ\fG/[8o\u0011!\t9*a'\u0005\u0002\u0005MFCAA[!\u0011\t9,a'\u000e\u0005\u0005EeaBA^\u0003#\u0003\u0011Q\u0018\u0002\u0010\u001fJ\u001c7i\u001c8wKJ$XM\u001d&pEN9\u0011\u0011\u0018\t\u0002\"\u0006}\u0006\u0003BAa\u0003\u0013l!!a1\u000b\u0007e\t)MC\u0002\u0002Hr\t1a\u001c:d\u0013\u0011\tY-a1\u0003/=\u00138m\u0015;pe\u0006<WmQ8oM&<WO]1uS>t\u0007\u0002CAL\u0003s#\t!a4\u0015\u0005\u0005E\u0007\u0003BA\\\u0003s3q!!6\u0002\u0012\u0002\t9N\u0001\u0007J]\u001e,7\u000f^'baB,'oE\u0003\u0002T\u0006ew\u0005\u0005\u0007\u0002X\u0005m\u0017q\\Au\u0003{\u0014\u0019!\u0003\u0003\u0002^\u0006e#AB'baB,'\u000f\u0005\u0003\u0002b\u0006\u0015XBAAr\u0015\r\ti!\\\u0005\u0005\u0003O\f\u0019O\u0001\u0007M_:<wK]5uC\ndW\r\u0005\u0003\u0002l\u0006eXBAAw\u0015\u0011\ty/!=\u0002\rMLW\u000e\u001d7f\u0015\u0011\t\u00190!>\u0002\u000f\u0019,\u0017\r^;sK*\u0019\u0011q\u001f\u0007\u0002\u000f=\u0004XM\\4jg&!\u00111`Aw\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKB!\u0011\u0011]A\u0000\u0013\u0011\u0011\t!a9\u0003\tQ+\u0007\u0010\u001e\t\u0005\u0003C\u0014)!\u0003\u0003\u0003\b\u0005\r(!\u0004\"zi\u0016\u001cxK]5uC\ndW\r\u0003\u0005\u0002\u0018\u0006MG\u0011\u0001B\u0006)\t\u0011i\u0001\u0005\u0003\u00028\u0006MWa\u0002B\t\u0003'\u0004!1\u0003\u0002\b\u0007>tG/\u001a=u!\u0011\tIN!\u0006\n\t\tE\u00111\u001c\u0005\r\u00053\t\u0019\u000e1AA\u0002\u0013%!1D\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014XC\u0001B\u000f!\u0011\u0011yB!\u000b\u000e\u0005\t\u0005\"\u0002\u0002B\u0012\u0005K\tAa\u001b:z_*\u0019!q\u0005\u0005\u0002\u0011\u0019,\u0017\r^;sKNLAAa\u000b\u0003\"\t)2J]=p\r\u0016\fG/\u001e:f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002\u0004B\u0018\u0003'\u0004\r\u00111A\u0005\n\tE\u0012AD:fe&\fG.\u001b>fe~#S-\u001d\u000b\u0004i\tM\u0002B\u0003B\u001b\u0005[\t\t\u00111\u0001\u0003\u001e\u0005\u0019\u0001\u0010J\u0019\t\u0013\te\u00121\u001bQ!\n\tu\u0011aC:fe&\fG.\u001b>fe\u0002BAB!\u0010\u0002T\u0002\u0007\t\u0019!C\u0005\u0005\u007f\tq\u0002]1si&$\u0018n\u001c8TG\",W.Z\u000b\u0003\u0005\u0003\u0002BAa\u0011\u0003J5\u0011!Q\t\u0006\u0004\u0005\u000fb\u0012aA1qS&!!1\nB#\u0005=\u0001\u0016M\u001d;ji&|gnU2iK6,\u0007\u0002\u0004B(\u0003'\u0004\r\u00111A\u0005\n\tE\u0013a\u00059beRLG/[8o'\u000eDW-\\3`I\u0015\fHc\u0001\u001b\u0003T!Q!Q\u0007B'\u0003\u0003\u0005\rA!\u0011\t\u0013\t]\u00131\u001bQ!\n\t\u0005\u0013\u0001\u00059beRLG/[8o'\u000eDW-\\3!\u00111\u0011Y&a5A\u0002\u0003\u0007I\u0011\u0001B/\u0003\u0019i\u0017\r\u001d9fIV\u0011!q\f\t\u0005\u0003/\u0012\t'\u0003\u0003\u0003d\u0005e#aB\"pk:$XM\u001d\u0005\r\u0005O\n\u0019\u000e1AA\u0002\u0013\u0005!\u0011N\u0001\u000b[\u0006\u0004\b/\u001a3`I\u0015\fHc\u0001\u001b\u0003l!Q!Q\u0007B3\u0003\u0003\u0005\rAa\u0018\t\u0013\t=\u00141\u001bQ!\n\t}\u0013aB7baB,G\r\t\u0005\r\u0003\u001b\n\u0019\u000e1AA\u0002\u0013\u0005!Q\f\u0005\r\u0005k\n\u0019\u000e1AA\u0002\u0013\u0005!qO\u0001\foJLG\u000f^3o?\u0012*\u0017\u000fF\u00025\u0005sB!B!\u000e\u0003t\u0005\u0005\t\u0019\u0001B0\u0011%\u0011i(a5!B\u0013\u0011y&\u0001\u0005xe&$H/\u001a8!\u00111\t\t'a5A\u0002\u0003\u0007I\u0011\u0001B/\u00111\u0011\u0019)a5A\u0002\u0003\u0007I\u0011\u0001BC\u0003)1\u0017-\u001b7fI~#S-\u001d\u000b\u0004i\t\u001d\u0005B\u0003B\u001b\u0005\u0003\u000b\t\u00111\u0001\u0003`!I!1RAjA\u0003&!qL\u0001\bM\u0006LG.\u001a3!\u0011!\u0011y)a5\u0005B\tE\u0015!B:fiV\u0004Hc\u0001\u001b\u0003\u0014\"A!Q\u0013BG\u0001\u0004\u00119*A\u0004d_:$X\r\u001f;\u0011\t\te%qB\u0007\u0003\u0003'D\u0001B!(\u0002T\u0012\u0005#qT\u0001\u0004[\u0006\u0004Hc\u0002\u001b\u0003\"\n\u0015&\u0011\u0016\u0005\t\u0005G\u0013Y\n1\u0001\u0002`\u0006\u00191.Z=\t\u0011\t\u001d&1\u0014a\u0001\u0003S\f!a\u001d4\t\u0011\tU%1\u0014a\u0001\u0005/3qA!,\u0002\u0012\u0002\u0011yK\u0001\u0007Ek6l\u0017PU3ek\u000e,'o\u0005\u0003\u0003,\nE\u0006\u0003DA,\u0005g\u000biPa\u0001\u00038\u0006%\u0018\u0002\u0002B[\u00033\u0012qAU3ek\u000e,'\u000f\u0005\u0003\u0003:\n}VB\u0001B^\u0015\u0011\u0011i,a\u0004\u0002\t1\fgnZ\u0005\u0005\u0005\u0003\u0014YL\u0001\u0003W_&$\u0007\u0002CAL\u0005W#\tA!2\u0015\u0005\t\u001d\u0007\u0003BA\\\u0005W+qA!\u0005\u0003,\u0002\u0011Y\r\u0005\u0003\u00032\n5\u0017\u0002\u0002B\t\u0005gCAB!\u0007\u0003,\u0002\u0007\t\u0019!C\u0005\u00057AABa\f\u0003,\u0002\u0007\t\u0019!C\u0005\u0005'$2\u0001\u000eBk\u0011)\u0011)D!5\u0002\u0002\u0003\u0007!Q\u0004\u0005\n\u0005s\u0011Y\u000b)Q\u0005\u0005;AA\"!\u001b\u0003,\u0002\u0007\t\u0019!C\u0001\u0005;BAB!8\u0003,\u0002\u0007\t\u0019!C\u0001\u0005?\f1B]3ek\u000e,Gm\u0018\u0013fcR\u0019AG!9\t\u0015\tU\"1\\A\u0001\u0002\u0004\u0011y\u0006C\u0005\u0003f\n-\u0006\u0015)\u0003\u0003`\u0005A!/\u001a3vG\u0016$\u0007\u0005\u0003\u0005\u0003\u0010\n-F\u0011\tBu)\r!$1\u001e\u0005\t\u0005+\u00139\u000f1\u0001\u0003nB!!q\u001eBe\u001b\t\u0011Y\u000b\u0003\u0005\u0003t\n-F\u0011\tB{\u0003\u0019\u0011X\rZ;dKR9AGa>\u0003z\u000e\r\u0001\u0002\u0003BR\u0005c\u0004\r!!@\t\u0011\tm(\u0011\u001fa\u0001\u0005{\faA^1mk\u0016\u001c\bC\u0002B]\u0005\u007f\u0014\u0019!\u0003\u0003\u0004\u0002\tm&\u0001C%uKJ\f'\r\\3\t\u0011\tU%\u0011\u001fa\u0001\u0005[\u0004")
public interface FileSystemConverterJob
extends StorageConfiguration,
JobWithLibJars,
LazyLogging {
    public Option<Tuple2<Object, Object>> run(Map<String, String> var1, String var2, Config var3, Seq<String> var4, Option<Path> var5, int var6, String var7, Iterator<Function0<Seq<File>>> var8, AbstractIngest.StatusCallback var9, boolean var10);

    public boolean run$default$10();

    public long written(Job var1);

    public long failed(Job var1);

    public long reduced(Job var1);

    public static class IngestMapper
    extends Mapper<LongWritable, SimpleFeature, Text, BytesWritable>
    implements LazyLogging {
        private KryoFeatureSerializer serializer;
        private PartitionScheme partitionScheme;
        private Counter mapped;
        private Counter written;
        private Counter failed;
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            IngestMapper ingestMapper = this;
            synchronized (ingestMapper) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        private KryoFeatureSerializer serializer() {
            return this.serializer;
        }

        private void serializer_$eq(KryoFeatureSerializer x$1) {
            this.serializer = x$1;
        }

        private PartitionScheme partitionScheme() {
            return this.partitionScheme;
        }

        private void partitionScheme_$eq(PartitionScheme x$1) {
            this.partitionScheme = x$1;
        }

        public Counter mapped() {
            return this.mapped;
        }

        public void mapped_$eq(Counter x$1) {
            this.mapped = x$1;
        }

        public Counter written() {
            return this.written;
        }

        public void written_$eq(Counter x$1) {
            this.written = x$1;
        }

        public Counter failed() {
            return this.failed;
        }

        public void failed_$eq(Counter x$1) {
            this.failed = x$1;
        }

        public void setup(Mapper.Context context) {
            super.setup(context);
            SimpleFeatureType sft = StorageConfiguration$.MODULE$.getSft(context.getConfiguration());
            this.serializer_$eq(KryoFeatureSerializer$.MODULE$.apply(sft, SerializationOption.SerializationOptions$.MODULE$.none()));
            this.partitionScheme_$eq((PartitionScheme)PartitionScheme$.MODULE$.extractFromSft(sft).get());
            this.mapped_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), "mapped"));
            this.written_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()));
            this.failed_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Failed()));
        }

        public void map(LongWritable key, SimpleFeature sf, Mapper.Context context) {
            try {
                this.mapped().increment(1L);
                Text partitionKey = new Text(this.partitionScheme().getPartition(sf));
                context.write((Object)partitionKey, (Object)new BytesWritable(this.serializer().serialize(sf)));
                this.written().increment(1L);
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataUtilities.encodeFeature((SimpleFeature)sf)})), throwable);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.failed().increment(1L);
            }
        }

        public IngestMapper() {
            LazyLogging.class.$init$((LazyLogging)this);
        }
    }

    public static class DummyReducer
    extends Reducer<Text, BytesWritable, Void, SimpleFeature> {
        private KryoFeatureSerializer org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer;
        private Counter reduced;

        public KryoFeatureSerializer org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer() {
            return this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer;
        }

        private void org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer_$eq(KryoFeatureSerializer x$1) {
            this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer = x$1;
        }

        public Counter reduced() {
            return this.reduced;
        }

        public void reduced_$eq(Counter x$1) {
            this.reduced = x$1;
        }

        public void setup(Reducer.Context context) {
            super.setup(context);
            SimpleFeatureType sft = StorageConfiguration$.MODULE$.getSft(context.getConfiguration());
            this.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer_$eq(KryoFeatureSerializer$.MODULE$.apply(sft, SerializationOption.SerializationOptions$.MODULE$.none()));
            this.reduced_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), "reduced"));
        }

        public void reduce(Text key, Iterable<BytesWritable> values, Reducer.Context context) {
            JavaConversions$.MODULE$.iterableAsScalaIterable(values).foreach((Function1)new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DummyReducer $outer;
                private final Reducer.Context context$1;

                public final void apply(BytesWritable bw) {
                    this.context$1.write(null, (Object)this.$outer.org$locationtech$geomesa$fs$tools$ingest$FileSystemConverterJob$DummyReducer$$serializer().deserialize(bw.getBytes()));
                    this.$outer.reduced().increment(1L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            });
        }
    }

    public static class OrcConverterJob
    implements FileSystemConverterJob,
    OrcStorageConfiguration {
        private final Logger logger;
        private volatile boolean bitmap$0;

        public void configureOutput(SimpleFeatureType sft, Job job) {
            OrcStorageConfiguration.class.configureOutput((OrcStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        @Override
        public Option<Tuple2<Object, Object>> run(Map<String, String> dsParams, String typeName, Config converterConfig, Seq<String> inputPaths, Option<Path> tempPath, int reducers, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths2, AbstractIngest.StatusCallback statusCallback, boolean waitForCompletion) {
            return FileSystemConverterJob$class.run(this, dsParams, typeName, converterConfig, inputPaths, tempPath, reducers, libjarsFile, libjarsPaths2, statusCallback, waitForCompletion);
        }

        @Override
        public long written(Job job) {
            return FileSystemConverterJob$class.written(this, job);
        }

        @Override
        public long failed(Job job) {
            return FileSystemConverterJob$class.failed(this, job);
        }

        @Override
        public long reduced(Job job) {
            return FileSystemConverterJob$class.reduced(this, job);
        }

        @Override
        public boolean run$default$10() {
            return FileSystemConverterJob$class.run$default$10(this);
        }

        private Logger logger$lzycompute() {
            OrcConverterJob orcConverterJob = this;
            synchronized (orcConverterJob) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public void setLibJars(Job job, String fileName, Iterator<Function0<Seq<File>>> searchPath) {
            JobWithLibJars.class.setLibJars((JobWithLibJars)this, (Job)job, (String)fileName, searchPath);
        }

        public OrcConverterJob() {
            JobWithLibJars.class.$init$((JobWithLibJars)this);
            LazyLogging.class.$init$((LazyLogging)this);
            FileSystemConverterJob$class.$init$(this);
            OrcStorageConfiguration.class.$init$((OrcStorageConfiguration)this);
        }
    }

    public static class ParquetConverterJob
    implements FileSystemConverterJob,
    ParquetStorageConfiguration {
        private final Logger logger;
        private volatile boolean bitmap$0;

        public void configureOutput(SimpleFeatureType sft, Job job) {
            ParquetStorageConfiguration.class.configureOutput((ParquetStorageConfiguration)this, (SimpleFeatureType)sft, (Job)job);
        }

        @Override
        public Option<Tuple2<Object, Object>> run(Map<String, String> dsParams, String typeName, Config converterConfig, Seq<String> inputPaths, Option<Path> tempPath, int reducers, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths2, AbstractIngest.StatusCallback statusCallback, boolean waitForCompletion) {
            return FileSystemConverterJob$class.run(this, dsParams, typeName, converterConfig, inputPaths, tempPath, reducers, libjarsFile, libjarsPaths2, statusCallback, waitForCompletion);
        }

        @Override
        public long written(Job job) {
            return FileSystemConverterJob$class.written(this, job);
        }

        @Override
        public long failed(Job job) {
            return FileSystemConverterJob$class.failed(this, job);
        }

        @Override
        public long reduced(Job job) {
            return FileSystemConverterJob$class.reduced(this, job);
        }

        @Override
        public boolean run$default$10() {
            return FileSystemConverterJob$class.run$default$10(this);
        }

        private Logger logger$lzycompute() {
            ParquetConverterJob parquetConverterJob = this;
            synchronized (parquetConverterJob) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.class.logger((LazyLogging)this);
                    this.bitmap$0 = true;
                }
                return this.logger;
            }
        }

        public Logger logger() {
            return this.bitmap$0 ? this.logger : this.logger$lzycompute();
        }

        public void setLibJars(Job job, String fileName, Iterator<Function0<Seq<File>>> searchPath) {
            JobWithLibJars.class.setLibJars((JobWithLibJars)this, (Job)job, (String)fileName, searchPath);
        }

        public ParquetConverterJob() {
            JobWithLibJars.class.$init$((JobWithLibJars)this);
            LazyLogging.class.$init$((LazyLogging)this);
            FileSystemConverterJob$class.$init$(this);
            ParquetStorageConfiguration.class.$init$((ParquetStorageConfiguration)this);
        }
    }
}

