/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.tools.ingest;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.BaseConverter;
import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.geomesa.fs.FileSystemDataStore;
import org.locationtech.geomesa.fs.storage.api.PartitionMetadata;
import org.locationtech.geomesa.fs.storage.api.StorageMetadata;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$FsParams$class;
import org.locationtech.geomesa.fs.tools.FsDataStoreCommand$class;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.CommandWithSubCommands;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.Runner;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001=\u0011Q#T1oC\u001e,W*\u001a;bI\u0006$\u0018mQ8n[\u0006tGM\u0003\u0002\u0004\t\u00051\u0011N\\4fgRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011A\u00014t\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ei\u0011\u0001\u0007\u0006\u0003\u000b!I!A\u0007\r\u0003-\r{W.\\1oI^KG\u000f[*vE\u000e{W.\\1oIND\u0001\u0002\b\u0001\u0003\u0006\u0004%\t!H\u0001\u0007eVtg.\u001a:\u0016\u0003y\u0001\"aF\u0010\n\u0005\u0001B\"A\u0002*v]:,'\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u001d\u0011XO\u001c8fe\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\u0003U\u000e,\u0012A\n\t\u0003O9j\u0011\u0001\u000b\u0006\u0003S)\n!B[2p[6\fg\u000eZ3s\u0015\tYC&A\u0003cKV\u001cHOC\u0001.\u0003\r\u0019w.\\\u0005\u0003_!\u0012!BS\"p[6\fg\u000eZ3s\u0011!\t\u0004A!A!\u0002\u00131\u0013a\u00016dA!)1\u0007\u0001C\u0001i\u00051A(\u001b8jiz\"2!N\u001c9!\t1\u0004!D\u0001\u0003\u0011\u0015a\"\u00071\u0001\u001f\u0011\u0015!#\u00071\u0001'\u0011\u001dQ\u0004A1A\u0005Bm\nAA\\1nKV\tA\b\u0005\u0002>\u0001:\u0011\u0011CP\u0005\u0003\u007fI\ta\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qH\u0005\u0005\u0007\t\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u000b9\fW.\u001a\u0011\t\u000f\u0019\u0003!\u0019!C!\u000f\u00061\u0001/\u0019:b[N,\u0012\u0001\u0013\t\u0004\u0013\n\u0015eB\u0001&Z\u001d\tY\u0005L\u0004\u0002M/:\u0011QJ\u0016\b\u0003\u001dVs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005Is\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\b\u000bi\u0013\u0001\u0012A.\u0002+5\u000bg.Y4f\u001b\u0016$\u0018\rZ1uC\u000e{W.\\1oIB\u0011a\u0007\u0018\u0004\u0006\u0003\tA\t!X\n\u00039BAQa\r/\u0005\u0002}#\u0012a\u0017\u0004\u0005Cr\u0003!M\u0001\bD_6\u0004\u0018m\u0019;D_6l\u0017M\u001c3\u0014\u0007\u0001\u00042\r\u0005\u0002eK6\tA!\u0003\u0002g\t\t\u0011bi\u001d#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u0015\u0019\u0004\r\"\u0001i)\u0005I\u0007C\u00016a\u001b\u0005a\u0006b\u0002\u001ea\u0005\u0004%\t\u0005\\\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0005Y\u0006twMC\u0001s\u0003\u0011Q\u0017M^1\n\u0005\u0005{\u0007B\u0002#aA\u0003%Q\u000eC\u0004GA\n\u0007I\u0011\t<\u0016\u0003]\u0004\"A\u001b=\u0007\ted\u0006A\u001f\u0002\u000e\u0007>l\u0007/Y2u!\u0006\u0014\u0018-\\:\u0014\u000ba\u000420!\u0002\u0011\u0005q|hBA&~\u0013\tqH!\u0001\nGg\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017\u0002BA\u0001\u0003\u0007\u0011\u0001BR:QCJ\fWn\u001d\u0006\u0003}\u0012\u00012aFA\u0004\u0013\r\tI\u0001\u0007\u0002\u0016%\u0016\fX/\u001b:fIRK\b/\u001a(b[\u0016\u0004\u0016M]1n\u0011\u0019\u0019\u0004\u0010\"\u0001\u0002\u000eQ\tq\u000fK\u0004y\u0003#\t9\"!\u0007\u0011\u0007\u001d\n\u0019\"C\u0002\u0002\u0016!\u0012!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0005\u0005m\u0011aK\"p[B\f7\r\u001e\u0011uQ\u0016\u0004S.\u001a;bI\u0006$\u0018\r\t4pe\u0002\n\u0007e\u001d;pe\u0006<W\rI5ogR\fgnY3\t\u000f\u0005}\u0001\r)A\u0005o\u00069\u0001/\u0019:b[N\u0004\u0003bBA\u0012A\u0012\u0005\u0013QE\u0001\bKb,7-\u001e;f)\t\t9\u0003E\u0002\u0012\u0003SI1!a\u000b\u0013\u0005\u0011)f.\u001b;\u0007\r\u0005=B\fAA\u0019\u0005=\u0011VmZ5ti\u0016\u00148i\\7nC:$7\u0003BA\u0017!\rDqaMA\u0017\t\u0003\t)\u0004\u0006\u0002\u00028A\u0019!.!\f\t\u0011i\niC1A\u0005B1Dq\u0001RA\u0017A\u0003%Q\u000eC\u0005G\u0003[\u0011\r\u0011\"\u0011\u0002@U\u0011\u0011\u0011\t\t\u0004U\u0006\rcABA#9\u0002\t9E\u0001\bSK\u001eL7\u000f^3s!\u0006\u0014\u0018-\\:\u0014\r\u0005\r\u0003c_A\u0003\u0011\u001d\u0019\u00141\tC\u0001\u0003\u0017\"\"!!\u0011\t\u0017\u0005=\u00131\ta\u0001\u0002\u0004%\taO\u0001\na\u0006\u0014H/\u001b;j_:DA\"a\u0015\u0002D\u0001\u0007\t\u0019!C\u0001\u0003+\nQ\u0002]1si&$\u0018n\u001c8`I\u0015\fH\u0003BA\u0014\u0003/B\u0011\"!\u0017\u0002R\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002^\u0005\r\u0003\u0015)\u0003=\u0003)\u0001\u0018M\u001d;ji&|g\u000e\t\u0015\u0011\u00037\n\t'a\u001a\u0002j\u0005=\u0014\u0011OA;\u0003o\u00022aJA2\u0013\r\t)\u0007\u000b\u0002\n!\u0006\u0014\u0018-\\3uKJ\fQA\\1nKNd#!a\u001b\"\u0005\u00055\u0014aC\u0017.a\u0006\u0014H/\u001b;j_:\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\u0012\u00111O\u0001\u0014!\u0006\u0014H/\u001b;j_:\u0004Co\u001c\u0011va\u0012\fG/Z\u0001\te\u0016\fX/\u001b:fIf\t\u0011\u0001\u0003\u0006\u0002|\u0005\r\u0003\u0019!C\u0001\u0003{\nQAZ5mKN,\"!a \u0011\u000b\u0005\u0005\u0015q\u0011\u001f\u000e\u0005\u0005\r%bAACc\u0006!Q\u000f^5m\u0013\u0011\tI)a!\u0003\t1K7\u000f\u001e\u0005\u000b\u0003\u001b\u000b\u0019\u00051A\u0005\u0002\u0005=\u0015!\u00034jY\u0016\u001cx\fJ3r)\u0011\t9#!%\t\u0015\u0005e\u00131RA\u0001\u0002\u0004\ty\bC\u0005\u0002\u0016\u0006\r\u0003\u0015)\u0003\u0002\u0000\u00051a-\u001b7fg\u0002BC#a%\u0002b\u0005\u001d\u0014\u0011TA8\u0003?\u000b)(a\u001e\u0002$\u0006]DFAANC\t\ti*A\u0004.[\u0019LG.Z:\"\u0005\u0005\u0005\u0016A\u0016(b[\u0016\u001c\be\u001c4!i\",\u0007EZ5mKN\u0004Co\u001c\u0011sK\u001eL7\u000f^3sY\u0001jWo\u001d;!C2\u0014X-\u00193zA\u0015D\u0018n\u001d;!S:\u0004C\u000f[3!CB\u0004(o\u001c9sS\u0006$X\r\t9beRLG/[8oA\u0019|G\u000eZ3s\u000351\u0018M]5bE2,\u0017I]5us\"a\u0011qUA\"\u0001\u0004\u0005\r\u0011\"\u0001\u0002*\u00061!m\\;oIN,\"!a+\u0011\u0017E\ti+!-\u00022\u0006E\u0016\u0011W\u0005\u0004\u0003_\u0013\"A\u0002+va2,G\u0007E\u0002\u0012\u0003gK1!!.\u0013\u0005\u0019!u.\u001e2mK\"a\u0011\u0011XA\"\u0001\u0004\u0005\r\u0011\"\u0001\u0002<\u0006Q!m\\;oIN|F%Z9\u0015\t\u0005\u001d\u0012Q\u0018\u0005\u000b\u00033\n9,!AA\u0002\u0005-\u0006\"CAa\u0003\u0007\u0002\u000b\u0015BAV\u0003\u001d\u0011w.\u001e8eg\u0002BC#a0\u0002b\u0005\u001d\u0014QYA8\u0003\u0017\f)(a4\u0002R\u0006MGFAAdC\t\tI-\u0001\u0005.[\t|WO\u001c3tC\t\ti-A+HK><'/\u00199iS\u000e\u0004#m\\;oIN\u0004sN\u001a\u0011uQ\u0016\u0004C-\u0019;bA\u0019LG.Z:!E\u0016Lgn\u001a\u0011sK\u001eL7\u000f^3sK\u0012d\u0003%\u001b8!i\",\u0007EZ8s[\u0002BX.\u001b8-s6Lg\u000e\f=nCbd\u00130\\1y3\u0005\u0001\u0011!C2p]Z,'\u000f^3sG\t\t)\u000eE\u0002k\u0003/4a!!7]\u0001\u0005m'a\u0004\"pk:$7oQ8om\u0016\u0014H/\u001a:\u0014\t\u0005]\u0017Q\u001c\t\u0007\u0003?\f)/a+\u000e\u0005\u0005\u0005(bAArQ\u0005Q1m\u001c8wKJ$XM]:\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u000e\u0005\u0006\u001cXmQ8om\u0016\u0014H/\u001a:\t\u0013i\n9N!A!\u0002\u0013a\u0004bB\u001a\u0002X\u0012\u0005\u0011Q\u001e\u000b\u0005\u0003+\fy\u000f\u0003\u0004;\u0003W\u0004\r\u0001\u0010\u0005\t\u0003g\f9\u000e\"\u0011\u0002v\u000691m\u001c8wKJ$H\u0003BAV\u0003oDq!!?\u0002r\u0002\u0007A(A\u0003wC2,X\r\u0003\u0007\u0002~\u0006\r\u0003\u0019!a\u0001\n\u0003\ty0A\u0003d_VtG/\u0006\u0002\u0003\u0002A\u0019aNa\u0001\n\u0007\t\u0015qN\u0001\u0003M_:<\u0007\u0002\u0004B\u0005\u0003\u0007\u0002\r\u00111A\u0005\u0002\t-\u0011!C2pk:$x\fJ3r)\u0011\t9C!\u0004\t\u0015\u0005e#qAA\u0001\u0002\u0004\u0011\t\u0001C\u0005\u0003\u0012\u0005\r\u0003\u0015)\u0003\u0003\u0002\u000511m\\;oi\u0002B\u0003Ca\u0004\u0002b\u0005\u001d$QCA8\u00057\t)(a4-\u0005\t]\u0011E\u0001B\r\u0003\u001diSfY8v]R\f#A!\b\u0002k9+XNY3sA=4\u0007EZ3biV\u0014Xm\u001d\u0011j]\u0002\"\b.\u001a\u0011eCR\f\u0007EZ5mKN\u0004#-Z5oO\u0002\u0012XmZ5ti\u0016\u0014X\r\u001a\u0015\t\u0003\u0007\n\t\"a\u0006\u0003\"\u0005\u0012!1E\u00010%\u0016<\u0017n\u001d;fe\u0002rWm\u001e\u0011eCR\f\u0007EZ5mKN\u0004s/\u001b;iA\u0005\u00043\u000f^8sC\u001e,\u0007%\u001b8ti\u0006t7-\u001a\u0005\n\u0003?\ti\u0003)A\u0005\u0003\u0003B\u0001\"a\t\u0002.\u0011\u0005\u0013Q\u0005\u0004\u0007\u0005Wa\u0006A!\f\u0003#Us'/Z4jgR,'oQ8n[\u0006tGm\u0005\u0003\u0003*A\u0019\u0007bB\u001a\u0003*\u0011\u0005!\u0011\u0007\u000b\u0003\u0005g\u00012A\u001bB\u0015\u0011!Q$\u0011\u0006b\u0001\n\u0003b\u0007b\u0002#\u0003*\u0001\u0006I!\u001c\u0005\n\r\n%\"\u0019!C!\u0005w)\"A!\u0010\u0011\u0007)\u0014yD\u0002\u0004\u0003Bq\u0003!1\t\u0002\u0011+:\u0014XmZ5ti\u0016\u0014\b+\u0019:b[N\u001cbAa\u0010\u0011w\u0006\u0015\u0001bB\u001a\u0003@\u0011\u0005!q\t\u000b\u0003\u0005{A1\"a\u0014\u0003@\u0001\u0007\t\u0019!C\u0001w!a\u00111\u000bB \u0001\u0004\u0005\r\u0011\"\u0001\u0003NQ!\u0011q\u0005B(\u0011%\tIFa\u0013\u0002\u0002\u0003\u0007A\b\u0003\u0005\u0002^\t}\u0002\u0015)\u0003=QA\u0011\t&!\u0019\u0002h\tU\u0013qNA9\u0003k\n9\b\f\u0002\u0002l!Q\u00111\u0010B \u0001\u0004%\t!! \t\u0015\u00055%q\ba\u0001\n\u0003\u0011Y\u0006\u0006\u0003\u0002(\tu\u0003BCA-\u00053\n\t\u00111\u0001\u0002\u0000!I\u0011Q\u0013B A\u0003&\u0011q\u0010\u0015\u0015\u0005?\n\t'a\u001a\u0003d\u0005=$QMA;\u0003o\n\u0019+a\u001e-\u0005\u0005m\u0015E\u0001B4\u0003as\u0015-\\3tA=4\u0007\u0005\u001e5fA\u0019LG.Z:!i>\u0004SO\u001c:fO&\u001cH/\u001a:-A5,8\u000f\u001e\u0011bYJ,\u0017\rZ=!KbL7\u000f\u001e\u0011j]\u0002\"\b.\u001a\u0011baB\u0014x\u000e\u001d:jCR,\u0007\u0005]1si&$\u0018n\u001c8!M>dG-\u001a:\t\u0019\u0005u(q\ba\u0001\u0002\u0004%\t!a@\t\u0019\t%!q\ba\u0001\u0002\u0004%\tA!\u001c\u0015\t\u0005\u001d\"q\u000e\u0005\u000b\u00033\u0012Y'!AA\u0002\t\u0005\u0001\"\u0003B\t\u0005\u007f\u0001\u000b\u0015\u0002B\u0001QA\u0011\t(!\u0019\u0002h\tU\u0014q\u000eB<\u0003k\ny\r\f\u0002\u0003\u0018\u0005\u0012!\u0011P\u00018\u001dVl'-\u001a:!_\u001a\u0004c-Z1ukJ,7\u000fI5oAQDW\r\t3bi\u0006\u0004c-\u001b7fg\u0002\u0012W-\u001b8hAUt'/Z4jgR,'/\u001a3)\u0011\t}\u0012\u0011CA\f\u0005{\n#Aa \u0002[Us'/Z4jgR,'\u000f\t3bi\u0006\u0004c-\u001b7fg\u00022'o\\7!C\u0002\u001aHo\u001c:bO\u0016\u0004\u0013N\\:uC:\u001cW\rC\u0005\u0002 \t%\u0002\u0015!\u0003\u0003>!A\u00111\u0005B\u0015\t\u0003\n)C\u0002\u0004\u0003\br\u0003!\u0011\u0012\u0002\u0015\u001b\u0006t\u0017mZ3NKR\fG-\u0019;b!\u0006\u0014\u0018-\\:\u0014\u0007\t\u0015\u0005\u0003C\u00044\u0005\u000b#\tA!$\u0015\u0005\t=\u0005c\u00016\u0003\u0006\"B!QQA\t\u0003/\u0011\u0019*\t\u0002\u0003\u0016\u0006QS*\u00198bO\u0016\u0004C\u000f[3![\u0016$\u0018\rZ1uC\u00022wN\u001d\u0011bAM$xN]1hK\u0002Jgn\u001d;b]\u000e,\u0007bBA\u0010\u0001\u0001\u0006I\u0001\u0013\u0005\n\u00057\u0003!\u0019!C!\u0005;\u000b1b];c\u0007>lW.\u00198egV\u0011!q\u0014\t\u0007\u0005C\u0013YK!-\u000f\t\t\r&q\u0015\b\u0004!\n\u0015\u0016\"A\n\n\u0007\t%&#A\u0004qC\u000e\\\u0017mZ3\n\t\t5&q\u0016\u0002\u0004'\u0016\f(b\u0001BU%A\u0019qCa-\n\u0007\tU\u0006DA\u0004D_6l\u0017M\u001c3\t\u0011\te\u0006\u0001)A\u0005\u0005?\u000bAb];c\u0007>lW.\u00198eg\u0002\u0002")
public class ManageMetadataCommand
implements CommandWithSubCommands {
    private final Runner runner;
    private final JCommander jc;
    private final String name;
    private final ManageMetadataParams params;
    private final Seq<Command> subCommands;

    public void execute() {
        CommandWithSubCommands.class.execute((CommandWithSubCommands)this);
    }

    public Runner runner() {
        return this.runner;
    }

    public JCommander jc() {
        return this.jc;
    }

    public String name() {
        return this.name;
    }

    public ManageMetadataParams params() {
        return this.params;
    }

    public Seq<Command> subCommands() {
        return this.subCommands;
    }

    public ManageMetadataCommand(Runner runner, JCommander jc) {
        this.runner = runner;
        this.jc = jc;
        CommandWithSubCommands.class.$init$((CommandWithSubCommands)this);
        this.name = "manage-metadata";
        this.params = new ManageMetadataParams();
        this.subCommands = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FsDataStoreCommand[]{new CompactCommand(), new RegisterCommand(), new UnregisterCommand()}));
    }

    @Parameters(commandDescription="Compact the metadata for a storage instance")
    public static class CompactParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam {
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", required=false, variableArity=true)
        private List<String> configuration;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public CompactParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
        }
    }

    public static class CompactCommand
    implements FsDataStoreCommand {
        private final String name;
        private final CompactParams params;

        @Override
        public Map<String, String> connection() {
            return FsDataStoreCommand$class.connection(this);
        }

        public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
            return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
        }

        public String name() {
            return this.name;
        }

        @Override
        public CompactParams params() {
            return this.params;
        }

        public void execute() {
            this.withDataStore((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CompactCommand $outer;

                public final void apply(FileSystemDataStore ds) {
                    StorageMetadata metadata = ds.storage(this.$outer.params().featureName()).getMetadata();
                    metadata.compact();
                    Buffer partitions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.getPartitions()).asScala();
                    Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compacted metadata into ", " partitions consisting of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitions.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)partitions.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(PartitionMetadata x$1) {
                            return x$1.files().size();
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)}))).toString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public CompactCommand() {
            DataStoreCommand.class.$init$((DataStoreCommand)this);
            FsDataStoreCommand$class.$init$(this);
            this.name = "compact";
            this.params = new CompactParams();
        }
    }

    @Parameters(commandDescription="Register new data files with a storage instance")
    public static class RegisterParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam {
        @Parameter(names={"--partition"}, description="Partition to update", required=true)
        private String partition;
        @Parameter(names={"--files"}, description="Names of the files to register, must already exist in the appropriate partition folder", required=true, variableArity=true)
        private List<String> files;
        @Parameter(names={"--bounds"}, description="Geographic bounds of the data files being registered, in the form xmin,ymin,xmax,ymax", required=false, converter=BoundsConverter.class)
        private Tuple4<Object, Object, Object, Object> bounds;
        @Parameter(names={"--count"}, description="Number of features in the data files being registered", required=false)
        private Long count;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", required=false, variableArity=true)
        private List<String> configuration;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public String partition() {
            return this.partition;
        }

        public void partition_$eq(String x$1) {
            this.partition = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public Tuple4<Object, Object, Object, Object> bounds() {
            return this.bounds;
        }

        public void bounds_$eq(Tuple4<Object, Object, Object, Object> x$1) {
            this.bounds = x$1;
        }

        public Long count() {
            return this.count;
        }

        public void count_$eq(Long x$1) {
            this.count = x$1;
        }

        public RegisterParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            this.files = new ArrayList<String>();
        }
    }

    public static class RegisterCommand
    implements FsDataStoreCommand {
        private final String name;
        private final RegisterParams params;

        @Override
        public Map<String, String> connection() {
            return FsDataStoreCommand$class.connection(this);
        }

        public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
            return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
        }

        public String name() {
            return this.name;
        }

        @Override
        public RegisterParams params() {
            return this.params;
        }

        public void execute() {
            this.withDataStore((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RegisterCommand $outer;

                public final void apply(FileSystemDataStore ds) {
                    StorageMetadata metadata = ds.storage(this.$outer.params().featureName()).getMetadata();
                    long count = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)this.$outer.params().count()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Long x$2) {
                            return x$2;
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                    Envelope bounds = new Envelope();
                    Option$.MODULE$.apply(this.$outer.params().bounds()).foreach((Function1)new Serializable(this, bounds){
                        public static final long serialVersionUID = 0L;
                        private final Envelope bounds$1;

                        public final void apply(Tuple4<Object, Object, Object, Object> x0$1) {
                            Tuple4<Object, Object, Object, Object> tuple4 = x0$1;
                            if (tuple4 != null) {
                                double xmin = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                                double ymin = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                                double xmax = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                                double ymax = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                                this.bounds$1.expandToInclude(xmin, ymin);
                                this.bounds$1.expandToInclude(xmax, ymax);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple4);
                        }
                        {
                            this.bounds$1 = bounds$1;
                        }
                    });
                    metadata.addPartition(new PartitionMetadata(this.$outer.params().partition(), this.$outer.params().files(), count, bounds));
                    PartitionMetadata partition = metadata.getPartition(this.$outer.params().partition());
                    Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered ", " new files. Updated partition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.params().files().size()), BoxesRunTime.boxToInteger((int)partition.files().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"files containing ", " known features"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)partition.count())}))).toString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public RegisterCommand() {
            DataStoreCommand.class.$init$((DataStoreCommand)this);
            FsDataStoreCommand$class.$init$(this);
            this.name = "register";
            this.params = new RegisterParams();
        }
    }

    public static class BoundsConverter
    extends BaseConverter<Tuple4<Object, Object, Object, Object>> {
        public Tuple4<Object, Object, Object, Object> convert(String value) {
            try {
                double[] dArray = (double[])Predef$.MODULE$.refArrayOps((Object[])value.split(",")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$4) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$4.trim())).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Option option = Array$.MODULE$.unapplySeq((Object)dArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
                    Tuple4 tuple4;
                    double xmin = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(0));
                    double ymin = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(1));
                    double xmax = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(2));
                    double ymax = BoxesRunTime.unboxToDouble((Object)((SeqLike)option.get()).apply(3));
                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax));
                    double xmin2 = BoxesRunTime.unboxToDouble((Object)tuple42._1());
                    double ymin2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                    double xmax2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                    double ymax2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
                    return new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin2), (Object)BoxesRunTime.boxToDouble((double)ymin2), (Object)BoxesRunTime.boxToDouble((double)xmax2), (Object)BoxesRunTime.boxToDouble((double)ymax2));
                }
                throw new MatchError((Object)dArray);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public BoundsConverter(String name) {
            super(name);
        }
    }

    @Parameters(commandDescription="Unregister data files from a storage instance")
    public static class UnregisterParams
    implements FsDataStoreCommand.FsParams,
    RequiredTypeNameParam {
        @Parameter(names={"--partition"}, description="Partition to update", required=true)
        private String partition;
        @Parameter(names={"--files"}, description="Names of the files to unregister, must already exist in the appropriate partition folder", required=true, variableArity=true)
        private List<String> files;
        @Parameter(names={"--count"}, description="Number of features in the data files being unregistered", required=false)
        private Long count;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--path", "-p"}, description="Path to root of filesystem datastore", required=true)
        private String path;
        @Parameter(names={"--config"}, description="Configuration properties, in the form k=v", required=false, variableArity=true)
        private List<String> configuration;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        @TraitSetter
        public void path_$eq(String x$1) {
            this.path = x$1;
        }

        @Override
        public List<String> configuration() {
            return this.configuration;
        }

        @Override
        @TraitSetter
        public void configuration_$eq(List<String> x$1) {
            this.configuration = x$1;
        }

        public String partition() {
            return this.partition;
        }

        public void partition_$eq(String x$1) {
            this.partition = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public Long count() {
            return this.count;
        }

        public void count_$eq(Long x$1) {
            this.count = x$1;
        }

        public UnregisterParams() {
            FsDataStoreCommand$FsParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            this.files = new ArrayList<String>();
        }
    }

    public static class UnregisterCommand
    implements FsDataStoreCommand {
        private final String name;
        private final UnregisterParams params;

        @Override
        public Map<String, String> connection() {
            return FsDataStoreCommand$class.connection(this);
        }

        public <T> T withDataStore(Function1<FileSystemDataStore, T> method) throws ParameterException {
            return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
        }

        public String name() {
            return this.name;
        }

        @Override
        public UnregisterParams params() {
            return this.params;
        }

        public void execute() {
            this.withDataStore((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UnregisterCommand $outer;

                public final void apply(FileSystemDataStore ds) {
                    StorageMetadata metadata = ds.storage(this.$outer.params().featureName()).getMetadata();
                    long count = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)this.$outer.params().count()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(Long x$3) {
                            return x$3;
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                    metadata.removePartition(new PartitionMetadata(this.$outer.params().partition(), this.$outer.params().files(), count, new Envelope()));
                    PartitionMetadata partition = metadata.getPartition(this.$outer.params().partition());
                    Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unregistered ", " files. Updated partition: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.params().files().size()), BoxesRunTime.boxToInteger((int)partition.files().size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"files containing ", " known features"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)partition.count())}))).toString());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public UnregisterCommand() {
            DataStoreCommand.class.$init$((DataStoreCommand)this);
            FsDataStoreCommand$class.$init$(this);
            this.name = "unregister";
            this.params = new UnregisterParams();
        }
    }

    @Parameters(commandDescription="Manage the metadata for a storage instance")
    public static class ManageMetadataParams {
    }
}

